/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.util.Conversion;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;

final class SecretKeyZeroizeable
extends SecretKeySpec
implements Zeroizeable {
    private byte[] V;
    private boolean U = false;

    public SecretKeyZeroizeable(byte[] byArray, String string) {
        super(new byte[]{0}, string);
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("bad arguments");
        }
        this.V = (byte[])byArray.clone();
    }

    public SecretKeyZeroizeable(byte[] byArray, int n, int n2, String string) {
        super(new byte[]{0}, string);
        if (string == null || byArray == null || n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("bad arguments");
        }
        this.V = new byte[n2];
        System.arraycopy(byArray, n, this.V, 0, n2);
    }

    public byte[] getEncoded() {
        return (byte[])this.V.clone();
    }

    public boolean equals(Object object) {
        if (object instanceof Key) {
            Key key = (Key)object;
            byte[] byArray = key.getEncoded();
            return this.getAlgorithm().equalsIgnoreCase(key.getAlgorithm()) && Arrays.equals(byArray, this.V);
        }
        return false;
    }

    public boolean isZeroized() {
        return this.U;
    }

    public boolean testZeroizationState() {
        return this.U;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.V, (byte)0);
        this.U = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        return Conversion.OS2Hex((byte[])this.V, (int)2);
    }
}

