/*
 * Decompiled with CFR 0.152.
 */
package javax.security.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.util.Conversion;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AESParameterSpec
implements AlgorithmParameterSpec,
Zeroizeable {
    public static final int IV_ONLY = 0;
    public static final int EMPTY = 1;
    public static final int COMPLETE = 2;
    private int case = 0;
    private int char;
    private byte[] byte;
    private boolean try = false;

    public AESParameterSpec(int n, byte[] byArray) {
        this.char = n;
        if (byArray != null) {
            this.byte = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.byte, 0, byArray.length);
            this.case = 2;
        } else {
            this.byte = null;
            this.case = 1;
        }
    }

    public AESParameterSpec(byte[] byArray) {
        if (byArray != null) {
            this.byte = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.byte, 0, byArray.length);
            this.case = 0;
        } else {
            this.byte = null;
            this.case = 1;
        }
    }

    public AESParameterSpec() {
        this.case = 1;
    }

    public Integer getblockLen() {
        return new Integer(this.char);
    }

    public byte[] getIV() {
        if (this.byte == null) {
            return null;
        }
        byte[] byArray = new byte[this.byte.length];
        System.arraycopy(this.byte, 0, byArray, 0, this.byte.length);
        return byArray;
    }

    public int getEncodingStyle() {
        return this.case;
    }

    public void setEncodingStyle(int n) {
        this.case = n;
    }

    public AlgorithmParameterSpec getParameterSpec(Class clazz) {
        if (this.byte != null) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.byte);
            return ivParameterSpec;
        }
        return null;
    }

    public boolean isZeroized() {
        return this.try;
    }

    public boolean testZeroizationState() {
        return this.try;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.byte, (byte)0);
        this.char = 0;
        this.try = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        return this.byte == null ? "null " : Conversion.OS2Hex((byte[])this.byte, (int)2);
    }
}

