/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.ASEPlanViewer;
import com.sybase.ase.planviewer.AdvancedInfo;
import com.sybase.ase.planviewer.ButtonTableCellEditor;
import com.sybase.ase.planviewer.Column;
import com.sybase.ase.planviewer.Constants;
import com.sybase.ase.planviewer.Item;
import com.sybase.ase.planviewer.Table;
import com.sybase.ase.planviewer.TableContainer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class AdvancedPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 13L;
    private JScrollPane _jspPlanInfo;
    private JLabel _lblPlanInfo;
    private JScrollPane _jspTextAreaAP;
    private JLabel _lblAP;
    private JScrollPane _jspTableResource;
    private JLabel _lblResource;
    private JScrollPane _jspTableCost;
    private JLabel _lblCost;
    private JScrollPane _jspTableOptMetrics;
    private JLabel _lblOptMetrics;
    private JScrollPane _jspTableOptStats;
    private JLabel _lblOptStats;
    private Connection _con;
    private ASEPlanViewer _pv;
    public static final int WIDTH = 200;

    public AdvancedPanel(ASEPlanViewer aSEPlanViewer) {
        this._pv = aSEPlanViewer;
    }

    public void setConnection(Connection connection) {
        this._con = connection;
    }

    public void build(AdvancedInfo advancedInfo) {
        this.removeAll();
        this.initGUI(advancedInfo);
    }

    public void initGUI(AdvancedInfo advancedInfo) {
        Object object;
        Object object2;
        this.setLayout(new GridBagLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setWrapStyleWord(true);
        Object[] objectArray = new String[]{this._pv.getLocalizedMessage("TBL_PROPERTY"), this._pv.getLocalizedMessage("TBL_VALUE"), this._pv.getLocalizedMessage("TBL_DESCRIPTION")};
        Object[][] objectArray2 = new Object[][]{{this._pv.getLocalizedMessage("PLAN_VERSION"), advancedInfo.getPlanInfo().getPlanVersion(), this._pv.getLocalizedMessage("PLAN_VERSION")}, {this._pv.getLocalizedMessage("STATEMENT_NUMBER"), advancedInfo.getPlanInfo().getStatementNumber(), this._pv.getLocalizedMessage("STATEMENT_NUMBER")}, {this._pv.getLocalizedMessage("LINE_NUMBER"), advancedInfo.getPlanInfo().getLineNumber(), this._pv.getLocalizedMessage("LINE_NUMBER")}};
        JTable jTable = new JTable(objectArray2, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        Object[][] objectArray3 = new Object[][]{{this._pv.getLocalizedMessage("THREADS"), advancedInfo.getResource().getThreads(), this._pv.getLocalizedMessage("THREADS_DESCRIPTION")}, {this._pv.getLocalizedMessage("AUX_SDES"), advancedInfo.getResource().getAuxSdes(), this._pv.getLocalizedMessage("AUX_SDES_DESCRIPTION")}};
        JTable jTable2 = new JTable(objectArray3, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        Object[][] objectArray4 = new Object[][]{{this._pv.getLocalizedMessage("LIO"), advancedInfo.getCost().getLIO(), this._pv.getLocalizedMessage("LIO_DESCRIPTION")}, {this._pv.getLocalizedMessage("PIO"), advancedInfo.getCost().getPIO(), this._pv.getLocalizedMessage("PIO_DESCRIPTION")}, {this._pv.getLocalizedMessage("CPU"), advancedInfo.getCost().getCPU(), this._pv.getLocalizedMessage("CPU_DESCRIPTION")}};
        JTable jTable3 = new JTable(objectArray4, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        Object[][] objectArray5 = new Object[][]{{this._pv.getLocalizedMessage("TIME_MS"), advancedInfo.getOptimizerMetrics().getTimeMs(), this._pv.getLocalizedMessage("TIME_MS_DESCRIPTION")}, {this._pv.getLocalizedMessage("TIME_TO_FIRST_PLAN_MS"), advancedInfo.getOptimizerMetrics().getTimeToFirstPlanMs(), this._pv.getLocalizedMessage("TIME_TO_FIRST_PLAN_MS_DESCRIPTION")}, {this._pv.getLocalizedMessage("PLANS_EVALUATED"), advancedInfo.getOptimizerMetrics().getPlansEvaluated(), this._pv.getLocalizedMessage("PLANS_EVALUATED_DESCRIPTION")}, {this._pv.getLocalizedMessage("PLANS_VALID"), advancedInfo.getOptimizerMetrics().getPlansValid(), this._pv.getLocalizedMessage("PLANS_VALID_DESCRIPTION")}, {this._pv.getLocalizedMessage("PROC_CACHE_BYTES"), advancedInfo.getOptimizerMetrics().getProcCacheBytes(), this._pv.getLocalizedMessage("PROC_CACHE_BYTES_DESCRIPTION")}};
        JTable jTable4 = new JTable(objectArray5, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        Object[] objectArray6 = new String[]{this._pv.getLocalizedMessage("TABLE_NAME"), this._pv.getLocalizedMessage("COLUMN_NAME"), this._pv.getLocalizedMessage("UPDATE_STAT_LAST_RUN"), this._pv.getLocalizedMessage("MISSING_DENSITY"), this._pv.getLocalizedMessage("MISSING_HISTOGRAM")};
        TableContainer tableContainer = advancedInfo.getOptimizerStatistics().getTables();
        int n = tableContainer.getItems().size();
        for (int i = 0; i < tableContainer.getItems().size(); ++i) {
            n += ((Table)tableContainer.getItems().elementAt(i)).getColumns().size();
        }
        Object[][] objectArray7 = new Object[n][5];
        int n2 = 0;
        for (int i = 0; i < tableContainer.getItems().size(); ++i) {
            object2 = (Table)tableContainer.getItems().elementAt(i);
            objectArray7[n2][0] = ((Item)object2).getName();
            objectArray7[n2][1] = "";
            objectArray7[n2][2] = "";
            objectArray7[n2][3] = new Column("");
            objectArray7[n2++][4] = new Boolean(false);
            for (int j = 0; j < ((Table)object2).getColumns().size(); ++j) {
                object = (Column)((Table)object2).getColumns().elementAt(j);
                objectArray7[n2][0] = "";
                objectArray7[n2][1] = ((Item)object).getName();
                objectArray7[n2][2] = ((Item)object).getLastUpdateStatTime();
                objectArray7[n2][3] = object;
                objectArray7[n2++][4] = new Boolean(((Item)object).isMissingHistogram());
            }
        }
        JTable jTable5 = new JTable(objectArray7, objectArray6){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 3;
            }
        };
        jTable5.setRowHeight(30);
        jTable5.getTableHeader().setReorderingAllowed(false);
        object2 = new JButton(this._pv.getLocalizedMessage("UPDATE_STATS"));
        final ButtonTableCellEditor buttonTableCellEditor = new ButtonTableCellEditor(this._con, this, this._pv);
        ((AbstractButton)object2).addActionListener(buttonTableCellEditor);
        object = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                switch (n2) {
                    case 0: {
                        if (((String)object).equals("")) {
                            return new JLabel("");
                        }
                        return new JLabel((String)object, Constants.TABLE_IMAGE, 2);
                    }
                    case 1: {
                        if (((String)object).equals("")) {
                            return new JLabel("");
                        }
                        return new JLabel((String)object, Constants.COL_IMAGE, 2);
                    }
                    case 2: {
                        return new JLabel((String)object);
                    }
                    case 3: {
                        return buttonTableCellEditor.getComponent((Column)object);
                    }
                    case 4: {
                        if (((Boolean)object).booleanValue()) {
                            return new JLabel(Constants.CHECK_IMAGE, 0);
                        }
                        return new JLabel();
                    }
                }
                return new JLabel((String)object);
            }
        };
        jTable5.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)object);
        jTable5.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)object);
        jTable5.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)object);
        jTable5.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)object);
        jTable5.getColumnModel().getColumn(3).setCellEditor(buttonTableCellEditor);
        jTable5.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)object);
        jTextArea.setText(advancedInfo.getAbstractPlan());
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 0.1, 0.1, 23, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._lblPlanInfo = new JLabel(AdvancedPanel.getBlueLabel(this._pv.getLocalizedMessage("LBL_PLAN_INFO")), Constants.DOWN_IMAGE, 2);
        this._lblPlanInfo.addMouseListener(this);
        this.add((Component)this._lblPlanInfo, gridBagConstraints);
        this._jspPlanInfo = new JScrollPane(jTable);
        this._jspPlanInfo.setPreferredSize(new Dimension(200, 91));
        this._lblPlanInfo.setLabelFor(this._jspPlanInfo);
        this.add((Component)this._jspPlanInfo, gridBagConstraints);
        this.add((Component)new JSeparator(), gridBagConstraints);
        this._lblAP = new JLabel(AdvancedPanel.getBlueLabel(this._pv.getLocalizedMessage("LBL_ABSTRACT_PLAN")), Constants.DOWN_IMAGE, 2);
        this._lblAP.addMouseListener(this);
        this.add((Component)this._lblAP, gridBagConstraints);
        this._jspTextAreaAP = new JScrollPane(jTextArea);
        this._jspTextAreaAP.setPreferredSize(new Dimension(200, 71));
        this._lblAP.setLabelFor(this._jspTextAreaAP);
        this.add((Component)this._jspTextAreaAP, gridBagConstraints);
        this.add((Component)new JSeparator(), gridBagConstraints);
        this._lblResource = new JLabel(AdvancedPanel.getBlueLabel(this._pv.getLocalizedMessage("LBL_RESOURCE")), Constants.DOWN_IMAGE, 2);
        this._lblResource.addMouseListener(this);
        this.add((Component)this._lblResource, gridBagConstraints);
        this._jspTableResource = new JScrollPane(jTable2);
        this._jspTableResource.setPreferredSize(new Dimension(200, 71));
        this._lblResource.setLabelFor(this._jspTableResource);
        this.add((Component)this._jspTableResource, gridBagConstraints);
        this.add((Component)new JSeparator(), gridBagConstraints);
        this._lblCost = new JLabel(AdvancedPanel.getBlueLabel(this._pv.getLocalizedMessage("LBL_COST")), Constants.DOWN_IMAGE, 2);
        this._lblCost.addMouseListener(this);
        this.add((Component)this._lblCost, gridBagConstraints);
        this._jspTableCost = new JScrollPane(jTable3);
        this._jspTableCost.setPreferredSize(new Dimension(200, 91));
        this._lblCost.setLabelFor(this._jspTableCost);
        this.add((Component)this._jspTableCost, gridBagConstraints);
        this.add((Component)new JSeparator(), gridBagConstraints);
        this._lblOptMetrics = new JLabel(AdvancedPanel.getBlueLabel(this._pv.getLocalizedMessage("LBL_OPT_METRICS")), Constants.DOWN_IMAGE, 2);
        this._lblOptMetrics.addMouseListener(this);
        this.add((Component)this._lblOptMetrics, gridBagConstraints);
        this._jspTableOptMetrics = new JScrollPane(jTable4);
        this._jspTableOptMetrics.setPreferredSize(new Dimension(200, 123));
        this._lblOptMetrics.setLabelFor(this._jspTableOptMetrics);
        this.add((Component)this._jspTableOptMetrics, gridBagConstraints);
        this.add((Component)new JSeparator(), gridBagConstraints);
        this._lblOptStats = new JLabel(AdvancedPanel.getBlueLabel(this._pv.getLocalizedMessage("LBL_OPT_STATS")), Constants.DOWN_IMAGE, 2);
        this._lblOptStats.addMouseListener(this);
        this.add((Component)this._lblOptStats, gridBagConstraints);
        this._jspTableOptStats = new JScrollPane(jTable5);
        this._jspTableOptStats.setPreferredSize(new Dimension(200, 201));
        this._lblOptStats.setLabelFor(this._jspTableOptStats);
        this.add((Component)this._jspTableOptStats, gridBagConstraints);
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.fill = 1;
        this.add(Box.createGlue(), gridBagConstraints);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        JScrollPane jScrollPane = (JScrollPane)jLabel.getLabelFor();
        if (jLabel.getIcon() == Constants.DOWN_IMAGE) {
            jLabel.setIcon(Constants.UP_IMAGE);
            jScrollPane.setVisible(false);
        } else {
            jLabel.setIcon(Constants.DOWN_IMAGE);
            jScrollPane.setVisible(true);
        }
        this.revalidate();
    }

    public static String getBlueLabel(String string) {
        return "<html><strong><font color=\"blue\"><u>" + string + "</font>" + "</u>" + "</strong>" + "</html>";
    }
}

