/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.ASEPlanViewer;
import com.sybase.ase.planviewer.Column;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;

class ButtonTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private Connection _con;
    private JPanel _parent;
    private ASEPlanViewer _pv;

    public ButtonTableCellEditor(Connection connection, JPanel jPanel, ASEPlanViewer aSEPlanViewer) {
        this._con = connection;
        this._parent = jPanel;
        this._pv = aSEPlanViewer;
    }

    public JComponent getComponent(Column column) {
        if (column != null && column.isMissingDensity()) {
            JButton jButton = new JButton(this._pv.getLocalizedMessage("UPDATE_STATS"));
            jButton.setActionCommand(column.getTableName() + " (" + column.getName() + ")");
            jButton.addActionListener(this);
            return jButton;
        }
        return new JLabel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        final String string = actionEvent.getActionCommand();
        final String string2 = "update statistics " + string;
        boolean bl = true;
        JTextArea jTextArea = new JTextArea(MessageFormat.format(this._pv.getLocalizedMessage("UPDATE_STATS_CONFIRMATION_MSG"), string));
        final JCheckBox jCheckBox = new JCheckBox(this._pv.getLocalizedMessage("MSG_NOTIFY_WHEN_COMPLETE"));
        jTextArea.setEditable(false);
        jCheckBox.setSelected(true);
        jTextArea.setBackground(jCheckBox.getBackground());
        Object[] objectArray = new Object[]{jTextArea, jCheckBox};
        int n = JOptionPane.showOptionDialog(this._parent, objectArray, this._pv.getLocalizedMessage("UPDATE_STATS_CONFIRMATION_TITLE"), 0, 3, null, null, null);
        if (n != 0) {
            return;
        }
        jButton.setEnabled(false);
        jButton.setVisible(false);
        if (this._con != null) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        ButtonTableCellEditor.this._con.createStatement().executeUpdate(string2);
                        if (jCheckBox.isSelected()) {
                            JOptionPane.showMessageDialog(ButtonTableCellEditor.this._parent, MessageFormat.format(ButtonTableCellEditor.this._pv.getLocalizedMessage("UPDATE_STATS_NOTIFICATION"), string), ButtonTableCellEditor.this._pv.getLocalizedMessage("UPDATE_STATS_CONFIRMATION_TITLE"), 1);
                        }
                    }
                    catch (SQLException sQLException) {
                        System.err.println(sQLException.toString());
                    }
                }
            };
            thread.start();
        }
        this.fireEditingStopped();
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.getComponent((Column)object);
    }
}

