/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.ImageIcon;

class PercentageIcon
extends ImageIcon {
    private static final long serialVersionUID = 11L;
    private double _dVal;

    PercentageIcon(double d) {
        this._dVal = d;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        int n3 = (int)Math.round((double)this.getIconWidth() * this._dVal);
        if (this._dVal > 0.66) {
            graphics.setColor(Color.RED);
        } else if (this._dVal > 0.33) {
            graphics.setColor(Color.ORANGE);
        } else if (this._dVal > 0.05) {
            graphics.setColor(Color.GREEN);
        } else {
            graphics.setColor(Color.WHITE);
        }
        if (this._dVal > 0.05) {
            graphics.fill3DRect(2, 2, n3, this.getIconHeight() - 2, true);
        }
        graphics.setColor(Color.black);
        if (this._dVal > 0.05) {
            graphics.draw3DRect(2, 2, this.getIconWidth(), this.getIconHeight() - 2, true);
        }
        BigDecimal bigDecimal = new BigDecimal(this._dVal);
        bigDecimal.setScale(2, 4);
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMinimumIntegerDigits(2);
        graphics.setColor(color);
    }

    @Override
    public int getIconWidth() {
        return 51;
    }

    @Override
    public int getIconHeight() {
        return 12;
    }

    @Override
    public String toString() {
        return this._dVal * 100.0 + "";
    }
}

