/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.ASEPlanViewer;
import com.sybase.ase.planviewer.Column;
import com.sybase.ase.planviewer.Item;
import com.sybase.ase.planviewer.ItemContainer;
import com.sybase.ase.planviewer.MyTableCellRenderer;
import com.sybase.ase.planviewer.Table;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class XMLListView
extends JPanel {
    private static final long serialVersionUID = 3L;
    private JTable _jTable;
    private DefaultTableColumnModel _dtcm;
    private ASEPlanViewer _pv;

    public XMLListView(ASEPlanViewer aSEPlanViewer) {
        super(new GridBagLayout());
        this.setSize(300, 300);
        this._pv = aSEPlanViewer;
        this._jTable = new JTable(){
            private static final long serialVersionUID = 4L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        TableColumn tableColumn = new TableColumn();
        tableColumn.setHeaderValue(this._pv.getLocalizedMessage("TITLE"));
        tableColumn.setWidth(200);
        this._dtcm = new DefaultTableColumnModel();
        this._dtcm.addColumn(tableColumn);
        JTableHeader jTableHeader = new JTableHeader(this._dtcm);
        this._jTable.setTableHeader(jTableHeader);
        this._jTable.setSelectionMode(0);
        this._jTable.setDefaultRenderer(Object.class, new MyTableCellRenderer());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)jTableHeader, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._jTable, gridBagConstraints);
    }

    public void setListMouseSelectionListener(MouseListener mouseListener) {
        this._jTable.addMouseListener(mouseListener);
    }

    public JTable getJTable() {
        return this._jTable;
    }

    public void showTreeElementsAsList(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string;
        if (defaultMutableTreeNode == null) {
            return;
        }
        for (int i = this._dtcm.getColumnCount() - 1; i >= 0; --i) {
            this._dtcm.removeColumn(this._dtcm.getColumn(i));
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        String string2 = string = defaultMutableTreeNode.toString() == null ? "" : defaultMutableTreeNode.toString();
        if (defaultMutableTreeNode2 != null) {
            String string3;
            String string4 = string3 = defaultMutableTreeNode2.toString() == null ? "" : defaultMutableTreeNode2.toString();
            if (string3.equals("Columns")) {
                this.showGenericTableItems(defaultMutableTreeNode, vector, vector2);
            } else if (string3.equals("TransitiveClosures")) {
                this.showTransitiveColumns(defaultMutableTreeNode, vector, vector2);
            } else if (string.equals("GenericTables")) {
                this.showGenericTables(defaultMutableTreeNode, vector, vector2);
            } else if (string.equals("Columns") || string.equals("VirtualColumns")) {
                this.showGenericTableItems(defaultMutableTreeNode, vector, vector2);
            } else if (string.equals("Indexes")) {
                this.showGenericTableItems(defaultMutableTreeNode, vector, vector2);
            } else {
                this.showChildList(defaultMutableTreeNode, vector, vector2);
            }
        } else if (string.equals("col") || string.equals("index")) {
            this.showChildList(defaultMutableTreeNode, vector, vector2);
        }
        this._jTable.setModel(new DefaultTableModel(vector, vector2));
    }

    private void showChildList(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector, Vector vector2) {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setWidth(this._jTable.getWidth());
        tableColumn.setHeaderValue(defaultMutableTreeNode.toString());
        this._dtcm.addColumn(tableColumn);
        vector2.addElement(defaultMutableTreeNode.toString());
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Vector<TreeNode> vector3 = new Vector<TreeNode>();
            vector3.addElement(enumeration.nextElement());
            vector.addElement(vector3);
        }
    }

    private void showGenericTableItems(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector, Vector vector2) {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setHeaderValue("name");
        tableColumn.setWidth(this._jTable.getWidth() / 3);
        TableColumn tableColumn2 = new TableColumn();
        tableColumn2.setWidth(this._jTable.getWidth() / 3);
        tableColumn2.setHeaderValue("id");
        TableColumn tableColumn3 = new TableColumn();
        tableColumn3.setWidth(this._jTable.getWidth() / 3);
        tableColumn3.setHeaderValue("alias");
        vector2.addElement("name");
        vector2.addElement("id");
        vector2.addElement("alias");
        this._dtcm.addColumn(tableColumn);
        this._dtcm.addColumn(tableColumn2);
        this._dtcm.addColumn(tableColumn3);
        ItemContainer itemContainer = (ItemContainer)defaultMutableTreeNode.getUserObject();
        Vector vector3 = itemContainer.getItems();
        for (int i = 0; i < vector3.size(); ++i) {
            Vector<Object> vector4 = new Vector<Object>();
            Item item = (Item)vector3.elementAt(i);
            vector4.addElement(new DefaultMutableTreeNode(item));
            vector4.addElement(item.getId());
            vector4.addElement(item.getAlias());
            vector.addElement(vector4);
        }
    }

    private void showGenericTables(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector, Vector vector2) {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setHeaderValue("name");
        tableColumn.setWidth(this._jTable.getWidth() / 3);
        TableColumn tableColumn2 = new TableColumn();
        tableColumn2.setWidth(this._jTable.getWidth() / 3);
        tableColumn2.setHeaderValue("id");
        TableColumn tableColumn3 = new TableColumn();
        tableColumn3.setWidth(this._jTable.getWidth() / 3);
        tableColumn3.setHeaderValue("alias");
        vector2.addElement("name");
        vector2.addElement("id");
        vector2.addElement("alias");
        this._dtcm.addColumn(tableColumn);
        this._dtcm.addColumn(tableColumn2);
        this._dtcm.addColumn(tableColumn3);
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Table table = (Table)defaultMutableTreeNode2.getUserObject();
            Vector<Object> vector3 = new Vector<Object>();
            vector3.addElement(defaultMutableTreeNode2);
            vector3.addElement(table.getId());
            vector3.addElement(table.getAlias());
            vector.addElement(vector3);
        }
    }

    private void showTransitiveColumns(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector, Vector vector2) {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setHeaderValue("name");
        tableColumn.setWidth(this._jTable.getWidth() / 4);
        TableColumn tableColumn2 = new TableColumn();
        tableColumn2.setWidth(this._jTable.getWidth() / 4);
        tableColumn2.setHeaderValue("id");
        TableColumn tableColumn3 = new TableColumn();
        tableColumn3.setWidth(this._jTable.getWidth() / 4);
        tableColumn3.setHeaderValue("alias");
        TableColumn tableColumn4 = new TableColumn();
        tableColumn4.setWidth(this._jTable.getWidth() / 4);
        tableColumn4.setHeaderValue("table");
        vector2.addElement("name");
        vector2.addElement("id");
        vector2.addElement("alias");
        vector2.addElement("table");
        this._dtcm.addColumn(tableColumn);
        this._dtcm.addColumn(tableColumn2);
        this._dtcm.addColumn(tableColumn3);
        this._dtcm.addColumn(tableColumn4);
        Table table = (Table)defaultMutableTreeNode.getUserObject();
        Vector vector3 = table.getColumns();
        for (int i = 0; i < vector3.size(); ++i) {
            Vector<Object> vector4 = new Vector<Object>();
            Column column = (Column)vector3.elementAt(i);
            vector4.addElement(new DefaultMutableTreeNode(column));
            vector4.addElement(column.getId());
            vector4.addElement(column.getAlias());
            vector4.addElement(column.getTableName());
            vector.addElement(vector4);
        }
    }
}

