/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.ASEPlanViewer;
import com.sybase.ase.planviewer.AdvancedInfo;
import com.sybase.ase.planviewer.Column;
import com.sybase.ase.planviewer.ColumnContainer;
import com.sybase.ase.planviewer.GenericTableContainer;
import com.sybase.ase.planviewer.Index;
import com.sybase.ase.planviewer.IndexContainer;
import com.sybase.ase.planviewer.Item;
import com.sybase.ase.planviewer.Table;
import com.sybase.ase.planviewer.XMLModelNode;
import com.sybase.ase.planviewer.XMLStringChunk;
import com.sybase.ase.planviewer.XMLTablet;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class XMLModelBuilder
extends DefaultHandler {
    private Stack _nodeStack = new Stack();
    private ASEPlanViewer _pv;
    private XMLModelNode _xGuiTreeRoot;
    private AdvancedInfo _advancedInfo;
    private String _currentNodeChars;
    private String _xpath = "";
    private XMLTablet _xt;
    private static Hashtable _hHideableNodes = new Hashtable(59);
    private Hashtable _hXPaths = new Hashtable(7);

    public XMLModelBuilder() {
        this._advancedInfo = new AdvancedInfo();
        this._hXPaths.clear();
    }

    public XMLModelBuilder(ASEPlanViewer aSEPlanViewer, XMLTablet xMLTablet) {
        this._advancedInfo = new AdvancedInfo();
        this._hXPaths.clear();
        this._pv = aSEPlanViewer;
        this._xt = xMLTablet;
    }

    public XMLTablet getXMLTablet() {
        return this._xt;
    }

    public XMLModelNode build(StringBuffer stringBuffer) throws Exception {
        block6: {
            if (stringBuffer == null) {
                return null;
            }
            this._xGuiTreeRoot = null;
            this._currentNodeChars = null;
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                if (this._xt.getStartOffset() != -1 && this._xt.getEndOffset() != -1) {
                    sAXParser.parse(new InputSource(new XMLStringChunk(stringBuffer.substring(this._xt.getStartOffset(), this._xt.getEndOffset()).toString())), (DefaultHandler)this);
                } else {
                    sAXParser.parse(new InputSource(new XMLStringChunk(stringBuffer.toString())), (DefaultHandler)this);
                }
            }
            catch (Exception exception) {
                if (exception.getMessage() == null || exception.getMessage().equals("java.util.EmptyStackException")) break block6;
                throw exception;
            }
        }
        if (this._xGuiTreeRoot != null) {
            this._xGuiTreeRoot.setAdvancedInfo(this._advancedInfo.isAccessed() ? this._advancedInfo : null);
        }
        return this._xGuiTreeRoot;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this._currentNodeChars = null;
        XMLModelNode xMLModelNode = this._xGuiTreeRoot == null ? (this._xGuiTreeRoot = new XMLModelNode(null, null, this._xpath, string3, this._xt, this._pv)) : new XMLModelNode(this._xGuiTreeRoot, (XMLModelNode)this._nodeStack.peek(), this._xpath, string3, this._xt, this._pv);
        this._xpath = this._xpath + "/" + xMLModelNode;
        this.setXPath(this._xpath);
        xMLModelNode.setXPath(this._xpath);
        if (this._xpath.startsWith("/query[1]/opTree[1]/Emit[1]")) {
            this._nodeStack.push(xMLModelNode);
            if (string3.equals("GenericTables")) {
                xMLModelNode.setUserObject(new GenericTableContainer());
            } else if (string3.equals("table")) {
                xMLModelNode.setUserObject(new Table(true));
            } else if (string3.equals("col")) {
                xMLModelNode.setUserObject(new Column());
            } else if (string3.equals("tc")) {
                xMLModelNode.setUserObject(new Table(false));
            } else if (string3.equals("Columns") || string3.equals("VirtualColumns")) {
                xMLModelNode.setUserObject(new ColumnContainer());
            } else if (string3.equals("Indexes")) {
                xMLModelNode.setUserObject(new IndexContainer());
            } else if (string3.equals("index")) {
                xMLModelNode.setUserObject(new Index());
            }
        } else {
            this._xGuiTreeRoot = null;
        }
    }

    private void setXPath(String string) {
        this._xpath = string;
        Integer n = (Integer)this._hXPaths.get(this._xpath);
        if (n != null) {
            this._hXPaths.put(this._xpath, new Integer(n + 1));
            this._xpath = this._xpath + "[" + (n + 1) + "]";
        } else {
            this._hXPaths.put(this._xpath, new Integer(1));
            this._xpath = this._xpath + "[1]";
        }
    }

    public boolean isNodeHideable(String string) {
        return _hHideableNodes.containsValue(string);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        XMLModelNode xMLModelNode = null;
        XMLModelNode xMLModelNode2 = null;
        if (this._xpath.startsWith("/query[1]/text[1]")) {
            this._xt.setSQL(this._currentNodeChars);
        }
        if (!this._nodeStack.isEmpty()) {
            xMLModelNode2 = (XMLModelNode)this._nodeStack.pop();
            xMLModelNode = (XMLModelNode)this._nodeStack.peek();
        }
        this._xpath = this._xpath.substring(0, this._xpath.lastIndexOf("/"));
        if (xMLModelNode == null) {
            String string4 = this._xpath + "/" + string3;
            if (string4.startsWith("/query[1]/planVersion")) {
                this._advancedInfo.getPlanInfo().setPlanVersion(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/statementNum")) {
                this._advancedInfo.getPlanInfo().setStatementNumber(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/lineNum")) {
                this._advancedInfo.getPlanInfo().setLineNumber(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/abstractPlan")) {
                this._advancedInfo.setAbstractPlan(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/costs[1]/pio")) {
                this._advancedInfo.getCost().setPIO(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/costs[1]/lio")) {
                this._advancedInfo.getCost().setLIO(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/costs[1]/cpu")) {
                this._advancedInfo.getCost().setCPU(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/resource[1]/auxSdes")) {
                this._advancedInfo.getResource().setAuxSdes(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/resource[1]/threads")) {
                this._advancedInfo.getResource().setThreads(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/optimizerMetrics[1]/optTimeMs")) {
                this._advancedInfo.getOptimizerMetrics().setTimeMs(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/optimizerMetrics[1]/optTimeToFirstPlanMs")) {
                this._advancedInfo.getOptimizerMetrics().setTimeToFirstPlanMs(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/optimizerMetrics[1]/plansEvaluated")) {
                this._advancedInfo.getOptimizerMetrics().setPlansEvaluated(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/optimizerMetrics[1]/plansValid")) {
                this._advancedInfo.getOptimizerMetrics().setPlansValid(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/optimizerMetrics[1]/procCacheBytes")) {
                this._advancedInfo.getOptimizerMetrics().setProcCacheBytes(this._currentNodeChars);
            } else if (string4.startsWith("/query[1]/optimizerStatistics[1]/statInfo[")) {
                if (string3.equals("objName")) {
                    this._advancedInfo.getOptimizerStatistics().addTable(this._currentNodeChars);
                } else if (string3.equals("column")) {
                    this._advancedInfo.getOptimizerStatistics().addColumn(new Column(this._currentNodeChars));
                    if (this._xpath.substring(0, this._xpath.length() - 3).endsWith("missingDensity")) {
                        this._advancedInfo.getOptimizerStatistics().setMissingDensity(this._currentNodeChars);
                    } else if (this._xpath.substring(0, this._xpath.length() - 3).endsWith("missingHistogram")) {
                        this._advancedInfo.getOptimizerStatistics().setMissingHistogram(this._currentNodeChars);
                    }
                } else if (string3.equals("updateTime")) {
                    this._advancedInfo.getOptimizerStatistics().setLastUpdateStatTime(this._currentNodeChars);
                } else if (string3.equals("missingDensity")) {
                    this._advancedInfo.getOptimizerStatistics().markMissingDensityComplete();
                }
            }
            return;
        }
        if (this.isNodeHideable(string3)) {
            xMLModelNode.setValue(xMLModelNode2, this._currentNodeChars);
            String string5 = xMLModelNode2.getName();
            if (string5.endsWith("Name")) {
                if (string5.equals("objName")) {
                    xMLModelNode.setObjectName(this._currentNodeChars);
                } else if (string5.equals("indName")) {
                    xMLModelNode.setIndexName(this._currentNodeChars);
                } else if (string5.equals("corrName")) {
                    xMLModelNode.setCorrelationName(this._currentNodeChars);
                }
            } else if (string3.equals("producerThreads")) {
                xMLModelNode.setNumberOfProducers(this._currentNodeChars);
            } else if (string3.equals("consumerThreads")) {
                xMLModelNode.setNumberOfConsumers(this._currentNodeChars);
            }
            xMLModelNode2.removeFromParent();
        }
        if (string3.equals("id")) {
            ((Item)xMLModelNode.getUserObject()).setId(this._currentNodeChars);
        } else if (string3.equals("alias")) {
            ((Item)xMLModelNode.getUserObject()).setAlias(this._currentNodeChars);
        } else if (string3.equals("name")) {
            ((Item)xMLModelNode.getUserObject()).setName(this._currentNodeChars);
        } else if (string3.equals("tableName")) {
            ((Item)xMLModelNode.getUserObject()).setTableName(this._currentNodeChars);
        } else if (string3.equals("index")) {
            ((IndexContainer)xMLModelNode.getUserObject()).add((Index)xMLModelNode2.getUserObject());
        } else if (string3.equals("col")) {
            if (xMLModelNode.getUserObject() instanceof ColumnContainer) {
                ((ColumnContainer)xMLModelNode.getUserObject()).add((Column)xMLModelNode2.getUserObject());
            } else {
                ((Table)xMLModelNode.getUserObject()).addColumn((Column)xMLModelNode2.getUserObject());
            }
        } else if (string3.equals("table")) {
            ((GenericTableContainer)xMLModelNode.getUserObject()).add((Table)xMLModelNode2.getUserObject());
        } else if (string3.equals("table")) {
            xMLModelNode2.setName(((Table)xMLModelNode2.getUserObject()).getName());
        } else if (string3.equals("tc")) {
            xMLModelNode2.setName(((Table)xMLModelNode2.getUserObject()).getName());
        }
        this._currentNodeChars = null;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        String string = new String(cArray, n, n2);
        if (string.trim().length() == 0) {
            return;
        }
        this._currentNodeChars = this._currentNodeChars != null ? this._currentNodeChars + string : string.trim();
    }

    static {
        _hHideableNodes.put("1", "est");
        _hHideableNodes.put("2", "act");
        _hHideableNodes.put("3", "arity");
        _hHideableNodes.put("4", "VA");
        _hHideableNodes.put("5", "lio");
        _hHideableNodes.put("6", "pio");
        _hHideableNodes.put("7", "rowCnt");
        _hHideableNodes.put("8", "rowSz");
        _hHideableNodes.put("9", "objName");
        _hHideableNodes.put("10", "corrName");
        _hHideableNodes.put("11", "varNo");
        _hHideableNodes.put("12", "indName");
        _hHideableNodes.put("13", "indId");
        _hHideableNodes.put("14", "id");
        _hHideableNodes.put("15", "alias");
        _hHideableNodes.put("16", "name");
        _hHideableNodes.put("17", "col");
        _hHideableNodes.put("18", "tableName");
        _hHideableNodes.put("19", "index");
        _hHideableNodes.put("20", "auxSdes");
        _hHideableNodes.put("21", "columnStats");
        _hHideableNodes.put("22", "consumerThreads");
        _hHideableNodes.put("23", "costs");
        _hHideableNodes.put("24", "cpu");
        _hHideableNodes.put("25", "dataBufReplStrategy");
        _hHideableNodes.put("26", "dataIOSizeInKB");
        _hHideableNodes.put("27", "hashScanDegree");
        _hHideableNodes.put("28", "indexBufReplStrategy");
        _hHideableNodes.put("29", "indexIOSizeInKB");
        _hHideableNodes.put("30", "keyCol");
        _hHideableNodes.put("31", "keyOrder");
        _hHideableNodes.put("32", "keyset");
        _hHideableNodes.put("33", "missingStat");
        _hHideableNodes.put("34", "optmetrics");
        _hHideableNodes.put("35", "optstat");
        _hHideableNodes.put("36", "optTimeMs");
        _hHideableNodes.put("37", "optTimeToFirstPlanMs");
        _hHideableNodes.put("38", "perKey");
        _hHideableNodes.put("39", "plansEvaluated");
        _hHideableNodes.put("40", "positioning");
        _hHideableNodes.put("41", "procCacheBytes");
        _hHideableNodes.put("42", "producerThreads");
        _hHideableNodes.put("43", "resource");
        _hHideableNodes.put("44", "scanCoverage");
        _hHideableNodes.put("45", "scanOrder");
        _hHideableNodes.put("46", "scanType");
        _hHideableNodes.put("47", "statInfo");
        _hHideableNodes.put("48", "threads");
        _hHideableNodes.put("49", "updateMode");
        _hHideableNodes.put("50", "updateTime");
        _hHideableNodes.put("51", "keyCol");
        _hHideableNodes.put("52", "keyOrder");
        _hHideableNodes.put("53", "dataIOSizeInKB");
        _hHideableNodes.put("54", "partitionInfo");
        _hHideableNodes.put("55", "partitionCount");
        _hHideableNodes.put("56", "eliminatedPartition");
    }
}

