/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.ASEPlanViewer;
import com.sybase.ase.planviewer.AdvancedInfo;
import com.sybase.ase.planviewer.XMLTablet;
import com.sybase.ase.planviewer.XMLViewNode;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.tree.DefaultMutableTreeNode;

public class XMLModelNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 10L;
    private String _label;
    private String _indName;
    private String _corrName;
    private String _objName = "";
    private String _name;
    private String _sNoOfProducers = null;
    private String _sNoOfConsumers = null;
    private int[] _iEliminatedPartitions = null;
    private int _iPartitionCount = -1;
    private String _xpath;
    private double _dActLIO = 0.0;
    private double _dEstLIO = 0.0;
    private double _dActPIO = 0.0;
    private double _dEstPIO = 0.0;
    private double _dActRowSize = 0.0;
    private double _dEstRowSize = 0.0;
    private double _dActRowCount = 0.0;
    private double _dEstRowCount = 0.0;
    private XMLViewNode _view;
    private XMLModelNode _childNode;
    private XMLModelNode _rootNode;
    private AdvancedInfo _advancedInfo;
    private String _tooltip;
    private int _xmlType;
    private XMLTablet _xt;
    private double _dCost = 0.0;
    private double _dRank1 = 0.0;
    private double _dRank2 = 0.0;
    private double _dRank3 = 0.0;
    private ASEPlanViewer _pv;

    public XMLModelNode(XMLModelNode xMLModelNode, XMLModelNode xMLModelNode2, String string, String string2, XMLTablet xMLTablet, ASEPlanViewer aSEPlanViewer) {
        this._name = string2;
        this._label = string2;
        this._xpath = string;
        this._xt = xMLTablet;
        this._pv = aSEPlanViewer;
        if (xMLModelNode2 != null) {
            xMLModelNode2.add(this);
        }
        this._rootNode = xMLModelNode != null ? xMLModelNode : this;
    }

    public String getLabel() {
        if (this._rootNode != null && this._rootNode.getType() != 10 && this._name != null) {
            this._label = this.generateLabel();
            return this._label;
        }
        this._label = this._name == null ? "" : this._name;
        return this._label;
    }

    private String generateLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._name.equals("Emit")) {
            this._xt.setCost(this.getTotalCost());
        }
        String string = this.getCostPercentage();
        String string2 = this.getRankColor();
        if (this._name.indexOf("Scan") != -1 && !this._name.startsWith("Cache")) {
            stringBuffer.append("<html>").append(this._name).append("<br>").append(this._name.indexOf("TableScan") != -1 ? "<font color=\"blue\">" : "<font color=\"green\">").append("<strong>");
            if (this._corrName == null) {
                if (!this._objName.equals("")) {
                    stringBuffer.append("(").append(this._objName).append(")");
                }
            } else if (!this._objName.equals("")) {
                stringBuffer.append(this._objName).append("(").append(this._corrName).append(")");
            } else {
                stringBuffer.append("(").append(this._corrName).append(")");
            }
            stringBuffer.append("</strong>").append("</font>").append("</br>");
            if (this._rootNode != null && this._rootNode.getType() != 309) {
                stringBuffer.append("<br>").append(string2).append("[").append(this._pv.getLocalizedMessage("COST")).append(string).append("]").append("</font>").append("</br>");
            }
            if (this._iPartitionCount != -1) {
                stringBuffer.append("<table border='1' cellspacing='5'>").append("<tr>");
                for (int i = 1; i <= this._iPartitionCount; ++i) {
                    if (this._iEliminatedPartitions != null) {
                        boolean bl = false;
                        for (int j = 0; j < this._iEliminatedPartitions.length; ++j) {
                            if (this._iEliminatedPartitions[j] != i) continue;
                            bl = true;
                            break;
                        }
                        stringBuffer.append(bl ? "<td bgcolor=\"red\"></td>" : "<td bgcolor=\"green\"></td>");
                        continue;
                    }
                    stringBuffer.append("<td bgcolor=\"green\"></td>");
                }
                stringBuffer.append("</tr>").append("</table>");
            }
            stringBuffer.append("</html>");
        } else if (this._rootNode != null && this._rootNode.getType() != 309) {
            stringBuffer.append("<html>").append(this._name).append("<br>").append(string2).append("[").append(this._pv.getLocalizedMessage("COST")).append(string).append("]").append("</font>").append("</br>").append("</html>");
        } else if (this._rootNode.toString().equals(this._name)) {
            stringBuffer.append("<html>").append(this._name).append("<br>").append(string2).append("[").append(this._pv.getLocalizedMessage("COST")).append("185.4").append("]").append("</font>").append("</br>").append("</html>");
        } else {
            stringBuffer.append(this._name);
        }
        return stringBuffer.toString();
    }

    protected void setAdvancedInfo(AdvancedInfo advancedInfo) {
        this._advancedInfo = advancedInfo;
    }

    public AdvancedInfo getAdvancedInfo() {
        return this._advancedInfo;
    }

    public String getObjectName() {
        return this._objName;
    }

    public void addElimiatedPartition(int n) {
        if (this._iEliminatedPartitions == null) {
            this._iEliminatedPartitions = new int[1];
            this._iEliminatedPartitions[0] = n;
            return;
        }
        int[] nArray = this._iEliminatedPartitions;
        this._iEliminatedPartitions = new int[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            this._iEliminatedPartitions[i] = nArray[i];
        }
        this._iEliminatedPartitions[nArray.length] = n;
    }

    public int[] getEliminatedPartitions() {
        return this._iEliminatedPartitions;
    }

    public void setPartitionCount(int n) {
        this._iPartitionCount = n;
    }

    public int getPartitionCount() {
        return this._iPartitionCount;
    }

    public void setObjectName(String string) {
        this._objName = string;
    }

    public String getIndexName() {
        return this._indName;
    }

    public void setIndexName(String string) {
        this._indName = string;
    }

    public String getNumberOfProducers() {
        return this._sNoOfProducers;
    }

    public void setNumberOfProducers(String string) {
        this._sNoOfProducers = string;
    }

    public String getNumberOfConsumers() {
        return this._sNoOfConsumers;
    }

    public void setNumberOfConsumers(String string) {
        this._sNoOfConsumers = string;
    }

    public String getCorrelationName() {
        return this._corrName;
    }

    public void setCorrelationName(String string) {
        this._corrName = string;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getXPath() {
        return this._xpath;
    }

    public void setXPath(String string) {
        this._xpath = string;
    }

    public void setToolTip(String string) {
        this._tooltip = string;
    }

    public String getToolTip() {
        return this._tooltip;
    }

    public XMLViewNode getViewNode() {
        return this._view;
    }

    public void setViewNode(XMLViewNode xMLViewNode) {
        this._view = xMLViewNode;
    }

    public XMLTablet getXMLTablet() {
        return this._xt;
    }

    public XMLModelNode getChildNode() {
        return this._childNode;
    }

    public void setEstimatedLIO(double d) {
        this._dEstLIO = d;
    }

    public double getEstimatedLIO() {
        if (this._dEstLIO < 0.0) {
            System.out.println("Warning: Estimated LIO is set to " + this._dEstLIO);
            return 0.0;
        }
        return this._dEstLIO;
    }

    public void setEstimatedPIO(double d) {
        this._dEstPIO = d;
    }

    public double getEstimatedPIO() {
        if (this._dEstPIO < 0.0) {
            System.out.println("Warning: Estimated PIO is set to " + this._dEstPIO);
            return 0.0;
        }
        return this._dEstPIO;
    }

    public void setEstimatedRowSize(double d) {
        this._dEstRowSize = d;
    }

    public double getEstimatedRowSize() {
        if (this._dEstRowSize < 0.0) {
            System.out.println("Warning: Estimated Row Size is set to " + this._dEstRowSize);
            return 0.0;
        }
        return this._dEstRowSize;
    }

    public void setEstimatedRowCount(double d) {
        this._dEstRowCount = d;
    }

    public double getEstimatedRowCount() {
        if (this._dEstRowCount < 0.0) {
            System.out.println("Warning: Estimated Row Count is set to " + this._dEstRowCount);
            return 0.0;
        }
        return this._dEstRowCount;
    }

    public void setActualLIO(double d) {
        this._dActLIO = d;
    }

    public double getActualLIO() {
        if (this._dActLIO < 0.0) {
            System.out.println("Warning: Actual LIO is set to " + this._dActLIO);
            return 0.0;
        }
        return this._dActLIO;
    }

    public void setActualPIO(double d) {
        this._dActPIO = d;
    }

    public double getActualPIO() {
        if (this._dActPIO < 0.0) {
            System.out.println("Warning: Actual PIO is set to " + this._dActPIO);
            return 0.0;
        }
        return this._dActPIO;
    }

    public void setActualRowSize(double d) {
        this._dActRowSize = d;
    }

    public double getActualRowSize() {
        if (this._dActRowSize < 0.0) {
            System.out.println("Warning: Actual Row Size is set to " + this._dActRowSize);
            return 0.0;
        }
        return this._dActRowSize;
    }

    public void setActualRowCount(double d) {
        this._dActRowCount = d;
    }

    public void setType(int n) {
        this._xmlType = n;
    }

    public int getType() {
        return this._xmlType;
    }

    public double getActualRowCount() {
        if (this._dActRowCount < 0.0) {
            System.out.println("Warning: Actual Row Count is set to " + this._dActRowCount);
            return 0.0;
        }
        return this._dActRowCount;
    }

    public void setValue(XMLModelNode xMLModelNode, String string) {
        this._childNode = xMLModelNode;
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        if (this.getName().equals("act")) {
            if (xMLModelNode.getName().equals("lio")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).setActualLIO(d);
                } else {
                    this.setActualLIO(d);
                }
                this.addToCost(2.0 * d);
            } else if (xMLModelNode.getName().equals("pio")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).setActualPIO(d);
                } else {
                    this.setActualPIO(d);
                }
                this.addToCost(25.0 * d);
            } else if (xMLModelNode.getName().equals("rowCnt")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).setActualRowCount(d);
                } else {
                    this.setActualRowCount(d);
                }
            } else if (xMLModelNode.getName().equals("rowSz")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).setActualRowSize(d);
                } else {
                    this.setActualRowSize(d);
                }
            }
        } else if (this.getName().equals("est")) {
            if (xMLModelNode.getName().equals("lio")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).setEstimatedLIO(d);
                } else {
                    this.setEstimatedLIO(d);
                }
            } else if (xMLModelNode.getName().equals("pio")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).setEstimatedPIO(d);
                } else {
                    this.setEstimatedPIO(d);
                }
            } else if (xMLModelNode.getName().equals("rowCnt")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).setEstimatedRowCount(d);
                } else {
                    this.setEstimatedRowCount(d);
                }
            } else if (xMLModelNode.getName().equals("rowSz")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).setEstimatedRowSize(d);
                } else {
                    this.setEstimatedRowSize(d);
                }
            }
        } else if (this.getName().equals("partitionInfo")) {
            if (xMLModelNode.getName().equals("partitionCount")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).setPartitionCount((int)d);
                } else {
                    this.setPartitionCount((int)d);
                }
            } else if (xMLModelNode.getName().equals("eliminatedPartition")) {
                if (this.parent != null) {
                    ((XMLModelNode)this.parent).addElimiatedPartition((int)d);
                } else {
                    this.addElimiatedPartition((int)d);
                }
            }
        }
    }

    private String getCostPercentage() {
        double d = 0.0;
        if (this.getTotalCost() > 0.0) {
            d = (25.0 * this.getActualPIO() + 2.0 * this.getActualLIO()) / this.getTotalCost();
        }
        this.setRanking(d);
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal.setScale(2, 4);
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format(bigDecimal);
    }

    public String getRankColor() {
        return "<font color=\"black\">";
    }

    public void setRanking(double d) {
        if (this._rootNode == null) {
            return;
        }
        if (d > this._rootNode._dRank1) {
            this._rootNode._dRank3 = this._rootNode._dRank2;
            this._rootNode._dRank2 = this._rootNode._dRank1;
            this._rootNode._dRank1 = d;
        } else if (d > this._rootNode._dRank2) {
            this._rootNode._dRank3 = this._rootNode._dRank2;
            this._rootNode._dRank2 = d;
        } else if (d > this._rootNode._dRank3) {
            this._rootNode._dRank3 = d;
        }
    }

    public double getTotalCost() {
        return this._rootNode.getCost();
    }

    private void addToTotalCost(double d) {
        if (this._rootNode != null) {
            if (d < 0.0) {
                return;
            }
            this._rootNode._dCost += d;
        }
    }

    public void addToCost(double d) {
        if (d < 0.0) {
            return;
        }
        this._dCost += d;
        this.addToTotalCost(d);
    }

    public double getCost() {
        if (this._dCost < 0.0) {
            System.out.println("Warning: The Cost is set to :" + this._dCost);
            return 0.0;
        }
        return this._dCost;
    }

    @Override
    public String toString() {
        return this._name;
    }
}

