/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.ASEPlanViewer;
import java.math.BigDecimal;
import java.text.NumberFormat;

final class XMLTablet {
    private int _id;
    private int _iStart = -1;
    private int _iEnd = -1;
    private String _sTitle;
    private String _sStartToken;
    private String _sSQL;
    private double _dCost = 0.0;
    private double _dCostPercent = 0.0;
    private double _dAggregatedCostFromXML = 0.0;
    private double _dAggregatedCostPercentFromXML = 0.0;
    private ASEPlanViewer _pv;
    private boolean _isOldASE = false;

    public XMLTablet(String string, int n, String string2, ASEPlanViewer aSEPlanViewer) {
        this._sTitle = string;
        this._id = n;
        this._pv = aSEPlanViewer;
        this._sStartToken = string2;
    }

    public void printDebugInfo() {
    }

    public void setOldASE(boolean bl) {
        this._isOldASE = bl;
    }

    public boolean isOldASE() {
        return this._isOldASE;
    }

    public String toString() {
        return this._sTitle;
    }

    public double getAggregatedCostFromXML() {
        return this._dAggregatedCostFromXML;
    }

    public void setAggregatedCostFromXML(double d) {
        this._dAggregatedCostFromXML = d;
    }

    public double getAggregatedCostPercentFromXML() {
        return this._dAggregatedCostPercentFromXML;
    }

    public void setAggregatedCostPercentFromXML(double d) {
        this._dAggregatedCostPercentFromXML = d;
    }

    public double getCost() {
        return this._dCost;
    }

    public void setCost(double d) {
        this._dCost = d;
    }

    public double getCostPercent() {
        return this._dCostPercent;
    }

    public void setCostPercent(double d) {
        this._dCostPercent = d;
    }

    public String getWholeSQL() {
        if (this._sSQL == null) {
            return "";
        }
        String string = this._sSQL.replaceAll("\n", "<br>");
        return (string = string.replaceAll("\t", "&nbsp;&nbsp;")).equals(this._sSQL) ? this._sSQL : "<html><body>" + string + "</body></html>";
    }

    public String getSQL() {
        if (this._sSQL == null) {
            return "";
        }
        double d = this.isOldASE() ? this.getCostPercent() : this.getAggregatedCostPercentFromXML();
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal.setScale(2, 4);
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMinimumIntegerDigits(2);
        String string = "[" + numberFormat.format(bigDecimal) + "] " + this._sSQL;
        string = string.replaceAll("\n", " ");
        string = string.replaceAll("\t", " ");
        string = string.replaceAll("  ", " ");
        string = string.replaceAll("  ", " ");
        return string;
    }

    public void setSQL(String string) {
        int n;
        if (string == null || string.trim().length() == 0) {
            string = "No query text available";
        }
        this._sSQL = (n = string.indexOf(this._pv.getLocalizedMessage("SQL_TEXT"))) != -1 ? string.substring(n + this._pv.getLocalizedMessage("SQL_TEXT").length() + 1).trim() : string;
    }

    public int getStartOffset() {
        return this._iStart;
    }

    public int getEndOffset() {
        return this._iEnd;
    }

    public void setStartOffset(int n) {
        this._iStart = n;
    }

    public void setEndOffset(int n) {
        this._iEnd = n;
    }

    public void computeOffsets() {
    }

    public String getSubString(String string) {
        if (this._iStart == -1 || this._iEnd == -1) {
            return string;
        }
        return string.substring(this._iStart, this._iEnd);
    }

    public int getId() {
        return this._id;
    }
}

