/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.ASEPlanViewer;
import com.sybase.ase.planviewer.Constants;
import com.sybase.ase.planviewer.XMLModelNode;
import com.sybase.ase.planviewer.XMLViewNode;
import com.sybase.ase.planviewer.XMLViewNodeButton;
import com.sybase.ase.planviewer.XMLViewNodeLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class XMLTreeView
extends JPanel {
    private static final long serialVersionUID = 6L;
    ASEPlanViewer _asePlanViewer;
    XMLModelNode _root;
    int _preferred_width = 0;
    int _preferred_height = 0;
    XMLViewNode _prevNode;
    Graphics _g;
    ActionListener _node_button_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLViewNodeButton xMLViewNodeButton = (XMLViewNodeButton)actionEvent.getSource();
            try {
                XMLTreeView.this._asePlanViewer.scrollToNode(xMLViewNodeButton.getParentView());
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
            if (XMLTreeView.this._prevNode != null) {
                XMLTreeView.this._prevNode.doDeSelectAction();
            }
            xMLViewNodeButton.doSelectAction();
            XMLTreeView.this._prevNode = xMLViewNodeButton.getParentView();
        }
    };
    MouseAdapter _node_mouse_listener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            XMLViewNodeLabel xMLViewNodeLabel = (XMLViewNodeLabel)mouseEvent.getSource();
            XMLModelNode xMLModelNode = xMLViewNodeLabel.getParentView().getModelNode();
            xMLViewNodeLabel.toggleState();
            XMLTreeView.this.showChildren(xMLModelNode, xMLViewNodeLabel.isExpanded());
            XMLTreeView.this.paintLines(xMLModelNode);
            if (!xMLViewNodeLabel.isExpanded()) {
                xMLViewNodeLabel.getParentView().getButton().doClick();
            }
        }
    };

    public XMLTreeView() {
        this.setLayout(null);
        this.setBackground(Constants.TREEVIEW_BACKGROUND);
        this.setSize(200, 200);
    }

    protected void showChildren(XMLModelNode xMLModelNode, boolean bl) {
        Enumeration<TreeNode> enumeration = xMLModelNode.children();
        while (enumeration != null && enumeration.hasMoreElements()) {
            XMLModelNode xMLModelNode2 = (XMLModelNode)enumeration.nextElement();
            XMLViewNode xMLViewNode = xMLModelNode2.getViewNode();
            if (bl && !xMLViewNode.getLabel().isExpanded()) {
                xMLViewNode.setVisible(bl);
                continue;
            }
            xMLViewNode.setVisible(bl);
            this.showChildren(xMLModelNode2, bl);
        }
    }

    protected void paintLines(XMLModelNode xMLModelNode) {
        Enumeration<TreeNode> enumeration = xMLModelNode.children();
        XMLViewNode xMLViewNode = xMLModelNode.getViewNode();
        Rectangle rectangle = xMLViewNode.getBounds();
        while (enumeration != null && enumeration.hasMoreElements()) {
            XMLModelNode xMLModelNode2 = (XMLModelNode)enumeration.nextElement();
            XMLViewNode xMLViewNode2 = xMLModelNode2.getViewNode();
            Rectangle rectangle2 = xMLViewNode2.getBounds();
            boolean bl = xMLModelNode.getViewNode().isVisible();
            if (xMLModelNode2.getParent() != null) {
                bl = bl && ((XMLModelNode)xMLModelNode2.getParent()).getViewNode().getLabel().isExpanded();
            }
            this.drawLine(rectangle, rectangle2, bl);
            this.paintLines(xMLModelNode2);
        }
    }

    private void drawLine(Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        int n = rectangle.x + rectangle.width / 2;
        int n2 = rectangle.y + rectangle.height / 2;
        int n3 = rectangle2.x + rectangle2.width / 2;
        int n4 = rectangle2.y + rectangle2.height / 2;
        this._g.setColor(bl ? Color.BLACK : this.getBackground());
        this._g.drawLine(n, n2, n3, n4);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this._root != null) {
            this._g = graphics;
            this.paintLines(this._root);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this._preferred_width, this._preferred_height);
    }

    public void build(ASEPlanViewer aSEPlanViewer, XMLModelNode xMLModelNode) throws Exception {
        this.removeAll();
        this.setLayout(null);
        this.repaint();
        this._asePlanViewer = aSEPlanViewer;
        this._root = xMLModelNode;
        new Builder().build(xMLModelNode, 0, 0, 0);
    }

    class Builder {
        final int VS = 10;
        final int HS = 10;
        Vector _rightmost = new Vector();

        Builder() {
        }

        private int getRightMost(int n) {
            int n2 = 0;
            while (n >= 0) {
                n2 = Math.max(n2, (Integer)this._rightmost.elementAt(n));
                --n;
            }
            return n2;
        }

        public void build(XMLModelNode xMLModelNode, int n, int n2, int n3) throws Exception {
            Rectangle rectangle;
            int n4;
            Enumeration<TreeNode> enumeration;
            Component component = null;
            Component component2 = null;
            XMLViewNode xMLViewNode = new XMLViewNode(xMLModelNode);
            xMLViewNode.getButton().addActionListener(XMLTreeView.this._node_button_listener);
            xMLViewNode.getLabel().addMouseListener(XMLTreeView.this._node_mouse_listener);
            if (xMLModelNode.getToolTip() != null) {
                xMLViewNode.setToolTipText(xMLModelNode.getToolTip());
            }
            Dimension dimension = xMLViewNode.getPreferredSize();
            dimension.width = Math.max(dimension.width, n3);
            if (n + 1 > this._rightmost.size()) {
                this._rightmost.addElement(new Integer(0));
            }
            if ((enumeration = xMLModelNode.children()) == null || xMLModelNode.getChildCount() == 0) {
                n4 = this.getRightMost(n);
                rectangle = new Rectangle(new Point(n4, n2), dimension);
                n4 += dimension.width + 10;
            } else {
                int n5 = n2 + dimension.height + 10;
                n3 = dimension.width / xMLModelNode.getChildCount();
                if (n + 2 > this._rightmost.size()) {
                    this._rightmost.addElement(new Integer(0));
                }
                while (enumeration.hasMoreElements()) {
                    XMLModelNode xMLModelNode2 = (XMLModelNode)enumeration.nextElement();
                    this.build(xMLModelNode2, n + 1, n5, n3);
                    if (component == null) {
                        component = xMLModelNode2.getViewNode();
                    }
                    component2 = xMLModelNode2.getViewNode();
                }
                int n6 = component.getBounds().x;
                int n7 = component2.getBounds().x + component2.getBounds().width;
                n4 = n6 + (n7 - n6 - dimension.width) / 2;
                rectangle = new Rectangle(n4, n2, dimension.width, dimension.height);
                n4 = Math.max(n7 + 10, n4 + dimension.width + 10);
            }
            XMLTreeView.this._preferred_width = Math.max(XMLTreeView.this._preferred_width, rectangle.x + rectangle.width);
            XMLTreeView.this._preferred_height = Math.max(XMLTreeView.this._preferred_height, rectangle.y + rectangle.height);
            xMLViewNode.setBounds(rectangle);
            XMLTreeView.this.add(xMLViewNode);
            this._rightmost.setElementAt(new Integer(n4), n);
            XMLTreeView.this._asePlanViewer.scrollToNode(xMLViewNode);
        }
    }
}

