/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCMenuItem;
import com.sybase.central.viewer.IMenuListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class BaseMenuItem
implements SCMenuItem,
MouseListener,
ActionListener {
    private String _name = null;
    private String _hintText = null;
    private int _commandId = 0;
    private int _menuItemIndex = -1;
    protected JMenuItem _jItem = null;
    private IMenuListener _listener = null;

    BaseMenuItem() {
    }

    BaseMenuItem(JMenu jMenu, String string) {
        this._name = jMenu.getText();
        this._jItem = jMenu;
        if (string != null) {
            jMenu.setMnemonic(string.charAt(0));
        }
    }

    BaseMenuItem(JMenuItem jMenuItem, String string, String string2, int n, IMenuListener iMenuListener) {
        this.initialize(jMenuItem, string, string2, n, iMenuListener, -1);
    }

    BaseMenuItem(JMenuItem jMenuItem, char c, String string, int n, IMenuListener iMenuListener, int n2) {
        if (c >= '\u0000') {
            this.initialize(jMenuItem, String.valueOf(c), string, n, iMenuListener, -1);
        } else {
            this.initialize(jMenuItem, null, string, n, iMenuListener, -1);
        }
        this._menuItemIndex = n2;
    }

    BaseMenuItem(JMenuItem jMenuItem, char c, String string, int n, IMenuListener iMenuListener, int n2, int n3) {
        if (c >= '\u0000') {
            this.initialize(jMenuItem, String.valueOf(c), string, n, iMenuListener, n3);
        } else {
            this.initialize(jMenuItem, null, string, n, iMenuListener, n3);
        }
        this._menuItemIndex = n2;
    }

    private void initialize(JMenuItem jMenuItem, String string, String string2, int n, IMenuListener iMenuListener, int n2) {
        this._name = jMenuItem.getText();
        this._hintText = string2;
        this._commandId = n;
        this._listener = iMenuListener;
        this._jItem = jMenuItem;
        if (string != null) {
            jMenuItem.setMnemonic(string.charAt(0));
            if (n2 >= 0 && n2 < this._name.length()) {
                jMenuItem.setDisplayedMnemonicIndex(n2);
            }
        }
        this._jItem.addActionListener(this);
        this._jItem.addMouseListener(this);
    }

    boolean isSeparator() {
        return this._jItem == null;
    }

    int getMenuItemIndex() {
        return this._menuItemIndex;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public JMenuItem getJMenuItem() {
        return this._jItem;
    }

    @Override
    public String getHintText() {
        return this._hintText;
    }

    @Override
    public int getCommandId() {
        return this._commandId;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._listener != null) {
            this._listener.mouseEnteredMenu(this._hintText);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._listener != null) {
            this._listener.mouseExitedMenu();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._listener != null) {
            this._listener.mouseExitedMenu();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._listener != null) {
            if (this._menuItemIndex >= 0) {
                this._listener.menuItemSelected(this._commandId, this._menuItemIndex);
            } else {
                this._listener.menuItemSelected(this._commandId);
            }
        }
    }
}

