/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.ProfilesKey;
import com.sybase.central.viewer.RepositoryKey;
import com.sybase.central.viewer.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

class BaseRepository {
    protected String repFilename = "";
    private boolean _isApplet;
    private RepositoryKey _rootKey;
    static final String REP_SEPARATOR = "/";
    static final String REP_DIVISION = "#";

    BaseRepository(boolean bl) {
        this._isApplet = bl;
    }

    RepositoryKey getRepositoryKey() {
        return this._rootKey;
    }

    String getFileName() {
        return this.repFilename;
    }

    void setFileName(String string) {
        this.repFilename = string;
    }

    RepositoryKey openKey(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, REP_SEPARATOR);
        RepositoryKey repositoryKey = this._rootKey;
        while (stringTokenizer.hasMoreTokens() && (repositoryKey = repositoryKey.openKey(stringTokenizer.nextToken(), bl)) != null) {
        }
        return repositoryKey;
    }

    void addEntry(String string, String string2, boolean bl) {
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, REP_SEPARATOR);
            if (bl) {
                char[] cArray = string2.toCharArray();
                ProfilesKey.encryptBlock(cArray);
                this._rootKey.addEntry(stringTokenizer, ProfilesKey.makeHexString(cArray));
            } else {
                this._rootKey.addEntry(stringTokenizer, string2);
            }
        }
    }

    boolean load() throws IOException {
        return this.load(true);
    }

    /*
     * Loose catch block
     */
    boolean load(boolean bl) throws IOException {
        InputStream inputStream = null;
        Properties properties = new Properties();
        BufferedReader bufferedReader = null;
        try {
            if (this._isApplet) {
                URL uRL = new URL(this.getFileName());
                inputStream = uRL.openStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            } else {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), "UTF-8"));
            }
            String string = bufferedReader.readLine();
            if (string == null) {
                this._rootKey = new RepositoryKey();
                boolean bl2 = false;
                return bl2;
            }
            while (string != null) {
                int n;
                if (!string.startsWith(REP_DIVISION) && (n = string.indexOf("=")) != -1) {
                    String[] stringArray = new String[]{string.substring(0, n), string.substring(n + 1)};
                    properties.put(stringArray[0], stringArray[1]);
                }
                string = bufferedReader.readLine();
            }
            this.setupRepository(properties);
        }
        catch (MalformedURLException malformedURLException) {
            this._rootKey = new RepositoryKey();
            boolean bl3 = false;
            return bl3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this._rootKey = new RepositoryKey();
            try {
                File file = new File(this.getFileName());
                if (bl) {
                    file.createNewFile();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            boolean bl4 = false;
            return bl4;
        }
        catch (IOException iOException) {
            throw iOException;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    if (this._isApplet && inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    boolean hasWriteAccess() {
        try {
            File file = new File(this.getFileName());
            return file.canWrite();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void save() throws IOException {
        this.save(true);
    }

    public void save(boolean bl) throws IOException {
        File file = null;
        File file2 = null;
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        if (!bl || bl && this.hasWriteAccess()) {
            try {
                fileOutputStream = new FileOutputStream(this.getFileName() + "_new");
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                printWriter.println("#  Version: " + Version.getVersionString());
                printWriter.println("#  " + new Date());
                printWriter.println(REP_DIVISION);
                this._rootKey.writeKey("", printWriter);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            file = new File(this.getFileName());
            if (file.exists()) {
                file2 = new File(this.getFileName() + "_backup");
                file2.delete();
                file.renameTo(file2);
            }
            if ((file = new File(this.getFileName() + "_new")).exists()) {
                file2 = new File(this.getFileName());
                file.renameTo(file2);
            }
        }
    }

    protected void setupRepository(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        this._rootKey = new RepositoryKey();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string, REP_SEPARATOR);
            this._rootKey.addEntry(stringTokenizer, properties.getProperty(string));
            stringTokenizer = null;
        }
    }
}

