/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.RepositoryKey;
import com.sybase.central.viewer.SCRepository;
import com.sybase.central.viewer.ScjSession;
import java.awt.Image;
import java.io.File;

class Configuration {
    private RepositoryKey _currentConfigKey;
    private static final String REP_CONFIG_KEY = "Config";
    private static final String CONFIG_SPLASH = "ShowSplash";
    private static final String CONFIG_SPLASHFILE = "SplashImageFile";
    private static final String CONFIG_TITLE = "Title";
    private static final String CONFIG_ICONFILE = "IconFile";
    private static final String CONFIG_SYBCENT_HLP = "ShowSybaseCentralHelp";
    private static final String CONFIG_ROOT_NAME = "RootName";

    Configuration(SCRepository sCRepository, String string) {
        this._currentConfigKey = sCRepository.openKey("Config/" + string, false);
    }

    boolean isSplashscreenEnabled() {
        if (this._currentConfigKey != null) {
            Boolean bl = this._currentConfigKey.getBooleanValue(CONFIG_SPLASH);
            if (bl == null) {
                return true;
            }
            return bl;
        }
        return true;
    }

    Image getSplashscreenImage(ScjSession scjSession) {
        String string;
        if (!scjSession.isApplet() && this._currentConfigKey != null && (string = this._currentConfigKey.getStringValue(CONFIG_SPLASHFILE)) != null) {
            return this.getImage(scjSession, string);
        }
        return null;
    }

    String getTitle() {
        if (this._currentConfigKey != null) {
            return this._currentConfigKey.getStringValue(CONFIG_TITLE);
        }
        return null;
    }

    Image getIconImage(ScjSession scjSession) {
        String string;
        if (!scjSession.isApplet() && this._currentConfigKey != null && (string = this._currentConfigKey.getStringValue(CONFIG_ICONFILE)) != null) {
            return this.getImage(scjSession, string);
        }
        return null;
    }

    boolean isSybaseCentralHelpEnabled() {
        if (this._currentConfigKey != null) {
            Boolean bl = this._currentConfigKey.getBooleanValue(CONFIG_SYBCENT_HLP);
            if (bl == null) {
                return true;
            }
            return bl;
        }
        return true;
    }

    String getRootName() {
        if (this._currentConfigKey != null) {
            return this._currentConfigKey.getStringValue(CONFIG_ROOT_NAME);
        }
        return null;
    }

    private Image getImage(ScjSession scjSession, String string) {
        Image image = null;
        if (string.indexOf(File.separatorChar) != -1) {
            image = scjSession.getBundleManager().getImageWithPath(string);
        } else {
            String string2 = scjSession.getCommandLineProperties().getProperty("screpository");
            if (string2 == null) {
                string2 = "";
            } else {
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                image = scjSession.getBundleManager().getImageWithPath(string2 + string);
            }
            if (image == null) {
                // empty if block
            }
        }
        return image;
    }
}

