/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.DefaultSCDialogController;
import com.sybase.central.DefaultSCPageController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import com.sybase.central.SCProvider;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.ChangeDescriptionDlg;
import com.sybase.central.viewer.ConnProfileDlgJPanel;
import com.sybase.central.viewer.ConnectThread;
import com.sybase.central.viewer.ConnectionProfile;
import com.sybase.central.viewer.CreateProfileDlg;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.IHelpConstants;
import com.sybase.central.viewer.ImportConnectionProfileDlg;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.Providers;
import com.sybase.central.viewer.SCButton;
import com.sybase.central.viewer.SCMultiList;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.central.viewer.Utilities;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ConnProfileDlg
extends DefaultSCPageController
implements ScjResourceConstants,
ActionListener,
ListSelectionListener,
IConstants,
IHelpConstants {
    private final int NAME_COL = 0;
    private final int STARTUP_COL = 1;
    private final int PLUGIN_COL = 2;
    private final int TYPE_COL = 3;
    private final int DESCRIPTION_COL = 4;
    private ScjSession _session = null;
    private ScjViewerSupport _viewerSupport = null;
    private SCButton _jcb_close;
    private SCButton _jcb_connect;
    private SCButton _jcb_new;
    private SCButton _jcb_edit;
    private SCButton _jcb_changeDescription;
    private SCButton _jcb_delete;
    private SCButton _jcb_export;
    private SCButton _jcb_import;
    private SCButton _jcb_startup;
    private SCButton _jcb_help;
    private SCMultiList _profList;
    private Providers _providers;
    private MouseListener _mouseListener;

    ConnProfileDlg(SCDialogSupport sCDialogSupport, ScjSession scjSession, ScjViewerSupport scjViewerSupport) {
        super(sCDialogSupport, new ConnProfileDlgJPanel());
        this._session = scjSession;
        this._viewerSupport = scjViewerSupport;
        this._providers = scjViewerSupport.getProviders();
        ConnProfileDlgJPanel connProfileDlgJPanel = (ConnProfileDlgJPanel)this.getJPanel();
        JLabel jLabel = connProfileDlgJPanel.jlabel_label;
        JPanel jPanel = connProfileDlgJPanel.jpanel_panel;
        this._profList = connProfileDlgJPanel.scmultil_list;
        this._jcb_close = connProfileDlgJPanel.jcb_close;
        this._jcb_connect = connProfileDlgJPanel.jcb_connect;
        this._jcb_new = connProfileDlgJPanel.jcb_new;
        this._jcb_edit = connProfileDlgJPanel.jcb_edit;
        this._jcb_changeDescription = connProfileDlgJPanel.jcb_changeDescription;
        this._jcb_delete = connProfileDlgJPanel.jcb_delete;
        this._jcb_export = connProfileDlgJPanel.jcb_export;
        this._jcb_import = connProfileDlgJPanel.jcb_import;
        this._jcb_startup = connProfileDlgJPanel.jcb_startup;
        this._jcb_help = connProfileDlgJPanel.jcb_help;
        jLabel.setText(ScjSession.getString("STR_CONNPROF_LABEL"));
        jLabel.setLabelFor(this._profList);
        this._jcb_close.setText(ScjSession.getString("STR_CONNPROF_CLOSE_BTN"));
        this._jcb_connect.setText(ScjSession.getString("STR_CONNPROF_CONNECT_BTN"));
        this._jcb_new.setText(ScjSession.getString("STR_CONNPROF_NEW_BTN"));
        this._jcb_edit.setText(ScjSession.getString("STR_CONNPROF_EDIT_BTN"));
        this._jcb_changeDescription.setText(ScjSession.getString("STR_CONNPROF_CHANGE_DESC_BTN"));
        this._jcb_delete.setText(ScjSession.getString("STR_CONNPROF_DELETE_BTN"));
        this._jcb_export.setText(ScjSession.getString("STR_CONNPROF_EXPORT_BTN"));
        this._jcb_import.setText(ScjSession.getString("STR_CONNPROF_IMPORT_BTN"));
        this._jcb_startup.setText(ScjSession.getString("STR_CONNPROF_STARTUP_BTN"));
        this._jcb_help.setText(ScjSession.getString("STR_DLG_HELP_BUTTON"));
        JComponent[] jComponentArray = new JComponent[]{this._jcb_close, this._jcb_connect, this._jcb_new, this._jcb_edit, this._jcb_changeDescription, this._jcb_delete, this._jcb_export, this._jcb_import, this._jcb_startup, this._jcb_help};
        DialogUtils.makeComponentsSameWidth((JComponent[])jComponentArray);
        this._profList.setSelectionMode(2);
        this._profList.setAutoResizeMode(0);
        this._profList.setColumnHeadings(new StringBuffer(ScjSession.getString("STR_CONNPROF_CONNPROF")).append(", ").append(ScjSession.getString("STR_CONNPROF_STARTUP")).append(", ").append(ScjSession.getString("STR_CONNPROF_PLUGIN")).append(", ").append(ScjSession.getString("STR_CONNPROF_ACCESS")).append(", ").append(ScjSession.getString("STR_CONNPROF_DESCRIPTION")).toString());
        this._profList.setColumnWidths("150, 100, 195, 100, 200");
        this._profList.setColumnHasIconTextData(0, true);
        this._profList.getScrollPane().setPreferredSize(new Dimension(515, 200));
        jPanel.add("list", this._profList.getScrollPane());
        this._jcb_close.addActionListener(this);
        this._jcb_new.addActionListener(this);
        this._jcb_connect.addActionListener(this);
        this._jcb_edit.addActionListener(this);
        this._jcb_changeDescription.addActionListener(this);
        this._jcb_delete.addActionListener(this);
        this._jcb_export.addActionListener(this);
        this._jcb_import.addActionListener(this);
        this._jcb_startup.addActionListener(this);
        this._jcb_help.addActionListener(this);
        this._profList.addListSelectionListener(this);
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    ConnProfileDlg.this.connectButtonPressed();
                }
            }
        };
        this._profList.addMouseListener(this._mouseListener);
    }

    @Override
    public void onInitDialog() {
        ActionListener actionListener = null;
        this.fillProfileList();
        this._dialogSupport.getJDialog().getRootPane().setDefaultButton((JButton)((Object)this._jcb_new));
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConnProfileDlg.this._jcb_delete.isEnabled()) {
                    ConnProfileDlg.this.deleteButtonPressed();
                }
            }
        };
        this._profList.registerKeyboardAction(actionListener, null, DELETE, 1);
        this._profList.requestFocusInWindow();
    }

    @Override
    public void onHelp() {
        this._session.showHelpIndex("HELP_CONNPROFILEDLG_INDEX", this._dialogSupport);
    }

    private void fillProfileList() {
        String string = null;
        Vector<String> vector = null;
        Enumeration enumeration = null;
        ConnectionProfile connectionProfile = null;
        String string2 = null;
        String string3 = null;
        this._profList.removeListSelectionListener(this);
        int n = this._profList.getSelectedRow();
        if (n > -1) {
            string = this._profList.getStringAt(n, 0);
        }
        this._profList.clear();
        enumeration = this._session.getConnectionProfilesKey().getConnectionProfiles();
        while (enumeration.hasMoreElements()) {
            connectionProfile = (ConnectionProfile)enumeration.nextElement();
            string2 = ScjSession.getString("STR_SCJ_NO");
            if (this._session.getUserPrefRepositoryInfo().isConnProfAutostart(connectionProfile.getName(), true)) {
                string2 = ScjSession.getString("STR_SCJ_YES");
            }
            string3 = ScjSession.getString("STR_CONNPROF_THIS_USER");
            if (connectionProfile.isSystemProfile()) {
                string3 = ScjSession.getString("STR_CONNPROF_ALL_USERS");
            }
            vector = new Vector<String>();
            vector.addElement(connectionProfile.getName());
            vector.addElement(string2);
            vector.addElement(connectionProfile.getProviderName());
            vector.addElement(string3);
            vector.addElement(connectionProfile.getDescription());
            this._profList.addRowWithIcon(JCOMP_CONN_PROFILE_ICON, vector);
        }
        this._profList.sort();
        if (this._profList.getRowCount() > 0) {
            for (n = 0; n < this._profList.getRowCount(); ++n) {
                if (!this._profList.getStringAt(n, 0).equals(string)) continue;
                this._profList.selectRow(n);
                break;
            }
            if (string == null) {
                this._profList.selectRow(0);
            }
        }
        this._profList.addListSelectionListener(this);
        this.enableButtons();
    }

    private void enableButtons() {
        this._jcb_new.setEnabled(true);
        this._jcb_import.setEnabled(!this._session.isApplet());
        if (this._profList.getRowCount() == 0 || this._profList.getSelectedRowCount() == 0) {
            this._jcb_connect.setEnabled(false);
            this._jcb_edit.setEnabled(false);
            this._jcb_changeDescription.setEnabled(false);
            this._jcb_delete.setEnabled(false);
            this._jcb_export.setEnabled(false);
            this._jcb_startup.setEnabled(false);
        } else {
            this._jcb_connect.setEnabled(true);
            this._jcb_startup.setEnabled(true);
            if (!this._session.isApplet()) {
                this._jcb_edit.setEnabled(this.isSelectedProfileModifiable());
                this._jcb_changeDescription.setEnabled(this.isSelectedProfileModifiable());
                this._jcb_delete.setEnabled(this.isSelectedProfileModifiable());
                this._jcb_export.setEnabled(true);
            } else {
                this._jcb_edit.setEnabled(false);
                this._jcb_changeDescription.setEnabled(false);
                this._jcb_delete.setEnabled(false);
                this._jcb_export.setEnabled(false);
            }
        }
    }

    private void newButtonPressed() {
        boolean bl;
        boolean bl2 = false;
        Enumeration enumeration = this._providers.getProviderList();
        String[] stringArray = new String[1];
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded() || !providerEntry.getProvider().supportsConnectionProfiles()) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), ScjSession.getString("ERR_CONNPROF_NO_LOADED_PLUGINS"), 0);
            return;
        }
        SCDialogSupport sCDialogSupport = this._viewerSupport.getDialogSupport(this._dialogSupport.getJDialog());
        CreateProfileDlg createProfileDlg = new CreateProfileDlg(sCDialogSupport, this._session, this._viewerSupport, stringArray);
        SCPageController[] sCPageControllerArray = new SCPageController[]{createProfileDlg};
        DefaultSCDialogController defaultSCDialogController = new DefaultSCDialogController(sCDialogSupport, sCPageControllerArray, 0);
        sCDialogSupport.setDialogController(defaultSCDialogController);
        sCDialogSupport.setTitle(ScjSession.getString("STR_CREATE_PROFILE"));
        sCDialogSupport.setStandardButtons(true);
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
        boolean bl3 = bl = !sCDialogSupport.render();
        if (!bl) {
            this.fillProfileList();
            this._profList.removeListSelectionListener(this);
            for (int i = 0; i < this._profList.getRowCount(); ++i) {
                if (!this._profList.getStringAt(i, 0).equals(stringArray[0])) continue;
                this._profList.selectRow(i);
                break;
            }
            this._profList.addListSelectionListener(this);
            this.enableButtons();
        }
    }

    @Override
    public void releaseResources() {
        this._session = null;
        this._viewerSupport = null;
        this._jcb_close.removeActionListener(this);
        this._jcb_new.removeActionListener(this);
        this._jcb_connect.removeActionListener(this);
        this._jcb_edit.removeActionListener(this);
        this._jcb_changeDescription.removeActionListener(this);
        this._jcb_delete.removeActionListener(this);
        this._jcb_export.removeActionListener(this);
        this._jcb_import.removeActionListener(this);
        this._jcb_startup.removeActionListener(this);
        this._jcb_help.removeActionListener(this);
        this._profList.unregisterKeyboardAction(DELETE);
        this._profList.releaseResources();
        this._profList.removeListSelectionListener(this);
        this._profList.removeMouseListener(this._mouseListener);
        super.releaseResources();
    }

    @Override
    public boolean onCancel() {
        this._session.saveSCPreferences();
        ConnProfileDlg connProfileDlg = this;
        connProfileDlg._session.saveUserPreferences();
        return super.onCancel();
    }

    void closeButtonPressed() {
        if (this._session != null) {
            this._session.saveSCPreferences();
            ConnProfileDlg connProfileDlg = this;
            connProfileDlg._session.saveUserPreferences();
            this._dialogSupport.closeDialog(true);
            this._dialogSupport.releaseResources();
        }
    }

    private void startupButtonPressed() {
        int[] nArray = null;
        String string = ScjSession.getString("STR_SCJ_YES");
        nArray = this._profList.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            boolean bl = true;
            if (this._profList.getStringAt(nArray[i], 1).equals(ScjSession.getString("STR_SCJ_YES"))) {
                string = ScjSession.getString("STR_SCJ_NO");
                bl = false;
            }
            this._profList.setValueAt(string, nArray[i], 1);
            ConnectionProfile connectionProfile = this._session.getConnectionProfilesKey().getConnectionProfileByName(this._profList.getStringAt(nArray[i], 0));
            this._session.getUserPrefRepositoryInfo().setConnProfAutostart(connectionProfile.getName(), bl);
        }
    }

    public void connectButtonPressed() {
        int n = this._profList.getSelectedRow();
        if (n < 0) {
            return;
        }
        ConnectionProfile connectionProfile = this._session.getConnectionProfilesKey().getConnectionProfileByName(this._profList.getStringAt(n, 0));
        String string = connectionProfile.getProviderName();
        Enumeration enumeration = this._providers.getProviderList();
        while (enumeration.hasMoreElements()) {
            SCProvider sCProvider;
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded() || !(sCProvider = providerEntry.getProvider()).getDisplayName().equals(string)) continue;
            JFrame jFrame = this.getJFrameParent();
            this._dialogSupport.startWait();
            SwingUtilities.invokeLater(new ConnectThread(jFrame, this._viewerSupport, this._dialogSupport, sCProvider, connectionProfile, this));
            return;
        }
        this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), ScjSession.getString("ERR_CONNPROF_PLUGIN_NOT_LOADED"), 0);
    }

    private void editButtonPressed() {
        int n = this._profList.getSelectedRow();
        this._profList.removeListSelectionListener(this);
        this._profList.selectRow(n);
        this._profList.addListSelectionListener(this);
        ConnectionProfile connectionProfile = this._session.getConnectionProfilesKey().getConnectionProfileByName(this._profList.getStringAt(n, 0));
        String string = connectionProfile.getProviderName();
        Enumeration enumeration = this._providers.getProviderList();
        while (enumeration.hasMoreElements()) {
            SCProvider sCProvider;
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded() || !(sCProvider = providerEntry.getProvider()).getDisplayName().equals(string)) continue;
            JFrame jFrame = this.getJFrameParent();
            sCProvider.editConnection(jFrame, connectionProfile.getDataProfilesKey());
            return;
        }
        this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), ScjSession.getString("ERR_CONNPROF_PLUGIN_NOT_LOADED"), 0);
    }

    private void changeDescriptionButtonPressed() {
        ConnectionProfile connectionProfile = null;
        SCDialogSupport sCDialogSupport = null;
        ChangeDescriptionDlg changeDescriptionDlg = null;
        SCPageController[] sCPageControllerArray = null;
        DefaultSCDialogController defaultSCDialogController = null;
        int n = this._profList.getSelectedRow();
        this._profList.removeListSelectionListener(this);
        this._profList.selectRow(n);
        this._profList.addListSelectionListener(this);
        connectionProfile = this._session.getConnectionProfilesKey().getConnectionProfileByName(this._profList.getStringAt(n, 0));
        sCDialogSupport = this._viewerSupport.getDialogSupport(this._dialogSupport.getJDialog());
        changeDescriptionDlg = new ChangeDescriptionDlg(sCDialogSupport, this._session, connectionProfile);
        sCPageControllerArray = new SCPageController[]{changeDescriptionDlg};
        defaultSCDialogController = new DefaultSCDialogController(sCDialogSupport, sCPageControllerArray, 0);
        sCDialogSupport.setDialogController(defaultSCDialogController);
        sCDialogSupport.setTitle(ScjSession.getString("STR_CHANGE_DESC_TITLE"));
        sCDialogSupport.setStandardButtons(true);
        sCDialogSupport.setHelpButton(false);
        sCDialogSupport.setModal(true);
        sCDialogSupport.setResizable(true);
        if (sCDialogSupport.render()) {
            this.fillProfileList();
        }
    }

    private void deleteButtonPressed() {
        int[] nArray = this._profList.getSelectedRows();
        ConnectionProfile connectionProfile = null;
        int n = this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), ScjSession.getString("STR_CONNPROF_DELETE_PROFILE"), 0, 3);
        if (n == 0) {
            this._profList.removeListSelectionListener(this);
            for (int i = nArray.length - 1; i >= 0; --i) {
                connectionProfile = this._session.getConnectionProfilesKey().getConnectionProfileByName(this._profList.getStringAt(nArray[i], 0));
                this._session.getConnectionProfilesKey().removeConnectionProfile(this._profList.getStringAt(nArray[i], 0));
                this._profList.removeRow(nArray[i]);
            }
            if (this._profList.getRowCount() > 0) {
                this._profList.setRowSelectionInterval(0, 0);
            }
            this._profList.addListSelectionListener(this);
        }
        this.enableButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportButtonPressed() {
        SybFileFilter[] sybFileFilterArray = null;
        File file = null;
        int[] nArray = null;
        ConnectionProfile connectionProfile = null;
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        SybFileFilter[] sybFileFilterArray2 = new SybFileFilter[1];
        sybFileFilterArray2[0] = new SybFileFilter("cpr", ScjSession.getString("STR_CPR_FILTER"));
        sybFileFilterArray = sybFileFilterArray2;
        file = Utilities.showFileChooser(this._dialogSupport.getJDialog(), this._session.getUserPrefRepositoryInfo().getLastBrowseDir(), sybFileFilterArray, false);
        if (file != null) {
            this._session.getUserPrefRepositoryInfo().setLastBrowseDir(file.getParent());
            nArray = this._profList.getSelectedRows();
            try {
                fileOutputStream = new FileOutputStream(file);
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                for (int i = 0; i < nArray.length; ++i) {
                    connectionProfile = this._session.getConnectionProfilesKey().getConnectionProfileByName(this._profList.getStringAt(nArray[i], 0));
                    connectionProfile.getKey().writeKey("ConnectionProfiles/", printWriter);
                }
            }
            catch (IOException iOException) {
                SybOptionPane.showMessageDialog((Component)this._dialogSupport.getJDialog(), (Object)ScjSession.getString("ERR_CONN_PROF_EXPORT"), (String)ScjSession.getString("STR_APP_NAME"), (int)0);
            }
            finally {
                printWriter.close();
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void importButtonPressed() {
        SCDialogSupport sCDialogSupport = null;
        ImportConnectionProfileDlg importConnectionProfileDlg = null;
        SCPageController[] sCPageControllerArray = null;
        DefaultSCDialogController defaultSCDialogController = null;
        sCDialogSupport = this._viewerSupport.getDialogSupport(this._dialogSupport.getJDialog());
        importConnectionProfileDlg = new ImportConnectionProfileDlg(sCDialogSupport, this._session, this._viewerSupport);
        sCPageControllerArray = new SCPageController[]{importConnectionProfileDlg};
        defaultSCDialogController = new DefaultSCDialogController(sCDialogSupport, sCPageControllerArray, 0);
        sCDialogSupport.setDialogController(defaultSCDialogController);
        sCDialogSupport.setTitle(ScjSession.getString("STR_IMPORT_TITLE"));
        sCDialogSupport.setStandardButtons(true);
        sCDialogSupport.setHelpButton(false);
        sCDialogSupport.setModal(true);
        sCDialogSupport.setResizable(true);
        if (sCDialogSupport.render()) {
            this.fillProfileList();
        }
    }

    boolean isSelectedProfileModifiable() {
        int n;
        if (this._profList.getRowCount() > 0 && (n = this._profList.getSelectedRow()) > -1) {
            ConnectionProfile connectionProfile = this._session.getConnectionProfilesKey().getConnectionProfileByName(this._profList.getStringAt(n, 0));
            return !connectionProfile.isSystemProfile() || this._session.isSCRepositoryWriteable();
        }
        return false;
    }

    private JFrame getJFrameParent() {
        Container container = this._dialogSupport.getJDialog().getParent();
        while (container != null && !(container instanceof JFrame)) {
            container = container.getParent();
        }
        return (JFrame)container;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._jcb_close) {
            this.closeButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_new) {
            this.newButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_connect) {
            this.connectButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_edit) {
            this.editButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_changeDescription) {
            this.changeDescriptionButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_startup) {
            this.startupButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_delete) {
            this.deleteButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_export) {
            this.exportButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_import) {
            this.importButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_help) {
            this.onHelp();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this._profList.getSelectionModel()) {
            this.enableButtons();
        }
    }
}

