/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.ConnectionProfile;
import com.sybase.central.viewer.RepositoryKey;
import com.sybase.central.viewer.SCRepository;
import com.sybase.central.viewer.UserPrefRepository;
import com.sybase.central.viewer.UserPrefRepositoryInfo;
import java.util.Enumeration;
import java.util.Vector;

class ConnectionProfilesKey {
    private RepositoryKey _scRepKey;
    private RepositoryKey _upRepKey;
    private UserPrefRepositoryInfo _upRepositoryInfo;
    private Vector<ConnectionProfile> _connectionProfileList = new Vector(30);
    public static final String CONNECTION_PROFILE_ENTRY = "ConnectionProfiles";

    ConnectionProfilesKey(SCRepository sCRepository, UserPrefRepository userPrefRepository, UserPrefRepositoryInfo userPrefRepositoryInfo) {
        this._upRepositoryInfo = userPrefRepositoryInfo;
        this._scRepKey = sCRepository.openKey(CONNECTION_PROFILE_ENTRY, false);
        Enumeration enumeration = this._scRepKey.getKeyNames();
        ConnectionProfile connectionProfile = null;
        while (enumeration.hasMoreElements()) {
            connectionProfile = new ConnectionProfile(this._scRepKey, (String)enumeration.nextElement(), true);
            this._connectionProfileList.addElement(connectionProfile);
        }
        this._upRepKey = userPrefRepository.openKey(CONNECTION_PROFILE_ENTRY, false);
        enumeration = this._upRepKey.getKeyNames();
        while (enumeration.hasMoreElements()) {
            connectionProfile = new ConnectionProfile(this._upRepKey, (String)enumeration.nextElement(), false);
            this._connectionProfileList.addElement(connectionProfile);
        }
    }

    boolean hasConnectionProfile(String string) {
        RepositoryKey repositoryKey = this._scRepKey.openKey(string, true);
        if (repositoryKey != null) {
            return true;
        }
        repositoryKey = this._upRepKey.openKey(string, true);
        return repositoryKey != null;
    }

    Enumeration getConnectionProfiles() {
        if (this._connectionProfileList == null) {
            return null;
        }
        return this._connectionProfileList.elements();
    }

    ConnectionProfile getConnectionProfileByName(String string) {
        if (this._connectionProfileList == null) {
            return null;
        }
        Enumeration enumeration = this.getConnectionProfiles();
        while (enumeration.hasMoreElements()) {
            ConnectionProfile connectionProfile = (ConnectionProfile)enumeration.nextElement();
            if (!connectionProfile.getName().equals(string)) continue;
            return connectionProfile;
        }
        return null;
    }

    ConnectionProfile createSystemConnectionProfile(String string, String string2, boolean bl, String string3, String string4, ConnectionProfile connectionProfile, boolean bl2) {
        ConnectionProfile connectionProfile2 = new ConnectionProfile(this._scRepKey, string, string2, string3, string4, connectionProfile, true, bl2);
        this._upRepositoryInfo.setConnProfAutostart(string, bl);
        this._connectionProfileList.addElement(connectionProfile2);
        return connectionProfile2;
    }

    ConnectionProfile createUserConnectionProfile(String string, String string2, boolean bl, String string3, String string4, ConnectionProfile connectionProfile) {
        ConnectionProfile connectionProfile2 = new ConnectionProfile(this._upRepKey, string, string2, string3, string4, connectionProfile, false, false);
        this._upRepositoryInfo.setConnProfAutostart(string, bl);
        this._connectionProfileList.addElement(connectionProfile2);
        return connectionProfile2;
    }

    void removeConnectionProfile(String string) {
        this._scRepKey.removeKey(string);
        this._upRepKey.removeKey(string);
        Enumeration enumeration = this.getConnectionProfiles();
        while (enumeration.hasMoreElements()) {
            ConnectionProfile connectionProfile = (ConnectionProfile)enumeration.nextElement();
            if (!connectionProfile.getName().equals(string)) continue;
            this._connectionProfileList.removeElement(connectionProfile);
            break;
        }
    }

    void removeConnectionProfile(ConnectionProfile connectionProfile) {
        this._scRepKey.removeKey(connectionProfile.getName());
        this._upRepKey.removeKey(connectionProfile.getName());
        this._connectionProfileList.removeElement(connectionProfile);
    }
}

