/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer;
import com.sybase.central.SCContainerEvent;
import com.sybase.central.SCContainerEvent2;
import com.sybase.central.SCContainerListener;
import com.sybase.central.SCItem;
import com.sybase.central.viewer.TreeItem;
import com.sybase.central.viewer.ViewerManager;

class ContainerListener
implements SCContainerListener {
    private ViewerManager _viewerManager;
    private SCContainer _container;
    private TreeItem _treeItem;

    ContainerListener(ViewerManager viewerManager, SCContainer sCContainer, TreeItem treeItem) {
        this._viewerManager = viewerManager;
        this._container = sCContainer;
        this._treeItem = treeItem;
        this._container.addContainerListener(this);
    }

    @Override
    public void containerChanged(SCContainerEvent sCContainerEvent) {
        int n = sCContainerEvent.getEventId();
        SCItem sCItem = sCContainerEvent.getSCItem();
        if (Thread.currentThread().getName().indexOf("AWT") >= 0 || Thread.currentThread().getName().indexOf("main") < 0) {
            // empty if block
        }
        if (sCItem == null && n != 8) {
            return;
        }
        if (this._viewerManager != null) {
            if (n == 1) {
                this._viewerManager.addItem(sCItem, this._treeItem);
            } else if (n == 2) {
                this._viewerManager.deleteItem(sCItem, this._treeItem);
            } else if (n == 3) {
                this._viewerManager.refreshItem(this._treeItem);
            } else if (n == 4) {
                this._viewerManager.expandItem(this._treeItem);
            } else if (n == 5) {
                this._viewerManager.collapseItem(this._treeItem);
            } else if (n == 6) {
                this._viewerManager.redisplayItem(sCItem, this._treeItem);
            } else if (n == 7) {
                if (sCItem instanceof SCContainer) {
                    this._viewerManager.selectTreeItem((SCContainer)sCItem);
                }
            } else if (n == 8) {
                if (sCContainerEvent instanceof SCContainerEvent2) {
                    this._viewerManager.selectListItems(((SCContainerEvent2)sCContainerEvent).getSCItems(), this._container);
                } else {
                    this._viewerManager.selectListItems(new SCItem[]{sCContainerEvent.getSCItem()}, this._container);
                }
            }
        }
    }

    void releaseResources() {
        this._container.removeContainerListener(this);
        this._container = null;
        this._viewerManager = null;
        this._treeItem = null;
    }

    SCContainer getContainer() {
        return this._container;
    }

    TreeItem getTreeItem() {
        return this._treeItem;
    }
}

