/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCContainer5;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDetailsPanel;
import com.sybase.central.SCDetailsPanel2;
import com.sybase.central.SCDetailsPanel3;
import com.sybase.central.SCDetailsPanel4;
import com.sybase.central.SCDetailsPanel5;
import com.sybase.central.SCDetailsPanel6;
import com.sybase.central.SCItem;
import com.sybase.central.SCViewerDetailsPanel;
import com.sybase.central.SCViewerDetailsPanel2;
import com.sybase.central.SCViewerDetailsPanel3;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.DetailsList;
import com.sybase.central.viewer.NewInterfaceVersionHelper;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.FontHelper;
import com.sybase.util.SybChangeNotificationListener;
import com.sybase.util.SybTabbedPane;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ContentPane
implements ScjResourceConstants,
ChangeListener,
SybChangeNotificationListener {
    private JFrame _viewerFrame;
    private ScjSession _session;
    private ViewerManager _viewerManager;
    private SCContainer _currentTreeContainer = null;
    private JPanel _jpanel = null;
    private JLabel _contextLabel = null;
    private SybTabbedPane _tabbedPane;
    private SCDetailsPanel[] _detailsPanels = new SCDetailsPanel[0];
    private String _oldPanelName = "";
    private boolean[] _openedPanelFlags = null;
    private MouseListener _mouseListener = null;
    private ArrayList<SCDetailsPanel> _cachedDetailsListPanels = new ArrayList();
    private int _currentPanelIndex;
    private Hashtable<JComponent, SCDetailsPanel> _jcomponents = new Hashtable(5);

    ContentPane(JFrame jFrame, ScjSession scjSession, ViewerManager viewerManager) {
        this._viewerFrame = jFrame;
        this._session = scjSession;
        this._viewerManager = viewerManager;
        this.init();
    }

    private DetailsList getCachedDetailsListPanel(int n) {
        DetailsList detailsList = null;
        if (this._cachedDetailsListPanels.size() > n) {
            detailsList = (DetailsList)this._cachedDetailsListPanels.get(n);
            detailsList.setSCDetailsContainer(null);
            return detailsList;
        }
        return null;
    }

    private DetailsList createDetailsListAndAddToCache() {
        DetailsList detailsList = new DetailsList(this._session);
        detailsList.setViewerManager(this._viewerManager);
        detailsList.setPanelName(ScjSession.getString("STR_DETAILS_LIST_NAME"));
        this._cachedDetailsListPanels.add(detailsList);
        return detailsList;
    }

    public boolean notifyChange(ChangeEvent changeEvent) {
        int n;
        if (changeEvent.getSource() == this._tabbedPane && (n = this._tabbedPane.getSelectedIndex()) > -1) {
            this._session.startWait();
            boolean bl = this.notifyCurrentPageOfOnKillActive();
            this._session.endWait();
            if (!bl) {
                return bl;
            }
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this._tabbedPane) {
            this._session.startWait();
            int n = this._tabbedPane.getSelectedIndex();
            if (n > -1) {
                this._currentPanelIndex = n;
                if (!this._openedPanelFlags[this._currentPanelIndex]) {
                    this.getTabPage(this._currentPanelIndex).onOpen(this._currentTreeContainer);
                    this._openedPanelFlags[this._currentPanelIndex] = true;
                }
                this._viewerManager.setSelectedDetailsItems(null);
                if (this.getTabPage(this._currentPanelIndex) instanceof SCDetailsPanel4) {
                    SCDetailsContainer sCDetailsContainer = ((SCDetailsPanel4)this.getTabPage(this._currentPanelIndex)).getSCDetailsContainer();
                    if (sCDetailsContainer != null) {
                        NewInterfaceVersionHelper.doOnNotify(sCDetailsContainer, this._viewerFrame, 207, 0);
                    } else if (this._currentTreeContainer instanceof SCContainer5) {
                        ((SCContainer5)this._currentTreeContainer).onNotify(this._viewerFrame, 208, null, 0);
                    }
                } else if (this._currentTreeContainer instanceof SCContainer5) {
                    ((SCContainer5)this._currentTreeContainer).onNotify(this._viewerFrame, 208, null, 0);
                }
                this._oldPanelName = this.getTabPage(this._currentPanelIndex).getPanelName();
                this.getTabPage(this._currentPanelIndex).onSetActive();
                this._viewerManager.setDetailsTabNameInNavigationPath(this.getTabPage(this._currentPanelIndex).getPanelName());
                this._viewerManager.updateProviderVisualElements();
            }
            this._session.endWait();
        }
    }

    SCContainer getTreeContainerForActiveDetailsPanel() {
        return this._currentTreeContainer;
    }

    SCDetailsContainer getDetailsContainerForActiveDetailsPanel() {
        SCDetailsPanel sCDetailsPanel = null;
        if (this._tabbedPane.getTabCount() > 0 && (sCDetailsPanel = this.getTabPage(this._currentPanelIndex)) instanceof SCDetailsPanel4 && ((SCDetailsPanel4)sCDetailsPanel).getSCDetailsContainer() != null) {
            return ((SCDetailsPanel4)sCDetailsPanel).getSCDetailsContainer();
        }
        return null;
    }

    DetailsList getDetailsListForActiveDetailsPanel() {
        SCDetailsPanel sCDetailsPanel = null;
        JComponent jComponent = null;
        Component component = null;
        if (this._tabbedPane.getTabCount() > 0) {
            sCDetailsPanel = this.getTabPage(this.getCurrentPanelIndex());
            if (sCDetailsPanel instanceof DetailsList) {
                return (DetailsList)sCDetailsPanel;
            }
            if (sCDetailsPanel instanceof SCDetailsPanel2 && (jComponent = ((SCDetailsPanel2)sCDetailsPanel).getJComponent()) instanceof JSplitPane) {
                component = ((JSplitPane)jComponent).getTopComponent();
                if (component instanceof DetailsList) {
                    return (DetailsList)component;
                }
                component = ((JSplitPane)jComponent).getBottomComponent();
                if (component instanceof DetailsList) {
                    return (DetailsList)component;
                }
            }
        }
        return null;
    }

    void selectFirstItemInDetailsPanel() {
        if (this._tabbedPane.getTabCount() > 0 && this.getTabPage(this._currentPanelIndex) instanceof SCDetailsPanel4) {
            ((SCDetailsPanel4)this.getTabPage(this._currentPanelIndex)).selectFirstItem();
        }
    }

    void selectAllItemsInDetailsPanel() {
        if (this._tabbedPane.getTabCount() > 0 && this.getTabPage(this._currentPanelIndex) instanceof SCDetailsPanel4) {
            ((SCDetailsPanel4)this.getTabPage(this._currentPanelIndex)).selectAllItems();
        }
    }

    void invertSelectionInDetailsPanel() {
        if (this._tabbedPane.getTabCount() > 0 && this.getTabPage(this._currentPanelIndex) instanceof SCDetailsPanel4) {
            ((SCDetailsPanel4)this.getTabPage(this._currentPanelIndex)).invertSelectedItems();
        }
    }

    boolean selectDetailsItemByName(String string) {
        if (this._tabbedPane.getTabCount() > 0 && this.getTabPage(this._currentPanelIndex) instanceof SCDetailsPanel5) {
            return ((SCDetailsPanel5)this.getTabPage(this._currentPanelIndex)).selectItemByName(string);
        }
        return true;
    }

    void init() {
        Font font = null;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = null;
        SCDetailsPanel[] sCDetailsPanelArray = null;
        this._contextLabel = new JLabel();
        font = UIManager.getDefaults().getFont("InternalFrame.titleFont");
        if (font == null) {
            font = this._contextLabel.getFont();
            font = font.deriveFont(font.getStyle(), font.getSize() + 4);
        }
        this._contextLabel.setFont(font);
        new FontHelper(this._contextLabel);
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    ContentPane.this.handleLabelClick(mouseEvent);
                    ContentPane.this.showPopupMenu(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ContentPane.this.handleLabelClick(mouseEvent);
                if (mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    ContentPane.this.showPopupMenu(mouseEvent);
                }
            }
        };
        this._contextLabel.addMouseListener(this._mouseListener);
        int n = this._session.getUserPrefRepositoryInfo().getTabPlacement();
        this._tabbedPane = new SybTabbedPane(n);
        this._tabbedPane.setTabLayoutPolicy(1);
        this.listenToTabEvents(true);
        this._currentPanelIndex = 0;
        sCDetailsPanelArray = this.getCachedDetailsListPanel(this._currentPanelIndex) == null ? new SCDetailsPanel[]{this.createDetailsListAndAddToCache()} : new SCDetailsPanel[]{this.getCachedDetailsListPanel(this._currentPanelIndex)};
        if (this._tabbedPane.getTabCount() > 0) {
            this._oldPanelName = this.getTabPage(this._currentPanelIndex).getPanelName();
        }
        this.setDetailsPanels(sCDetailsPanelArray);
        this._jpanel = new JPanel(gridBagLayout);
        this._jpanel.setBorder(null);
        this._jpanel.add(this._contextLabel);
        this._jpanel.add((Component)this._tabbedPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this._contextLabel, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints((Component)this._tabbedPane, gridBagConstraints);
    }

    void showPopupMenu(MouseEvent mouseEvent) {
        JMenuItem[] jMenuItemArray = null;
        jMenuItemArray = this._viewerManager.buildContextMenuItems();
        if (jMenuItemArray != null) {
            JPopupMenu jPopupMenu = new JPopupMenu(null);
            for (int i = 0; i < jMenuItemArray.length; ++i) {
                if (jMenuItemArray[i] == null) {
                    jPopupMenu.addSeparator();
                    continue;
                }
                jPopupMenu.add(jMenuItemArray[i]);
            }
            this._viewerManager.setPopupMenu(jPopupMenu);
            this._viewerManager.startWait();
            UIUtils.showJPopupMenu((JPopupMenu)jPopupMenu, (JComponent)this._contextLabel, (Point)new Point(mouseEvent.getX(), mouseEvent.getY()));
            this._viewerManager.endWait();
        }
    }

    void handleLabelClick(MouseEvent mouseEvent) {
        if (this.getTabPage(this._currentPanelIndex) instanceof SCDetailsPanel6) {
            ((SCDetailsPanel6)this.getTabPage(this._currentPanelIndex)).deselectAllItems();
        }
    }

    void initializeAfterVisible() {
        this._contextLabel.setMinimumSize(new Dimension(0, this._contextLabel.getMinimumSize().height));
    }

    private void listenToTabEvents(boolean bl) {
        if (bl) {
            this._tabbedPane.addChangeNotificationListener((SybChangeNotificationListener)this);
            this._tabbedPane.addChangeListener((ChangeListener)this);
        } else {
            this._tabbedPane.removeChangeNotificationListener((SybChangeNotificationListener)this);
            this._tabbedPane.removeChangeListener((ChangeListener)this);
        }
    }

    void clearDetailsPanels() {
        this.listenToTabEvents(false);
        this._tabbedPane.removeAll();
        this._jcomponents.clear();
        this._currentPanelIndex = 0;
        this.listenToTabEvents(true);
    }

    int getNumberOfDetailsItems() {
        if (this.getDetailsListForActiveDetailsPanel() == null) {
            return -1;
        }
        return this.getDetailsListForActiveDetailsPanel().getNumberOfDetailsItems();
    }

    int getNumberOfSelectedDetailsItems() {
        if (this.getDetailsListForActiveDetailsPanel() == null) {
            return -1;
        }
        return this.getDetailsListForActiveDetailsPanel().getNumberOfSelectedDetailsItems();
    }

    int getCurrentPanelIndex() {
        return this._currentPanelIndex;
    }

    JPanel getPanel() {
        return this._jpanel;
    }

    SybTabbedPane getPane() {
        return this._tabbedPane;
    }

    JLabel getContextLabel() {
        return this._contextLabel;
    }

    void setContextLabelVisible(boolean bl) {
        this._contextLabel.setVisible(bl);
        if (bl) {
            if (UIUtils.isXPLookAndFeelActive()) {
                this._jpanel.setBackground(UIManager.getColor("Table.background"));
            }
        } else {
            this._jpanel.setBackground(UIManager.getColor("Panel.background"));
        }
    }

    private void setDetailsPanels(SCDetailsPanel[] sCDetailsPanelArray) {
        this._openedPanelFlags = null;
        this._openedPanelFlags = new boolean[sCDetailsPanelArray.length];
        this.clearDetailsPanels();
        this._detailsPanels = sCDetailsPanelArray;
        this.listenToTabEvents(false);
        for (int i = 0; i < this._detailsPanels.length; ++i) {
            this._openedPanelFlags[i] = false;
            String string = this._detailsPanels[i].getPanelName();
            this.addTabPage(this._detailsPanels[i], string);
            if (!string.equals(this._oldPanelName)) continue;
            this._currentPanelIndex = i;
        }
        this._tabbedPane.setSelectedIndex(this._currentPanelIndex);
        this.listenToTabEvents(true);
    }

    boolean setSelectedDetailsTabByName(String string) {
        int n = -1;
        if (string != null) {
            if (this.getSelectedDetailsTabName() != null && this.getSelectedDetailsTabName().equals(string)) {
                return true;
            }
            for (int i = 0; i < this._detailsPanels.length; ++i) {
                if (!string.equals(this._detailsPanels[i].getPanelName())) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                return this.changeToNewPanel(n);
            }
            return false;
        }
        return false;
    }

    String getSelectedDetailsTabName() {
        if (this._tabbedPane.getTabCount() > 0) {
            return this.getTabPage(this._currentPanelIndex).getPanelName();
        }
        return null;
    }

    private boolean changeToNewPanel(int n) {
        if (!this.notifyCurrentPageOfOnKillActive()) {
            this.listenToTabEvents(false);
            this._tabbedPane.setSelectedIndex(this._currentPanelIndex);
            this.listenToTabEvents(true);
            return false;
        }
        this.listenToTabEvents(false);
        this._currentPanelIndex = n;
        if (!this._openedPanelFlags[this._currentPanelIndex]) {
            this.getTabPage(this._currentPanelIndex).onOpen(this._currentTreeContainer);
            this._openedPanelFlags[this._currentPanelIndex] = true;
        }
        this._tabbedPane.setSelectedIndex(this._currentPanelIndex);
        this._viewerManager.setDetailsTabNameInNavigationPath(this.getTabPage(this._currentPanelIndex).getPanelName());
        this.getTabPage(this._currentPanelIndex).onSetActive();
        if (!(this.getTabPage(this._currentPanelIndex) instanceof DetailsList)) {
            this._viewerManager.setSelectedDetailsItems(null);
        }
        this.listenToTabEvents(true);
        return true;
    }

    private void addTabPage(SCDetailsPanel sCDetailsPanel, String string) {
        Icon icon = null;
        JComponent jComponent = null;
        if (sCDetailsPanel instanceof SCDetailsPanel5) {
            icon = ((SCDetailsPanel5)sCDetailsPanel).getIcon();
            jComponent = ((SCDetailsPanel5)sCDetailsPanel).getJComponent();
            this._tabbedPane.addTab(string, icon, (Component)jComponent);
            this._jcomponents.put(jComponent, sCDetailsPanel);
        } else if (sCDetailsPanel instanceof SCDetailsPanel2) {
            jComponent = ((SCDetailsPanel2)sCDetailsPanel).getJComponent();
            this._tabbedPane.addTab(string, (Component)jComponent);
            this._jcomponents.put(jComponent, sCDetailsPanel);
        } else {
            this._tabbedPane.addTab(string, (Component)((Object)sCDetailsPanel));
        }
    }

    private SCDetailsPanel getTabPage(int n) {
        Component component = this._tabbedPane.getComponentAt(n);
        if (component instanceof SCDetailsPanel2) {
            return (SCDetailsPanel2)((Object)component);
        }
        if (component instanceof SCDetailsPanel) {
            return (SCDetailsPanel)((Object)component);
        }
        return (SCDetailsPanel2)this._jcomponents.get(component);
    }

    void setContainer(SCContainer sCContainer) {
        Rectangle rectangle = new Rectangle(0, 0, 1, 1);
        this._currentTreeContainer = sCContainer;
        for (int i = 0; i < this._detailsPanels.length; ++i) {
            if (this._detailsPanels[i] instanceof DetailsList) {
                ((DetailsList)this._detailsPanels[i]).getJTable().scrollRectToVisible(rectangle);
                JScrollBar jScrollBar = ((DetailsList)this._detailsPanels[i]).getHorizontalScrollBar();
                if (jScrollBar != null) {
                    jScrollBar.setValue(0);
                }
                if ((jScrollBar = ((DetailsList)this._detailsPanels[i]).getVerticalScrollBar()) != null) {
                    jScrollBar.setValue(0);
                }
            }
            this._detailsPanels[i].releaseResources();
        }
        this.listenToTabEvents(false);
        this._tabbedPane.removeAll();
        this.listenToTabEvents(true);
        if (this._currentTreeContainer instanceof SCContainer2) {
            this.setDetailsPanels(this.determineDetailsPanels(((SCContainer2)this._currentTreeContainer).getDetailsPanels(this._viewerFrame)));
        } else {
            this.setDetailsPanels(this.determineDetailsPanels(this._currentTreeContainer.getDetailsPanels()));
        }
        this.getTabPage(this._currentPanelIndex).onOpen(this._currentTreeContainer);
        this._openedPanelFlags[this._currentPanelIndex] = true;
        this.getTabPage(this._currentPanelIndex).onSetActive();
        this.updateContextLabel(sCContainer);
    }

    void closeDetailsContainers() {
        for (int i = 0; i < this._detailsPanels.length; ++i) {
            SCDetailsContainer sCDetailsContainer;
            if (!(this._detailsPanels[i] instanceof SCDetailsPanel4) || (sCDetailsContainer = ((SCDetailsPanel4)this._detailsPanels[i]).getSCDetailsContainer()) == null) continue;
            this._detailsPanels[i].releaseResources();
            NewInterfaceVersionHelper.doOnNotify(sCDetailsContainer, this._viewerFrame, 200, 0);
            sCDetailsContainer.close();
        }
    }

    private SCDetailsPanel[] determineDetailsPanels(Object[] objectArray) {
        Object[] objectArray2 = null;
        Vector<Object> vector = null;
        int n = 0;
        DetailsList detailsList = null;
        String string = null;
        if (objectArray == null || objectArray.length == 0) {
            objectArray2 = new SCDetailsPanel[]{this.getCachedDetailsListPanel(0)};
            this.getCachedDetailsListPanel(0).setPanelName(ScjSession.getString("STR_DETAILS_LIST_NAME"));
        } else {
            vector = new Vector<Object>(10);
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof SCViewerDetailsPanel) {
                    if (!((SCViewerDetailsPanel)objectArray[i]).getPanelType().equals("DETAILS_LIST")) continue;
                    detailsList = this.getCachedDetailsListPanel(n);
                    ++n;
                    if (detailsList == null) {
                        detailsList = this.createDetailsListAndAddToCache();
                    }
                    if ((string = ((SCViewerDetailsPanel)objectArray[i]).getPanelName()) != null) {
                        detailsList.setPanelName(string);
                    } else {
                        detailsList.setPanelName(ScjSession.getString("STR_DETAILS_LIST_NAME"));
                    }
                    if (objectArray[i] instanceof SCViewerDetailsPanel2) {
                        detailsList.setSCDetailsContainer(((SCViewerDetailsPanel2)objectArray[i]).getSCDetailsContainer());
                    } else {
                        detailsList.setSCDetailsContainer(null);
                    }
                    if (objectArray[i] instanceof SCViewerDetailsPanel3) {
                        vector.addElement(((SCViewerDetailsPanel3)objectArray[i]).createPassthroughDetailsPanel(((SCViewerDetailsPanel3)objectArray[i]).getSplitPane(), ((SCViewerDetailsPanel3)objectArray[i]).getLocation(), detailsList));
                        continue;
                    }
                    vector.addElement(detailsList);
                    continue;
                }
                if (!(objectArray[i] instanceof SCDetailsPanel)) continue;
                ((SCDetailsPanel)objectArray[i]).setViewerManager(this._viewerManager);
                vector.addElement((SCDetailsPanel)objectArray[i]);
            }
            if (vector.size() == 0) {
                objectArray2 = new SCDetailsPanel[]{this.getCachedDetailsListPanel(0)};
                this.getCachedDetailsListPanel(0).setPanelName(ScjSession.getString("STR_DETAILS_LIST_NAME"));
            } else {
                objectArray2 = new SCDetailsPanel[vector.size()];
                vector.copyInto(objectArray2);
            }
        }
        return objectArray2;
    }

    boolean notifyCurrentPageOfOnKillActive() {
        String string = null;
        if (this._tabbedPane.getTabCount() > 0) {
            string = this.getTabPage(this._currentPanelIndex).getPanelName();
            if (this.getTabPage(this._currentPanelIndex) instanceof SCDetailsPanel3 && !((SCDetailsPanel3)this.getTabPage(this._currentPanelIndex)).onKillActiveNotification()) {
                return false;
            }
            this._oldPanelName = string;
            if (this._tabbedPane.getTabCount() > 0) {
                this.getTabPage(this._currentPanelIndex).onKillActive();
            }
        }
        return true;
    }

    boolean redisplayItem(SCItem sCItem) {
        boolean bl = false;
        this.updateContextLabel(this._currentTreeContainer);
        for (int i = 0; i < this._detailsPanels.length; ++i) {
            if (!this._openedPanelFlags[i]) continue;
            if (this._detailsPanels[i] instanceof SCDetailsPanel4) {
                if (((SCDetailsPanel4)this._detailsPanels[i]).getSCDetailsContainer() != null) continue;
                ((SCDetailsPanel2)this._detailsPanels[i]).redisplayItem(sCItem);
                bl = true;
                continue;
            }
            if (!(this._detailsPanels[i] instanceof SCDetailsPanel2)) continue;
            ((SCDetailsPanel2)this._detailsPanels[i]).redisplayItem(sCItem);
            bl = true;
        }
        return bl;
    }

    private void updateContextLabel(SCContainer sCContainer) {
        String string = null;
        Icon icon = null;
        if (sCContainer != null) {
            if (sCContainer instanceof SCContainer5) {
                string = ((SCContainer5)sCContainer).getContextString();
                icon = ((SCContainer5)sCContainer).getContextIcon();
            }
            if (string == null) {
                string = sCContainer.getDisplayName(0);
            }
            if (icon == null) {
                icon = sCContainer.getImage(false);
            }
            this._contextLabel.setText(string);
            this._contextLabel.setIcon(icon);
            this.setContextLabelVisible(this._session.getUserPrefRepositoryInfo().isContextLabelVisible());
        } else {
            this.setContextLabelVisible(false);
            this._contextLabel.setText("");
            this._contextLabel.setIcon(null);
        }
    }

    boolean deleteItem(SCItem sCItem) {
        boolean bl = false;
        for (int i = 0; i < this._detailsPanels.length; ++i) {
            if (!this._openedPanelFlags[i]) continue;
            if (this._detailsPanels[i] instanceof SCDetailsPanel4) {
                if (((SCDetailsPanel4)this._detailsPanels[i]).getSCDetailsContainer() != null) continue;
                ((SCDetailsPanel2)this._detailsPanels[i]).deleteItem(sCItem);
                bl = true;
                continue;
            }
            if (!(this._detailsPanels[i] instanceof SCDetailsPanel2)) continue;
            ((SCDetailsPanel2)this._detailsPanels[i]).deleteItem(sCItem);
            bl = true;
        }
        return bl;
    }

    boolean addItem(SCItem sCItem) {
        boolean bl = false;
        for (int i = 0; i < this._detailsPanels.length; ++i) {
            if (!this._openedPanelFlags[i]) continue;
            if (this._detailsPanels[i] instanceof SCDetailsPanel4) {
                if (((SCDetailsPanel4)this._detailsPanels[i]).getSCDetailsContainer() != null) continue;
                ((SCDetailsPanel2)this._detailsPanels[i]).addItem(sCItem);
                bl = true;
                continue;
            }
            if (!(this._detailsPanels[i] instanceof SCDetailsPanel2)) continue;
            ((SCDetailsPanel2)this._detailsPanels[i]).addItem(sCItem);
            bl = true;
        }
        return bl;
    }

    void releaseResources() {
        int n;
        this._viewerFrame = null;
        this._session = null;
        this._viewerManager = null;
        this._currentTreeContainer = null;
        this._jpanel = null;
        this._contextLabel.removeMouseListener(this._mouseListener);
        this._mouseListener = null;
        this._contextLabel = null;
        this.listenToTabEvents(false);
        this._tabbedPane.removeAll();
        this._tabbedPane = null;
        for (n = 0; n < this._detailsPanels.length; ++n) {
            this._detailsPanels[n].releaseResources();
        }
        this._detailsPanels = null;
        for (n = 0; n < this._cachedDetailsListPanels.size(); ++n) {
            this.getCachedDetailsListPanel(n).releaseAllResources();
        }
        this._cachedDetailsListPanels.clear();
        this._cachedDetailsListPanels = null;
        this._jcomponents.clear();
        this._jcomponents = null;
    }
}

