/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.SCDropDownTreeItemRenderer;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.TreeItem;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;

class ContextComboBoxPanel
extends JPanel
implements IConstants,
ScjResourceConstants,
ActionListener {
    private ScjSession _session;
    private ViewerManager _viewerManager;
    private SybComboBox _comboBox;
    private int _selectedRow = 0;

    ContextComboBoxPanel(ScjSession scjSession, ViewerManager viewerManager) {
        this._session = scjSession;
        this._viewerManager = viewerManager;
        this.init();
    }

    private void init() {
        SybLabel sybLabel = null;
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        JSeparator jSeparator = null;
        this.setBorder(null);
        sybLabel = new SybLabel(ScjSession.getString("STR_CONTEXT_COMBO"));
        this.add((Component)sybLabel);
        this._comboBox = new SybComboBox();
        sybLabel.setLabelFor((Component)this._comboBox);
        this._comboBox.setRenderer((ListCellRenderer)new SCDropDownTreeItemRenderer(true));
        this._comboBox.addActionListener((ActionListener)this);
        this._comboBox.setMinimumSize(new Dimension(1, this._comboBox.getPreferredSize().height));
        this.add((Component)this._comboBox);
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = UIUtils.isXPLookAndFeelActive() ? new Insets(0, 3, 0, 5) : new Insets(0, 1, 0, 5);
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = UIUtils.isXPLookAndFeelActive() ? new Insets(1, 0, 1, 2) : new Insets(1, 0, 1, 0);
        gridBagLayout.setConstraints((Component)this._comboBox, gridBagConstraints);
        jSeparator = new JSeparator();
        this.add(jSeparator);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
    }

    void selectPreviousTreeItem() {
        int n = this._comboBox.getSelectedIndex() - 1;
        if (n >= 0) {
            TreeItem treeItem = (TreeItem)this._comboBox.getItemAt(n);
            this._viewerManager.selectTreeItem(treeItem.getContainer());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreeItem treeItem = null;
        if (actionEvent.getSource() == this._comboBox) {
            treeItem = (TreeItem)this._comboBox.getSelectedItem();
            if (!this._viewerManager.selectTreeItem(treeItem.getContainer())) {
                this._comboBox.removeActionListener((ActionListener)this);
                this._comboBox.setSelectedIndex(this._selectedRow);
                this._comboBox.addActionListener((ActionListener)this);
            } else {
                this._selectedRow = this._comboBox.getSelectedIndex();
            }
            this._comboBox.requestFocusInWindow();
        }
    }

    void updateDropDown(TreeItem treeItem) {
        TreeItem[] treeItemArray = null;
        this._comboBox.removeActionListener((ActionListener)this);
        if (this._comboBox.getItemCount() > 0) {
            this._comboBox.removeAllItems();
        }
        int n = 0;
        treeItemArray = treeItem.getPath();
        for (n = 0; n < treeItemArray.length; ++n) {
            this._comboBox.addItem((Object)treeItemArray[n]);
        }
        if (n > 0) {
            this._comboBox.setSelectedIndex(n - 1);
        }
        this._selectedRow = this._comboBox.getSelectedIndex();
        this._comboBox.repaint();
        this._comboBox.addActionListener((ActionListener)this);
    }

    void releaseResources() {
        this._session = null;
        this._viewerManager = null;
        this._comboBox.removeActionListener((ActionListener)this);
        this._comboBox.setRenderer(null);
        if (this._comboBox.getItemCount() > 0) {
            this._comboBox.removeAllItems();
        }
        this._comboBox = null;
    }
}

