/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.DefaultSCPageController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCProvider;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.ConnectionProfile;
import com.sybase.central.viewer.ConnectionProfilesKey;
import com.sybase.central.viewer.CreateProfileDlgJPanel;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.IHelpConstants;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.Providers;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.SCMultiList;
import com.sybase.central.viewer.SCSortingTableModel;
import com.sybase.central.viewer.SCTextArea;
import com.sybase.central.viewer.SCTextField;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class CreateProfileDlg
extends DefaultSCPageController
implements ScjResourceConstants,
ItemListener,
DocumentListener,
ListSelectionListener,
IConstants,
IHelpConstants {
    private ScjSession _session;
    private ScjViewerSupport _viewerSupport;
    private JLabel _jlabel_name;
    private SCTextField _jtextf_name;
    private JLabel _jlabel_description;
    private SCTextArea _jtexta_description;
    private JRadioButton _jradiob_newProfile;
    private JLabel _jlabel_provider;
    private JComboBox _jcombo_provider;
    private JRadioButton _jradiob_copyProfile;
    private JLabel _jlabel_list;
    private SCMultiList _scmultil_list;
    private JCheckBox _jcheckb_allUsers;
    private JCheckBox _jcheckb_firstTimeStart;
    private Providers _providers;
    private String[] _newProfileName;

    CreateProfileDlg(SCDialogSupport sCDialogSupport, ScjSession scjSession, ScjViewerSupport scjViewerSupport, String[] stringArray) {
        super(sCDialogSupport, new CreateProfileDlgJPanel());
        this._session = scjSession;
        this._viewerSupport = scjViewerSupport;
        this._providers = scjViewerSupport.getProviders();
        this._newProfileName = stringArray;
        CreateProfileDlgJPanel createProfileDlgJPanel = (CreateProfileDlgJPanel)this.getJPanel();
        this._jlabel_name = createProfileDlgJPanel.jlabel_name;
        this._jtextf_name = createProfileDlgJPanel.jtextf_name;
        this._jlabel_description = createProfileDlgJPanel.jlabel_description;
        this._jtexta_description = createProfileDlgJPanel.jtexta_description;
        this._jtexta_description.setFont(this._jlabel_description.getFont());
        this._jradiob_newProfile = createProfileDlgJPanel.jradiob_newProfile;
        this._jlabel_provider = createProfileDlgJPanel.jlabel_provider;
        this._jcombo_provider = createProfileDlgJPanel.jcombo_provider;
        this._jradiob_copyProfile = createProfileDlgJPanel.jradiob_copyProfile;
        this._jlabel_list = createProfileDlgJPanel.jlabel_list;
        this._scmultil_list = createProfileDlgJPanel.scmultil_list;
        this._jcheckb_allUsers = createProfileDlgJPanel.jcheckb_allUsers;
        this._jcheckb_firstTimeStart = createProfileDlgJPanel.jcheckb_firstTimeStart;
        this._jlabel_name.setText(ScjSession.getString("STR_CREATE_PROF_NAME"));
        this._jlabel_name.setLabelFor(this._jtextf_name);
        this._jlabel_description.setText(ScjSession.getString("STR_CREATE_PROF_DESC"));
        this._jlabel_description.setLabelFor((Component)((Object)this._jtexta_description));
        this._jlabel_provider.setText(ScjSession.getString("STR_CREATE_PROF_PLUGIN"));
        this._jlabel_provider.setLabelFor(this._jcombo_provider);
        this._jradiob_newProfile.setText(ScjSession.getString("STR_CREATE_PROF_NEW_BTN"));
        this._jradiob_copyProfile.setText(ScjSession.getString("STR_CREATE_PROF_CPY_BTN"));
        this._jlabel_list.setText(ScjSession.getString("STR_CREATE_PROF_EXIST_LBL"));
        this._jlabel_list.setLabelFor(this._scmultil_list);
        this._scmultil_list.setSelectionMode(0);
        this._scmultil_list.setAutoResizeMode(0);
        this._scmultil_list.setColumnHeadings(new StringBuffer(ScjSession.getString("STR_CONNPROF_CONNPROF")).append(", ").append(ScjSession.getString("STR_CONNPROF_PLUGIN")).append(", ").append(ScjSession.getString("STR_CONNPROF_ACCESS")).append(", ").append(ScjSession.getString("STR_CONNPROF_DESCRIPTION")).toString());
        this._scmultil_list.setColumnWidths("150, 180, 100, 200");
        this._scmultil_list.setColumnHasIconTextData(0, true);
        this._scmultil_list.getScrollPane().setPreferredSize(new Dimension(300, 100));
        this._jcheckb_allUsers.setText(ScjSession.getString("STR_CREATE_PROF_ALL_USERS"));
        this._jcheckb_allUsers.setEnabled(this._session.isSCRepositoryWriteable());
        this._jcheckb_firstTimeStart.setText(ScjSession.getString("STR_CREATE_PROF_FIRST_TIME"));
        this._jcheckb_firstTimeStart.setEnabled(false);
        this._jcombo_provider.setRenderer(new DropDownRenderer());
        this._jtextf_name.getDocument().addDocumentListener(this);
        this._jcheckb_allUsers.addItemListener(this);
        this._jradiob_newProfile.addItemListener(this);
        this._jradiob_copyProfile.addItemListener(this);
        this._scmultil_list.addListSelectionListener(this);
    }

    @Override
    public void onInitDialog() {
        this.fillProviderCombo();
        this.fillProfileList();
        this.enableButtons();
        this._jtextf_name.requestFocusInWindow();
    }

    @Override
    public void onHelp() {
        this._session.showHelpIndex("HELP_CREATEPROFILEDLG_INDEX", this._dialogSupport);
    }

    private void fillProfileList() {
        this._scmultil_list.clear();
        Enumeration enumeration = this._session.getConnectionProfilesKey().getConnectionProfiles();
        while (enumeration.hasMoreElements()) {
            ConnectionProfile connectionProfile = (ConnectionProfile)enumeration.nextElement();
            String string = ScjSession.getString("STR_CONNPROF_THIS_USER");
            if (connectionProfile.isSystemProfile()) {
                string = ScjSession.getString("STR_CONNPROF_ALL_USERS");
            }
            Vector<String> vector = new Vector<String>();
            vector.addElement(connectionProfile.getName());
            vector.addElement(connectionProfile.getProviderName());
            vector.addElement(string);
            vector.addElement(connectionProfile.getDescription());
            this._scmultil_list.addRowWithIcon(JCOMP_CONN_PROFILE_ICON, vector);
        }
        this._scmultil_list.sort();
        if (this._scmultil_list.getRowCount() > 0) {
            this._scmultil_list.setRowSelectionInterval(0, 0);
        }
    }

    private void fillProviderCombo() {
        Enumeration enumeration = this._providers.getProviderList();
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded() || !providerEntry.getProvider().supportsConnectionProfiles()) continue;
            this._jcombo_provider.addItem(providerEntry);
        }
    }

    private void enableButtons() {
        if (this._scmultil_list.getRowCount() < 1) {
            this._jradiob_copyProfile.setEnabled(false);
            this._jlabel_list.setEnabled(false);
            this._scmultil_list.setEnabled(false);
        }
        this._jcheckb_firstTimeStart.setEnabled(this._jcheckb_allUsers.isSelected());
        this._jlabel_provider.setEnabled(this._jradiob_newProfile.isSelected());
        this._jcombo_provider.setEnabled(this._jradiob_newProfile.isSelected());
        this._jlabel_list.setEnabled(this._jradiob_copyProfile.isSelected());
        this._scmultil_list.setEnabled(this._jradiob_copyProfile.isSelected());
        if (this._jtextf_name.getText().trim().length() > 0 && (this._jradiob_newProfile.isSelected() || this._jradiob_copyProfile.isSelected() && this._scmultil_list.getSelectedRow() >= 0)) {
            this._dialogSupport.setEnabledStandardButtons(11);
        } else {
            this._dialogSupport.setEnabledStandardButtons(10);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onOk() {
        ConnectionProfilesKey connectionProfilesKey;
        String string = this._jtextf_name.getText().trim();
        String string2 = this._jtexta_description.getText().trim();
        if (string2 != null && string2.length() > 256) {
            string2 = string2.substring(0, 255);
        }
        if ((connectionProfilesKey = this._session.getConnectionProfilesKey()).hasConnectionProfile(string)) {
            this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), ScjSession.getString("ERR_NEWCONN_DUPLICATE_PROFILE"), 0);
            return false;
        }
        SCProvider sCProvider = null;
        String string3 = null;
        String string4 = null;
        ConnectionProfile connectionProfile = null;
        if (this._jradiob_newProfile.isSelected()) {
            sCProvider = ((ProviderEntry)this._jcombo_provider.getSelectedItem()).getProvider();
            string3 = sCProvider.getDisplayName();
            string4 = ((ProviderEntry)this._jcombo_provider.getSelectedItem()).getProviderId();
        } else {
            int n = 0;
            int n2 = ((SCSortingTableModel)this._scmultil_list.getModel()).getDataIndexForTableIndex(this._scmultil_list.getSelectedRow());
            Enumeration enumeration = this._session.getConnectionProfilesKey().getConnectionProfiles();
            while (enumeration.hasMoreElements()) {
                connectionProfile = (ConnectionProfile)enumeration.nextElement();
                if (n == n2) break;
                ++n;
            }
            if (connectionProfile != null) {
                string3 = connectionProfile.getProviderName();
                enumeration = this._providers.getProviderList();
                while (enumeration.hasMoreElements()) {
                    ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
                    if (!providerEntry.getName().equals(string3)) continue;
                    sCProvider = providerEntry.getProvider();
                    string4 = providerEntry.getProviderId();
                    break;
                }
            }
        }
        if (sCProvider == null) {
            this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), ScjSession.getString("ERR_CONNPROF_PLUGIN_NOT_LOADED"), 0);
            return false;
        }
        ConnectionProfile connectionProfile2 = null;
        if (this._jcheckb_allUsers.isSelected()) {
            if (!this._session.isSCRepositoryWriteable()) return false;
            connectionProfile2 = connectionProfilesKey.createSystemConnectionProfile(string, string2, false, string3, string4, connectionProfile, this._jcheckb_firstTimeStart.isSelected());
        } else {
            connectionProfile2 = connectionProfilesKey.createUserConnectionProfile(string, string2, false, string3, string4, connectionProfile);
        }
        JFrame jFrame = this.getJFrameParent();
        if (!sCProvider.editConnection(jFrame, connectionProfile2.getDataProfilesKey())) {
            connectionProfilesKey.removeConnectionProfile(connectionProfile2);
            return false;
        }
        this._newProfileName[0] = string;
        return true;
    }

    private JFrame getJFrameParent() {
        Container container = this._dialogSupport.getJDialog().getParent();
        while (container != null && !(container instanceof JFrame)) {
            container = container.getParent();
        }
        return (JFrame)container;
    }

    @Override
    public void releaseResources() {
        this._jcheckb_allUsers.removeItemListener(this);
        this._jtextf_name.getDocument().removeDocumentListener(this);
        this._jradiob_newProfile.removeItemListener(this);
        this._jradiob_copyProfile.removeItemListener(this);
        this._scmultil_list.removeListSelectionListener(this);
        this._session = null;
        this._viewerSupport = null;
        this._jlabel_name = null;
        this._jtextf_name = null;
        this._jlabel_description = null;
        this._jtexta_description = null;
        this._jradiob_newProfile = null;
        this._jlabel_provider = null;
        this._jcombo_provider = null;
        this._jradiob_copyProfile = null;
        this._jlabel_list = null;
        this._scmultil_list.releaseResources();
        this._scmultil_list = null;
        this._jcheckb_allUsers = null;
        this._providers = null;
        this._newProfileName = null;
        super.releaseResources();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableButtons();
        if (this._jradiob_newProfile.isSelected()) {
            this._jcombo_provider.requestFocusInWindow();
        } else if (this._jradiob_copyProfile.isSelected()) {
            this._scmultil_list.requestFocusInWindow();
        }
        if (itemEvent.getSource() == this._jcheckb_allUsers) {
            this._jcheckb_allUsers.requestFocusInWindow();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this._scmultil_list.getSelectionModel()) {
            this.enableButtons();
        }
    }

    static class DropDownRenderer
    extends JLabel
    implements ListCellRenderer {
        public DropDownRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl || bl2) {
                this.setBackground(UIManager.getColor("TextField.selectionBackground"));
                this.setForeground(UIManager.getColor("TextField.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("TextField.background"));
                this.setForeground(UIManager.getColor("Label.foreground"));
            }
            if (object != null) {
                ProviderEntry providerEntry = (ProviderEntry)object;
                this.setText(providerEntry.getProvider().getDisplayName());
                this.setIcon(SCImageLoader.getImageIcon("plugin16", 1006));
            }
            return this;
        }
    }
}

