/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCContainer3;
import com.sybase.central.SCContainerEvent;
import com.sybase.central.SCContainerEvent2;
import com.sybase.central.SCContainerListener;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDetailsPanel6;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCHeader;
import com.sybase.central.SCHeader2;
import com.sybase.central.SCHeader3;
import com.sybase.central.SCItem;
import com.sybase.central.SCItem5;
import com.sybase.central.SCViewerManager;
import com.sybase.central.viewer.CustomizeDlg;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.NewInterfaceVersionHelper;
import com.sybase.central.viewer.SCButton;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.SCScrollPane;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjTableModel;
import com.sybase.central.viewer.TableSorter;
import com.sybase.central.viewer.TransferableItems;
import com.sybase.central.viewer.TransferableSCItem;
import com.sybase.central.viewer.TreeItem;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.FontHelper;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class DetailsList
extends SCScrollPane
implements SCDetailsPanel6,
ListSelectionListener,
ActionListener,
SCContainerListener,
DropTargetListener,
IConstants,
FocusListener {
    private ScjSession _session = null;
    private SCViewerManager _viewerManager = null;
    SCContainer _treeContainer = null;
    SCDetailsContainer _detailsContainer = null;
    Vector<SCItem> _iScjItems = new Vector();
    DnDJTable _table = null;
    protected TableSorter _sortingTableModel = null;
    private ZipButton _verticalZipButton = null;
    private ZipButton _horizontalZipButton = null;
    private String _panelName;
    private DropTarget _dropTarget;
    private int _defaultActions = 0x40000003;
    private MouseListener _mouseListener = null;
    static Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final String ENTER_KEY_RELEASE = "ENTER_KEY_RELEASE";
    static int sortedColumn = 0;
    private ArrowIcon _ascendingIcon = null;
    private ArrowIcon _descendingIcon = null;
    private ArrowIcon _emptyIcon = null;
    private int[] _visibleColumns = null;
    private ImageHeaderRenderer _leftImageHeaderRenderer = null;
    private ImageHeaderRenderer _rightImageHeaderRenderer = null;

    DetailsList(ScjSession scjSession) {
        this._session = scjSession;
        this._table = new DnDJTable(scjSession);
        this.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.getViewport().setForeground(UIManager.getColor("Table.foreground"));
        this.getViewport().setOpaque(true);
        this._verticalZipButton = new ZipButton(SCImageLoader.getImageIcon("vertzip16", 1006));
        this._horizontalZipButton = new ZipButton(SCImageLoader.getImageIcon("horizzip16", 1006));
        this.setCorner("UPPER_RIGHT_CORNER", (Component)((Object)this._verticalZipButton));
        this.setCorner("LOWER_RIGHT_CORNER", (Component)((Object)this._horizontalZipButton));
        this._verticalZipButton.addActionListener(this);
        this._horizontalZipButton.addActionListener(this);
        InputMap inputMap = new InputMap();
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "selectNextRow");
        inputMap.put(KeyStroke.getKeyStroke(225, 0), "selectNextRow");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "selectPreviousRow");
        inputMap.put(KeyStroke.getKeyStroke(224, 0), "selectPreviousRow");
        inputMap.put(KeyStroke.getKeyStroke(40, 1), "selectNextRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(225, 1), "selectNextRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(38, 1), "selectPreviousRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(224, 1), "selectPreviousRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "scrollUpChangeSelection");
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "scrollDownChangeSelection");
        inputMap.put(KeyStroke.getKeyStroke(33, 1), "scrollUpExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(34, 1), "scrollDownExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "selectFirstRow");
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "selectLastRow");
        inputMap.put(KeyStroke.getKeyStroke(36, 1), "selectFirstRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(35, 1), "selectLastRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(36, 2), "selectFirstRow");
        inputMap.put(KeyStroke.getKeyStroke(35, 2), "selectLastRow");
        SwingUtilities.replaceUIInputMap(this._table, 1, inputMap);
        this._ascendingIcon = new ArrowIcon(true);
        this._descendingIcon = new ArrowIcon(false);
        this._emptyIcon = new ArrowIcon();
        this._table.setDefaultRenderer(Object.class, new ImageLabelRenderer());
        this._leftImageHeaderRenderer = new ImageHeaderRenderer(this._table, 2);
        this._rightImageHeaderRenderer = new ImageHeaderRenderer(this._table, 4);
        this._table.setShowGrid(false);
        this._table.setCellSelectionEnabled(true);
        this._table.setSelectionMode(2);
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.getTableHeader().setUpdateTableInRealTime(true);
        this._sortingTableModel = new TableSorter(this, this._table);
        this._table.setModel(this._sortingTableModel);
        this._table.setAutoResizeMode(0);
        this.getViewport().setView(this._table);
        this.initMouseListener();
        this._table.registerKeyboardAction(this, ENTER_KEY_RELEASE, KeyStroke.getKeyStroke(10, 0), 1);
        this._dropTarget = new DropTarget(this.getViewport(), this._defaultActions, this, true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._verticalZipButton) {
            Rectangle rectangle = this._table.getVisibleRect().y != 0 ? new Rectangle(0, 0, 1, 1) : new Rectangle(0, this._table.getSize().height, 1, 1);
            this._table.scrollRectToVisible(rectangle);
        } else if (actionEvent.getSource() == this._horizontalZipButton) {
            Rectangle rectangle = this._table.getVisibleRect().x != 0 ? new Rectangle(0, this._table.getVisibleRect().y, 1, 1) : new Rectangle(this._table.getSize().width, this._table.getVisibleRect().y, 1, 1);
            this._table.scrollRectToVisible(rectangle);
        } else if (actionEvent.getActionCommand().equals(ENTER_KEY_RELEASE)) {
            ((ViewerManager)this._viewerManager).enterKeyReleased();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this._table.getSelectionModel()) {
            this.setViewerSelectedDetailsItems();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this._table != null) {
            this._table.removeFocusListener(this);
            if (focusEvent.getSource() == this._table) {
                this.setViewerSelectedDetailsItems();
                this.repaint();
            }
            this._table.addFocusListener(this);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this._table != null) {
            this._table.removeFocusListener(this);
            if (focusEvent.getSource() == this._table) {
                this.repaint();
            }
            this._table.addFocusListener(this);
        }
    }

    @Override
    public void setViewerManager(SCViewerManager sCViewerManager) {
        this._viewerManager = sCViewerManager;
    }

    @Override
    public void onOpen(SCContainer sCContainer) {
        Object object;
        Object object2;
        SCHeader[] sCHeaderArray = null;
        boolean bl = false;
        if (this._detailsContainer != null) {
            NewInterfaceVersionHelper.doOnNotify(this._detailsContainer, this._viewerManager.getViewerFrame(), 100, 0);
            if (this._detailsContainer != null) {
                this._detailsContainer.open(0);
            } else {
                return;
            }
        }
        this.setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._table.setCursor(Cursor.getPredefinedCursor(3));
        this._table.getSelectionModel().removeListSelectionListener(this);
        this._table.getSelectionModel().clearSelection();
        if (this._detailsContainer != null) {
            sortedColumn = this._detailsContainer.getSortedColumn();
            this._visibleColumns = this._detailsContainer.getVisibleColumns();
        } else if (sCContainer instanceof SCContainer3) {
            sortedColumn = ((SCContainer3)sCContainer).getSortedColumn();
            this._visibleColumns = ((SCContainer3)sCContainer).getVisibleColumns();
        } else {
            this._visibleColumns = null;
            if (sCContainer != this._treeContainer) {
                sortedColumn = 0;
            }
        }
        this._treeContainer = sCContainer;
        this._iScjItems.removeAllElements();
        sCHeaderArray = this.getHeader();
        Vector<Vector<ColData>> vector = new Vector<Vector<ColData>>();
        Vector<String> vector2 = new Vector<String>(20);
        int n = 0;
        int[] nArray = null;
        if (this._visibleColumns == null) {
            n = sCHeaderArray.length;
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                vector2.addElement(sCHeaderArray[i].getText());
                nArray[i] = sCHeaderArray[i].getWidth();
                if (nArray[i] != -1) continue;
                bl = true;
            }
            if (this._detailsContainer != null) {
                object2 = this._detailsContainer.getItems();
                while (object2.hasMoreElements()) {
                    object = (SCItem)object2.nextElement();
                    this._iScjItems.addElement((SCItem)object);
                    vector.addElement(this.createRowDataForItem((SCItem)object, null));
                }
            } else {
                object2 = this._treeContainer.getItems();
                while (object2.hasMoreElements()) {
                    object = (SCItem)object2.nextElement();
                    this._iScjItems.addElement((SCItem)object);
                    vector.addElement(this.createRowDataForItem((SCItem)object, null));
                }
            }
        } else {
            n = this._visibleColumns.length;
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                vector2.addElement(sCHeaderArray[this._visibleColumns[i]].getText());
                nArray[i] = sCHeaderArray[this._visibleColumns[i]].getWidth();
                if (nArray[i] != -1) continue;
                bl = true;
            }
            if (this._detailsContainer != null) {
                object2 = this._detailsContainer.getItems();
                while (object2.hasMoreElements()) {
                    object = (SCItem)object2.nextElement();
                    this._iScjItems.addElement((SCItem)object);
                    vector.addElement(this.createRowDataForItem((SCItem)object, this._visibleColumns));
                }
            } else {
                object2 = this._treeContainer.getItems();
                while (object2.hasMoreElements()) {
                    object = (SCItem)object2.nextElement();
                    this._iScjItems.addElement((SCItem)object);
                    vector.addElement(this.createRowDataForItem((SCItem)object, this._visibleColumns));
                }
            }
        }
        this._sortingTableModel.setModel(new ScjTableModel((Vector)vector, (Vector)vector2));
        if (sortedColumn != 0) {
            this._sortingTableModel.setSort(Math.abs(sortedColumn) - 1, sortedColumn > 0);
        }
        object2 = this._table.getColumnModel();
        this._table.setAutoResizeMode(0);
        for (int i = 0; i < n; ++i) {
            object = object2.getColumn(i);
            if (!bl) {
                ((TableColumn)object).setPreferredWidth(nArray[i]);
                ((TableColumn)object).setWidth(nArray[i]);
            }
            int n2 = 2;
            if (this._visibleColumns == null) {
                if (sCHeaderArray[i] instanceof SCHeader2) {
                    n2 = ((SCHeader2)sCHeaderArray[i]).getAlignment();
                }
            } else if (sCHeaderArray[this._visibleColumns[i]] instanceof SCHeader2) {
                n2 = ((SCHeader2)sCHeaderArray[this._visibleColumns[i]]).getAlignment();
            }
            if (n2 == 2) {
                ((TableColumn)object).setHeaderRenderer(this._leftImageHeaderRenderer);
                continue;
            }
            if (n2 != 4) continue;
            ((TableColumn)object).setHeaderRenderer(this._rightImageHeaderRenderer);
        }
        if (bl) {
            this._table.setInitialColumnWidths();
        }
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.addFocusListener(this);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this._table.setCursor(Cursor.getPredefinedCursor(0));
        this.setVisible(true);
    }

    @Override
    public void setPanelName(String string) {
        this._panelName = string;
    }

    @Override
    public String getPanelName() {
        return this._panelName;
    }

    @Override
    public void onSetActive() {
        if (this._detailsContainer != null) {
            sortedColumn = this._detailsContainer.getSortedColumn();
            this._visibleColumns = this._detailsContainer.getVisibleColumns();
        } else if (this._treeContainer instanceof SCContainer3) {
            SCContainer3 sCContainer3 = (SCContainer3)this._treeContainer;
            sortedColumn = sCContainer3.getSortedColumn();
            this._visibleColumns = sCContainer3.getVisibleColumns();
        } else {
            this._visibleColumns = null;
        }
    }

    @Override
    public void onKillActive() {
    }

    @Override
    public void releaseResources() {
        this._table.getSelectionModel().removeListSelectionListener(this);
        this._table.removeFocusListener(this);
        this._treeContainer = null;
        if (this._detailsContainer != null) {
            this._detailsContainer.removeContainerListener(this);
        }
        this._detailsContainer = null;
        this._iScjItems.removeAllElements();
    }

    @Override
    public void refresh() {
        this._table.getSelectionModel().removeListSelectionListener(this);
        this._table.getSelectionModel().clearSelection();
        this._table.getSelectionModel().addListSelectionListener(this);
        sortedColumn = 0;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    public JTable getJTable() {
        return this._table;
    }

    @Override
    public void redisplayItem(SCItem sCItem) {
        int n = this.getRowIndex(sCItem);
        if (n > -1) {
            this._sortingTableModel.updateRowData(n, this.createRowDataForItem(sCItem, this._visibleColumns));
            this._table.tableChanged(new TableModelEvent(this._sortingTableModel, n));
        }
    }

    @Override
    public void deleteItem(SCItem sCItem) {
        int n = this.getRowIndex(sCItem);
        if (n > -1) {
            this._sortingTableModel.removeRow(n);
            this._table.tableChanged(new TableModelEvent(this._sortingTableModel, n, n, -1, -1));
        }
        this._iScjItems.removeElement(sCItem);
    }

    @Override
    public void addItem(SCItem sCItem) {
        this._sortingTableModel.addRow(this.createRowDataForItem(sCItem, this._visibleColumns));
        this._iScjItems.addElement(sCItem);
        this._table.tableChanged(new TableModelEvent(this._sortingTableModel, this._sortingTableModel.getRowCount() - 1, this._sortingTableModel.getRowCount() - 1, -1, 1));
    }

    @Override
    public boolean onKillActiveNotification() {
        return true;
    }

    @Override
    public void setSCDetailsContainer(SCDetailsContainer sCDetailsContainer) {
        if (this._detailsContainer != null) {
            this._detailsContainer.removeContainerListener(this);
        }
        this._detailsContainer = sCDetailsContainer;
        if (this._detailsContainer != null) {
            this._detailsContainer.addContainerListener(this);
        }
    }

    @Override
    public SCDetailsContainer getSCDetailsContainer() {
        return this._detailsContainer;
    }

    @Override
    public void selectFirstItem() {
        if (!this._iScjItems.isEmpty()) {
            this._table.getSelectionModel().removeListSelectionListener(this);
            this._table.getSelectionModel().setSelectionInterval(0, 0);
            this._table.getSelectionModel().addListSelectionListener(this);
            this.setViewerSelectedDetailsItems();
        }
        this._table.requestFocusInWindow();
    }

    @Override
    public void selectAllItems() {
        if (!this._iScjItems.isEmpty()) {
            this._table.getSelectionModel().removeListSelectionListener(this);
            this._table.selectAll();
            this._table.getSelectionModel().addListSelectionListener(this);
            this.setViewerSelectedDetailsItems();
        }
        this._table.requestFocusInWindow();
    }

    @Override
    public void invertSelectedItems() {
        if (!this._iScjItems.isEmpty()) {
            Object var2_1 = null;
            int n = this._table.getSelectionModel().getAnchorSelectionIndex();
            this._table.getSelectionModel().removeListSelectionListener(this);
            this._table.getSelectionModel().setValueIsAdjusting(true);
            for (int i = 0; i < this._iScjItems.size(); ++i) {
                if (!this._table.getSelectionModel().isSelectedIndex(i)) {
                    this._table.getSelectionModel().addSelectionInterval(i, i);
                    continue;
                }
                this._table.getSelectionModel().removeSelectionInterval(i, i);
            }
            if (this._table.getSelectionModel().isSelectedIndex(n)) {
                this._table.getSelectionModel().addSelectionInterval(n, n);
            } else {
                this._table.getSelectionModel().removeSelectionInterval(n, n);
            }
            this._table.getSelectionModel().setValueIsAdjusting(false);
            this._table.getSelectionModel().addListSelectionListener(this);
            this.setViewerSelectedDetailsItems();
        }
        this._table.requestFocusInWindow();
    }

    @Override
    public boolean selectItemByName(String string) {
        int n = -1;
        if (!this._iScjItems.isEmpty()) {
            for (int i = 0; i < this._iScjItems.size(); ++i) {
                if (!this._iScjItems.elementAt(i).getDisplayName(0).equals(string)) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                this._table.getSelectionModel().removeListSelectionListener(this);
                this._table.getSelectionModel().setValueIsAdjusting(true);
                this._table.getSelectionModel().setSelectionInterval(n, n);
                this._table.scrollRectToVisible(this._table.getCellRect(n, 0, true));
                this._table.getSelectionModel().setValueIsAdjusting(false);
                this._table.getSelectionModel().addListSelectionListener(this);
                this.setViewerSelectedDetailsItems();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DetailsList.this._table.requestFocusInWindow();
                    }
                });
                return true;
            }
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void deselectAllItems() {
        this._table.getSelectionModel().removeListSelectionListener(this);
        this._table.getSelectionModel().clearSelection();
        this._table.getSelectionModel().addListSelectionListener(this);
        this.setViewerSelectedDetailsItems();
    }

    @Override
    public void containerChanged(SCContainerEvent sCContainerEvent) {
        int n = sCContainerEvent.getEventId();
        SCItem sCItem = sCContainerEvent.getSCItem();
        if (sCItem == null && this._detailsContainer == null) {
            return;
        }
        if (sCItem != null) {
            if (n == 1) {
                this.addItem(sCItem);
            } else if (n == 2) {
                this.deleteItem(sCItem);
            } else if (n == 6) {
                this.redisplayItem(sCItem);
            }
        }
        if (n == 3) {
            this.refresh();
            if (sCItem == this._treeContainer && this._detailsContainer == null) {
                this.onOpen((SCContainer)sCItem);
                this._table.tableChanged(new TableModelEvent(this._sortingTableModel));
            } else if (this._detailsContainer != null) {
                NewInterfaceVersionHelper.doOnNotify(this._detailsContainer, this._viewerManager.getViewerFrame(), 200, 0);
                this._detailsContainer.close();
                this.onOpen(this._treeContainer);
            }
        }
        if (n == 8) {
            if (sCContainerEvent instanceof SCContainerEvent2) {
                this.selectItems(((SCContainerEvent2)sCContainerEvent).getSCItems());
            } else {
                this.selectItems(new SCItem[]{sCContainerEvent.getSCItem()});
            }
        }
    }

    TableSorter getSortingModel() {
        return this._sortingTableModel;
    }

    void selectItems(SCItem[] sCItemArray) {
        int n = Integer.MAX_VALUE;
        this._table.getSelectionModel().removeListSelectionListener(this);
        this._table.getSelectionModel().clearSelection();
        this._table.getSelectionModel().setValueIsAdjusting(true);
        if (!this._iScjItems.isEmpty()) {
            block0: for (int i = 0; i < this._iScjItems.size(); ++i) {
                for (int j = 0; j < sCItemArray.length; ++j) {
                    if (this._iScjItems.elementAt(i) != sCItemArray[j]) continue;
                    this._table.getSelectionModel().addSelectionInterval(i, i);
                    n = Math.min(i, n);
                    continue block0;
                }
            }
        }
        if (n != Integer.MAX_VALUE) {
            this._table.scrollRectToVisible(this._table.getCellRect(n, 0, true));
        }
        this._table.getSelectionModel().setValueIsAdjusting(false);
        this._table.getSelectionModel().addListSelectionListener(this);
        this.setViewerSelectedDetailsItems();
        this._table.requestFocusInWindow();
    }

    private void setViewerSelectedDetailsItems() {
        Vector<SCItem> vector = this.getSelectedListItems();
        if (vector == null) {
            this._viewerManager.setSelectedDetailsItems(null);
        } else {
            Object[] objectArray = new SCItem[vector.size()];
            vector.copyInto(objectArray);
            this._viewerManager.setSelectedDetailsItems((SCItem[])objectArray);
        }
    }

    private int getDisplaySortedColumnForHeaderSortedColumn(int n) {
        int n2;
        block3: {
            SCContainer3 sCContainer3;
            int[] nArray;
            block4: {
                nArray = null;
                n2 = n;
                if (n == 0) break block3;
                if (this._detailsContainer == null) break block4;
                nArray = this._detailsContainer.getVisibleColumns();
                if (nArray == null) break block3;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != Math.abs(n) - 1) continue;
                    n2 = i + 1;
                    if (n >= 0) break block3;
                    n2 *= -1;
                    break block3;
                }
                break block3;
            }
            if (this._treeContainer instanceof SCContainer3 && (nArray = (sCContainer3 = (SCContainer3)this._treeContainer).getVisibleColumns()) != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != Math.abs(n) - 1) continue;
                    n2 = i + 1;
                    if (n >= 0) break;
                    n2 *= -1;
                    break;
                }
            }
        }
        return n2;
    }

    void showCustomizeDialog(SCDialogSupport sCDialogSupport) {
        int[] nArray = null;
        int[] nArray2 = null;
        boolean bl = false;
        SCHeader[] sCHeaderArray = null;
        TreeItem treeItem = null;
        if (this._detailsContainer != null) {
            nArray = this._detailsContainer.getVisibleColumns();
            sCHeaderArray = this._detailsContainer.getHeadingInfo();
            bl = true;
        } else if (this._treeContainer instanceof SCContainer3) {
            nArray = ((SCContainer3)this._treeContainer).getVisibleColumns();
            sCHeaderArray = this._treeContainer.getHeadingInfo();
            bl = true;
        }
        if (bl) {
            ArrayList<Integer> arrayList;
            if (nArray != null) {
                nArray2 = new int[nArray.length];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            }
            if (CustomizeDlg.showCustomizeDialog(this._session, sCDialogSupport, sCHeaderArray, nArray2, arrayList = new ArrayList<Integer>())) {
                int[] nArray3 = new int[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    nArray3[i] = arrayList.get(i);
                }
                if (this._detailsContainer != null) {
                    this._detailsContainer.setVisibleColumns(nArray3);
                    sortedColumn = this._detailsContainer.getSortedColumn();
                } else {
                    ((SCContainer3)this._treeContainer).setVisibleColumns(nArray3);
                    sortedColumn = ((SCContainer3)this._treeContainer).getSortedColumn();
                }
                treeItem = ((ViewerManager)this._viewerManager).getTreeItemForContainer(this._treeContainer);
                if (treeItem != null) {
                    ((ViewerManager)this._viewerManager).refreshItem(treeItem);
                }
                TableColumnModel tableColumnModel = this._table.getColumnModel();
            }
        }
    }

    private int getRowIndex(SCItem sCItem) {
        for (int i = 0; i < this._iScjItems.size(); ++i) {
            if (this._iScjItems.elementAt(i) != sCItem) continue;
            return i;
        }
        return -1;
    }

    private SCHeader[] getHeader() {
        SCHeader[] sCHeaderArray = null;
        if (this._detailsContainer != null) {
            sCHeaderArray = this._detailsContainer.getHeadingInfo();
        } else if (this._treeContainer != null) {
            sCHeaderArray = this._treeContainer.getHeadingInfo();
        } else {
            return null;
        }
        return sCHeaderArray;
    }

    private Vector<ColData> createRowDataForItem(SCItem sCItem, int[] nArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        ColData colData = null;
        Vector<ColData> vector = new Vector<ColData>();
        SCHeader[] sCHeaderArray = this.getHeader();
        n = nArray == null ? sCHeaderArray.length : nArray.length;
        String string = sCItem.getDisplayName(sCHeaderArray[0].getId());
        if (string == null) {
            string = "";
        }
        stringBuffer.append(string).append(',');
        int n2 = 2;
        colData = new ColData(sCItem.getImage(false), string, string, n2);
        vector.addElement(colData);
        if (nArray == null) {
            for (int i = 1; i < n; ++i) {
                if (sCHeaderArray[i] instanceof SCHeader2) {
                    string = ((SCHeader2)sCHeaderArray[i]).getAccessibilityText();
                    n2 = ((SCHeader2)sCHeaderArray[i]).getAlignment();
                } else {
                    string = sCHeaderArray[i].getText();
                    n2 = 2;
                }
                if (string == null) {
                    string = "";
                }
                stringBuffer.append(string).append(' ');
                string = sCItem.getDisplayName(sCHeaderArray[i].getId());
                if (string == null) {
                    string = "";
                }
                stringBuffer.append(string).append(',');
                vector.addElement(new ColData(null, string, string, n2));
            }
            colData.accessibleDescription = stringBuffer.toString();
        } else {
            for (int i = 1; i < n; ++i) {
                if (sCHeaderArray[nArray[i]] instanceof SCHeader2) {
                    string = ((SCHeader2)sCHeaderArray[nArray[i]]).getAccessibilityText();
                    n2 = ((SCHeader2)sCHeaderArray[nArray[i]]).getAlignment();
                } else {
                    string = sCHeaderArray[nArray[i]].getText();
                    n2 = 2;
                }
                if (string == null) {
                    string = "";
                }
                stringBuffer.append(string).append(' ');
                string = sCItem.getDisplayName(sCHeaderArray[nArray[i]].getId());
                if (string == null) {
                    string = "";
                }
                stringBuffer.append(string).append(',');
                vector.addElement(new ColData(null, string, string, n2));
            }
            colData.accessibleDescription = stringBuffer.toString();
        }
        return vector;
    }

    void releaseAllResources() {
        this.releaseResources();
        this._session = null;
        this._table.removeMouseListener(this._mouseListener);
        this.removeMouseListener(this._mouseListener);
        this._mouseListener = null;
        this._viewerManager = null;
        this._iScjItems = null;
        this._table.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this._table.setDefaultRenderer(Object.class, null);
        this._table.getTableHeader().setDefaultRenderer(null);
        this._table.releaseResources();
        this._table = null;
        this._ascendingIcon = null;
        this._descendingIcon = null;
        this._emptyIcon = null;
        this._sortingTableModel = null;
        this._visibleColumns = null;
        this._verticalZipButton.removeActionListener(this);
        this._horizontalZipButton.removeActionListener(this);
        this._verticalZipButton = null;
        this._horizontalZipButton = null;
        if (this._detailsContainer != null) {
            this._detailsContainer.removeContainerListener(this);
        }
        this._detailsContainer = null;
        this._leftImageHeaderRenderer = null;
        this._rightImageHeaderRenderer = null;
    }

    int columnSort(int n, boolean bl) {
        SCHeader[] sCHeaderArray = null;
        this._table.getSelectionModel().removeListSelectionListener(this);
        this._table.getSelectionModel().clearSelection();
        this.setViewerSelectedDetailsItems();
        this._table.getSelectionModel().addListSelectionListener(this);
        int n2 = sortedColumn = n + 1;
        if (this._visibleColumns != null) {
            n2 = this._visibleColumns[n] + 1;
        }
        if (!bl) {
            sortedColumn *= -1;
            n2 *= -1;
        }
        if (this._detailsContainer != null) {
            if (!NewInterfaceVersionHelper.doOnNotify(this._detailsContainer, this._viewerManager.getViewerFrame(), 205, n2)) {
                this.onOpen(this._treeContainer);
                this._sortingTableModel.setSort(n, bl);
                return 3;
            }
            this._table.getTableHeader().repaint();
        } else {
            if (!NewInterfaceVersionHelper.doOnNotify(this._treeContainer, this._viewerManager.getViewerFrame(), 205, n2)) {
                NewInterfaceVersionHelper.doOnNotify(this._treeContainer, this._viewerManager.getViewerFrame(), 100, 0);
                this.onOpen(this._treeContainer);
                this._sortingTableModel.setSort(n, bl);
                return 3;
            }
            this._table.getTableHeader().repaint();
        }
        sCHeaderArray = this.getHeader();
        if (sCHeaderArray[n] instanceof SCHeader2 && ((SCHeader2)sCHeaderArray[n]).isNumeric()) {
            return 1;
        }
        return 2;
    }

    void columnWidthsChanged(int[] nArray) {
        if (this._detailsContainer != null) {
            this._detailsContainer.columnWidthsChanged(nArray);
        } else if (this._treeContainer instanceof SCContainer2) {
            ((SCContainer2)this._treeContainer).columnWidthsChanged(nArray);
        }
    }

    private void initMouseListener() {
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    DetailsList.this.showPopupMenu(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    DetailsList.this.showPopupMenu(mouseEvent);
                } else {
                    DetailsList.this.handleListClick(mouseEvent);
                }
            }
        };
        this._table.addMouseListener(this._mouseListener);
        this.addMouseListener(this._mouseListener);
    }

    private void handleListClick(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._table && mouseEvent.getClickCount() > 1) {
            int n = this._table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (n > -1 && this._table.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY())) == 0) {
                if ((mouseEvent.getModifiers() & 8) == 8) {
                    this.callOnCommandForItems(107);
                } else {
                    this._table.setRowSelectionInterval(n, n);
                    SCItem sCItem = this.getSelectedItem(n);
                    if (sCItem instanceof SCContainer) {
                        if (this._detailsContainer == null) {
                            if ((this._treeContainer.getAttributes() & 1) != 0) {
                                this._viewerManager.openDetailsContainer(this._treeContainer, (SCContainer)sCItem);
                            } else {
                                this.callOnCommandForItems(107);
                            }
                        }
                    } else {
                        this.callOnCommandForItems(100);
                    }
                }
            }
        } else if (mouseEvent.getSource() == this) {
            this._table.getSelectionModel().removeListSelectionListener(this);
            this._table.getSelectionModel().clearSelection();
            this._table.getSelectionModel().addListSelectionListener(this);
            this.setViewerSelectedDetailsItems();
        }
    }

    private void callOnCommandForItems(int n) {
        this._viewerManager.startWait();
        Vector<SCItem> vector = this.getSelectedListItems();
        if (vector != null) {
            Enumeration<SCItem> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().onCommand(this._viewerManager.getViewerFrame(), n, vector.elements(), 0);
            }
        }
        this._viewerManager.endWait();
    }

    private Vector<SCItem> getSelectedListItems() {
        Vector<SCItem> vector = new Vector<SCItem>(50);
        int[] nArray = this._table.getSelectedRows();
        SCItem sCItem = null;
        for (int i = 0; i < nArray.length; ++i) {
            sCItem = this.getSelectedItem(nArray[i]);
            if (sCItem == null) continue;
            vector.addElement(sCItem);
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    private SCItem getSelectedItem(int n) {
        try {
            int n2 = this._sortingTableModel.getDataIndexForTableIndex(n);
            return this._iScjItems.elementAt(n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        int n;
        JMenuItem[] jMenuItemArray = null;
        if (mouseEvent.getSource() == this._table) {
            int n2 = this._table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            n = this._table.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (n2 > -1 && n > -1) {
                if (n == 0) {
                    if (!this._table.getSelectionModel().isSelectedIndex(n2)) {
                        this._table.setRowSelectionInterval(n2, n2);
                    }
                    this._table.requestFocusInWindow();
                    this.setViewerSelectedDetailsItems();
                } else {
                    this._table.getSelectionModel().clearSelection();
                    this.setViewerSelectedDetailsItems();
                }
            }
            jMenuItemArray = this._viewerManager.buildContextMenuItems();
        } else if (mouseEvent.getSource() == this) {
            this._table.getSelectionModel().clearSelection();
            this.setViewerSelectedDetailsItems();
            jMenuItemArray = this._viewerManager.buildContextMenuItems();
        }
        if (jMenuItemArray != null) {
            JPopupMenu jPopupMenu = new JPopupMenu(null);
            for (n = 0; n < jMenuItemArray.length; ++n) {
                if (jMenuItemArray[n] == null) {
                    jPopupMenu.addSeparator();
                    continue;
                }
                jPopupMenu.add(jMenuItemArray[n]);
            }
            this._viewerManager.setPopupMenu(jPopupMenu);
            this._viewerManager.startWait();
            if (mouseEvent.getSource() == this._table) {
                UIUtils.showJPopupMenu((JPopupMenu)jPopupMenu, (JComponent)this._table, (Point)new Point(mouseEvent.getX(), mouseEvent.getY()));
            } else {
                UIUtils.showJPopupMenu((JPopupMenu)jPopupMenu, (JComponent)this, (Point)new Point(mouseEvent.getX(), mouseEvent.getY()));
            }
            this._viewerManager.endWait();
        }
    }

    int getNumberOfDetailsItems() {
        return this._iScjItems.size();
    }

    int getNumberOfSelectedDetailsItems() {
        if (this.getSelectedListItems() == null) {
            return 0;
        }
        return this.getSelectedListItems().size();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.determineDragAction(dropTargetDragEvent);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.determineDragAction(dropTargetDragEvent);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.determineDragAction(dropTargetDragEvent);
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        SCContainer sCContainer = this._treeContainer;
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Vector vector = null;
            try {
                vector = (Vector)transferable.getTransferData(TransferableItems.TransferableItemsFlavor);
                switch (dropTargetDropEvent.getDropAction()) {
                    case 1: {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        dropTargetDropEvent.dropComplete(true);
                        sCContainer.onCommand(this._viewerManager.getViewerFrame(), 103, vector.elements(), 0);
                        break;
                    }
                    case 2: {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        dropTargetDropEvent.dropComplete(true);
                        sCContainer.onCommand(this._viewerManager.getViewerFrame(), 104, vector.elements(), 0);
                        break;
                    }
                    case 0x40000000: {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        dropTargetDropEvent.dropComplete(true);
                        sCContainer.onCommand(this._viewerManager.getViewerFrame(), 105, vector.elements(), 0);
                        break;
                    }
                    default: {
                        dropTargetDropEvent.rejectDrop();
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                }
                return;
            }
            catch (Exception exception) {
                Vector<Transferable> vector2 = new Vector<Transferable>(1);
                vector2.addElement(transferable);
                switch (dropTargetDropEvent.getDropAction()) {
                    case 1: {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        dropTargetDropEvent.dropComplete(true);
                        sCContainer.onCommand(this._viewerManager.getViewerFrame(), 103, vector2.elements(), 0);
                        break;
                    }
                    case 2: {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        dropTargetDropEvent.dropComplete(true);
                        sCContainer.onCommand(this._viewerManager.getViewerFrame(), 104, vector2.elements(), 0);
                        break;
                    }
                    case 0x40000000: {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        dropTargetDropEvent.dropComplete(true);
                        sCContainer.onCommand(this._viewerManager.getViewerFrame(), 105, vector2.elements(), 0);
                        break;
                    }
                    default: {
                        dropTargetDropEvent.rejectDrop();
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                }
                return;
            }
        }
        catch (Exception exception) {
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
            return;
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    private void determineDragAction(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        Vector<Transferable> vector = new Vector<Transferable>(1);
        SCContainer sCContainer = this._treeContainer;
        int n2 = dropTargetDragEvent.getDropAction();
        Object[] objectArray = dropTargetDragEvent.getCurrentDataFlavors();
        Vector<Object> vector2 = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].equals(TransferableItems.TransferableItemsFlavor)) continue;
            vector2.addElement(objectArray[i]);
        }
        objectArray = new DataFlavor[vector2.size()];
        vector2.copyInto(objectArray);
        if (sCContainer instanceof SCItem5) {
            if (dropTargetDragEvent.getTransferable() instanceof TransferableItems) {
                n = ((SCItem5)((Object)sCContainer)).queryDropItems(dropTargetDragEvent.getDropAction(), (DataFlavor[])objectArray, ((TransferableItems)dropTargetDragEvent.getTransferable()).elements());
            } else {
                vector.add(dropTargetDragEvent.getTransferable());
                n = ((SCItem5)((Object)sCContainer)).queryDropItems(dropTargetDragEvent.getDropAction(), (DataFlavor[])objectArray, vector.elements());
            }
        } else {
            n = sCContainer.queryDropItems(dropTargetDragEvent.getDropAction(), (DataFlavor[])objectArray);
        }
        if (n == 1) {
            dropTargetDragEvent.acceptDrag(1);
            return;
        }
        if (n == 0x40000000) {
            dropTargetDragEvent.acceptDrag(0x40000000);
            return;
        }
        if (n == 2) {
            dropTargetDragEvent.acceptDrag(2);
            return;
        }
        dropTargetDragEvent.rejectDrag();
    }

    private String getHeaderToolTipText(int n) {
        SCHeader[] sCHeaderArray = null;
        sCHeaderArray = this.getHeader();
        if (sCHeaderArray == null) {
            return null;
        }
        if (sCHeaderArray.length > n) {
            if (this._visibleColumns != null && this._visibleColumns.length > n && sCHeaderArray.length > this._visibleColumns[n]) {
                if (sCHeaderArray[this._visibleColumns[n]] instanceof SCHeader3) {
                    return ((SCHeader3)sCHeaderArray[this._visibleColumns[n]]).getToolTipText();
                }
            } else if (sCHeaderArray[n] instanceof SCHeader3) {
                return ((SCHeader3)sCHeaderArray[n]).getToolTipText();
            }
        }
        return null;
    }

    class DnDJTable
    extends JTable
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener,
    ActionListener {
        private DragSource _dSource = null;
        private DropTarget _dTarget = null;
        private ScjSession _scjSession = null;
        private Timer _timer = null;
        private StringBuffer _typedSoFar = null;
        private boolean _sameKeyChar = true;
        private int _ticksWithoutActivity = 0;

        DnDJTable(ScjSession scjSession) {
            this._scjSession = scjSession;
            this._dSource = DragSource.getDefaultDragSource();
            this._dSource.createDefaultDragGestureRecognizer(this, DetailsList.this._defaultActions, this);
            this._dTarget = new DropTarget(this, DetailsList.this._defaultActions, this, true);
            this._typedSoFar = new StringBuffer();
            this._timer = new Timer(500, this);
            this._timer.start();
            TreeSet<KeyStroke> treeSet = new TreeSet<KeyStroke>();
            treeSet.add(KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            TreeSet<KeyStroke> treeSet2 = new TreeSet<KeyStroke>();
            treeSet2.add(KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
            this.setFocusTraversalKeys(0, treeSet);
            this.setFocusTraversalKeys(1, treeSet2);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public void setInitialColumnWidths() {
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n = this.getModel().getColumnCount();
            int n2 = this.getPreferredScrollableViewportSize().height;
            int n3 = n2 / this.getRowHeight();
            int n4 = this.getRowCount();
            int n5 = Math.min(n4, n3);
            if (n5 < 10 && n4 >= 10) {
                n5 = 10;
            }
            for (int i = 0; i < n; ++i) {
                Object object;
                TableCellRenderer tableCellRenderer;
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                int n6 = 0;
                JTableHeader jTableHeader = this.getTableHeader();
                if (jTableHeader != null) {
                    tableCellRenderer = jTableHeader.getDefaultRenderer();
                    object = tableColumn.getHeaderValue();
                    if (object != null) {
                        try {
                            Component component = tableCellRenderer.getTableCellRendererComponent(null, object, false, false, 0, 0);
                            n6 = component.getPreferredSize().width;
                        }
                        catch (Exception exception) {
                            return;
                        }
                    }
                }
                for (int j = 0; j < n5; ++j) {
                    tableCellRenderer = this.getCellRenderer(j, i);
                    object = this.getModel().getValueAt(j, i);
                    if (object == null && j >= (n5 = Math.min(this.getRowCount(), 10))) break;
                    int n7 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                    n6 = Math.max(n6, n7);
                }
                tableColumn.setPreferredWidth(n6 + 2);
            }
            this.sizeColumnsToFit(-1);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            ColData colData;
            int n = DetailsList.this._table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            int n2 = DetailsList.this._table.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (n > -1 && n2 > -1 && DetailsList.this._sortingTableModel.getValueAt(n, n2) instanceof ColData && (colData = (ColData)DetailsList.this._sortingTableModel.getValueAt(n, n2)) != null && colData.toString().length() > 0) {
                return colData.toString();
            }
            return null;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
            if (inputEvent instanceof MouseEvent && ((MouseEvent)inputEvent).isPopupTrigger()) {
                return;
            }
            int n = this.rowAtPoint(dragGestureEvent.getDragOrigin());
            int n2 = this.columnAtPoint(dragGestureEvent.getDragOrigin());
            if (n > -1 && n2 > -1) {
                Transferable transferable;
                if (n2 > 0) {
                    return;
                }
                if (!this.getSelectionModel().isSelectedIndex(n)) {
                    this.addRowSelectionInterval(n, n);
                }
                if ((transferable = this.buildTransferableItems()) != null) {
                    try {
                        dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, transferable, this);
                    }
                    catch (InvalidDnDOperationException invalidDnDOperationException) {
                        // empty catch block
                    }
                }
            }
        }

        private Transferable buildTransferableItems() {
            TransferableItems transferableItems = null;
            Vector vector = DetailsList.this.getSelectedListItems();
            if (vector != null) {
                transferableItems = new TransferableItems();
                for (int i = 0; i < vector.size(); ++i) {
                    transferableItems.addTransferable(new TransferableSCItem((SCItem)vector.elementAt(i)));
                }
            }
            return transferableItems;
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            int n = dragSourceDragEvent.getTargetActions();
            dragSourceContext.setCursor(null);
            if (n == 0x40000000) {
                dragSourceContext.setCursor(DragSource.DefaultLinkDrop);
            } else if (n == 1) {
                dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
            } else if (n == 2) {
                dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
            } else {
                dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            int n = dragSourceDragEvent.getTargetActions();
            dragSourceContext.setCursor(null);
            if (n == 0x40000000) {
                dragSourceContext.setCursor(DragSource.DefaultLinkDrop);
            } else if (n == 1) {
                dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
            } else if (n == 2) {
                dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
            } else {
                dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
            dragSourceContext.setCursor(null);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.determineDragAction(dropTargetDragEvent);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.determineDragAction(dropTargetDragEvent);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this.determineDragAction(dropTargetDragEvent);
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n = this.rowAtPoint(dropTargetDropEvent.getLocation());
            int n2 = this.columnAtPoint(dropTargetDropEvent.getLocation());
            if (n > -1 && n2 > -1) {
                SCItem sCItem = null;
                sCItem = n2 > 0 ? DetailsList.this._treeContainer : DetailsList.this.getSelectedItem(n);
                if (sCItem != null) {
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        Vector vector = null;
                        try {
                            vector = (Vector)transferable.getTransferData(TransferableItems.TransferableItemsFlavor);
                            switch (dropTargetDropEvent.getDropAction()) {
                                case 1: {
                                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                    dropTargetDropEvent.dropComplete(true);
                                    sCItem.onCommand(DetailsList.this._viewerManager.getViewerFrame(), 103, vector.elements(), 0);
                                    break;
                                }
                                case 2: {
                                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                    dropTargetDropEvent.dropComplete(true);
                                    sCItem.onCommand(DetailsList.this._viewerManager.getViewerFrame(), 104, vector.elements(), 0);
                                    break;
                                }
                                case 0x40000000: {
                                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                    dropTargetDropEvent.dropComplete(true);
                                    sCItem.onCommand(DetailsList.this._viewerManager.getViewerFrame(), 105, vector.elements(), 0);
                                    break;
                                }
                                default: {
                                    dropTargetDropEvent.rejectDrop();
                                    dropTargetDropEvent.dropComplete(false);
                                    return;
                                }
                            }
                            return;
                        }
                        catch (Exception exception) {
                            Vector<Transferable> vector2 = new Vector<Transferable>(1);
                            vector2.addElement(transferable);
                            switch (dropTargetDropEvent.getDropAction()) {
                                case 1: {
                                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                    dropTargetDropEvent.dropComplete(true);
                                    sCItem.onCommand(DetailsList.this._viewerManager.getViewerFrame(), 103, vector2.elements(), 0);
                                    break;
                                }
                                case 2: {
                                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                    dropTargetDropEvent.dropComplete(true);
                                    sCItem.onCommand(DetailsList.this._viewerManager.getViewerFrame(), 104, vector2.elements(), 0);
                                    break;
                                }
                                case 0x40000000: {
                                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                    dropTargetDropEvent.dropComplete(true);
                                    sCItem.onCommand(DetailsList.this._viewerManager.getViewerFrame(), 105, vector2.elements(), 0);
                                    break;
                                }
                                default: {
                                    dropTargetDropEvent.rejectDrop();
                                    dropTargetDropEvent.dropComplete(false);
                                    return;
                                }
                            }
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        private void determineDragAction(DropTargetDragEvent dropTargetDragEvent) {
            Vector<Transferable> vector = new Vector<Transferable>(1);
            int n = this.rowAtPoint(dropTargetDragEvent.getLocation());
            int n2 = this.columnAtPoint(dropTargetDragEvent.getLocation());
            if (n > -1 && n2 > -1) {
                SCItem sCItem = null;
                sCItem = n2 > 0 ? DetailsList.this._treeContainer : DetailsList.this.getSelectedItem(n);
                int n3 = dropTargetDragEvent.getDropAction();
                if (sCItem != null) {
                    int n4;
                    Object[] objectArray = dropTargetDragEvent.getCurrentDataFlavors();
                    Vector<Object> vector2 = new Vector<Object>(objectArray.length);
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i].equals(TransferableItems.TransferableItemsFlavor)) continue;
                        vector2.addElement(objectArray[i]);
                    }
                    objectArray = new DataFlavor[vector2.size()];
                    vector2.copyInto(objectArray);
                    if (sCItem instanceof SCItem5) {
                        if (dropTargetDragEvent.getTransferable() instanceof TransferableItems) {
                            n4 = ((SCItem5)sCItem).queryDropItems(dropTargetDragEvent.getDropAction(), (DataFlavor[])objectArray, ((TransferableItems)dropTargetDragEvent.getTransferable()).elements());
                        } else {
                            vector.add(dropTargetDragEvent.getTransferable());
                            n4 = ((SCItem5)sCItem).queryDropItems(dropTargetDragEvent.getDropAction(), (DataFlavor[])objectArray, vector.elements());
                        }
                    } else {
                        n4 = sCItem.queryDropItems(dropTargetDragEvent.getDropAction(), (DataFlavor[])objectArray);
                    }
                    if (n4 == 1) {
                        dropTargetDragEvent.acceptDrag(1);
                        return;
                    }
                    if (n4 == 0x40000000) {
                        dropTargetDragEvent.acceptDrag(0x40000000);
                        return;
                    }
                    if (n4 == 2) {
                        dropTargetDragEvent.acceptDrag(2);
                        return;
                    }
                }
            }
            dropTargetDragEvent.rejectDrag();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            int n2;
            if ((keyEvent.getModifiers() == 0 || (keyEvent.getModifiers() & 1) != 0) && n == 0 && keyEvent.getKeyCode() == 0 && keyEvent.getKeyChar() != '\uffff' && (n2 = this.getRowCount()) > 0) {
                this._timer.stop();
                char c = keyEvent.getKeyChar();
                this._ticksWithoutActivity = 0;
                if (this._typedSoFar.length() > 0 && this._typedSoFar.charAt(this._typedSoFar.length() - 1) != c) {
                    this._sameKeyChar = false;
                }
                this._typedSoFar.append(c);
                int n3 = 0;
                int[] nArray = this.getSelectedRows();
                if (nArray.length > 0) {
                    n3 = nArray[nArray.length - 1];
                }
                boolean bl2 = false;
                bl2 = this._sameKeyChar ? this.selectMatchingRow(++n3, n2, String.valueOf(c)) : this.selectMatchingRow(n3, n2, this._typedSoFar.toString());
                if (!bl2) {
                    if (this._sameKeyChar) {
                        this.selectMatchingRow(0, n3, String.valueOf(c));
                    } else {
                        this.selectMatchingRow(0, n3, this._typedSoFar.toString());
                    }
                }
                this._timer.restart();
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        private boolean selectMatchingRow(int n, int n2, String string) {
            TableSorter tableSorter = (TableSorter)this.getModel();
            for (int i = n; i < n2; ++i) {
                String string2 = ((ColData)tableSorter.getValueAt(i, 0)).toString();
                if (string2.toLowerCase().indexOf(string.toLowerCase()) != 0) continue;
                this.setRowSelectionInterval(i, i);
                this.scrollRectToVisible(this.getCellRect(i, 0, true));
                return true;
            }
            return false;
        }

        public void releaseResources() {
            this._dSource = null;
            this._dTarget = null;
            this._scjSession = null;
            if (this._timer.isRunning()) {
                this._timer.stop();
            }
            this._timer.removeActionListener(this);
            this._timer = null;
            this._typedSoFar = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._timer && ++this._ticksWithoutActivity == 2) {
                this._typedSoFar.setLength(0);
                this._sameKeyChar = true;
            }
        }
    }

    static class ImageLabelRenderer
    extends JPanel
    implements TableCellRenderer {
        GridBagLayout _gbl = null;
        GridBagConstraints _gbc = null;
        private Font _defaultFont = null;
        private JLabel _iconLabel = new JLabel();
        private JLabel _textLabel = new JLabel();

        public ImageLabelRenderer() {
            this.setOpaque(true);
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Label.foreground"));
            this._gbl = new GridBagLayout();
            this.setLayout(this._gbl);
            this._gbc = new GridBagConstraints();
            this._gbc.anchor = 17;
            this._gbc.fill = 0;
            this._gbc.gridx = 0;
            this._gbc.gridy = 0;
            this._gbc.gridwidth = 1;
            this._gbc.gridheight = 1;
            this._gbl.setConstraints(this._iconLabel, this._gbc);
            this.add(this._iconLabel);
            this._gbc.anchor = 17;
            this._gbc.fill = 0;
            this._gbc.gridx = 1;
            this._gbc.gridy = 0;
            this._gbc.gridwidth = 1;
            this._gbc.gridheight = 1;
            this._gbc.weightx = 1.0;
            this._gbc.weighty = 0.0;
            this._gbc.insets = new Insets(0, 5, 0, 0);
            this._gbl.setConstraints(this._textLabel, this._gbc);
            this.add(this._textLabel);
            this._iconLabel.setBackground(UIManager.getColor("Table.background"));
            this._iconLabel.setForeground(UIManager.getColor("Label.foreground"));
            this._textLabel.setOpaque(true);
            this._textLabel.setBackground(UIManager.getColor("Table.background"));
            this._textLabel.setForeground(UIManager.getColor("Label.foreground"));
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this._textLabel.getAccessibleContext();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            if (object != null) {
                if (object instanceof ColData) {
                    this._iconLabel.setIcon(((ColData)object).icon);
                    this._textLabel.setText(((ColData)object).displayName);
                    this._textLabel.getAccessibleContext().setAccessibleDescription(((ColData)object).accessibleDescription);
                    this._textLabel.getAccessibleContext().setAccessibleName(((ColData)object).accessibleDescription);
                    this._gbc.anchor = 17;
                    if (((ColData)object).alignment == 4) {
                        this._gbc.anchor = 13;
                    }
                    this._gbl.setConstraints(this._textLabel, this._gbc);
                } else if (object instanceof String) {
                    this._textLabel.setText((String)object);
                    this._iconLabel.setIcon(null);
                }
                if (n2 == 0) {
                    this._textLabel.setBorder(bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : NO_FOCUS_BORDER);
                } else {
                    this._textLabel.setBorder(null);
                }
                if (bl && jTable.isFocusOwner() && n2 == 0) {
                    this._textLabel.setBackground(UIManager.getColor("TextField.selectionBackground"));
                    this._textLabel.setForeground(UIManager.getColor("TextField.selectionForeground"));
                } else if (bl && !jTable.isFocusOwner() && n2 == 0) {
                    this._textLabel.setBackground(SystemColor.control);
                    this._textLabel.setForeground(SystemColor.controlText);
                } else {
                    this._textLabel.setBackground(UIManager.getColor("Table.background"));
                    this._textLabel.setForeground(UIManager.getColor("Label.foreground"));
                }
            }
            if ((string = this._textLabel.toString()).length() > 0) {
                if (this._defaultFont == null) {
                    this._defaultFont = this._textLabel.getFont();
                }
                if (this._defaultFont.canDisplayUpTo(string) == -1) {
                    this._textLabel.setFont(this._defaultFont);
                } else {
                    FontHelper.setFontForString((Component)this._textLabel, (Font)this._defaultFont, (String)string);
                }
            }
            return this;
        }
    }

    class ArrowIcon
    implements Icon {
        private final boolean SOLID_ARROW = UIUtils.shouldDrawSolidSortArrow();
        private final int POINTS = 3;
        private boolean _ascending;
        private boolean _draw;
        private int _widthAndHeight = 10;

        ArrowIcon() {
            this._draw = false;
        }

        ArrowIcon(boolean bl) {
            this._ascending = bl;
            this._draw = true;
        }

        @Override
        public int getIconWidth() {
            return this._widthAndHeight;
        }

        @Override
        public int getIconHeight() {
            return this._widthAndHeight;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            this._widthAndHeight = n3 = graphics.getFontMetrics().getAscent() - 2;
            if (this._draw) {
                if (this._ascending) {
                    nArray[0] = n + n3 / 2;
                    nArray2[0] = n2;
                    nArray[1] = n;
                    nArray2[1] = n2 + n3;
                    nArray[2] = n + n3;
                    nArray2[2] = n2 + n3;
                    if (this.SOLID_ARROW) {
                        graphics.setColor(SystemColor.controlShadow);
                        graphics.fillPolygon(nArray, nArray2, 3);
                    } else {
                        graphics.setColor(SystemColor.controlDkShadow);
                        graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                        graphics.setColor(SystemColor.controlLtHighlight);
                        graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                        graphics.drawLine(nArray[2], nArray2[2], nArray[0], nArray2[0]);
                    }
                } else {
                    nArray[0] = n + 1 + (n3 - 1) / 2;
                    nArray2[0] = n2 + n3;
                    nArray[1] = n + n3;
                    nArray2[1] = n2 + 1;
                    nArray[2] = n + 1;
                    nArray2[2] = n2 + 1;
                    if (this.SOLID_ARROW) {
                        graphics.setColor(SystemColor.controlShadow);
                        graphics.fillPolygon(nArray, nArray2, 3);
                    } else {
                        graphics.setColor(SystemColor.controlLtHighlight);
                        graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                        graphics.setColor(SystemColor.controlDkShadow);
                        graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                        graphics.drawLine(nArray[2], nArray2[2], nArray[0], nArray2[0]);
                    }
                }
            }
        }
    }

    class ImageHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer _renderer;
        private int _alignment;

        public ImageHeaderRenderer(JTable jTable, int n) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                this._renderer = jTableHeader.getDefaultRenderer();
            }
            this._alignment = n;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this._renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)component;
                defaultTableCellRenderer.setHorizontalAlignment(this._alignment);
                defaultTableCellRenderer.setHorizontalTextPosition(2);
                defaultTableCellRenderer.setToolTipText(DetailsList.this.getHeaderToolTipText(n2));
                int n3 = DetailsList.this.getDisplaySortedColumnForHeaderSortedColumn(sortedColumn);
                if (Math.abs(n3) == n2 + 1) {
                    if (n3 < 0) {
                        defaultTableCellRenderer.setIcon(DetailsList.this._descendingIcon);
                    } else if (n3 > 0) {
                        defaultTableCellRenderer.setIcon(DetailsList.this._ascendingIcon);
                    } else {
                        defaultTableCellRenderer.setIcon(DetailsList.this._emptyIcon);
                    }
                } else {
                    defaultTableCellRenderer.setIcon(DetailsList.this._emptyIcon);
                }
            }
            return component;
        }
    }

    static class ZipButton
    extends SCButton {
        ZipButton(Icon icon) {
            super(icon);
            this.setFocusPainted(false);
        }

        public boolean isFocusable() {
            return false;
        }
    }

    static class ColData {
        Icon icon = null;
        String displayName = null;
        String accessibleDescription = null;
        int alignment = 2;

        ColData(Icon icon, String string, String string2, int n) {
            this.icon = icon;
            this.displayName = string;
            this.accessibleDescription = string2;
            this.alignment = n;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

