/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.DefaultSCPageController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.DisconnectDlgJPanel;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.IHelpConstants;
import com.sybase.central.viewer.SCMultiList;
import com.sybase.central.viewer.SCSortingTableModel;
import com.sybase.central.viewer.ScjConnection;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class DisconnectDlg
extends DefaultSCPageController
implements ScjResourceConstants,
ListSelectionListener,
IConstants,
IHelpConstants {
    private ScjSession _session = null;
    private ScjViewerSupport _viewerSupport = null;
    private SCMultiList _scmultil_list;
    private Vector _connections;

    DisconnectDlg(SCDialogSupport sCDialogSupport, ScjSession scjSession, ScjViewerSupport scjViewerSupport) {
        super(sCDialogSupport, new DisconnectDlgJPanel());
        this._session = scjSession;
        this._viewerSupport = scjViewerSupport;
        this._connections = scjViewerSupport.getConnectionList();
        DisconnectDlgJPanel disconnectDlgJPanel = (DisconnectDlgJPanel)this.getJPanel();
        JLabel jLabel = disconnectDlgJPanel.jlabel_label;
        this._scmultil_list = disconnectDlgJPanel.scmultil_list;
        this._scmultil_list.setSelectionMode(2);
        this._scmultil_list.setAutoResizeMode(0);
        this._scmultil_list.setColumnHeadings(new StringBuffer(ScjSession.getString("STR_DISCONN_DLG_CONN_DESC")).append(", ").append(ScjSession.getString("STR_DISCONN_DLG_CONN_NAME")).append(", ").append(ScjSession.getString("STR_DISCONN_DLG_PLUGIN_NAME")).toString());
        this._scmultil_list.setColumnWidths("175, 175, 175");
        this._scmultil_list.setColumnHasIconTextData(0, true);
        this._scmultil_list.getScrollPane().setPreferredSize(new Dimension(500, 200));
        jLabel.setText(ScjSession.getString("STR_DISCONN_DLG_LABEL"));
        jLabel.setLabelFor(this._scmultil_list);
        this._scmultil_list.addListSelectionListener(this);
    }

    @Override
    public void onInitDialog() {
        this.fillConnectionList();
    }

    @Override
    public void onHelp() {
        this._session.showHelpIndex("HELP_DISCONNECTDLG_INDEX", this._dialogSupport);
    }

    private void fillConnectionList() {
        Enumeration enumeration = this._connections.elements();
        this._scmultil_list.removeListSelectionListener(this);
        this._scmultil_list.clear();
        while (enumeration.hasMoreElements()) {
            ScjConnection scjConnection = (ScjConnection)enumeration.nextElement();
            Vector<String> vector = new Vector<String>();
            vector.addElement(scjConnection.description);
            vector.addElement(scjConnection.displayName);
            vector.addElement(scjConnection.provider.getDisplayName());
            this._scmultil_list.addRowWithIcon(JCOMP_CONNECTION_ICON, vector);
        }
        this._scmultil_list.sort();
        this._scmultil_list.addListSelectionListener(this);
        this.enableButtons();
    }

    private void enableButtons() {
        if (this._scmultil_list.getSelectedRowCount() != 0) {
            this._dialogSupport.setEnabledStandardButtons(11);
        } else {
            this._dialogSupport.setEnabledStandardButtons(10);
        }
    }

    @Override
    public boolean onOk() {
        int n;
        int[] nArray = this._scmultil_list.getSelectedRows();
        ArrayList arrayList = new ArrayList();
        for (n = nArray.length - 1; n >= 0; --n) {
            int n2 = ((SCSortingTableModel)this._scmultil_list.getModel()).getDataIndexForTableIndex(nArray[n]);
            arrayList.add(this._connections.elementAt(n2));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ScjConnection scjConnection = (ScjConnection)arrayList.get(n);
            scjConnection.provider.disconnect((JFrame)this._dialogSupport.getJDialog().getParent(), scjConnection.data);
        }
        return super.onOk();
    }

    @Override
    public void releaseResources() {
        this._scmultil_list.removeListSelectionListener(this);
        this._scmultil_list.releaseResources();
        this._session = null;
        this._viewerSupport = null;
        this._connections = null;
        super.releaseResources();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this._scmultil_list.getSelectionModel()) {
            this.enableButtons();
        }
    }
}

