/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.SCButton;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.SCLabel;
import com.sybase.central.viewer.ScjSession;
import com.sybase.util.DialogUtils;
import com.sybase.util.NumericTextField;
import com.sybase.util.Platform;
import com.sybase.util.SybLabel;
import com.sybase.util.SybModalDialog;
import com.sybase.util.UserDataComboBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class FastLoaderConfigurationDialog
extends SybModalDialog
implements ActionListener,
ScjResourceConstants {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private ScjSession _session = null;
    private boolean _retcode;
    private int _inactivityTimeout;
    private int _port;
    private int _defaultInactivityTimeout;
    private int _defaultPort;
    private SCButton _ok = null;
    private SCButton _cancel = null;
    private SCButton _useDefaults = null;
    private JTextField _portNumber = null;
    private UserDataComboBox _inactivityTimer = null;

    FastLoaderConfigurationDialog(ScjSession scjSession, Dialog dialog, int n, int n2, int n3, int n4) {
        super(dialog);
        this._session = scjSession;
        this._port = n;
        this._inactivityTimeout = n2;
        this._defaultPort = n3;
        this._defaultInactivityTimeout = n4;
        this.setTitle(ScjSession.getString("FAST_LOADER_CONFIGURATION_TITLE"));
        this._retcode = false;
        this.createUI();
        this.pack();
        this.setResizable(false);
        if (!Platform.isHP()) {
            this.setMinimumSize(this.getPreferredSize());
        }
        this.setLocationRelativeTo(dialog);
    }

    boolean isOK() {
        return this._retcode;
    }

    int getPort() {
        return this._port;
    }

    int getInactivityTimeout() {
        return this._inactivityTimeout;
    }

    void destroy() {
        this._session = null;
        this._portNumber = null;
        this._inactivityTimer = null;
        if (this._useDefaults != null) {
            this._useDefaults.removeActionListener(this);
            this._useDefaults = null;
        }
        if (this._ok != null) {
            this._ok.removeActionListener(this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener(this);
            this._cancel = null;
        }
        DialogUtils.removeComponents((Container)((Object)this));
    }

    private void createUI() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ScjSession.getString("FAST_LOADER_PORT_NUMBER_TITLE")), BorderFactory.createEmptyBorder(5, 5, 10, 5)));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        SCLabel sCLabel = new SCLabel(SCImageLoader.getImageIcon("portnumber32", 1006));
        ((JComponent)((Object)sCLabel)).setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)((Object)sCLabel), gridBagConstraints);
        JTextArea jTextArea = new JTextArea(ScjSession.getString("FAST_LOADER_ABOUT_PORT_NUMBER"));
        jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jTextArea.setFont(((Component)((Object)sCLabel)).getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setColumns(48);
        jTextArea.setEditable(false);
        jTextArea.setForeground(((Component)((Object)sCLabel)).getForeground());
        jTextArea.setBackground(((Component)((Object)sCLabel)).getBackground());
        jTextArea.setSelectionColor(((Component)((Object)sCLabel)).getBackground());
        jTextArea.setSelectedTextColor(((Component)((Object)sCLabel)).getForeground());
        jTextArea.setFocusable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jTextArea, gridBagConstraints);
        sCLabel = new SybLabel(ScjSession.getString("FAST_LOADER_PORT_NUMBER"));
        ((JComponent)((Object)sCLabel)).setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)((Object)sCLabel), gridBagConstraints);
        this._portNumber = new NumericTextField();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._portNumber, gridBagConstraints);
        ((JLabel)((Object)sCLabel)).setLabelFor(this._portNumber);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ScjSession.getString("FAST_LOADER_INACTIVITY_TIMER_TITLE")), BorderFactory.createEmptyBorder(5, 5, 10, 5)));
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        sCLabel = new SCLabel(SCImageLoader.getImageIcon("inactivitytimer32", 1006));
        ((JComponent)((Object)sCLabel)).setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)((Object)sCLabel), gridBagConstraints);
        jTextArea = new JTextArea(ScjSession.getString("FAST_LOADER_ABOUT_INACTIVITY_TIMER"));
        jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jTextArea.setFont(((Component)((Object)sCLabel)).getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setColumns(48);
        jTextArea.setEditable(false);
        jTextArea.setForeground(((Component)((Object)sCLabel)).getForeground());
        jTextArea.setBackground(((Component)((Object)sCLabel)).getBackground());
        jTextArea.setSelectionColor(((Component)((Object)sCLabel)).getBackground());
        jTextArea.setSelectedTextColor(((Component)((Object)sCLabel)).getForeground());
        jTextArea.setFocusable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jTextArea, gridBagConstraints);
        sCLabel = new SybLabel(ScjSession.getString("FAST_LOADER_INACTIVITY_TIMER"));
        ((JComponent)((Object)sCLabel)).setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)((Object)sCLabel), gridBagConstraints);
        String[] stringArray = new String[8];
        stringArray[0] = ScjSession.getString("FAST_LOADER_NEVER");
        stringArray[1] = ScjSession.getString("FAST_LOADER_15MIN");
        stringArray[2] = ScjSession.getString("FAST_LOADER_30MIN");
        stringArray[3] = ScjSession.getString("FAST_LOADER_1HOUR");
        stringArray[4] = ScjSession.getString("FAST_LOADER_2HOURS");
        stringArray[5] = ScjSession.getString("FAST_LOADER_3HOURS");
        stringArray[6] = ScjSession.getString("FAST_LOADER_4HOURS");
        stringArray[7] = ScjSession.getString("FAST_LOADER_5HOURS");
        String[] stringArray2 = stringArray;
        Object[] objectArray = new Object[]{0, 15, 30, 60, 120, 180, 240, 300};
        this._inactivityTimer = new UserDataComboBox(stringArray2, objectArray);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._inactivityTimer, gridBagConstraints);
        ((JLabel)((Object)sCLabel)).setLabelFor((Component)this._inactivityTimer);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this._ok = new SCButton(ScjSession.getString("STR_DLG_OK_BUTTON"));
        this._ok.addActionListener(this);
        this._cancel = new SCButton(ScjSession.getString("STR_DLG_CANCEL_BUTTON"));
        this._cancel.addActionListener(this);
        this._useDefaults = new SCButton(ScjSession.getString("FAST_LOADER_USE_DEFAULTS"));
        this._useDefaults.addActionListener(this);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)((Object)this._useDefaults));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)((Object)this._ok));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)((Object)this._cancel));
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jPanel2);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.getRootPane().setDefaultButton((JButton)((Object)this._ok));
        this.setControlValues(this._port, this._inactivityTimeout);
        this.getContentPane().add(jPanel);
    }

    private void setControlValues(int n, int n2) {
        this._inactivityTimer.setSelectedByUserData((Object)n2);
        this._portNumber.setText(Integer.toString(n));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else if (object == this._useDefaults) {
            this.setControlValues(this._defaultPort, this._defaultInactivityTimeout);
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                this.handleCancel();
            }
        }
    }

    private void handleOK() {
        int n;
        String string = this._portNumber.getText();
        if (string != null && string.length() != 0) {
            try {
                this._port = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((n = this._inactivityTimer.getSelectedIndex()) >= 0) {
            this._inactivityTimeout = (Integer)this._inactivityTimer.getUserData(n);
        }
        this._retcode = true;
        this.setVisible(false);
    }

    private void handleCancel() {
        this._retcode = false;
        this.setVisible(false);
    }
}

