/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer5;
import com.sybase.central.SCProvider2;
import com.sybase.central.SCTaskItem;
import com.sybase.central.viewer.DetailsList;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.HypertextButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

class HypertextButtonListener
implements ActionListener {
    private JFrame _viewerFrame = null;
    private ViewerManager _viewerManager = null;
    private SCProvider2 _provider = null;
    private SCContainer5 _container = null;
    private SCTaskItem _item = null;
    private HypertextButton _button = null;

    HypertextButtonListener(JFrame jFrame, ViewerManager viewerManager, SCProvider2 sCProvider2, SCTaskItem sCTaskItem, int n, Color color) {
        this._viewerFrame = jFrame;
        this._viewerManager = viewerManager;
        this._provider = sCProvider2;
        this._item = sCTaskItem;
        this._button = new HypertextButton(sCTaskItem.getText(), sCTaskItem.getToolTip(), sCTaskItem.getImage(), 11, true, color, n);
        this._button.addActionListener((ActionListener)this);
    }

    HypertextButtonListener(JFrame jFrame, ViewerManager viewerManager, SCContainer5 sCContainer5, SCTaskItem sCTaskItem, int n, Color color) {
        this._viewerFrame = jFrame;
        this._viewerManager = viewerManager;
        this._container = sCContainer5;
        this._item = sCTaskItem;
        this._button = new HypertextButton(sCTaskItem.getText(), sCTaskItem.getToolTip(), sCTaskItem.getImage(), 11, true, color, n);
        this._button.addActionListener((ActionListener)this);
    }

    HypertextButton getButton() {
        return this._button;
    }

    void releaseResources() {
        this._button.removeActionListener((ActionListener)this);
        this._button.releaseResources();
        this._button = null;
        this._viewerFrame = null;
        this._viewerManager = null;
        this._provider = null;
        this._container = null;
        this._item = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final ViewerManager viewerManager = this._viewerManager;
        final HypertextButton hypertextButton = this._button;
        if (this._provider != null) {
            this._provider.onCommand(this._viewerFrame, this._item.getCommandId(), this._viewerManager.getCurrentlySelectedItemsToNotify(), 0);
        } else {
            this._container.onCommand(this._viewerFrame, this._item.getCommandId(), this._viewerManager.getCurrentlySelectedItemsToNotify(), 0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component component = viewerManager.getViewerFrame().getFocusOwner();
                if (component == hypertextButton) {
                    DetailsList detailsList = viewerManager.getContentPane().getDetailsListForActiveDetailsPanel();
                    if (detailsList != null) {
                        detailsList.getJTable().requestFocusInWindow();
                    } else {
                        viewerManager.getContentPane().getPane().requestFocusInWindow();
                    }
                }
            }
        });
    }
}

