/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.DefaultSCPageController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.viewer.BaseRepository;
import com.sybase.central.viewer.ConnectionProfile;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.ImportConnectionProfileDlgJPanel;
import com.sybase.central.viewer.RepositoryKey;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.central.viewer.Utilities;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ImportConnectionProfileDlg
extends DefaultSCPageController
implements IConstants,
ActionListener,
ItemListener,
DocumentListener {
    private ScjSession _session = null;
    private ScjViewerSupport _viewerSupport = null;
    private ImportConnectionProfileDlgJPanel _panel = null;

    ImportConnectionProfileDlg(SCDialogSupport sCDialogSupport, ScjSession scjSession, ScjViewerSupport scjViewerSupport) {
        super(sCDialogSupport, new ImportConnectionProfileDlgJPanel(scjSession));
        this._session = scjSession;
        this._viewerSupport = scjViewerSupport;
        this._panel = (ImportConnectionProfileDlgJPanel)this.getJPanel();
        this._panel.browse.addActionListener(this);
        this._panel.shared.addItemListener(this);
        this._panel.startup.setEnabled(false);
        this._panel.fileName.getDocument().addDocumentListener(this);
    }

    @Override
    public void onInitDialog() {
        this._dialogSupport.setEnabledStandardButtons(2);
        this._panel.fileName.requestFocusInWindow();
    }

    @Override
    public boolean onOk() {
        BaseRepository baseRepository = null;
        RepositoryKey repositoryKey = null;
        RepositoryKey repositoryKey2 = null;
        Enumeration enumeration = null;
        ConnectionProfile connectionProfile = null;
        baseRepository = new BaseRepository(false);
        baseRepository.setFileName(this._panel.fileName.getText());
        try {
            baseRepository.load(false);
            repositoryKey = baseRepository.getRepositoryKey();
            repositoryKey2 = repositoryKey.openKey("ConnectionProfiles", false);
            enumeration = repositoryKey2.getKeyNames();
            if (!enumeration.hasMoreElements()) {
                SybOptionPane.showMessageDialog((Component)this._dialogSupport.getJDialog(), (Object)ScjSession.getString("ERR_CONN_PROF_IMPORT_FORMAT"), (String)ScjSession.getString("STR_APP_NAME"), (int)0);
                this._panel.fileName.requestFocusInWindow();
                return false;
            }
            while (enumeration.hasMoreElements()) {
                connectionProfile = new ConnectionProfile(repositoryKey2, (String)enumeration.nextElement(), false);
                if (this._session.getConnectionProfilesKey().hasConnectionProfile(connectionProfile.getName())) {
                    this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), SybMessageFormat.format((String)ScjSession.getString("ERR_CONN_PROF_IMPORT_EXISTS"), (Object[])new Object[]{connectionProfile.getName()}), 0);
                    this._panel.fileName.requestFocusInWindow();
                    continue;
                }
                if (this._panel.shared.isSelected()) {
                    this._session.getConnectionProfilesKey().createSystemConnectionProfile(connectionProfile.getName(), connectionProfile.getDescription(), false, connectionProfile.getProviderName(), connectionProfile.getProviderId(), connectionProfile, this._panel.startup.isEnabled() && this._panel.startup.isSelected());
                    continue;
                }
                this._session.getConnectionProfilesKey().createUserConnectionProfile(connectionProfile.getName(), connectionProfile.getDescription(), false, connectionProfile.getProviderName(), connectionProfile.getProviderId(), connectionProfile);
            }
        }
        catch (IOException iOException) {
            SybOptionPane.showMessageDialog((Component)this._dialogSupport.getJDialog(), (Object)ScjSession.getString("ERR_CONN_PROF_IMPORT"), (String)ScjSession.getString("STR_APP_NAME"), (int)0);
            this._panel.fileName.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private void browseButtonPressed() {
        SybFileFilter[] sybFileFilterArray = null;
        File file = null;
        SybFileFilter[] sybFileFilterArray2 = new SybFileFilter[1];
        sybFileFilterArray2[0] = new SybFileFilter("cpr", ScjSession.getString("STR_CPR_FILTER"));
        sybFileFilterArray = sybFileFilterArray2;
        file = Utilities.showFileChooser(this._dialogSupport.getJDialog(), this._session.getUserPrefRepositoryInfo().getLastBrowseDir(), "", sybFileFilterArray, 0, false);
        if (file != null) {
            this._session.getUserPrefRepositoryInfo().setLastBrowseDir(file.getParent());
            this._panel.fileName.setText(file.getPath());
        }
    }

    @Override
    public void releaseResources() {
        this._session = null;
        this._viewerSupport = null;
        this._panel.browse.removeActionListener(this);
        this._panel.shared.removeItemListener(this);
        this._panel.fileName.getDocument().removeDocumentListener(this);
        this._panel = null;
        super.releaseResources();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._panel.browse) {
            this.browseButtonPressed();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this._panel.startup.setEnabled(this._panel.shared.isSelected());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this._panel.fileName.getText().trim().length() > 0) {
            this._dialogSupport.setEnabledStandardButtons(3);
        } else {
            this._dialogSupport.setEnabledStandardButtons(2);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }
}

