/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCLogEntry;
import com.sybase.central.SCLogViewer;
import com.sybase.central.viewer.EventDetail;
import com.sybase.central.viewer.FilterDialog;
import com.sybase.central.viewer.FindDialog;
import com.sybase.central.viewer.LogViewerSortableTable;
import com.sybase.central.viewer.LogViewerTableModel;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.SaveOptionsDialog;
import com.sybase.central.viewer.ScjSession;
import com.sybase.util.Platform;
import com.sybase.util.SybCheckBoxMenuItem;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybMenu;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybRadioButtonMenuItem;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class LogViewer
extends JFrame
implements SCLogViewer,
WindowListener,
ComponentListener,
KeyListener,
MouseListener,
ActionListener {
    private static final int MAX_ENTRIES = 1000;
    private Timer _columnResizeTimer = new Timer(750, this);
    private boolean _initialized = false;
    private JMenuBar _menuBar = new JMenuBar();
    private JScrollPane _scrollPane = new JScrollPane();
    private LogTable _logTable = new LogTable(0, 6, this);
    private EventDetail _eventDetail = null;
    private FindDialog _findDialog = null;
    private FilterDialog _filterDialog = null;
    private SaveOptionsDialog _saveOptionsDialog = null;
    private ScjSession _session = null;
    private Vector<Object> _data = new Vector();
    private boolean _filteringData = false;
    private Vector<Object> _filteredData = new Vector();
    private SybRadioButtonMenuItem _filterEventsMenuItem;
    private SybRadioButtonMenuItem _allEventsMenuItem;
    private SybCheckBoxMenuItem _newestFirstMenuItem;
    private SybCheckBoxMenuItem _oldestFirstMenuItem;
    private static ImageIcon _errorIcon;
    private static ImageIcon _warnIcon;
    private static ImageIcon _informIcon;
    private String _filteringSource = null;
    private boolean _filteringInformation = true;
    private boolean _filteringWarning = true;
    private boolean _filteringError = true;
    private String _filteringShortMessage = "";
    private String _filteringDescription = "";
    private Date _filteringFromDate = null;
    private Date _filteringToDate = null;
    public static final int TYPE_COLUMN = 0;
    public static final int DATE_COLUMN = 1;
    public static final int TIME_COLUMN = 2;
    public static final int SOURCE_COLUMN = 3;
    public static final int SHORT_MESSAGE_COLUMN = 4;
    public static final int HIDDEN_COLUMN = 5;
    public static final int COLUMN_COUNT = 6;
    Action saveAsAction = new AbstractAction("", null){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogViewer.this.saveAsActionPerformed(actionEvent);
        }
    };
    Action clearAllEventsAction = new AbstractAction("", null){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogViewer.this.clearAllEventsActionPerformed(actionEvent);
        }
    };
    Action closeAction = new AbstractAction("", null){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogViewer.this.closeActionPerformed(actionEvent);
        }
    };
    Action allEventsAction = new AbstractAction("", null){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogViewer.this.allEventsActionPerformed(actionEvent);
        }
    };
    Action filterEventsAction = new AbstractAction("", null){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogViewer.this.filterEventsActionPerformed(actionEvent);
        }
    };
    Action newestFirstAction = new AbstractAction("", null){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogViewer.this.newestFirstActionPerformed(actionEvent);
        }
    };
    Action oldestFirstAction = new AbstractAction("", null){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogViewer.this.oldestFirstActionPerformed(actionEvent);
        }
    };
    Action findAction = new AbstractAction("", null){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogViewer.this.findActionPerformed(actionEvent);
        }
    };
    Action detailAction = new AbstractAction("", null){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LogViewer.this.detailActionPerformed(actionEvent);
        }
    };
    private EventTypeCellRenderer _eventTypeCellRenderer;
    private DateCellRenderer _dateCellRenderer = new DateCellRenderer();
    private TimeCellRenderer _timeCellRenderer = new TimeCellRenderer();

    private Rectangle DURectangle(int n, int n2, int n3, int n4) {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        double d = fontMetrics != null ? (double)(fontMetrics.stringWidth(string) / string.length()) : 0.0;
        double d2 = fontMetrics != null ? (double)fontMetrics.getHeight() / 2.0 : 0.0;
        return new Rectangle((int)Math.round(d * (double)n / 4.0), (int)Math.round(d2 * (double)n2 / 4.0), (int)Math.round(d * (double)n3 / 4.0), (int)Math.round(d2 * (double)n4 / 4.0));
    }

    private void DUPositionComponent(Component component, int n, int n2, int n3, int n4, Insets insets) {
        Rectangle rectangle = this.DURectangle(n, n2, n3, n4);
        if (component != this && insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
        }
        if (component == this && insets != null && insets.bottom > 0) {
            rectangle.height += insets.bottom;
        }
        component.setBounds(rectangle);
    }

    private boolean createTheForm() {
        this.setResizable(true);
        Container container = this.getContentPane();
        boolean bl = true;
        this.addNotify();
        this.setJMenuBar(this._menuBar);
        Insets insets = (Insets)container.getInsets().clone();
        container.setBackground(SystemColor.control);
        container.setForeground(SystemColor.controlText);
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        container.add((Component)this._scrollPane, "Center");
        this._scrollPane.getViewport().add(this._logTable);
        this.DUPositionComponent(this, 46, 123, 500, 200, insets);
        this.addWindowListener(this);
        this._menuBar.setOpaque(true);
        this._scrollPane.addComponentListener(this);
        if (Platform.isMacOS()) {
            this._scrollPane.setVerticalScrollBarPolicy(22);
            this._scrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._scrollPane.setVerticalScrollBarPolicy(20);
            this._scrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._scrollPane.setBackground(SystemColor.control);
        this._scrollPane.setForeground(SystemColor.controlText);
        this._scrollPane.setEnabled(true);
        this._scrollPane.setVisible(true);
        Insets insets2 = this._scrollPane.getInsets();
        this._logTable.addKeyListener(this);
        this._logTable.addMouseListener(this);
        this.DUPositionComponent(this._logTable, 190, 97, 80, 40, insets2);
        this.setResizable(true);
        return bl;
    }

    @Override
    public boolean create() {
        return this.create(true);
    }

    @Override
    public boolean create(boolean bl) {
        if (this._initialized) {
            if (bl) {
                this.setVisible(true);
            }
            return true;
        }
        this._initialized = true;
        boolean bl2 = this.createTheForm();
        this.setTitle(ScjSession.getString("STR_LOGVIEWER_TITLE"));
        SybMenu sybMenu = new SybMenu(ScjSession.getString("STR_LOGVIEWER_LOG"));
        sybMenu.add((JMenuItem)new SybMenuItem(this.saveAsAction));
        sybMenu.add((JMenuItem)new SybMenuItem(this.clearAllEventsAction));
        sybMenu.add((JMenuItem)new SybMenuItem(this.closeAction));
        this._menuBar.add((JMenu)sybMenu);
        SybMenu sybMenu2 = new SybMenu(ScjSession.getString("STR_LOGVIEWER_VIEW_MENU"));
        this._allEventsMenuItem = new SybRadioButtonMenuItem((String)this.allEventsAction.getValue("Name"), (Icon)this.allEventsAction.getValue("SmallIcon"));
        this._allEventsMenuItem.setHorizontalTextPosition(4);
        this._allEventsMenuItem.setVerticalTextPosition(0);
        this._allEventsMenuItem.setEnabled(this.allEventsAction.isEnabled());
        this._allEventsMenuItem.addActionListener((ActionListener)this.allEventsAction);
        this._allEventsMenuItem.setText(ScjSession.getString("STR_LOGVIEWER_ALLEVENTS"));
        this._allEventsMenuItem.setSelected(true);
        sybMenu2.add((JMenuItem)this._allEventsMenuItem);
        this._filterEventsMenuItem = new SybRadioButtonMenuItem((String)this.filterEventsAction.getValue("Name"), (Icon)this.filterEventsAction.getValue("SmallIcon"));
        this._filterEventsMenuItem.setHorizontalTextPosition(4);
        this._filterEventsMenuItem.setVerticalTextPosition(0);
        this._filterEventsMenuItem.setEnabled(this.allEventsAction.isEnabled());
        this._filterEventsMenuItem.addActionListener((ActionListener)this.filterEventsAction);
        this._filterEventsMenuItem.setText(ScjSession.getString("STR_LOGVIEWER_FILTEREVENTS"));
        this._filterEventsMenuItem.setSelected(false);
        sybMenu2.add((JMenuItem)this._filterEventsMenuItem);
        sybMenu2.addSeparator();
        this._newestFirstMenuItem = new SybCheckBoxMenuItem((String)this.newestFirstAction.getValue("Name"), (Icon)this.newestFirstAction.getValue("SmallIcon"));
        this._newestFirstMenuItem.setHorizontalTextPosition(4);
        this._newestFirstMenuItem.setVerticalTextPosition(0);
        this._newestFirstMenuItem.setEnabled(this.allEventsAction.isEnabled());
        this._newestFirstMenuItem.addActionListener((ActionListener)this.newestFirstAction);
        this._newestFirstMenuItem.setText(ScjSession.getString("STR_LOGVIEWER_NEWESTFIRST"));
        sybMenu2.add((JMenuItem)this._newestFirstMenuItem);
        this._oldestFirstMenuItem = new SybCheckBoxMenuItem((String)this.oldestFirstAction.getValue("Name"), (Icon)this.oldestFirstAction.getValue("SmallIcon"));
        this._oldestFirstMenuItem.setHorizontalTextPosition(4);
        this._oldestFirstMenuItem.setVerticalTextPosition(0);
        this._oldestFirstMenuItem.setEnabled(this.allEventsAction.isEnabled());
        this._oldestFirstMenuItem.addActionListener((ActionListener)this.oldestFirstAction);
        this._oldestFirstMenuItem.setText(ScjSession.getString("STR_LOGVIEWER_OLDESTFIRST"));
        this._oldestFirstMenuItem.setState(false);
        sybMenu2.add((JMenuItem)this._oldestFirstMenuItem);
        sybMenu2.addSeparator();
        JMenuItem jMenuItem = sybMenu2.add((JMenuItem)new SybMenuItem(this.findAction));
        jMenuItem.setText(ScjSession.getString("STR_LOGVIEWER_FIND_MENU_ITEM"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0, false));
        jMenuItem = sybMenu2.add((JMenuItem)new SybMenuItem(this.detailAction));
        jMenuItem.setText(ScjSession.getString("STR_LOGVIEWER_DETAIL"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0, false));
        this._menuBar.add((JMenu)sybMenu2);
        LogViewerTableModel logViewerTableModel = new LogViewerTableModel();
        this._logTable.setModel(logViewerTableModel);
        Object[] objectArray = new String[6];
        objectArray[0] = ScjSession.getString("STR_LOGVIEWER_TYPE_HEADER");
        objectArray[1] = ScjSession.getString("STR_LOGVIEWER_DATE_HEADER");
        objectArray[2] = ScjSession.getString("STR_LOGVIEWER_TIME_HEADER");
        objectArray[3] = ScjSession.getString("STR_LOGVIEWER_SOURCE_HEADER");
        objectArray[4] = ScjSession.getString("STR_LOGVIEWER_SHORTMESSAGE_HEADER");
        objectArray[5] = "";
        Object[] objectArray2 = objectArray;
        ((DefaultTableModel)this._logTable.getModel()).setColumnIdentifiers(objectArray2);
        this._logTable.setCellSelectionEnabled(false);
        this._logTable.setRowSelectionAllowed(true);
        this._logTable.setColumnSelectionAllowed(false);
        this._logTable.setSelectionMode(0);
        this._logTable.getTableHeader().setReorderingAllowed(false);
        this._logTable.setSelectionMode(0);
        this._logTable.setAutoResizeMode(0);
        TableColumn tableColumn = this._logTable.getColumn(this._logTable.getColumnName(0));
        this._eventTypeCellRenderer = new EventTypeCellRenderer(this._session);
        tableColumn.setCellRenderer(this._eventTypeCellRenderer);
        TableColumn tableColumn2 = this._logTable.getColumn(this._logTable.getColumnName(1));
        tableColumn2.setCellRenderer(this._dateCellRenderer);
        TableColumn tableColumn3 = this._logTable.getColumn(this._logTable.getColumnName(2));
        tableColumn3.setCellRenderer(this._timeCellRenderer);
        TableColumn tableColumn4 = this._logTable.getColumn(this._logTable.getColumnName(5));
        tableColumn4.setMinWidth(0);
        tableColumn4.setMaxWidth(0);
        tableColumn4.setPreferredWidth(0);
        if (!Platform.isVista()) {
            for (int i = 0; i < 4; ++i) {
                TableColumn tableColumn5 = this._logTable.getColumnModel().getColumn(i);
                int n = tableColumn5.getHeaderRenderer() == null ? this._logTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, (Object)tableColumn5.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width + 20 : tableColumn5.getHeaderRenderer().getTableCellRendererComponent(null, (Object)tableColumn5.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width + 2;
                tableColumn5.setPreferredWidth(n + 2);
            }
        }
        this.getIcons();
        this.setVisible(bl);
        return bl2;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            UIUtils.ensureWindowIsVisible((Window)this);
        }
        super.setVisible(bl);
    }

    @Override
    public synchronized boolean destroy() {
        this.dispose();
        return true;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object == this) {
            this.setVisible(false);
            this.destroy();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Object object = componentEvent.getSource();
        if (object == this._scrollPane) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                n += this._logTable.getColumn(this._logTable.getColumnName(i)).getWidth() + 2;
            }
            Container container = this._logTable.getParent().getParent();
            Insets insets = container.getInsets();
            Insets insets2 = this._logTable.getInsets();
            n = container.getWidth() - n - insets.left - insets.right - insets2.left - insets2.right;
            this._logTable.getColumn(this._logTable.getColumnName(4)).setPreferredWidth(n);
            this._logTable.updateUI();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this._logTable) {
            if (keyEvent.getKeyCode() == 10) {
                keyEvent.consume();
                this.showDetail(this._logTable.getSelectedRow());
            } else if (keyEvent.getKeyCode() == 27) {
                keyEvent.consume();
                this.setVisible(false);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this._logTable && mouseEvent.getClickCount() == 2) {
            Point point = mouseEvent.getPoint();
            int n = this._logTable.rowAtPoint(point);
            this.showDetail(n);
        }
    }

    LogViewer(ScjSession scjSession) {
        this._session = scjSession;
        Image image = scjSession.getConfiguration().getIconImage(scjSession);
        if (image == null) {
            image = SCImageLoader.getImage("scj16", 1006);
        }
        this.setIconImage(image);
        this.saveAsAction.putValue("Name", ScjSession.getString("STR_LOGVIEWER_SAVE"));
        this.clearAllEventsAction.putValue("Name", ScjSession.getString("STR_LOGVIEWER_CLEARALL"));
        this.closeAction.putValue("Name", ScjSession.getString("STR_LOGVIEWER_CLOSE"));
        this.allEventsAction.putValue("Name", ScjSession.getString("STR_LOGVIEWER_ALLEVENTS"));
        this.filterEventsAction.putValue("Name", ScjSession.getString("STR_LOGVIEWER_FILTEREVENTS"));
        this.newestFirstAction.putValue("Name", ScjSession.getString("STR_LOGVIEWER_NEWESTFIRST"));
        this.oldestFirstAction.putValue("Name", ScjSession.getString("STR_LOGVIEWER_OLDESTFIRST"));
        this.findAction.putValue("Name", ScjSession.getString("STR_LOGVIEWER_FIND_MENU_ITEM"));
        this.detailAction.putValue("Name", ScjSession.getString("STR_LOGVIEWER_DETAIL"));
    }

    @Override
    public void addLogEntry(SCLogEntry sCLogEntry) {
        this._data.add(sCLogEntry);
        if (this._filteringData) {
            if (this.filter(this._filteredData, sCLogEntry, this._filteringInformation, this._filteringWarning, this._filteringError, this._filteringSource, this._filteringShortMessage, this._filteringDescription, this._filteringFromDate, this._filteringToDate)) {
                this.postLogEntry(sCLogEntry);
            }
        } else {
            this.postLogEntry(sCLogEntry);
        }
    }

    private void postLogEntry(SCLogEntry sCLogEntry) {
        Vector<Object> vector = new Vector<Object>(6);
        vector.add(sCLogEntry.getType());
        vector.add(sCLogEntry.getDate());
        vector.add(sCLogEntry.getDate());
        vector.add(sCLogEntry.getSource());
        vector.add(sCLogEntry.getTitle());
        vector.add(sCLogEntry);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this._logTable.getModel();
        int n = this.getRowCount();
        if (n == 1000) {
            defaultTableModel.removeRow(0);
        }
        defaultTableModel.addRow(vector);
        if (n == 0) {
            this.selectRow(0);
        }
        this._columnResizeTimer.setRepeats(false);
        this._columnResizeTimer.restart();
    }

    private void setColumnSizes() {
        int n = this.getRowCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int n2;
                    TableColumn tableColumn = this._logTable.getColumnModel().getColumn(j);
                    int n3 = tableColumn.getHeaderRenderer() == null ? this._logTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width + 20 : tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width + 2;
                    TableCellRenderer tableCellRenderer = this._logTable.getCellRenderer(i, j);
                    int n4 = tableCellRenderer.getTableCellRendererComponent((JTable)this._logTable, (Object)this._logTable.getValueAt((int)i, (int)j), (boolean)false, (boolean)false, (int)i, (int)j).getPreferredSize().width;
                    if ((n3 = Math.max(n3, n4) + 2) <= (n2 = tableColumn.getPreferredWidth())) continue;
                    tableColumn.setPreferredWidth(n3);
                }
            }
        }
    }

    SCLogEntry getLogEntry(int n) {
        if (n > -1 && n < this.getRowCount()) {
            return (SCLogEntry)this._logTable.getValueAt(n, 5);
        }
        return null;
    }

    int getRowCount() {
        return this._logTable.getModel().getRowCount();
    }

    void selectRow(int n) {
        this._logTable.setRowSelectionInterval(n, n);
        this._logTable.setColumnSelectionInterval(0, 3);
        Rectangle rectangle = this._logTable.getCellRect(n, 0, false);
        ++rectangle.y;
        this._logTable.scrollRectToVisible(rectangle);
    }

    void showDetail(int n) {
        if (n > -1 && n < this.getRowCount()) {
            SCLogEntry sCLogEntry;
            if (this._eventDetail == null) {
                this._eventDetail = new EventDetail(this, this._session);
                try {
                    this._eventDetail.create(false);
                }
                catch (Exception exception) {
                    return;
                }
            }
            if ((sCLogEntry = (SCLogEntry)this._logTable.getValueAt(n, 5)) != null) {
                this._eventDetail.setLogEntry(sCLogEntry, n);
                if (!this._eventDetail.isVisible()) {
                    UIUtils.ensureWindowIsVisible((Window)((Object)this._eventDetail));
                    this._eventDetail.setVisible(true);
                }
            }
        }
    }

    private void saveAsActionPerformed(ActionEvent actionEvent) {
        SybFileChooser sybFileChooser = new SybFileChooser(18);
        if (sybFileChooser.showDialog((Window)this, null, null)) {
            int n;
            File file = sybFileChooser.getSelectedFile();
            if (this._saveOptionsDialog == null) {
                this._saveOptionsDialog = new SaveOptionsDialog(this, this._session);
                this._saveOptionsDialog.create(false);
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            Date date = new Date(Long.MIN_VALUE);
            Date date2 = new Date(Long.MAX_VALUE);
            int n2 = this._data.size();
            for (n = 0; n < n2; ++n) {
                SCLogEntry sCLogEntry = (SCLogEntry)this._data.get(n);
                treeMap.put(sCLogEntry.getSource(), sCLogEntry.getSource());
                if (sCLogEntry.getDate().after(date)) {
                    date = sCLogEntry.getDate();
                }
                if (!sCLogEntry.getDate().before(date2)) continue;
                date2 = sCLogEntry.getDate();
            }
            if (this._saveOptionsDialog.showDialog(treeMap.values(), date2, date) == 0) {
                String string = this._saveOptionsDialog.getSource();
                n = this._saveOptionsDialog.isShowingInformation() ? 1 : 0;
                boolean bl = this._saveOptionsDialog.isShowingWarning();
                boolean bl2 = this._saveOptionsDialog.isShowingError();
                String string2 = this._saveOptionsDialog.getShortMessage();
                String string3 = this._saveOptionsDialog.getDescription();
                date2 = this._saveOptionsDialog.getFromDate();
                date = this._saveOptionsDialog.getToDate();
                this._filteringData = true;
                Vector<Object> vector = new Vector<Object>(n2);
                for (int i = 0; i < n2; ++i) {
                    this.filter(vector, (SCLogEntry)this._data.get(i), n != 0, bl, bl2, string, string2, string3, date2, date);
                }
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    int n3 = vector.size();
                    for (int i = 0; i < n3; ++i) {
                        SCLogEntry sCLogEntry = (SCLogEntry)vector.get(i);
                        if (this._saveOptionsDialog.isIncludingType()) {
                            switch (sCLogEntry.getType()) {
                                case 0: {
                                    bufferedWriter.write(ScjSession.getString("STR_LOGVIEWER_ERROR"));
                                    break;
                                }
                                case 1: {
                                    bufferedWriter.write(ScjSession.getString("STR_LOGVIEWER_WARNING"));
                                    break;
                                }
                                case 2: {
                                    bufferedWriter.write(ScjSession.getString("STR_LOGVIEWER_INFORMATION"));
                                }
                            }
                            bufferedWriter.newLine();
                        }
                        if (this._saveOptionsDialog.isIncludingDate()) {
                            bufferedWriter.write(DateFormat.getDateInstance(1, this.getLocale()).format(sCLogEntry.getDate()));
                            bufferedWriter.newLine();
                        }
                        if (this._saveOptionsDialog.isIncludingTime()) {
                            bufferedWriter.write(DateFormat.getTimeInstance(2, this.getLocale()).format(sCLogEntry.getDate()));
                            bufferedWriter.newLine();
                        }
                        if (this._saveOptionsDialog.isIncludingSource()) {
                            bufferedWriter.write(sCLogEntry.getSource());
                            bufferedWriter.newLine();
                        }
                        if (this._saveOptionsDialog.isIncludingShortMessage()) {
                            bufferedWriter.write(sCLogEntry.getTitle());
                            bufferedWriter.newLine();
                        }
                        if (this._saveOptionsDialog.isIncludingMessage()) {
                            bufferedWriter.write(sCLogEntry.getMessage());
                            bufferedWriter.newLine();
                        }
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void clearAllEventsActionPerformed(ActionEvent actionEvent) {
        this._data = new Vector();
        this._filteringData = false;
        this._filteredData = new Vector();
        int n = this.getRowCount();
        for (int i = n - 1; i > -1; --i) {
            ((DefaultTableModel)this._logTable.getModel()).removeRow(i);
        }
        this._logTable.updateUI();
    }

    private void closeActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void allEventsActionPerformed(ActionEvent actionEvent) {
        if (!this._allEventsMenuItem.isSelected()) {
            this._allEventsMenuItem.setSelected(true);
            return;
        }
        this._filterEventsMenuItem.setSelected(false);
        this._filteringData = false;
        this.clearTable();
        int n = this._data.size();
        for (int i = 0; i < n; ++i) {
            this.postLogEntry((SCLogEntry)this._data.get(i));
        }
    }

    private void filterEventsActionPerformed(ActionEvent actionEvent) {
        int n;
        Date date;
        Date date2;
        boolean bl = false;
        if (!this._filterEventsMenuItem.isSelected()) {
            this._filterEventsMenuItem.setSelected(true);
        }
        if (this._filteringData) {
            bl = true;
        }
        this._allEventsMenuItem.setSelected(false);
        this._filteringData = false;
        if (this._filterDialog == null) {
            this._filterDialog = new FilterDialog(this, this._session);
            try {
                this._filterDialog.create(false);
            }
            catch (Exception exception) {
                return;
            }
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        int n2 = this._data.size();
        if (n2 > 0) {
            date2 = new Date(Long.MIN_VALUE);
            date = new Date(Long.MAX_VALUE);
            for (n = 0; n < n2; ++n) {
                SCLogEntry sCLogEntry = (SCLogEntry)this._data.get(n);
                treeMap.put(sCLogEntry.getSource(), sCLogEntry.getSource());
                if (sCLogEntry.getDate().after(date2)) {
                    date2 = sCLogEntry.getDate();
                }
                if (!sCLogEntry.getDate().before(date)) continue;
                date = sCLogEntry.getDate();
            }
        } else {
            date2 = new Date();
            date = new Date();
        }
        if ((n = bl ? this._filterDialog.showDialog(treeMap.values(), date, date2, this._filteringInformation, this._filteringWarning, this._filteringError, this._filteringSource, this._filteringShortMessage, this._filteringDescription, this._filteringFromDate, this._filteringToDate) : this._filterDialog.showDialog(treeMap.values(), date, date2)) == 0) {
            this.filterEvents(this._filterDialog.isShowingInformation(), this._filterDialog.isShowingWarning(), this._filterDialog.isShowingError(), this._filterDialog.getSource(), this._filterDialog.getShortMessage(), this._filterDialog.getDescription(), this._filterDialog.getFromDate(), this._filterDialog.getToDate());
        }
    }

    void filterEvents(boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3, Date date, Date date2) {
        if (!this._filterEventsMenuItem.isSelected()) {
            this._filterEventsMenuItem.removeActionListener((ActionListener)this.filterEventsAction);
            this._allEventsMenuItem.removeActionListener((ActionListener)this.allEventsAction);
            this._filterEventsMenuItem.setSelected(true);
            this._allEventsMenuItem.setSelected(false);
            this._filterEventsMenuItem.addActionListener((ActionListener)this.filterEventsAction);
            this._allEventsMenuItem.addActionListener((ActionListener)this.allEventsAction);
        }
        this._filteringData = true;
        this._filteringSource = string == null || string.trim().length() == 0 ? ScjSession.getString("STR_LOGVIEWER_ALL") : string;
        this._filteringInformation = bl;
        this._filteringWarning = bl2;
        this._filteringError = bl3;
        this._filteringShortMessage = string2 == null ? "" : string2;
        this._filteringDescription = string3 == null ? "" : string3;
        this._filteringFromDate = date;
        this._filteringToDate = date2;
        this.updateLog();
    }

    private void updateLog() {
        int n = this._data.size();
        this.clearTable();
        if (this._filteringData) {
            int n2;
            this._filteredData = new Vector(n);
            for (n2 = 0; n2 < n; ++n2) {
                this.filter(this._filteredData, (SCLogEntry)this._data.get(n2), this._filteringInformation, this._filteringWarning, this._filteringError, this._filteringSource, this._filteringShortMessage, this._filteringDescription, this._filteringFromDate, this._filteringToDate);
            }
            int n3 = this._filteredData.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.postLogEntry((SCLogEntry)this._filteredData.get(n2));
            }
        } else {
            int n4 = this._data.size();
            for (int i = 0; i < n4; ++i) {
                this.postLogEntry((SCLogEntry)this._data.get(i));
            }
        }
    }

    private boolean filter(Vector<Object> vector, SCLogEntry sCLogEntry, boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3, Date date, Date date2) {
        boolean bl4 = false;
        if (string.equals(ScjSession.getString("STR_LOGVIEWER_ALL"))) {
            bl4 = true;
        }
        if (!bl4 && !string.equals(sCLogEntry.getSource())) {
            return false;
        }
        switch (sCLogEntry.getType()) {
            case 2: {
                if (bl) break;
                return false;
            }
            case 1: {
                if (bl2) break;
                return false;
            }
            case 0: {
                if (bl3) break;
                return false;
            }
        }
        if (date2 != null && sCLogEntry.getDate().compareTo(date2) > 0) {
            return false;
        }
        if (date != null && sCLogEntry.getDate().compareTo(date) < 0) {
            return false;
        }
        if ((string2 = string2.trim()).length() > 0 && sCLogEntry.getTitle().toLowerCase().indexOf(string2.toLowerCase()) == -1) {
            return false;
        }
        if ((string3 = string3.trim()).length() > 0 && sCLogEntry.getMessage().toLowerCase().indexOf(string3.toLowerCase()) == -1) {
            return false;
        }
        vector.add(sCLogEntry);
        return true;
    }

    private void findActionPerformed(ActionEvent actionEvent) {
        if (this._findDialog == null) {
            this._findDialog = new FindDialog(this, this._session);
            try {
                this._findDialog.create(false);
            }
            catch (Exception exception) {
                return;
            }
        }
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = this._logTable.getValueAt(i, 2);
            treeMap.put(object, object);
        }
        if (this._findDialog.showDialog(treeMap.values()) == 0) {
            this.find(this._findDialog.isFindDown(), this._findDialog.isFindingInformation(), this._findDialog.isFindingWarning(), this._findDialog.isFindingError(), this._findDialog.getSource(), this._findDialog.getShortMessage(), this._findDialog.getDescription());
        }
    }

    void find(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, String string2, String string3) {
        int n = this._logTable.getSelectedRow();
        int n2 = this.getRowCount();
        boolean bl5 = false;
        if (string.equals(ScjSession.getString("STR_LOGVIEWER_ALL"))) {
            bl5 = true;
        }
        Object[] objectArray = this._filteringData ? this._filteredData.toArray() : this._data.toArray();
        if (bl) {
            for (int i = n + 1; i < n2; ++i) {
                if (!this.found((SCLogEntry)objectArray[i], bl5, string, bl2, bl3, bl4, string2, string3)) continue;
                this.selectRow(i);
                i = n2;
            }
        } else {
            for (int i = n - 1; i > -1; --i) {
                if (!this.found((SCLogEntry)objectArray[i], bl5, string, bl2, bl3, bl4, string2, string3)) continue;
                this.selectRow(i);
                i = -1;
            }
        }
    }

    private boolean found(SCLogEntry sCLogEntry, boolean bl, String string, boolean bl2, boolean bl3, boolean bl4, String string2, String string3) {
        switch (sCLogEntry.getType()) {
            case 2: {
                if (bl2) break;
                return false;
            }
            case 1: {
                if (bl3) break;
                return false;
            }
            case 0: {
                if (bl4) break;
                return false;
            }
        }
        if (!bl && !string.equals(sCLogEntry.getSource())) {
            return false;
        }
        if ((string2 = string2.trim()).length() > 0 && sCLogEntry.getTitle().toLowerCase().indexOf(string2.toLowerCase()) == -1) {
            return false;
        }
        return (string3 = string3.trim()).length() <= 0 || sCLogEntry.getMessage().toLowerCase().indexOf(string3.toLowerCase()) != -1;
    }

    private void newestFirstActionPerformed(ActionEvent actionEvent) {
        this._newestFirstMenuItem.setState(true);
        this._oldestFirstMenuItem.setState(false);
        this._logTable.setSortAscending(false);
        this._logTable.setSortColumn(1);
    }

    void setSortColumn(int n) {
        this._logTable.setSortColumn(n);
    }

    int getSortColumn() {
        return this._logTable.getSortColumn();
    }

    void setSortAscending(boolean bl) {
        this._logTable.setSortAscending(false);
    }

    public boolean isSortAscending() {
        return this._logTable.isSortAscending();
    }

    void oldestFirstActionPerformed(ActionEvent actionEvent) {
        this._newestFirstMenuItem.setState(false);
        this._oldestFirstMenuItem.setState(true);
        this._logTable.setSortAscending(true);
        this._logTable.setSortColumn(1);
    }

    void detailActionPerformed(ActionEvent actionEvent) {
        this.showDetail(this._logTable.getSelectedRow());
    }

    void clearTable() {
        ((DefaultTableModel)this._logTable.getModel()).setRowCount(0);
    }

    private void getIcons() {
        Image image = SCImageLoader.getImage("error", 1002);
        Image image2 = SCImageLoader.getImage("warn", 1002);
        Image image3 = SCImageLoader.getImage("inform", 1002);
        int n = this._logTable.getRowHeight() - 2;
        if (image != null) {
            _errorIcon = new ImageIcon(image.getScaledInstance(n, n, 1));
            _warnIcon = new ImageIcon(image2.getScaledInstance(n, n, 1));
            _informIcon = new ImageIcon(image3.getScaledInstance(n, n, 1));
        }
    }

    Icon getErrorIcon() {
        return _errorIcon;
    }

    Icon getWarningIcon() {
        return _warnIcon;
    }

    Icon getInformationIcon() {
        return _informIcon;
    }

    private void tableSorted(int n, boolean bl) {
        if (n == 1 || n == 2) {
            this._newestFirstMenuItem.setState(!bl);
            this._oldestFirstMenuItem.setState(bl);
        } else {
            this._newestFirstMenuItem.setState(false);
            this._oldestFirstMenuItem.setState(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setColumnSizes();
    }

    static class TimeCellRenderer
    extends DefaultTableCellRenderer {
        TimeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            SCLogEntry sCLogEntry = (SCLogEntry)jTable.getValueAt(n, 5);
            this.setText(DateFormat.getTimeInstance(2, this.getLocale()).format(sCLogEntry.getDate()));
            return this;
        }
    }

    static class DateCellRenderer
    extends DefaultTableCellRenderer {
        DateCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            SCLogEntry sCLogEntry = (SCLogEntry)jTable.getValueAt(n, 5);
            this.setText(DateFormat.getDateInstance(1, this.getLocale()).format(sCLogEntry.getDate()));
            return this;
        }
    }

    static class EventTypeCellRenderer
    extends DefaultTableCellRenderer {
        private ScjSession _session;

        EventTypeCellRenderer(ScjSession scjSession) {
            this._session = scjSession;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            SCLogEntry sCLogEntry = (SCLogEntry)jTable.getValueAt(n, 5);
            switch (sCLogEntry.getType()) {
                case 0: {
                    this.setIcon(_errorIcon);
                    this.setText(ScjSession.getString("STR_LOGVIEWER_ERROR"));
                    break;
                }
                case 1: {
                    this.setIcon(_warnIcon);
                    this.setText(ScjSession.getString("STR_LOGVIEWER_WARNING"));
                    break;
                }
                case 2: {
                    this.setIcon(_informIcon);
                    this.setText(ScjSession.getString("STR_LOGVIEWER_INFORMATION"));
                }
            }
            return this;
        }
    }

    static class LogTable
    extends LogViewerSortableTable {
        private LogViewer _logViewer;

        LogTable(int n, int n2, LogViewer logViewer) {
            super(n, n2);
            this._logViewer = logViewer;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            this._logViewer.tableSorted(this.getSortColumn(), this.isSortAscending());
        }
    }
}

