/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.LogViewerSortableTable;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class LogViewerSortableTableHeaderRenderer
implements TableCellRenderer {
    private static final ArrowIcon ICON_ASCENDING = new ArrowIcon(true);
    private static final ArrowIcon ICON_DESCENDING = new ArrowIcon(false);
    private TableCellRenderer _renderer;
    private int _alignment;
    private static final TableCellRenderer DUMMY_RENDERER = new DefaultTableCellRenderer.UIResource();
    private TableHeaderUI headerUI;

    public LogViewerSortableTableHeaderRenderer(JTable jTable) {
        this(jTable, 2);
    }

    public LogViewerSortableTableHeaderRenderer(JTable jTable, int n) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (jTableHeader != null) {
            this._renderer = jTableHeader.getDefaultRenderer();
        }
        this._alignment = n;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component;
        if (jTable != null) {
            this.checkAndFix(jTable);
        }
        if ((component = this._renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)component;
            defaultTableCellRenderer.setHorizontalAlignment(this._alignment);
            defaultTableCellRenderer.setHorizontalTextPosition(2);
            if (jTable != null) {
                defaultTableCellRenderer.setForeground(jTable.isEnabled() ? UIManager.getColor("TableHeader.foreground") : UIManager.getColor("TextField.inactiveForeground"));
                if (jTable instanceof LogViewerSortableTable) {
                    LogViewerSortableTable logViewerSortableTable = (LogViewerSortableTable)jTable;
                    if (logViewerSortableTable.getSortColumn() == logViewerSortableTable.convertColumnIndexToModel(n2)) {
                        defaultTableCellRenderer.setIcon(logViewerSortableTable.isSortAscending() ? ICON_ASCENDING : ICON_DESCENDING);
                    } else {
                        defaultTableCellRenderer.setIcon(null);
                    }
                }
            }
        }
        return component;
    }

    private void checkAndFix(JTable jTable) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (this.headerUI == null || this.headerUI != jTableHeader.getUI()) {
            TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
            jTableHeader.setDefaultRenderer(DUMMY_RENDERER);
            jTableHeader.updateUI();
            this.headerUI = jTableHeader.getUI();
            this._renderer = jTableHeader.getDefaultRenderer();
            if (this._renderer == null || this._renderer == tableCellRenderer || this._renderer == DUMMY_RENDERER) {
                this._renderer = new JTableHeader().getDefaultRenderer();
            }
            jTableHeader.setDefaultRenderer(tableCellRenderer);
        }
    }

    static class ArrowIcon
    implements Icon {
        private static final boolean SOLID_ARROW = UIUtils.shouldDrawSolidSortArrow();
        private static final int POINTS = 3;
        private boolean _ascending;
        private int _widthAndHeight = 10;

        ArrowIcon(boolean bl) {
            this._ascending = bl;
        }

        @Override
        public int getIconWidth() {
            return this._widthAndHeight;
        }

        @Override
        public int getIconHeight() {
            return this._widthAndHeight;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            this._widthAndHeight = n3 = graphics.getFontMetrics().getAscent() - 2;
            graphics.setColor(SystemColor.control);
            graphics.fillRect(n, n2, this._widthAndHeight, this._widthAndHeight);
            if (this._ascending) {
                nArray[0] = n + n3 / 2;
                nArray2[0] = n2;
                nArray[1] = n;
                nArray2[1] = n2 + n3;
                nArray[2] = n + n3;
                nArray2[2] = n2 + n3;
                if (SOLID_ARROW) {
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.fillPolygon(nArray, nArray2, 3);
                } else {
                    graphics.setColor(SystemColor.controlDkShadow);
                    graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                    graphics.setColor(SystemColor.controlLtHighlight);
                    graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                    graphics.drawLine(nArray[2], nArray2[2], nArray[0], nArray2[0]);
                }
            } else {
                nArray[0] = n + 1 + (n3 - 1) / 2;
                nArray2[0] = n2 + n3;
                nArray[1] = n + n3;
                nArray2[1] = n2 + 1;
                nArray[2] = n + 1;
                nArray2[2] = n2 + 1;
                if (SOLID_ARROW) {
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.fillPolygon(nArray, nArray2, 3);
                } else {
                    graphics.setColor(SystemColor.controlLtHighlight);
                    graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                    graphics.setColor(SystemColor.controlDkShadow);
                    graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                    graphics.drawLine(nArray[2], nArray2[2], nArray[0], nArray2[0]);
                }
            }
        }
    }
}

