/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import java.text.Collator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

class LogViewerSortedTableModel
extends AbstractTableModel
implements TableModelListener {
    TableModel _model;
    int[] _indexes;
    int[] _reverseIndexes;
    int _sortColumn = -1;
    boolean _ascending = true;
    Collator _collator = Collator.getInstance();

    LogViewerSortedTableModel() {
        this._indexes = new int[0];
        this._reverseIndexes = new int[0];
    }

    LogViewerSortedTableModel(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public TableModel getModel() {
        return this._model;
    }

    public void setModel(TableModel tableModel) {
        this._model = tableModel;
        this._model.addTableModelListener(this);
        this._sortColumn = -1;
        this._ascending = true;
        this.reallocateIndexes();
    }

    int convertRowIndexToModel(int n) {
        this.checkModel();
        return this._indexes[n];
    }

    int convertRowIndexToView(int n) {
        return this._reverseIndexes[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        this.checkModel();
        return this._model.getValueAt(this._indexes[n], n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        this._model.setValueAt(object, this._indexes[n], n2);
    }

    @Override
    public int getRowCount() {
        return this._model == null ? 0 : this._model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._model == null ? 0 : this._model.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this._model.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this._model.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this._model.isCellEditable(n, n2);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        this.sort(this._sortColumn, this._ascending);
        this.fireTableChanged(tableModelEvent);
    }

    int getSortColumn() {
        return this._sortColumn;
    }

    void setSortColumn(int n) {
        this._sortColumn = n;
        this.sort(this._sortColumn, this._ascending);
    }

    boolean isSortAscending() {
        return this._ascending;
    }

    void setSortAscending(boolean bl) {
        this._ascending = bl;
    }

    void reallocateIndexes() {
        int n = this._model.getRowCount();
        this._indexes = new int[n];
        this._reverseIndexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this._indexes[i] = i;
            this._reverseIndexes[i] = i;
        }
    }

    int compareRowsByColumn(int n, int n2, int n3) {
        Class<?> clazz = this._model.getColumnClass(n3);
        Object object = this._model.getValueAt(n, n3);
        Object object2 = this._model.getValueAt(n2, n3);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (String.class.isAssignableFrom(clazz)) {
            int n4 = this._collator.compare((String)object, (String)object2);
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            double d;
            double d2 = ((Number)object).doubleValue();
            if (d2 < (d = ((Number)object2).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            boolean bl;
            boolean bl2 = (Boolean)object;
            if (bl2 == (bl = ((Boolean)object2).booleanValue())) {
                return 0;
            }
            if (bl2) {
                return 1;
            }
            return -1;
        }
        int n5 = this._collator.compare(object.toString(), object2.toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    int compare(int n, int n2) {
        int n3 = this.compareRowsByColumn(n, n2, this._sortColumn);
        if (n3 != 0) {
            return this._ascending ? n3 : -n3;
        }
        return 0;
    }

    void checkModel() {
        if (this._indexes.length != this._model.getRowCount()) {
            // empty if block
        }
    }

    void sort(int n, boolean bl) {
        this._sortColumn = n;
        this._ascending = bl;
        if (this._sortColumn < 0) {
            return;
        }
        this.checkModel();
        this.shuttlesort((int[])this._indexes.clone(), this._indexes, 0, this._indexes.length);
        for (int i = 0; i < this._indexes.length; ++i) {
            this._reverseIndexes[this._indexes[i]] = i;
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            for (int i = n; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }
}

