/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCProvider4;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.ContentPane;
import com.sybase.central.viewer.ContextComboBoxPanel;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.ProviderToolBar;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.SCLabel;
import com.sybase.central.viewer.SCViewerToolBarButton;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjToolBar;
import com.sybase.central.viewer.ScopePane;
import com.sybase.central.viewer.SearchPane;
import com.sybase.central.viewer.TaskPane;
import com.sybase.central.viewer.Utilities;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.SybMessageFormat;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

class MainPanel
extends JPanel
implements IConstants,
ScjResourceConstants,
ActionListener {
    private ViewerManager _viewerManager = null;
    private ScjToolBar _toolBar = null;
    private ContextComboBoxPanel _contextComboBoxPanel = null;
    private ScopePane _scopePane = null;
    private SearchPane _searchPane = null;
    private TaskPane _taskPane = null;
    private JPanel _leftPanel = null;
    private Component _leftPanelWithHeader = null;
    private JLabel _leftPanelHeaderLabel = null;
    private ContentPane _contentPane = null;
    private JLabel _statusLabel = null;
    private JPanel _statusPanel = null;
    private JComponent _providerStatusBarJComponent = null;
    private JSplitPane _splitter = null;
    private ScjSession _session = null;
    private JSplitPane _bottomSplitter = null;
    private SCViewerToolBarButton _paneCloseButton = null;
    private SCViewerToolBarButton _bottomJComponentCloseButton = null;
    private JPanel _toolBarPanel = null;
    private ProviderToolBar _providerToolBar = null;
    private ProviderEntry _providerEntry = null;
    private int _dividerSize;
    private int _splitterDividerLocation;
    private int _bottomSplitterDividerLocation;
    private JComponent _bottomJComponent = null;
    private JComponent _bottomJComponentWithoutHeader = null;
    private boolean _showPane = false;
    private String _pane = null;
    private boolean _showBottomJComponent = false;
    private static final String ONE_SPACE = " ";

    MainPanel(ScjSession scjSession, ViewerManager viewerManager, JFrame jFrame) {
        String string;
        this._session = scjSession;
        this._viewerManager = viewerManager;
        ArrayList<JComponent> arrayList = null;
        this.setLayout(new BorderLayout());
        this._pane = this._session.getUserPrefRepositoryInfo().getVisiblePane();
        this._toolBar = new ScjToolBar(this._session, viewerManager);
        this._contextComboBoxPanel = new ContextComboBoxPanel(this._session, viewerManager);
        this._scopePane = new ScopePane(jFrame, this._session);
        this._searchPane = new SearchPane(jFrame, this._session);
        this._taskPane = new TaskPane(jFrame, this._session);
        this._contentPane = new ContentPane(jFrame, this._session, viewerManager);
        this._paneCloseButton = new SCViewerToolBarButton(SCImageLoader.getImageIcon("close", 1006), ScjSession.getString("STR_CLOSE_HINT"), null, null);
        this._paneCloseButton.addActionListener(this);
        this._bottomJComponentCloseButton = new SCViewerToolBarButton(SCImageLoader.getImageIcon("close", 1006), ScjSession.getString("STR_CLOSE_HINT"), null, null);
        this._bottomJComponentCloseButton.addActionListener(this);
        this._leftPanel = new JPanel();
        this._leftPanel.setLayout(new CardLayout());
        this._leftPanel.add("search", this._searchPane.getPane());
        this._leftPanel.add("tasks", this._taskPane.getPane());
        this._leftPanel.add("folders", this._scopePane.getPane());
        ((CardLayout)this._leftPanel.getLayout()).show(this._leftPanel, this._pane);
        if (this._pane.equals("search")) {
            string = ScjSession.getString("STR_SEARCH_HEADER");
            this._showPane = true;
        } else if (this._pane.equals("tasks")) {
            string = ScjSession.getString("STR_TASKS_HEADER");
            this._showPane = true;
        } else if (this._pane.equals("folders")) {
            string = ScjSession.getString("STR_FOLDERS_HEADER");
            this._showPane = true;
        } else {
            string = ScjSession.getString("STR_FOLDERS_HEADER");
        }
        arrayList = Utilities.addHeaderToComponent(this._leftPanel, string, this._paneCloseButton);
        this._leftPanelWithHeader = arrayList.get(0);
        this._leftPanelHeaderLabel = (JLabel)arrayList.get(1);
        arrayList.clear();
        this._splitter = new JSplitPane(1, false, this._leftPanelWithHeader, this._contentPane.getPanel());
        this._splitter.setMinimumSize(new Dimension(70, 70));
        this._dividerSize = this._splitter.getDividerSize();
        this._bottomSplitter = new JSplitPane(0, false, this._splitter, null);
        this._splitter.setBorder(null);
        this._statusPanel = new JPanel();
        this._statusPanel.setBorder(BorderFactory.createBevelBorder(1));
        this._statusPanel.setLayout(new BoxLayout(this._statusPanel, 0));
        this._statusLabel = new SCLabel(ONE_SPACE);
        this._statusPanel.add(this._statusLabel);
        this._toolBarPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._toolBarPanel.setLayout(gridBagLayout);
        this._toolBarPanel.add(this._toolBar);
        this._toolBarPanel.add(this._contextComboBoxPanel);
        this._providerToolBar = new ProviderToolBar(this._session, this._viewerManager);
        this._toolBarPanel.add(this._providerToolBar);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this._toolBar, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this._contextComboBoxPanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this._providerToolBar, gridBagConstraints);
        this.add((Component)this._toolBarPanel, "North");
        this.add((Component)this._bottomSplitter, "Center");
        this.add((Component)this._statusPanel, "South");
        this._splitterDividerLocation = this._session.getUserPrefRepositoryInfo().getSplitterLocation();
        this._bottomSplitterDividerLocation = this._session.getUserPrefRepositoryInfo().getBottomSplitterLocation();
        this.showComponents(!this._pane.equals("none"), false, false);
        this.setVisible(false);
    }

    void initialize() {
        this._toolBar.setVisible(this._session.getUserPrefRepositoryInfo().isToolBarVisible());
        this._contextComboBoxPanel.setVisible(this._session.getUserPrefRepositoryInfo().isContextComboBoxVisible());
        this._providerToolBar.setVisible(this._session.getUserPrefRepositoryInfo().isToolBarVisible());
        this._splitter.setDividerLocation(this._session.getUserPrefRepositoryInfo().getSplitterLocation());
        this._bottomSplitter.setDividerLocation(this._session.getUserPrefRepositoryInfo().getBottomSplitterLocation());
        this._statusPanel.setVisible(this._session.getUserPrefRepositoryInfo().isStatusBarVisible());
        this.updateStatusBarText(null);
        this._searchPane.initialize(this._viewerManager);
        this._taskPane.initialize(this._viewerManager);
        this._scopePane.initialize(this._session.getRootContainer(), this._viewerManager);
    }

    void open() {
        this.setVisible(true);
        this._contentPane.initializeAfterVisible();
        this.requestPaneFocus();
    }

    void initProviderToolBar() {
        if (this._providerToolBar.getHeight() <= 0) {
            this._providerToolBar.updateProviderToolBar(null, false);
        }
    }

    void updateProviderToolBar(ProviderEntry providerEntry, boolean bl) {
        this._providerToolBar.updateProviderToolBar(providerEntry, bl);
        this._toolBarPanel.updateUI();
    }

    void enableProviderToolBarButtonsByCommandIdList(int[] nArray) {
        this._providerToolBar.enableProviderToolBarButtonsByCommandIdList(nArray);
    }

    void toggleSearchPaneVisible() {
        this.togglePane("search");
    }

    void stopSearch() {
        this._searchPane.stopSearch();
    }

    void toggleTaskPaneVisible() {
        this.togglePane("tasks");
    }

    void toggleFolderPaneVisible() {
        this.togglePane("folders");
    }

    private void updatePaneHeaderName() {
        if (this._pane.equals("search")) {
            this._leftPanelHeaderLabel.setText(ScjSession.getString("STR_SEARCH_HEADER"));
        } else if (this._pane.equals("tasks")) {
            this._leftPanelHeaderLabel.setText(ScjSession.getString("STR_TASKS_HEADER"));
        } else if (this._pane.equals("folders")) {
            this._leftPanelHeaderLabel.setText(ScjSession.getString("STR_FOLDERS_HEADER"));
        }
    }

    void requestPaneFocus() {
        if (this._pane.equals("search")) {
            this._searchPane.requestFocusInWindow();
        } else if (this._pane.equals("tasks")) {
            this._taskPane.requestFocusInWindow();
        } else if (this._pane.equals("folders")) {
            this._scopePane.requestFocusInWindow();
        }
    }

    private void togglePane(String string) {
        KeyboardFocusManager keyboardFocusManager;
        Component component;
        Object var2_2 = null;
        if (this._pane.equals("search")) {
            this.stopSearch();
        }
        this._viewerManager.setStatusMenuHint(null);
        if (this._pane == "none") {
            this._pane = string;
            ((CardLayout)this._leftPanel.getLayout()).show(this._leftPanel, this._pane);
            this.updatePaneHeaderName();
            if (this._pane.equals("tasks")) {
                this._taskPane.updateTasks();
            }
            this.requestPaneFocus();
            this._toolBar.setSelectedViewButton(this._pane);
            this._showPane = true;
        } else if (this._pane.equals(string) || string == "none") {
            this._pane = "none";
            this._toolBar.setSelectedViewButton(this._pane);
            this._showPane = false;
        } else {
            this._pane = string;
            ((CardLayout)this._leftPanel.getLayout()).show(this._leftPanel, this._pane);
            this.updatePaneHeaderName();
            if (this._pane.equals("tasks")) {
                this._taskPane.updateTasks();
            }
            this.requestPaneFocus();
            this._toolBar.setSelectedViewButton(this._pane);
            return;
        }
        if (!this._showPane && (component = (keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getPermanentFocusOwner()) != null && SwingUtilities.isDescendingFrom(component, this._leftPanelWithHeader)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainPanel.this._contentPane.getPane().requestFocusInWindow();
                }
            });
        }
        this.showComponents(this._showPane, this._showBottomJComponent, true);
        if (this._showPane) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MainPanel.this._pane.equals("search")) {
                        MainPanel.this._searchPane.requestFocusInWindow();
                    } else if (MainPanel.this._pane.equals("tasks")) {
                        MainPanel.this._taskPane.requestFocusInWindow();
                    } else if (MainPanel.this._pane.equals("folders")) {
                        MainPanel.this._scopePane.requestFocusInWindow();
                    }
                }
            });
        }
    }

    boolean isFolderPaneVisible() {
        return this._pane.equals("folders");
    }

    boolean isTaskPaneVisible() {
        return this._pane.equals("tasks");
    }

    boolean isSearchPaneVisible() {
        return this._pane.equals("search");
    }

    boolean isBottomJComponentVisible() {
        return this._showBottomJComponent;
    }

    void updateProviderBottomJComponent(ProviderEntry providerEntry, boolean bl) {
        if (!bl || bl && providerEntry == this._viewerManager.getProviderEntryForSelectedTreeItem()) {
            this._providerEntry = providerEntry;
            if (providerEntry == null) {
                if (this._bottomJComponent == null) {
                    return;
                }
                this._bottomJComponent = null;
                this._bottomJComponentWithoutHeader = null;
                this.showComponents(this._showPane, false, true);
                this._viewerManager.getMenuManager().updateViewMenu(null, null, false);
            } else {
                JComponent jComponent = providerEntry.getBottomJComponent();
                String string = providerEntry.getBottomJComponentMenuName();
                String string2 = providerEntry.getBottomJComponentMenuHint();
                boolean bl2 = providerEntry.isBottomJComponentVisible();
                if (jComponent != null) {
                    if (string != null) {
                        if (this._bottomJComponentWithoutHeader == jComponent) {
                            return;
                        }
                        this._bottomJComponentWithoutHeader = jComponent;
                        this._bottomJComponent = Utilities.addHeaderToComponent(jComponent, string, this._bottomJComponentCloseButton).get(0);
                        this.showComponents(this._showPane, bl2, true);
                        this._viewerManager.getMenuManager().updateViewMenu(string, string2, bl2);
                    } else {
                        if (this._bottomJComponentWithoutHeader == jComponent) {
                            return;
                        }
                        this._bottomJComponent = jComponent;
                        this._bottomJComponentWithoutHeader = jComponent;
                        this.showComponents(this._showPane, true, true);
                        this._viewerManager.getMenuManager().updateViewMenu(null, null, false);
                    }
                } else {
                    if (this._bottomJComponent == null) {
                        return;
                    }
                    this._bottomJComponent = null;
                    this._bottomJComponentWithoutHeader = null;
                    this.showComponents(this._showPane, false, true);
                    this._viewerManager.getMenuManager().updateViewMenu(null, null, false);
                }
            }
        }
    }

    void updateProviderStatusBarJComponent(ProviderEntry providerEntry, boolean bl) {
        if (!bl || bl && providerEntry == this._viewerManager.getProviderEntryForSelectedTreeItem()) {
            this._statusPanel.setVisible(this._session.getUserPrefRepositoryInfo().isStatusBarVisible());
            if (providerEntry == null) {
                if (this._statusPanel.getComponentCount() > 0 && this._statusPanel.getComponent(0) == this._statusLabel) {
                    return;
                }
                this._statusPanel.removeAll();
                this._statusPanel.add(this._statusLabel);
            } else {
                this._providerStatusBarJComponent = providerEntry.getStatusBarJComponent();
                if (this._statusPanel.getComponentCount() > 0 && this._statusPanel.getComponent(0) == this._providerStatusBarJComponent) {
                    return;
                }
                this._statusPanel.removeAll();
                if (this._providerStatusBarJComponent != null) {
                    int n = Math.max(16, this._statusLabel.getPreferredSize().height);
                    this._providerStatusBarJComponent.setMinimumSize(new Dimension(this._providerStatusBarJComponent.getMinimumSize().width, n));
                    this._statusPanel.add(this._providerStatusBarJComponent);
                } else {
                    this._statusPanel.add(this._statusLabel);
                }
            }
            Graphics graphics = this._statusPanel.getGraphics();
            this._statusPanel.paintAll(graphics);
            graphics = null;
        }
    }

    void updateStatusBarText(String string) {
        this._statusLabel.setText(ONE_SPACE);
        this._statusPanel.setVisible(this._session.getUserPrefRepositoryInfo().isStatusBarVisible());
        this._statusPanel.removeAll();
        if (string == null || string.trim().length() == 0) {
            if (this._providerStatusBarJComponent != null) {
                this._statusPanel.add(this._providerStatusBarJComponent);
            } else {
                this._statusPanel.add(this._statusLabel);
                if (this._viewerManager.getNumberOfSelectedDetailsItems() > 0) {
                    if (this._viewerManager.getNumberOfSelectedDetailsItems() == 1) {
                        this._statusLabel.setText(ONE_SPACE + SybMessageFormat.format((String)ScjSession.getString("STR_STATUS_LABL_OBJ_SEL"), (Object[])new Object[]{this._viewerManager.getNumberOfSelectedDetailsItems()}));
                    } else {
                        this._statusLabel.setText(ONE_SPACE + SybMessageFormat.format((String)ScjSession.getString("STR_STATUS_LABL_OBJS_SEL"), (Object[])new Object[]{this._viewerManager.getNumberOfSelectedDetailsItems()}));
                    }
                } else if (this._viewerManager.getNumberOfDetailsItems() == 1) {
                    this._statusLabel.setText(ONE_SPACE + SybMessageFormat.format((String)ScjSession.getString("STR_STATUS_LABL_OBJ"), (Object[])new Object[]{this._viewerManager.getNumberOfDetailsItems()}));
                } else if (this._viewerManager.getNumberOfDetailsItems() != -1) {
                    this._statusLabel.setText(ONE_SPACE + SybMessageFormat.format((String)ScjSession.getString("STR_STATUS_LABL_OBJS"), (Object[])new Object[]{this._viewerManager.getNumberOfDetailsItems()}));
                }
            }
        } else {
            this._statusPanel.add(this._statusLabel);
            this._statusLabel.setMaximumSize(null);
            this._statusLabel.setPreferredSize(null);
            this._statusLabel.setText(ONE_SPACE + string);
            int n = Math.max(16, this._statusLabel.getPreferredSize().height);
            this._statusLabel.setMaximumSize(new Dimension(this._statusLabel.getMaximumSize().width, n));
            this._statusLabel.setPreferredSize(new Dimension(this._statusLabel.getPreferredSize().width, n));
        }
        Graphics graphics = this._statusPanel.getGraphics();
        this._statusPanel.paintAll(graphics);
        graphics = null;
    }

    void showBottomComponent(boolean bl) {
        this.showComponents(this._showPane, bl, true);
    }

    void toggleBottomComponentVisible() {
        KeyboardFocusManager keyboardFocusManager;
        Component component;
        boolean bl = false;
        boolean bl2 = this._showBottomJComponent = !this._showBottomJComponent;
        if (this._providerEntry != null) {
            this._providerEntry.setBottomJComponentVisible(this._showBottomJComponent);
        }
        if (!this._showBottomJComponent && this._bottomJComponent != null && (component = (keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getPermanentFocusOwner()) != null && SwingUtilities.isDescendingFrom(component, this._bottomJComponent)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainPanel.this._contentPane.getPane().requestFocusInWindow();
                }
            });
        }
        this.showComponents(this._showPane, this._showBottomJComponent, true);
        if (this._providerEntry.getProvider() instanceof SCProvider4) {
            ((SCProvider4)this._providerEntry.getProvider()).bottomJComponentVisibilityChanged(this._showBottomJComponent);
        }
        if (this._showBottomJComponent && this._bottomJComponent != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainPanel.this._bottomJComponent.requestFocusInWindow();
                }
            });
        }
    }

    private void showComponents(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (this._splitter.getLeftComponent() == null) {
                this._splitter.setLeftComponent(this._leftPanelWithHeader);
                this._splitter.setDividerSize(this._dividerSize);
                this._splitter.setDividerLocation(this._splitterDividerLocation);
            }
        } else {
            if (this._splitter.getLeftComponent() != null) {
                if (bl3) {
                    this._splitterDividerLocation = this._splitter.getDividerLocation();
                }
                this._splitter.setLeftComponent(null);
            }
            this._splitter.setDividerSize(0);
        }
        Component component = this._bottomSplitter.getBottomComponent();
        if (bl2) {
            final int n = this._bottomSplitter.getDividerLocation();
            this._bottomSplitter.setBottomComponent(this._bottomJComponent);
            if (component == null) {
                this._bottomSplitter.setDividerSize(this._dividerSize);
                this._bottomSplitter.setDividerLocation(this._bottomSplitterDividerLocation);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainPanel.this._bottomSplitter.setDividerLocation(n);
                    }
                });
            }
        } else {
            if (component != null) {
                if (bl3) {
                    this._bottomSplitterDividerLocation = this._bottomSplitter.getDividerLocation();
                }
                this._bottomSplitter.setBottomComponent(null);
            }
            this._bottomSplitter.setDividerSize(0);
        }
        this._showBottomJComponent = bl2;
    }

    void setViewSettings() {
        this._session.getUserPrefRepositoryInfo().setPaneVisible(this._pane);
        int n = this._showPane ? this._splitter.getDividerLocation() : this._splitterDividerLocation;
        this._session.getUserPrefRepositoryInfo().setSplitterLocation(n);
        n = this._showBottomJComponent ? this._bottomSplitter.getDividerLocation() : this._bottomSplitterDividerLocation;
        this._session.getUserPrefRepositoryInfo().setBottomSplitterLocation(n);
    }

    ScopePane getScopePane() {
        return this._scopePane;
    }

    SearchPane getSearchPane() {
        return this._searchPane;
    }

    TaskPane getTaskPane() {
        return this._taskPane;
    }

    JPanel getToolBarPanel() {
        return this._toolBarPanel;
    }

    ScjToolBar getToolBar() {
        return this._toolBar;
    }

    ProviderToolBar getProviderToolBar() {
        return this._providerToolBar;
    }

    ContextComboBoxPanel getContextComboBoxPanel() {
        return this._contextComboBoxPanel;
    }

    ContentPane getContentPane() {
        return this._contentPane;
    }

    JPanel getStatusPanel() {
        return this._statusPanel;
    }

    public void menuItemHilited(String string) {
        this.updateStatusBarText(string);
    }

    void releaseResources() {
        this._viewerManager = null;
        this._statusLabel = null;
        this._statusPanel = null;
        this._providerStatusBarJComponent = null;
        this._splitter = null;
        this._bottomSplitter = null;
        this._session = null;
        this._toolBar.releaseResources();
        this._toolBar = null;
        this._contextComboBoxPanel.releaseResources();
        this._contextComboBoxPanel = null;
        this._searchPane.releaseResources();
        this._searchPane = null;
        this._taskPane.releaseResources();
        this._taskPane = null;
        this._scopePane.releaseResources();
        this._scopePane = null;
        this._leftPanel = null;
        this._leftPanelWithHeader = null;
        this._leftPanelHeaderLabel = null;
        this._contentPane.releaseResources();
        this._contentPane = null;
        this._paneCloseButton.removeActionListener(this);
        this._paneCloseButton = null;
        this._bottomJComponent = null;
        this._bottomJComponentWithoutHeader = null;
        this._bottomJComponentCloseButton.removeActionListener(this);
        this._bottomJComponentCloseButton = null;
        this._toolBarPanel = null;
        this._providerToolBar.releaseResources();
        this._providerToolBar = null;
        this._providerEntry = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._paneCloseButton) {
            this.togglePane("none");
        } else if (actionEvent.getSource() == this._bottomJComponentCloseButton) {
            this._viewerManager.menuItemSelected(1005);
        }
    }
}

