/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer;
import com.sybase.central.SCContainer3;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCHeader;
import com.sybase.central.SCHeader4;
import com.sybase.central.SCHeader5;
import com.sybase.central.SCHeader6;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCProvider;
import com.sybase.central.SCProvider4;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.BaseMenu;
import com.sybase.central.viewer.BaseMenuItem;
import com.sybase.central.viewer.DetailsList;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.SCJCheckBoxMenuItem;
import com.sybase.central.viewer.SCJMenu;
import com.sybase.central.viewer.SCJMenuItem;
import com.sybase.central.viewer.SCJRadioButtonMenuItem;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.central.viewer.SessionEvent;
import com.sybase.central.viewer.SessionListener;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.Platform;
import com.sybase.util.SybMessageFormat;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class MenuManager
implements ScjResourceConstants,
IConstants,
MenuListener,
SessionListener {
    private ViewerManager _viewerManager = null;
    private ScjSession _session = null;
    private ScjViewerSupport _viewerSupport = null;
    private JMenuBar _menuBar;
    private BaseMenu[] _topMenu = null;
    private Hashtable<ProviderEntry, JMenu> _extendedMenus = new Hashtable();
    private JMenu[] _providerTopLevelJMenus = null;
    private BaseMenu[] _providerMenuBarBaseMenus = null;
    private Hashtable<Object, JMenuItem> _menuItemAccelerators = new Hashtable();
    private static final int FILE = 0;
    private static final int EDIT = 1;
    private static final int VIEW = 2;
    private static final int TOOLS = 3;
    private static final int CONNECTIONS = 4;
    private static final int HELP = 5;
    private static final int MENU_NAME = 0;
    private static final int MENU_HINT = 1;
    private static final int MENU_COMMAND = 2;
    private static final int MENU_ACCELERATOR = 3;
    private static final int MENU_ICON = 4;
    private static final int VIEW_CHOOSE_COL_POS = 2;
    private static final int VIEW_SORT_POS = 3;
    private static final int VIEW_GOTO_POS = 4;
    private static final int VIEW_TASKS_COMP_POS = 9;
    private static final int VIEW_FOLDERS_COMP_POS = 10;
    private static final int VIEW_SEARCH_COMP_POS = 11;
    private static final int VIEW_BTM_COMP_POS = 13;
    private static final String VIEW_BTM_COMP_ACC = "1 ";

    MenuManager(ViewerManager viewerManager, ScjSession scjSession, ScjViewerSupport scjViewerSupport, JFrame jFrame) {
        this._viewerManager = viewerManager;
        this._session = scjSession;
        this._viewerSupport = scjViewerSupport;
        this._session.addSessionListener(this);
        this._menuBar = new JMenuBar();
        jFrame.setJMenuBar(this._menuBar);
        this.initMenus();
    }

    protected void initMenus() {
        this._topMenu = new BaseMenu[6];
        this.initFileMenu();
        this.initEditMenu();
        this.initViewMenu();
        this.initToolsMenu();
        this.initConnectionsMenu();
        this.initHelpMenu();
    }

    private void initFileMenu() {
        Object object;
        Object object2 = Platform.isMacOS() ? (object = new Object[][]{{"STR_FILE_NONE_ITEM", null, new Integer(0)}}) : (object = new Object[][]{{"STR_FILE_EXIT_ITEM", "STR_FILE_EXIT_HINT", new Integer(1000)}});
        this._topMenu[0] = new BaseMenu((JMenu)((Object)new SCJMenu(ScjSession.getString("STR_FILE_MENU"))), null);
        this._topMenu[0].getJMenu().addMenuListener(this);
        for (int i = 0; i < ((Object[][])object2).length; ++i) {
            object = object2[i][1] != null ? ScjSession.getString((String)object2[i][1]) : null;
            BaseMenuItem baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJMenuItem(ScjSession.getString((String)object2[i][0]))), null, (String)object, (Integer)object2[i][2], this._viewerManager);
            if (Platform.isMacOS()) {
                baseMenuItem.getJMenuItem().setEnabled(false);
            }
            this._topMenu[0].addMenuItem(baseMenuItem);
        }
        this._menuBar.add(this._topMenu[0].getJMenu());
    }

    private void initEditMenu() {
        Object[][] objectArrayArray = new Object[][]{{"STR_EDIT_UNDO", "STR_EDIT_UNDO_HINT", new Integer(109), MENU_Z, MENU_UNDO_ICON}, {"STR_EDIT_REDO", "STR_EDIT_REDO_HINT", new Integer(108), MENU_Y, MENU_REDO_ICON}, new Object[0], {"STR_EDIT_CUT", "STR_EDIT_CUT_HINT", new Integer(101), MENU_X, MENU_CUT_ICON}, {"STR_EDIT_COPY", "STR_EDIT_COPY_HINT", new Integer(102), MENU_C, MENU_COPY_ICON}, {"STR_EDIT_PASTE", "STR_EDIT_PASTE_HINT", new Integer(103), MENU_V, MENU_PASTE_ICON}, {"STR_EDIT_DELETE", "STR_EDIT_DELETE_HINT", new Integer(106), DELETE, MENU_DELETE_ICON}, new Object[0], {"STR_EDIT_SELECT_ALL", "STR_EDIT_SELECT_ALL_HINT", new Integer(1023), MENU_A, EMPTY_ICON}, {"STR_EDIT_INVERT_SEL", "STR_EDIT_INVERT_SEL_HINT", new Integer(1024), null, EMPTY_ICON}};
        SCJMenu sCJMenu = new SCJMenu(ScjSession.getString("STR_EDIT_MENU"));
        this._topMenu[1] = new BaseMenu((JMenu)((Object)sCJMenu), null);
        this._topMenu[1].getJMenu().addMenuListener(this);
        for (int i = 0; i < objectArrayArray.length; ++i) {
            BaseMenuItem baseMenuItem;
            if (objectArrayArray[i].length == 0) {
                baseMenuItem = new BaseMenuItem();
            } else {
                baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJMenuItem(ScjSession.getString((String)objectArrayArray[i][0]))), null, ScjSession.getString((String)objectArrayArray[i][1]), (Integer)objectArrayArray[i][2], this._viewerManager);
                if (objectArrayArray[i][3] != null) {
                    baseMenuItem.getJMenuItem().setAccelerator((KeyStroke)objectArrayArray[i][3]);
                    this._menuItemAccelerators.put(objectArrayArray[i][3], baseMenuItem.getJMenuItem());
                }
                baseMenuItem.getJMenuItem().setIcon((Icon)objectArrayArray[i][4]);
            }
            this._topMenu[1].addMenuItem(baseMenuItem);
        }
        this._menuBar.add((JMenu)((Object)sCJMenu));
    }

    private void initViewMenu() {
        Object[][] objectArrayArray = new Object[][]{{"STR_VIEW_REFRESH", "STR_VIEW_REFRESH_HINT", new Integer(1006), F5, MENU_REFRESH_FOLDER_ICON}, {"STR_VIEW_REFRESH_ALL", "STR_VIEW_REFRESH_ALL_HINT", new Integer(1007), null, MENU_REFRESH_ALL_ICON}, {"STR_VIEW_CHOOSE_COLUMNS", "STR_VIEW_CHOOSE_COLUMNS_HINT", new Integer(1025), null, EMPTY_ICON}};
        BaseMenuItem baseMenuItem = null;
        this._topMenu[2] = new BaseMenu((JMenu)((Object)new SCJMenu(ScjSession.getString("STR_VIEW_MENU"))), null);
        this._topMenu[2].getJMenu().addMenuListener(this);
        for (int i = 0; i < objectArrayArray.length; ++i) {
            baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJMenuItem(ScjSession.getString((String)objectArrayArray[i][0]))), null, ScjSession.getString((String)objectArrayArray[i][1]), (Integer)objectArrayArray[i][2], this._viewerManager);
            if (objectArrayArray[i][3] != null) {
                baseMenuItem.getJMenuItem().setAccelerator((KeyStroke)objectArrayArray[i][3]);
                this._menuItemAccelerators.put(objectArrayArray[i][3], baseMenuItem.getJMenuItem());
            }
            baseMenuItem.getJMenuItem().setIcon((Icon)objectArrayArray[i][4]);
            this._topMenu[2].addMenuItem(baseMenuItem);
        }
        this._menuBar.add(this._topMenu[2].getJMenu());
        this._topMenu[2].addMenuItem(new BaseMenu((JMenu)((Object)new SCJMenu(ScjSession.getString("STR_VIEW_SORT_MENU"))), null, EMPTY_ICON));
        this._topMenu[2].addMenuItem(this.initViewGoToMenu());
        this._topMenu[2].addMenuItem(new BaseMenuItem());
        this._topMenu[2].addMenuItem(this.initViewToolbarsMenu());
        baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJCheckBoxMenuItem(ScjSession.getString("STR_VIEW_STATUSBAR"))), null, ScjSession.getString("STR_VIEW_STATUSBAR_HINT"), 1004, this._viewerManager);
        this._topMenu[2].addMenuItem(baseMenuItem);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setIcon(EMPTY_ICON);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setState(this._session.getUserPrefRepositoryInfo().isStatusBarVisible());
        this._topMenu[2].addMenuItem(new BaseMenuItem());
        baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJCheckBoxMenuItem(ScjSession.getString("STR_VIEW_TASK_PANE"))), null, ScjSession.getString("STR_VIEW_TASK_PANE_HINT"), 1016, this._viewerManager);
        this._topMenu[2].addMenuItem(baseMenuItem);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setIcon(TASKS_ICON);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setState(this._session.getUserPrefRepositoryInfo().getVisiblePane().equals("tasks"));
        baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJCheckBoxMenuItem(ScjSession.getString("STR_VIEW_FOLDER_PANE"))), null, ScjSession.getString("STR_VIEW_FOLDER_PANE_HINT"), 1017, this._viewerManager);
        this._topMenu[2].addMenuItem(baseMenuItem);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setIcon(FOLDERS_ICON);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setState(this._session.getUserPrefRepositoryInfo().getVisiblePane().equals("folders"));
        baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJCheckBoxMenuItem(ScjSession.getString("STR_VIEW_SEARCH_PANE"))), null, ScjSession.getString("STR_VIEW_SEARCH_PANE_HINT"), 1015, this._viewerManager);
        this._topMenu[2].addMenuItem(baseMenuItem);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setIcon(SEARCH_ICON);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setState(this._session.getUserPrefRepositoryInfo().getVisiblePane().equals("search"));
    }

    private BaseMenu initViewGoToMenu() {
        Object[][] objectArrayArray = new Object[][]{{"STR_VIEW_GOTO_BACK", "STR_VIEW_GOTO_BACK_HINT", new Integer(1012), ALT_LEFT, MENU_BACK_ICON}, {"STR_VIEW_GOTO_FORWARD", "STR_VIEW_GOTO_FORWARD_HINT", new Integer(1013), ALT_RIGHT, MENU_FORWARD_ICON}, {"STR_VIEW_GOTO_UP", "STR_VIEW_GOTO_UP_HINT", new Integer(1014), ALT_UP, MENU_UP_ICON}};
        SCJMenu sCJMenu = new SCJMenu(ScjSession.getString("STR_VIEW_GOTO_MENU"));
        BaseMenu baseMenu = new BaseMenu((JMenu)((Object)sCJMenu), null, EMPTY_ICON);
        for (int i = 0; i < objectArrayArray.length; ++i) {
            BaseMenuItem baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJMenuItem(ScjSession.getString((String)objectArrayArray[i][0]))), null, ScjSession.getString((String)objectArrayArray[i][1]), (Integer)objectArrayArray[i][2], this._viewerManager);
            if (objectArrayArray[i][3] != null) {
                baseMenuItem.getJMenuItem().setAccelerator((KeyStroke)objectArrayArray[i][3]);
                this._menuItemAccelerators.put(objectArrayArray[i][3], baseMenuItem.getJMenuItem());
            }
            baseMenuItem.getJMenuItem().setIcon((Icon)objectArrayArray[i][4]);
            baseMenu.addMenuItem(baseMenuItem);
        }
        return baseMenu;
    }

    private BaseMenu initViewToolbarsMenu() {
        SCJMenu sCJMenu = new SCJMenu(ScjSession.getString("STR_VIEW_TOOLBARS_MENU"));
        BaseMenu baseMenu = new BaseMenu((JMenu)((Object)sCJMenu), null, EMPTY_ICON);
        BaseMenuItem baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJCheckBoxMenuItem(ScjSession.getString("STR_VIEW_STANDARD_TOOLBARS"))), null, ScjSession.getString("STR_VIEW_STANDARD_TOOLBARS_HINT"), 1001, this._viewerManager);
        baseMenu.addMenuItem(baseMenuItem);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setIcon(EMPTY_ICON);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setState(this._session.getUserPrefRepositoryInfo().isToolBarVisible());
        baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJCheckBoxMenuItem(ScjSession.getString("STR_VIEW_CONTEXT_COMBOBOX"))), null, ScjSession.getString("STR_VIEW_CONTEXT_COMBOBOX_HINT"), 1002, this._viewerManager);
        baseMenu.addMenuItem(baseMenuItem);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setIcon(EMPTY_ICON);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setState(this._session.getUserPrefRepositoryInfo().isContextComboBoxVisible());
        baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJCheckBoxMenuItem(ScjSession.getString("STR_VIEW_CONTEXT_TITLE"))), null, ScjSession.getString("STR_VIEW_CONTEXT_TITLE_HINT"), 1003, this._viewerManager);
        baseMenu.addMenuItem(baseMenuItem);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setIcon(EMPTY_ICON);
        ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setState(this._session.getUserPrefRepositoryInfo().isContextLabelVisible());
        return baseMenu;
    }

    private void initToolsMenu() {
        Object[][] objectArrayArray;
        Object[][] objectArrayArray2 = Platform.isMacOS() ? (objectArrayArray = new Object[][]{{"STR_TOOLS_DEBUG_OUTPUT", "STR_TOOLS_DEBUG_OUTPUT_HINT", new Integer(1009), null, MENU_DEBUG_LOG_ICON}, {"STR_TOOLS_PLUGIN", "STR_TOOLS_PLUGIN_HINT", new Integer(1022), null, MENU_PLUGIN_ICON}}) : (objectArrayArray = new Object[][]{{"STR_TOOLS_DEBUG_OUTPUT", "STR_TOOLS_DEBUG_OUTPUT_HINT", new Integer(1009), null, MENU_DEBUG_LOG_ICON}, {"STR_TOOLS_PLUGIN", "STR_TOOLS_PLUGIN_HINT", new Integer(1022), null, MENU_PLUGIN_ICON}, {"STR_TOOLS_OPTIONS", "STR_TOOLS_OPTIONS_HINT", new Integer(1018), null, EMPTY_ICON}});
        SCJMenu sCJMenu = new SCJMenu(ScjSession.getString("STR_TOOLS_MENU"));
        this._topMenu[3] = new BaseMenu((JMenu)((Object)sCJMenu), null);
        this._topMenu[3].getJMenu().addMenuListener(this);
        for (int i = 0; i < objectArrayArray2.length; ++i) {
            BaseMenuItem baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJMenuItem(ScjSession.getString((String)objectArrayArray2[i][0]))), null, ScjSession.getString((String)objectArrayArray2[i][1]), (Integer)objectArrayArray2[i][2], this._viewerManager);
            if (objectArrayArray2[i][3] != null) {
                baseMenuItem.getJMenuItem().setAccelerator((KeyStroke)objectArrayArray2[i][3]);
                this._menuItemAccelerators.put(objectArrayArray2[i][3], baseMenuItem.getJMenuItem());
            }
            baseMenuItem.getJMenuItem().setIcon((Icon)objectArrayArray2[i][4]);
            this._topMenu[3].addMenuItem(baseMenuItem);
        }
        this._menuBar.add((JMenu)((Object)sCJMenu));
    }

    private void initConnectionsMenu() {
        Object[][] objectArrayArray;
        SCJMenu sCJMenu = new SCJMenu(ScjSession.getString("STR_CONNECTIONS_MENU"));
        this._topMenu[4] = new BaseMenu((JMenu)((Object)sCJMenu), null);
        Object[][] objectArrayArray2 = Platform.isMacOS() ? (objectArrayArray = new Object[][]{{"STR_CONNECTIONS_CONNPROF", "STR_CONNECTIONS_CONNPROF_HINT", new Integer(1021), null, MENU_CONN_PROFILE_ICON}, new Object[0], {"STR_CONNECTIONS_DISCONNECT", "STR_CONNECTIONS_DISCONNECT_HINT", new Integer(1020), null, MENU_DISCONNECT_ICON}}) : (objectArrayArray = new Object[][]{{"STR_CONNECTIONS_CONNPROF", "STR_CONNECTIONS_CONNPROF_HINT", new Integer(1021), F9, MENU_CONN_PROFILE_ICON}, new Object[0], {"STR_CONNECTIONS_DISCONNECT", "STR_CONNECTIONS_DISCONNECT_HINT", new Integer(1020), F12, MENU_DISCONNECT_ICON}});
        this._topMenu[4] = new BaseMenu((JMenu)((Object)sCJMenu), null);
        this._topMenu[4].getJMenu().addMenuListener(this);
        for (int i = 0; i < objectArrayArray2.length; ++i) {
            BaseMenuItem baseMenuItem;
            if (objectArrayArray2[i].length == 0) {
                baseMenuItem = new BaseMenuItem();
            } else {
                baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJMenuItem(ScjSession.getString((String)objectArrayArray2[i][0]))), null, ScjSession.getString((String)objectArrayArray2[i][1]), (Integer)objectArrayArray2[i][2], this._viewerManager);
                if (objectArrayArray2[i][3] != null) {
                    baseMenuItem.getJMenuItem().setAccelerator((KeyStroke)objectArrayArray2[i][3]);
                    this._menuItemAccelerators.put(objectArrayArray2[i][3], baseMenuItem.getJMenuItem());
                }
                baseMenuItem.getJMenuItem().setIcon((Icon)objectArrayArray2[i][4]);
            }
            this._topMenu[4].addMenuItem(baseMenuItem);
        }
        this._menuBar.add((JMenu)((Object)sCJMenu));
    }

    private void initHelpMenu() {
        Object[][] objectArrayArray;
        Object[][] objectArrayArray2 = Platform.isMacOS() ? (objectArrayArray = new Object[][]{{"STR_SCJ_HELP_ITEM", "STR_SCJ_HELP_HINT", new Integer(1010), null}, {"STR_SCJ_HELP_TIP_OF_THE_DAY_ITEM", "STR_SCJ_HELP_TIP_OF_THE_DAY_HINT", new Integer(1027), null}}) : (objectArrayArray = new Object[][]{{"STR_SCJ_HELP_ITEM", "STR_SCJ_HELP_HINT", new Integer(1010), null}, {"STR_SCJ_HELP_TIP_OF_THE_DAY_ITEM", "STR_SCJ_HELP_TIP_OF_THE_DAY_HINT", new Integer(1027), null}, new Object[0], {"STR_SCJ_HELP_ABOUT_ITEM", "STR_SCJ_HELP_ABOUT_HINT", new Integer(1011), null}});
        BaseMenuItem baseMenuItem = null;
        this._topMenu[5] = new BaseMenu((JMenu)((Object)new SCJMenu(ScjSession.getString("STR_HELP_MENU"))), null);
        this._topMenu[5].getJMenu().addMenuListener(this);
        if (this._session.getConfiguration().isSybaseCentralHelpEnabled()) {
            for (int i = 0; i < objectArrayArray2.length; ++i) {
                if (objectArrayArray2[i].length == 0) {
                    baseMenuItem = new BaseMenuItem();
                } else {
                    baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJMenuItem(ScjSession.getString((String)objectArrayArray2[i][0]))), null, ScjSession.getString((String)objectArrayArray2[i][1]), (Integer)objectArrayArray2[i][2], this._viewerManager);
                    if (objectArrayArray2[i][3] != null) {
                        baseMenuItem.getJMenuItem().setAccelerator((KeyStroke)objectArrayArray2[i][3]);
                        this._menuItemAccelerators.put(objectArrayArray2[i][3], baseMenuItem.getJMenuItem());
                    }
                }
                this._topMenu[5].addMenuItem(baseMenuItem);
            }
        }
        this._menuBar.add(this._topMenu[5].getJMenu());
    }

    void updateFileMenu(JMenuItem[] jMenuItemArray, JMenuItem[] jMenuItemArray2) {
        int n;
        boolean bl = false;
        this._topMenu[0].getJMenuItem().removeAll();
        if (jMenuItemArray != null) {
            for (n = 0; n < jMenuItemArray.length; ++n) {
                if (jMenuItemArray[n] == null || jMenuItemArray[n].getIcon() == null) continue;
                bl = true;
                break;
            }
        }
        if (jMenuItemArray2 != null) {
            SCJMenu sCJMenu = new SCJMenu(ScjSession.getString("STR_FILE_NEW_ITEM"));
            if (bl) {
                sCJMenu.setIcon(EMPTY_ICON);
            } else {
                sCJMenu.setIcon(null);
            }
            BaseMenu baseMenu = new BaseMenu((JMenu)((Object)sCJMenu), null);
            for (int i = 0; i < jMenuItemArray2.length; ++i) {
                if (jMenuItemArray2[i] == null) {
                    sCJMenu.addSeparator();
                    continue;
                }
                sCJMenu.add(jMenuItemArray2[i]);
            }
            this._topMenu[0].getJMenuItem().add((Component)((Object)sCJMenu));
            if (jMenuItemArray != null) {
                ((JMenu)this._topMenu[0].getJMenuItem()).addSeparator();
            }
        }
        if (jMenuItemArray != null) {
            for (n = 0; n < jMenuItemArray.length; ++n) {
                if (jMenuItemArray[n] == null) {
                    ((JMenu)this._topMenu[0].getJMenuItem()).addSeparator();
                    continue;
                }
                if (jMenuItemArray[n].getIcon() == null || jMenuItemArray[n].getIcon() == EMPTY_ICON) {
                    if (bl) {
                        jMenuItemArray[n].setIcon(EMPTY_ICON);
                    } else {
                        jMenuItemArray[n].setIcon(null);
                    }
                }
                if (jMenuItemArray[n] instanceof JMenu) {
                    this.addEmptyIconsToMenuIfRequired((JMenu)jMenuItemArray[n]);
                }
                this._topMenu[0].getJMenuItem().add(jMenuItemArray[n]);
            }
        }
        if (this._topMenu[0].getJMenu().getItemCount() > 0) {
            ((JMenu)this._topMenu[0].getJMenuItem()).addSeparator();
        }
        if (!Platform.isMacOS() || Platform.isMacOS() && this._topMenu[0].getJMenu().getItemCount() == 0) {
            SCMenuItem[] sCMenuItemArray = this._topMenu[0].getMenuItems();
            for (int i = 0; sCMenuItemArray != null && i < sCMenuItemArray.length; ++i) {
                if (bl) {
                    sCMenuItemArray[i].getJMenuItem().setIcon(EMPTY_ICON);
                } else {
                    sCMenuItemArray[i].getJMenuItem().setIcon(null);
                }
                this._topMenu[0].getJMenuItem().add(sCMenuItemArray[i].getJMenuItem());
            }
        }
    }

    private void addEmptyIconsToMenuIfRequired(JMenu jMenu) {
        int n;
        boolean bl = false;
        Object var4_3 = null;
        int n2 = jMenu.getItemCount();
        for (n = 0; n < n2; ++n) {
            if (jMenu.getItem(n) == null || jMenu.getItem(n).getIcon() == null) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                if (jMenu.getItem(n) == null || jMenu.getItem(n).getIcon() != null) continue;
                jMenu.getItem(n).setIcon(EMPTY_ICON);
                if (!(jMenu.getItem(n) instanceof JMenu)) continue;
                this.addEmptyIconsToMenuIfRequired((JMenu)jMenu.getItem(n));
            }
        }
    }

    void updateEditMenu(int n) {
        SCMenuItem[] sCMenuItemArray = this._topMenu[1].getMenuItems();
        for (int i = 0; i < sCMenuItemArray.length; ++i) {
            if (sCMenuItemArray[i].getCommandId() == 109) {
                sCMenuItemArray[i].getJMenuItem().setEnabled((n & 0x80) != 0);
                continue;
            }
            if (sCMenuItemArray[i].getCommandId() == 108) {
                sCMenuItemArray[i].getJMenuItem().setEnabled((n & 0x100) != 0);
                continue;
            }
            if (sCMenuItemArray[i].getCommandId() == 101) {
                sCMenuItemArray[i].getJMenuItem().setEnabled((n & 4) != 0);
                continue;
            }
            if (sCMenuItemArray[i].getCommandId() == 102) {
                sCMenuItemArray[i].getJMenuItem().setEnabled((n & 8) != 0);
                continue;
            }
            if (sCMenuItemArray[i].getCommandId() == 103) {
                sCMenuItemArray[i].getJMenuItem().setEnabled((n & 0x10) != 0);
                continue;
            }
            if (sCMenuItemArray[i].getCommandId() != 106) continue;
            sCMenuItemArray[i].getJMenuItem().setEnabled((n & 0x20) != 0);
        }
    }

    boolean isEditMenuItemEnabled(int n) {
        SCMenuItem[] sCMenuItemArray = this._topMenu[1].getMenuItems();
        for (int i = 0; i < sCMenuItemArray.length; ++i) {
            if (sCMenuItemArray[i].getCommandId() != n) continue;
            return sCMenuItemArray[i].getJMenuItem().isEnabled();
        }
        return false;
    }

    private void updateViewSortMenu() {
        DetailsList detailsList = null;
        SCMenuItem[] sCMenuItemArray = this._topMenu[2].getMenuItems();
        SCMenu sCMenu = (SCMenu)sCMenuItemArray[3];
        sCMenu.getJMenuItem().removeAll();
        sCMenu.getJMenuItem().setEnabled(false);
        detailsList = this._viewerManager.getContentPane().getDetailsListForActiveDetailsPanel();
        if (detailsList != null) {
            SCHeader[] sCHeaderArray = this._viewerManager.getDetailsListHeaders();
            int[] nArray = this._viewerManager.getDetailsListVisibleColumns();
            if (nArray == null) {
                for (int i = 0; i < sCHeaderArray.length; ++i) {
                    int n;
                    String string;
                    char c;
                    String string2;
                    if (sCHeaderArray[i] instanceof SCHeader6) {
                        string2 = ((SCHeader6)sCHeaderArray[i]).getSortMenuItemName();
                        c = ((SCHeader6)sCHeaderArray[i]).getSortMenuItemMnemonic();
                        string = ((SCHeader6)sCHeaderArray[i]).getSortMenuItemHint();
                        n = ((SCHeader6)sCHeaderArray[i]).getSortMenuItemMnemonicIndex();
                    } else if (sCHeaderArray[i] instanceof SCHeader5) {
                        string2 = ((SCHeader5)sCHeaderArray[i]).getSortMenuItemName();
                        c = ((SCHeader5)sCHeaderArray[i]).getSortMenuItemMnemonic();
                        string = ((SCHeader5)sCHeaderArray[i]).getSortMenuItemHint();
                        n = -1;
                    } else if (sCHeaderArray[i] instanceof SCHeader4) {
                        string2 = sCHeaderArray[i].getText();
                        c = ((SCHeader4)sCHeaderArray[i]).getSortMenuItemMnemonic();
                        string = ((SCHeader4)sCHeaderArray[i]).getSortMenuItemHint();
                        n = -1;
                    } else {
                        string2 = sCHeaderArray[i].getText();
                        c = '\u0000';
                        string = "";
                        n = -1;
                    }
                    if (string == null || string.trim().length() == 0) {
                        string = SybMessageFormat.format((String)ScjSession.getString("STR_VIEW_SORT_HINT"), (Object[])new Object[]{string2});
                    }
                    BaseMenuItem baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJRadioButtonMenuItem(string2, i == Math.abs(DetailsList.sortedColumn) - 1)), c, string, 1026, this._viewerManager, i, n);
                    sCMenu.getJMenuItem().add(baseMenuItem.getJMenuItem());
                }
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    int n;
                    String string;
                    char c;
                    String string3;
                    if (sCHeaderArray[i] instanceof SCHeader6) {
                        string3 = ((SCHeader6)sCHeaderArray[nArray[i]]).getSortMenuItemName();
                        c = ((SCHeader6)sCHeaderArray[nArray[i]]).getSortMenuItemMnemonic();
                        string = ((SCHeader6)sCHeaderArray[nArray[i]]).getSortMenuItemHint();
                        n = ((SCHeader6)sCHeaderArray[nArray[i]]).getSortMenuItemMnemonicIndex();
                    } else if (sCHeaderArray[nArray[i]] instanceof SCHeader5) {
                        string3 = ((SCHeader5)sCHeaderArray[nArray[i]]).getSortMenuItemName();
                        c = ((SCHeader5)sCHeaderArray[nArray[i]]).getSortMenuItemMnemonic();
                        string = ((SCHeader5)sCHeaderArray[nArray[i]]).getSortMenuItemHint();
                        n = -1;
                    } else if (sCHeaderArray[nArray[i]] instanceof SCHeader4) {
                        string3 = sCHeaderArray[nArray[i]].getText();
                        c = ((SCHeader4)sCHeaderArray[nArray[i]]).getSortMenuItemMnemonic();
                        string = ((SCHeader4)sCHeaderArray[nArray[i]]).getSortMenuItemHint();
                        n = -1;
                    } else {
                        string3 = sCHeaderArray[nArray[i]].getText();
                        c = '\u0000';
                        string = "";
                        n = -1;
                    }
                    if (string == null || string.trim().length() == 0) {
                        string = SybMessageFormat.format((String)ScjSession.getString("STR_VIEW_SORT_HINT"), (Object[])new Object[]{string3});
                    }
                    BaseMenuItem baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJRadioButtonMenuItem(string3, nArray[i] == Math.abs(DetailsList.sortedColumn) - 1)), c, string, 1026, this._viewerManager, i, n);
                    sCMenu.getJMenuItem().add(baseMenuItem.getJMenuItem());
                }
            }
            sCMenu.getJMenuItem().setEnabled(true);
        }
    }

    void updateViewGoToMenu(int n) {
        SCMenuItem[] sCMenuItemArray = this._topMenu[2].getMenuItems();
        SCMenuItem[] sCMenuItemArray2 = ((SCMenu)sCMenuItemArray[4]).getMenuItems();
        for (int i = 0; i < sCMenuItemArray2.length; ++i) {
            if (sCMenuItemArray2[i].getCommandId() == 1012) {
                sCMenuItemArray2[i].getJMenuItem().setEnabled((n & 1) != 0);
                continue;
            }
            if (sCMenuItemArray2[i].getCommandId() == 1013) {
                sCMenuItemArray2[i].getJMenuItem().setEnabled((n & 2) != 0);
                continue;
            }
            if (sCMenuItemArray2[i].getCommandId() != 1014) continue;
            sCMenuItemArray2[i].getJMenuItem().setEnabled((n & 4) != 0);
        }
    }

    void enableConnectionsMenuItems(int n) {
        SCMenuItem[] sCMenuItemArray = this._topMenu[4].getMenuItems();
        for (int i = 0; sCMenuItemArray != null && i < sCMenuItemArray.length; ++i) {
            if (sCMenuItemArray[i].getCommandId() == 1019) {
                sCMenuItemArray[i].getJMenuItem().setEnabled((n & 0x80) != 0);
                continue;
            }
            if (sCMenuItemArray[i].getCommandId() != 1020) continue;
            sCMenuItemArray[i].getJMenuItem().setEnabled((n & 0x40) != 0);
        }
    }

    private void updateConnectionsMenu() {
        Enumeration enumeration = null;
        ProviderEntry providerEntry = null;
        SCProvider sCProvider = null;
        BaseMenuItem baseMenuItem = null;
        String string = null;
        Vector vector = null;
        ArrayList<String> arrayList = null;
        boolean bl = false;
        SCMenuItem[] sCMenuItemArray = this._topMenu[4].getMenuItems();
        JMenuItem jMenuItem = null;
        this._topMenu[4].getJMenuItem().removeAll();
        int n = -1;
        enumeration = this._viewerSupport.getProviders().getProviderList();
        while (enumeration.hasMoreElements()) {
            providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded() || (sCProvider = providerEntry.getProvider()) instanceof SCProvider4 && (!(sCProvider instanceof SCProvider4) || !((SCProvider4)sCProvider).supportsConnecting())) continue;
            string = sCProvider instanceof SCProvider4 ? ((SCProvider4)sCProvider).getProviderConnectionsMenuItemText() : sCProvider.getDisplayName();
            baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJMenuItem(SybMessageFormat.format((String)ScjSession.getString("STR_CONNECTIONS_CONNECT_TO"), (Object[])new Object[]{string}))), null, null, 1305 + ++n, this._viewerManager);
            if (sCProvider instanceof SCProvider4) {
                baseMenuItem.getJMenuItem().setIcon(((SCProvider4)sCProvider).getProviderIcon());
            } else {
                baseMenuItem.getJMenuItem().setIcon(EMPTY_ICON);
            }
            this._topMenu[4].getJMenuItem().add(baseMenuItem.getJMenuItem());
        }
        this._topMenu[4].getJMenuItem().add(sCMenuItemArray[0].getJMenuItem());
        arrayList = this._session.getConnectionProfileMRUList(this._viewerSupport);
        if (arrayList.size() > 0) {
            n = 0;
            int n2 = 0;
            for (int i = 0; i < 5 && i * 2 + 1 < arrayList.size(); ++i) {
                if (!bl) {
                    ((JMenu)this._topMenu[4].getJMenuItem()).addSeparator();
                    bl = true;
                }
                baseMenuItem = new BaseMenuItem((JMenuItem)((Object)new SCJMenuItem(String.valueOf(n2 + 1) + " " + arrayList.get(n))), String.valueOf(n2 + 1), null, 1300 + n2, this._viewerManager);
                ++n2;
                baseMenuItem.getJMenuItem().setIcon(JCOMP_CONN_PROFILE_ICON);
                this._topMenu[4].getJMenuItem().add(baseMenuItem.getJMenuItem());
                n += 2;
            }
        }
        ((JMenu)this._topMenu[4].getJMenuItem()).addSeparator();
        vector = this._viewerSupport.getConnectionList();
        String string2 = vector.size() > 1 ? ScjSession.getString("STR_CONNECTIONS_DISCONNECT_MANY") : ScjSession.getString("STR_CONNECTIONS_DISCONNECT");
        jMenuItem = sCMenuItemArray[2].getJMenuItem();
        jMenuItem.setText(string2);
        this._topMenu[4].getJMenuItem().add(jMenuItem);
    }

    private void updateHelpMenu(JMenuItem[] jMenuItemArray) {
        SCMenuItem[] sCMenuItemArray;
        boolean bl = false;
        this._topMenu[5].getJMenuItem().removeAll();
        if (jMenuItemArray != null) {
            int n;
            for (n = 0; n < jMenuItemArray.length; ++n) {
                if (jMenuItemArray[n] == null || jMenuItemArray[n].getIcon() == null) continue;
                bl = true;
                break;
            }
            for (n = 0; n < jMenuItemArray.length; ++n) {
                if (jMenuItemArray[n] == null) {
                    ((JMenu)this._topMenu[5].getJMenuItem()).addSeparator();
                    continue;
                }
                if (jMenuItemArray[n].getIcon() == null || jMenuItemArray[n].getIcon() == EMPTY_ICON) {
                    if (bl) {
                        jMenuItemArray[n].setIcon(EMPTY_ICON);
                    } else {
                        jMenuItemArray[n].setIcon(null);
                    }
                }
                this._topMenu[5].getJMenuItem().add(jMenuItemArray[n]);
            }
        }
        if ((sCMenuItemArray = this._topMenu[5].getMenuItems()) != null) {
            for (int i = 0; i < sCMenuItemArray.length; ++i) {
                if (sCMenuItemArray[i].getJMenuItem() == null) {
                    ((JMenu)this._topMenu[5].getJMenuItem()).addSeparator();
                    continue;
                }
                if (bl) {
                    sCMenuItemArray[i].getJMenuItem().setIcon(EMPTY_ICON);
                } else {
                    sCMenuItemArray[i].getJMenuItem().setIcon(null);
                }
                this._topMenu[5].getJMenuItem().add(sCMenuItemArray[i].getJMenuItem());
            }
        }
    }

    private void updateViewMenu() {
        DetailsList detailsList = null;
        boolean bl = false;
        JMenu jMenu = null;
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        detailsList = this._viewerManager.getContentPane().getDetailsListForActiveDetailsPanel();
        if (detailsList != null) {
            if (this._viewerManager.getContentPane().getDetailsContainerForActiveDetailsPanel() != null) {
                if (this._viewerManager.getContentPane().getDetailsContainerForActiveDetailsPanel().getHeadingInfo().length > 1) {
                    bl = true;
                }
            } else if (this._viewerManager.getContentPane().getTreeContainerForActiveDetailsPanel() instanceof SCContainer3 && this._viewerManager.getContentPane().getTreeContainerForActiveDetailsPanel().getHeadingInfo().length > 1) {
                bl = true;
            }
            ((JMenu)this._topMenu[2].getJMenuItem()).getItem(2).setEnabled(bl);
        } else {
            ((JMenu)this._topMenu[2].getJMenuItem()).getItem(2).setEnabled(false);
        }
        jMenu = (JMenu)this._topMenu[2].getJMenuItem();
        jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenu.getItem(9);
        jCheckBoxMenuItem.setState(this._viewerManager.getMainPanel().isTaskPaneVisible());
        jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenu.getItem(10);
        jCheckBoxMenuItem.setState(this._viewerManager.getMainPanel().isFolderPaneVisible());
        jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenu.getItem(11);
        jCheckBoxMenuItem.setState(this._viewerManager.getMainPanel().isSearchPaneVisible());
        if (jMenu.getMenuComponentCount() > 13) {
            jCheckBoxMenuItem = (JCheckBoxMenuItem)((JMenu)this._topMenu[2].getJMenuItem()).getItem(13);
            jCheckBoxMenuItem.setState(this._viewerManager.getMainPanel().isBottomJComponentVisible());
        }
    }

    void updateViewMenu(String string, String string2, boolean bl) {
        if (((JMenu)this._topMenu[2].getJMenuItem()).getItemCount() == 14) {
            ((JMenu)this._topMenu[2].getJMenuItem()).remove(13);
            ((JMenu)this._topMenu[2].getJMenuItem()).remove(12);
        }
        if (string != null) {
            this._topMenu[2].addMenuItem(new BaseMenuItem());
            BaseMenuItem baseMenuItem = new BaseMenuItem(new JCheckBoxMenuItem(VIEW_BTM_COMP_ACC + string), VIEW_BTM_COMP_ACC, string2, 1005, this._viewerManager);
            baseMenuItem.getJMenuItem().setAccelerator(ALT_1);
            ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setIcon(EMPTY_ICON);
            ((JCheckBoxMenuItem)baseMenuItem.getJMenuItem()).setState(bl);
            this._topMenu[2].addMenuItem(baseMenuItem);
        }
    }

    private void replaceDefaultViewerAccelerators() {
        Enumeration<Object> enumeration = this._menuItemAccelerators.keys();
        while (enumeration.hasMoreElements()) {
            KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
            JMenuItem jMenuItem = this._menuItemAccelerators.get(keyStroke);
            jMenuItem.setAccelerator(keyStroke);
        }
        this._viewerManager.getMainPanel().getToolBar().registerF11Key(true);
    }

    private void removeViewerAccelerator(JMenuItem jMenuItem) {
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        if (keyStroke != null) {
            Enumeration<Object> enumeration = this._menuItemAccelerators.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke2 = (KeyStroke)enumeration.nextElement();
                if (keyStroke.getKeyCode() != keyStroke2.getKeyCode() || keyStroke.getModifiers() != keyStroke2.getModifiers()) continue;
                JMenuItem jMenuItem2 = this._menuItemAccelerators.get(keyStroke2);
                jMenuItem2.setAccelerator(null);
                return;
            }
            if (keyStroke.getKeyCode() == F11.getKeyCode() && keyStroke.getModifiers() == F11.getModifiers()) {
                this._viewerManager.getMainPanel().getToolBar().registerF11Key(false);
            }
        }
    }

    private void removeViewerAccelerator(JMenu[] jMenuArray) {
        for (int i = 0; i < jMenuArray.length; ++i) {
            JMenu jMenu = jMenuArray[i];
            for (int j = 0; j < jMenu.getItemCount(); ++j) {
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (jMenuItem instanceof JMenu) {
                    this.removeViewerAccelerator(new JMenu[]{(JMenu)jMenuItem});
                    continue;
                }
                if (!(jMenuItem instanceof JMenuItem)) continue;
                this.removeViewerAccelerator(jMenuItem);
            }
        }
    }

    void updateProviderMenus(ProviderEntry providerEntry, boolean bl) {
        if (providerEntry == null) {
            int n;
            if (this._providerTopLevelJMenus != null) {
                for (n = 0; n < this._providerTopLevelJMenus.length; ++n) {
                    this._menuBar.remove(this._providerTopLevelJMenus[n]);
                }
                this._providerTopLevelJMenus = null;
            }
            if (this._providerMenuBarBaseMenus != null) {
                for (n = 0; n < this._providerMenuBarBaseMenus.length; ++n) {
                    this._menuBar.remove(this._providerMenuBarBaseMenus[n].getJMenuItem());
                }
                this._providerMenuBarBaseMenus = null;
            }
            this.replaceDefaultViewerAccelerators();
            this._menuBar.updateUI();
            return;
        }
        if (!bl || bl && providerEntry == this._viewerManager.getProviderEntryForSelectedTreeItem()) {
            JMenu[] jMenuArray = providerEntry.getTopLevelJMenus();
            if (jMenuArray == null && this._providerTopLevelJMenus == null) {
                return;
            }
            boolean bl2 = false;
            if (this._providerTopLevelJMenus != null && jMenuArray != null && jMenuArray.length == this._providerTopLevelJMenus.length) {
                for (int i = 0; i < jMenuArray.length; ++i) {
                    if (jMenuArray[i] == this._providerTopLevelJMenus[i]) continue;
                    bl2 = true;
                    break;
                }
            } else {
                bl2 = true;
            }
            SCMenu[] sCMenuArray = null;
            SCDetailsContainer sCDetailsContainer = this._viewerManager.getContentPane().getDetailsContainerForActiveDetailsPanel();
            if (sCDetailsContainer != null) {
                sCMenuArray = sCDetailsContainer.getContextMenuBarMenus();
            } else {
                SCContainer sCContainer = this._viewerManager.getContentPane().getTreeContainerForActiveDetailsPanel();
                if (sCContainer instanceof SCContainer3) {
                    sCMenuArray = ((SCContainer3)sCContainer).getContextMenuBarMenus();
                }
            }
            if (!(bl2 || sCMenuArray == null && this._providerMenuBarBaseMenus == null)) {
                if (this._providerMenuBarBaseMenus != null && sCMenuArray != null && sCMenuArray.length == this._providerMenuBarBaseMenus.length) {
                    for (int i = 0; i < sCMenuArray.length; ++i) {
                        if (sCMenuArray[i].getName().equals(this._providerMenuBarBaseMenus[i].getName())) continue;
                        bl2 = true;
                        break;
                    }
                } else {
                    bl2 = true;
                }
            }
            if (bl2) {
                if (this._providerTopLevelJMenus != null) {
                    for (int i = 0; i < this._providerTopLevelJMenus.length; ++i) {
                        this._menuBar.remove(this._providerTopLevelJMenus[i]);
                    }
                }
                this._providerTopLevelJMenus = jMenuArray;
                if (this._providerMenuBarBaseMenus != null) {
                    for (int i = 0; i < this._providerMenuBarBaseMenus.length; ++i) {
                        this._menuBar.remove(this._providerMenuBarBaseMenus[i].getJMenuItem());
                    }
                }
                this._providerMenuBarBaseMenus = null;
                this._menuBar.remove(this._topMenu[5].getJMenu());
                this.replaceDefaultViewerAccelerators();
                if (this._providerTopLevelJMenus != null) {
                    this.removeViewerAccelerator(this._providerTopLevelJMenus);
                    for (int i = 0; i < this._providerTopLevelJMenus.length; ++i) {
                        this._menuBar.add(this._providerTopLevelJMenus[i]);
                    }
                }
                if (sCMenuArray != null) {
                    this._providerMenuBarBaseMenus = new BaseMenu[sCMenuArray.length];
                    for (int i = 0; i < sCMenuArray.length; ++i) {
                        JMenu jMenu = (JMenu)sCMenuArray[i].getJMenuItem();
                        this._providerMenuBarBaseMenus[i] = new BaseMenu(jMenu, null);
                        BaseMenuItem[] baseMenuItemArray = this.bindMenuItems(sCMenuArray[i].getMenuItems());
                        for (int j = 0; j < baseMenuItemArray.length; ++j) {
                            jMenu.add(baseMenuItemArray[j].getJMenuItem());
                            this._providerMenuBarBaseMenus[i].addMenuItem(baseMenuItemArray[j]);
                            this.removeViewerAccelerator(baseMenuItemArray[j].getJMenuItem());
                        }
                        this._menuBar.add(jMenu);
                    }
                }
                this._menuBar.add(this._topMenu[5].getJMenu());
                this._menuBar.updateUI();
            }
        }
    }

    BaseMenuItem[] bindMenuItems(SCMenuItem[] sCMenuItemArray) {
        BaseMenuItem[] baseMenuItemArray = new BaseMenuItem[sCMenuItemArray.length];
        for (int i = 0; i < sCMenuItemArray.length; ++i) {
            if (sCMenuItemArray[i] instanceof SCMenu) {
                baseMenuItemArray[i] = new BaseMenu((JMenu)sCMenuItemArray[i].getJMenuItem(), null);
                BaseMenuItem[] baseMenuItemArray2 = this.bindMenuItems(((SCMenu)sCMenuItemArray[i]).getMenuItems());
                for (int j = 0; j < baseMenuItemArray2.length; ++j) {
                    if (baseMenuItemArray2[j] == null) {
                        ((BaseMenu)baseMenuItemArray[i]).addMenuItem(new BaseMenuItem());
                        continue;
                    }
                    ((BaseMenu)baseMenuItemArray[i]).addMenuItem(baseMenuItemArray2[j]);
                }
                continue;
            }
            if (sCMenuItemArray[i] == null) continue;
            baseMenuItemArray[i] = new BaseMenuItem(sCMenuItemArray[i].getJMenuItem(), null, sCMenuItemArray[i].getHintText(), sCMenuItemArray[i].getCommandId(), this._viewerManager);
        }
        return baseMenuItemArray;
    }

    void enableProviderMenusByCommandIdList(int[] nArray) {
        if (this._providerMenuBarBaseMenus != null) {
            for (int i = 0; i < this._providerMenuBarBaseMenus.length; ++i) {
                this.enableProviderMenusByCommandIdList(nArray, this._providerMenuBarBaseMenus[i]);
            }
        }
    }

    private void enableProviderMenusByCommandIdList(int[] nArray, BaseMenu baseMenu) {
        SCMenuItem[] sCMenuItemArray = baseMenu.getMenuItems();
        if (sCMenuItemArray != null) {
            for (int i = 0; i < sCMenuItemArray.length; ++i) {
                if (sCMenuItemArray[i] instanceof BaseMenu) {
                    this.enableProviderMenusByCommandIdList(nArray, (BaseMenu)sCMenuItemArray[i]);
                    continue;
                }
                if (nArray == null) {
                    sCMenuItemArray[i].getJMenuItem().setEnabled(false);
                    continue;
                }
                boolean bl = false;
                for (int j = 0; j < nArray.length; ++j) {
                    if (sCMenuItemArray[i].getCommandId() != nArray[j]) continue;
                    bl = true;
                    break;
                }
                sCMenuItemArray[i].getJMenuItem().setEnabled(bl);
            }
        }
    }

    void setEnabled(boolean bl) {
        this._menuBar.setEnabled(bl);
    }

    void releaseResources() {
        this._viewerManager.getViewerFrame().setJMenuBar(null);
        this._topMenu[0].getJMenu().removeMenuListener(this);
        this._topMenu[1].getJMenu().removeMenuListener(this);
        this._topMenu[2].getJMenu().removeMenuListener(this);
        this._topMenu[3].getJMenu().removeMenuListener(this);
        this._topMenu[4].getJMenu().removeMenuListener(this);
        this._topMenu[5].getJMenu().removeMenuListener(this);
        this._session.removeSessionListener(this);
        this._viewerManager = null;
        this._session = null;
        this._menuBar = null;
        this._topMenu = null;
        this._extendedMenus.clear();
        this._extendedMenus = null;
        this._menuItemAccelerators.clear();
        this._menuItemAccelerators = null;
        this._providerTopLevelJMenus = null;
        this._providerMenuBarBaseMenus = null;
    }

    JMenu getHelpMenu() {
        return this._topMenu[5].getJMenu();
    }

    void addMenuExtensions() {
        Enumeration enumeration = this._viewerSupport.getProviders().getProviderList();
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded()) continue;
            this.addProviderMenuExtension(providerEntry);
        }
    }

    private void addProviderMenuExtension(ProviderEntry providerEntry) {
        JMenu jMenu = this._extendedMenus.get(providerEntry);
        if (jMenu != null) {
            return;
        }
        jMenu = this._viewerManager.buildExtendedMenu(providerEntry);
        if (jMenu != null) {
            if (this._extendedMenus.isEmpty()) {
                ((JMenu)this._topMenu[3].getJMenuItem()).addSeparator();
            }
            this._extendedMenus.put(providerEntry, jMenu);
            if (jMenu.getIcon() == null) {
                jMenu.setIcon(EMPTY_ICON);
            }
            this._topMenu[3].getJMenuItem().add(jMenu);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        if (menuEvent.getSource() == this._topMenu[5].getJMenu()) {
            this.updateHelpMenu(this._viewerManager.buildHelpMenuItems());
        } else if (menuEvent.getSource() == this._topMenu[2].getJMenu()) {
            this.updateViewMenu();
            this.updateViewSortMenu();
        } else if (menuEvent.getSource() == this._topMenu[4].getJMenu()) {
            this.updateConnectionsMenu();
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        this._viewerManager.setStatusMenuHint(null);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        this._viewerManager.setStatusMenuHint(null);
    }

    @Override
    public void sessionChanged(SessionEvent sessionEvent) {
        if (sessionEvent.getEventId() == SessionEvent.PROVIDER_CHANGE_ID) {
            ProviderEntry providerEntry = (ProviderEntry)sessionEvent.getSource();
            if (providerEntry.isLoaded()) {
                this.addProviderMenuExtension(providerEntry);
            } else {
                JMenu jMenu = this._extendedMenus.get(providerEntry);
                if (jMenu != null) {
                    this._extendedMenus.remove(providerEntry);
                    this._topMenu[3].getJMenuItem().remove(jMenu);
                    if (this._extendedMenus.isEmpty()) {
                        int n = this._topMenu[3].getJMenu().getItemCount();
                        this._topMenu[3].getJMenuItem().remove(n - 1);
                    }
                }
                this._viewerManager.removeMenuExtensionEntries(providerEntry);
            }
            this.updateHelpMenu(this._viewerManager.buildHelpMenuItems());
        }
    }
}

