/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.DefaultSCPageController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCProvider;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.IHelpConstants;
import com.sybase.central.viewer.PluginDlgJPanel;
import com.sybase.central.viewer.PluginPropertyDlg;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.Providers;
import com.sybase.central.viewer.RegisterPlugInWizard;
import com.sybase.central.viewer.SCButton;
import com.sybase.central.viewer.SCIconTextUserData;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.SCMultiList;
import com.sybase.central.viewer.SCSortingTableModel;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.DialogUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class PluginDlg
extends DefaultSCPageController
implements ScjResourceConstants,
IHelpConstants,
ActionListener,
ListSelectionListener {
    private final int NAME_COL = 0;
    private final int VERSION_COL = 1;
    private final int STATUS_COL = 2;
    private final int STARTUP_COL = 3;
    private final int LOADER_COL = 4;
    private final int CLASSPATH_COL = 5;
    private final String MANIFEST_CLASS = "SybaseCentral-PluginClass";
    private ScjSession _session = null;
    private ScjViewerSupport _viewerSupport = null;
    private SCButton _jcb_load;
    private SCButton _jcb_unload;
    private SCButton _jcb_register;
    private SCButton _jcb_unregister;
    private SCButton _jcb_close;
    private SCButton _jcb_properties;
    private SCButton _jcb_help;
    private SCMultiList _scmultil_list;
    private Providers _providers;
    private MouseListener _mouseListener = null;

    PluginDlg(SCDialogSupport sCDialogSupport, ScjSession scjSession, ScjViewerSupport scjViewerSupport) {
        super(sCDialogSupport, new PluginDlgJPanel());
        this._session = scjSession;
        this._viewerSupport = scjViewerSupport;
        this._providers = scjViewerSupport.getProviders();
        PluginDlgJPanel pluginDlgJPanel = (PluginDlgJPanel)this.getJPanel();
        JLabel jLabel = pluginDlgJPanel.jlabel_label;
        this._jcb_load = pluginDlgJPanel.jcb_load;
        this._jcb_unload = pluginDlgJPanel.jcb_unload;
        this._jcb_register = pluginDlgJPanel.jcb_register;
        this._jcb_unregister = pluginDlgJPanel.jcb_unregister;
        this._jcb_close = pluginDlgJPanel.jcb_close;
        this._jcb_properties = pluginDlgJPanel.jcb_properties;
        this._jcb_help = pluginDlgJPanel.jcb_help;
        this._scmultil_list = pluginDlgJPanel.scmultil_list;
        jLabel.setText(ScjSession.getString("STR_PLUGIN_LABEL"));
        jLabel.setLabelFor(this._scmultil_list);
        this._jcb_load.setText(ScjSession.getString("STR_PLUGIN_LOAD_BTN"));
        this._jcb_unload.setText(ScjSession.getString("STR_PLUGIN_UNLOAD_BTN"));
        this._jcb_register.setText(ScjSession.getString("STR_PLUGIN_REG_BTN"));
        this._jcb_unregister.setText(ScjSession.getString("STR_PLUGIN_UNREG_BTN"));
        this._jcb_close.setText(ScjSession.getString("STR_PLUGIN_CLOSE_BTN"));
        this._jcb_properties.setText(ScjSession.getString("STR_PLUGIN_PROP_BTN"));
        this._jcb_help.setText(ScjSession.getString("STR_DLG_HELP_BUTTON"));
        this._jcb_register.setEnabled(this._session.isSCRepositoryWriteable());
        this._jcb_unregister.setEnabled(this._session.isSCRepositoryWriteable());
        JComponent[] jComponentArray = new JComponent[]{this._jcb_load, this._jcb_unload, this._jcb_register, this._jcb_unregister, this._jcb_close, this._jcb_properties, this._jcb_help};
        DialogUtils.makeComponentsSameWidth((JComponent[])jComponentArray);
        this._scmultil_list.setSelectionMode(0);
        this._scmultil_list.setAutoResizeMode(0);
        this._scmultil_list.setColumnHeadings(new StringBuffer(ScjSession.getString("STR_PLUGIN_NAME")).append(", ").append(ScjSession.getString("STR_PLUGIN_VERSION")).append(", ").append(ScjSession.getString("STR_PLUGIN_STATUS")).append(", ").append(ScjSession.getString("STR_PLUGIN_STARTUP")).append(", ").append(ScjSession.getString("STR_PLUGIN_CLASSLOADER")).append(", ").append(ScjSession.getString("STR_PLUGIN_CLASSPATH")).toString());
        this._scmultil_list.setColumnWidths("195, 120, 85, 70, 110, 400");
        this._scmultil_list.getScrollPane().setPreferredSize(new Dimension(515, 200));
        this._scmultil_list.setColumnHasIconTextData(0, true);
        this._jcb_load.addActionListener(this);
        this._jcb_unload.addActionListener(this);
        this._jcb_register.addActionListener(this);
        this._jcb_unregister.addActionListener(this);
        this._jcb_close.addActionListener(this);
        this._jcb_properties.addActionListener(this);
        this._jcb_help.addActionListener(this);
        this._scmultil_list.addListSelectionListener(this);
        this.initMouseListener();
    }

    @Override
    public void onInitDialog() {
        this.fillPluginList();
        this._dialogSupport.getJDialog().getRootPane().setDefaultButton((JButton)((Object)this._jcb_register));
        this._jcb_close.requestFocusInWindow();
    }

    @Override
    public void onHelp() {
        this._session.showHelpIndex("HELP_PLUGINDLG_INDEX", this._dialogSupport);
    }

    @Override
    public void releaseResources() {
        this._jcb_load.removeActionListener(this);
        this._jcb_unload.removeActionListener(this);
        this._jcb_register.removeActionListener(this);
        this._jcb_unregister.removeActionListener(this);
        this._jcb_close.removeActionListener(this);
        this._jcb_properties.removeActionListener(this);
        this._jcb_help.removeActionListener(this);
        this._scmultil_list.removeMouseListener(this._mouseListener);
        this._scmultil_list.removeListSelectionListener(this);
        this._scmultil_list.releaseResources();
        super.releaseResources();
    }

    private void fillPluginList() {
        Enumeration enumeration = this._providers.getProviderList();
        this._scmultil_list.removeListSelectionListener(this);
        int n = this._scmultil_list.getSelectedRow();
        this._scmultil_list.clear();
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            String string = providerEntry.getName();
            String string2 = providerEntry.getVersion();
            String string3 = providerEntry.isLoaded() ? ScjSession.getString("STR_PLUGIN_LOADED") : ScjSession.getString("STR_PLUGIN_UNLOADED");
            String string4 = providerEntry.getClasspath();
            String string5 = providerEntry.isClassloaderUsed() ? ScjSession.getString("STR_SCJ_YES") : ScjSession.getString("STR_SCJ_NO");
            String string6 = this._session.getUserPrefRepositoryInfo().isProviderAutoload(providerEntry.getProviderId()) ? ScjSession.getString("STR_PLUGIN_AUTOMATIC") : ScjSession.getString("STR_PLUGIN_MANUAL");
            Vector<String> vector = new Vector<String>();
            vector.addElement(string);
            vector.addElement(string2);
            vector.addElement(string3);
            vector.addElement(string6);
            vector.addElement(string5);
            vector.addElement(string4);
            this._scmultil_list.addRowWithIcon(SCImageLoader.getImageIcon("plugin16", 1006), vector);
        }
        this._scmultil_list.sort();
        if (n >= 0 && n < this._providers.getProviderCount()) {
            this._scmultil_list.selectRow(n);
        } else if (this._scmultil_list.getRowCount() > 0) {
            this._scmultil_list.selectRow(0);
        }
        this._scmultil_list.addListSelectionListener(this);
        this.enableButtons();
        ((ViewerManager)this._viewerSupport.getViewerManager()).getMainPanel().getTaskPane().updateTasks();
    }

    private void initMouseListener() {
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() > 1 && (n = PluginDlg.this._scmultil_list.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()))) > -1) {
                    PluginDlg.this.propertiesButtonPressed();
                }
            }
        };
        this._scmultil_list.addMouseListener(this._mouseListener);
    }

    private void enableButtons() {
        if (this._scmultil_list.getSelectedRow() < 0) {
            this._jcb_load.setEnabled(false);
            this._jcb_unload.setEnabled(false);
            this._jcb_unregister.setEnabled(false);
            this._jcb_properties.setEnabled(false);
        } else if (this._scmultil_list.getSelectedRow() >= 0) {
            int n = this._scmultil_list.getSelectedRow();
            ProviderEntry providerEntry = this._providers.getProviderEntry(this.getProviderEntryIndexForTableIndex(n));
            this._jcb_unregister.setEnabled(this._session.isSCRepositoryWriteable());
            this._jcb_load.setEnabled(!providerEntry.isLoaded());
            this._jcb_unload.setEnabled(providerEntry.isLoaded());
            this._jcb_properties.setEnabled(true);
        }
        this._session.updateConnectionOptions();
    }

    private void propertiesButtonPressed() {
        int n = this._scmultil_list.getSelectedRow();
        ProviderEntry providerEntry = this._providers.getProviderEntry(this.getProviderEntryIndexForTableIndex(n));
        PluginPropertyDlg.displayPropertyDialog(this._dialogSupport.getJDialog(), this._session, this._viewerSupport, providerEntry);
        String string = this._session.getUserPrefRepositoryInfo().isProviderAutoload(providerEntry.getProviderId()) ? ScjSession.getString("STR_PLUGIN_AUTOMATIC") : ScjSession.getString("STR_PLUGIN_MANUAL");
        this._scmultil_list.setValueAt(string, n, 3);
        String string2 = providerEntry.isClassloaderUsed() ? ScjSession.getString("STR_SCJ_YES") : ScjSession.getString("STR_SCJ_NO");
        this._scmultil_list.setValueAt(string2, n, 4);
        String string3 = providerEntry.getClasspath();
        this._scmultil_list.setValueAt(string3, n, 5);
    }

    private void registerButtonPressed() {
        if (RegisterPlugInWizard.displayWizardDialog(this._dialogSupport.getJDialog(), this._session, this._viewerSupport)) {
            this.fillPluginList();
        }
    }

    private void unregisterButtonPressed() {
        int n = this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), ScjSession.getString("STR_PLUGIN_UNREGISTER"), 0, 3);
        if (n == 0) {
            int n2 = this._scmultil_list.getSelectedRow();
            ProviderEntry providerEntry = this._providers.getProviderEntry(this.getProviderEntryIndexForTableIndex(n2));
            if (providerEntry.isLoaded() && !this.unloadProvider(providerEntry, true)) {
                return;
            }
            this._providers.removeProviderEntry(providerEntry);
            this._session.providerEntryChanged(providerEntry);
            this.fillPluginList();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean loadProvider(ProviderEntry var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadButtonPressed() {
        int n = this._scmultil_list.getSelectedRow();
        ProviderEntry providerEntry = this._providers.getProviderEntry(this.getProviderEntryIndexForTableIndex(n));
        if (this.loadProvider(providerEntry)) {
            providerEntry.setName(providerEntry.getProvider().getDisplayName());
            this._scmultil_list.setValueAt(new SCIconTextUserData(SCImageLoader.getImageIcon("plugin16", 1006), providerEntry.getProvider().getDisplayName()), n, 0);
            providerEntry.setVersion(providerEntry.getProvider().getDisplayVersion());
            this._scmultil_list.setValueAt(providerEntry.getProvider().getDisplayVersion(), n, 1);
            this._scmultil_list.setValueAt(ScjSession.getString("STR_PLUGIN_LOADED"), n, 2);
            this.enableButtons();
            ((ViewerManager)this._viewerSupport.getViewerManager()).getMainPanel().getTaskPane().updateTasks();
        }
    }

    private ProviderEntry[] getLoadedSharedClassloaderProviders(ProviderEntry providerEntry) {
        Enumeration enumeration = this._providers.getProviderList();
        String string = "";
        ArrayList<ProviderEntry> arrayList = new ArrayList<ProviderEntry>();
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry2 = (ProviderEntry)enumeration.nextElement();
            string = providerEntry2.getClassloaderId();
            if (string == null || string.length() <= 0 || !string.equals(providerEntry.getClassloaderId()) || !providerEntry2.isLoaded() || providerEntry2 == providerEntry) continue;
            arrayList.add(providerEntry2);
        }
        return arrayList.toArray(new ProviderEntry[arrayList.size()]);
    }

    private void unloadButtonPressed() {
        int n = this._scmultil_list.getSelectedRow();
        if (this.unloadProvider(this._providers.getProviderEntry(this.getProviderEntryIndexForTableIndex(n)), false)) {
            this.fillPluginList();
        }
    }

    private boolean unloadProvider(ProviderEntry providerEntry, boolean bl) {
        int n;
        ProviderEntry[] providerEntryArray = null;
        int n2 = 1;
        SCProvider sCProvider = null;
        providerEntryArray = this.getLoadedSharedClassloaderProviders(providerEntry);
        if (providerEntryArray.length > 0) {
            n2 = bl ? this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), ScjSession.getString("STR_PLUGIN_WARN_UNREG"), 0, 3) : this._viewerSupport.messageBoxString(this._dialogSupport.getJDialog(), ScjSession.getString("STR_PLUGIN_WARN_UNLOAD"), 0, 3);
            if (n2 == 1) {
                return false;
            }
            for (n = 0; n < providerEntryArray.length; ++n) {
                sCProvider = providerEntryArray[n].getProvider();
                if (sCProvider.isOkToShutdown((JFrame)this._dialogSupport.getJDialog().getParent())) continue;
                return false;
            }
        }
        if (!(sCProvider = providerEntry.getProvider()).isOkToShutdown((JFrame)this._dialogSupport.getJDialog().getParent())) {
            return false;
        }
        sCProvider.shutdown();
        if (providerEntryArray.length > 0) {
            for (n = 0; n < providerEntryArray.length; ++n) {
                sCProvider = providerEntryArray[n].getProvider();
                sCProvider.shutdown();
            }
        }
        providerEntry.unloadProvider();
        this._session.providerEntryChanged(providerEntry);
        if (providerEntryArray.length > 0) {
            for (n = 0; n < providerEntryArray.length; ++n) {
                providerEntryArray[n].unloadProvider();
                this._session.providerEntryChanged(providerEntryArray[n]);
            }
        }
        if (providerEntryArray.length > 0) {
            for (n = 0; n < providerEntryArray.length; ++n) {
                this.loadProvider(providerEntryArray[n]);
                this._session.providerEntryChanged(providerEntryArray[n]);
            }
        }
        return true;
    }

    @Override
    public boolean onCancel() {
        this._session.saveSCPreferences();
        PluginDlg pluginDlg = this;
        pluginDlg._session.saveUserPreferences();
        return super.onCancel();
    }

    private void closeButtonPressed() {
        this._session.saveSCPreferences();
        PluginDlg pluginDlg = this;
        pluginDlg._session.saveUserPreferences();
        this._dialogSupport.closeDialog(true);
        this._dialogSupport.releaseResources();
    }

    private int getProviderEntryIndexForTableIndex(int n) {
        if (n < 0) {
            return -1;
        }
        return ((SCSortingTableModel)this._scmultil_list.getModel()).getDataIndexForTableIndex(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._jcb_load) {
            this.loadButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_unload) {
            this.unloadButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_close) {
            this.closeButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_register) {
            this.registerButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_unregister) {
            this.unregisterButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_properties) {
            this.propertiesButtonPressed();
        } else if (actionEvent.getSource() == this._jcb_help) {
            this.onHelp();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this._scmultil_list.getSelectionModel()) {
            this.enableButtons();
        }
    }
}

