/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer;
import com.sybase.central.SCProfile;
import com.sybase.central.SCProvider;
import com.sybase.central.SCProviderLoader2;
import com.sybase.central.viewer.ProfilesKey;
import com.sybase.central.viewer.Providers;
import com.sybase.central.viewer.RepositoryKey;
import com.sybase.central.viewer.SCClassLoader;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JMenu;

class ProviderEntry {
    private Providers _providers;
    private String _internalName;
    private RepositoryKey _key;
    private SCProvider _provider;
    private SCClassLoader _loader = null;
    private RepositoryKey _profilesKey = null;
    private ProfilesKey _profile = null;
    private boolean _loaded = false;
    private Hashtable<SCContainer, SCContainer> _topLevelContainers = new Hashtable();
    private JComponent[] _toolBarJComponents = null;
    private JMenu[] _topLevelJMenus = null;
    private JComponent _statusBarJComponent = null;
    private JComponent _bottomJComponent = null;
    private String _bottomJComponentMenuName = " ";
    private String _bottomJComponentMenuHint = " ";
    private boolean _bottomJComponentVisible = false;
    static final String PROVIDERS_CLASS = "Provider";
    static final String PROVIDERS_CLASSPATH = "Classpath";
    static final String PROVIDERS_ADDITIONAL_CLASSPATH = "AdditionalClasspath";
    static final String PROVIDERS_VERSION = "Version";
    static final String PROVIDERS_NAME = "Name";
    static final String PROVIDERS_PROVIDER_ID = "ProviderId";
    static final String PROVIDERS_CLASSLOADER = "UseClassloader";
    static final String PROVIDERS_INITIAL_LOAD_ORDER = "InitialLoadOrder";
    static final String PROVIDERS_CLASS_LOADER_ID = "ClassloaderId";
    static final String PROVIDERS_GRANT_STATEMENTS = "GrantStatements";

    ProviderEntry(Providers providers, String string, RepositoryKey repositoryKey, RepositoryKey repositoryKey2) {
        this._providers = providers;
        this._internalName = string;
        this._key = repositoryKey.openKey(string, true);
        this._profilesKey = repositoryKey2;
    }

    String getFullClasspath() {
        String string = null;
        string = this.getClasspath();
        if (this.getAdditionalClasspath() != null && this.getAdditionalClasspath().length() > 0) {
            string = string + File.pathSeparator + this.getAdditionalClasspath();
        }
        return string;
    }

    void releaseResources() {
        this._providers = null;
        this._key = null;
        this._provider = null;
        this._loader = null;
        this._profilesKey = null;
        this._profile = null;
        this._topLevelContainers.clear();
        this._topLevelContainers = null;
        this._toolBarJComponents = null;
        this._topLevelJMenus = null;
        this._statusBarJComponent = null;
        this._bottomJComponent = null;
    }

    void addTopLevelContainer(SCContainer sCContainer) {
        if (sCContainer != null) {
            this._topLevelContainers.put(sCContainer, sCContainer);
        }
    }

    void removeTopLevelContainer(SCContainer sCContainer) {
        if (sCContainer != null) {
            this._topLevelContainers.remove(sCContainer);
        }
    }

    Enumeration getTopLevelContainers() {
        return this._topLevelContainers.keys();
    }

    void setToolBarJComponents(JComponent[] jComponentArray) {
        this._toolBarJComponents = jComponentArray;
    }

    JComponent[] getToolBarJComponents() {
        return this._toolBarJComponents;
    }

    void setTopLevelJMenus(JMenu[] jMenuArray) {
        this._topLevelJMenus = jMenuArray;
    }

    JMenu[] getTopLevelJMenus() {
        return this._topLevelJMenus;
    }

    void setBottomJComponent(JComponent jComponent, String string, String string2) {
        this._bottomJComponent = jComponent;
        this._bottomJComponentMenuName = string;
        this._bottomJComponentMenuHint = string2;
    }

    JComponent getBottomJComponent() {
        return this._bottomJComponent;
    }

    void setBottomJComponentVisible(boolean bl) {
        this._bottomJComponentVisible = bl;
    }

    boolean isBottomJComponentVisible() {
        return this._bottomJComponentVisible;
    }

    String getBottomJComponentMenuName() {
        return this._bottomJComponentMenuName;
    }

    String getBottomJComponentMenuHint() {
        return this._bottomJComponentMenuHint;
    }

    void setStatusBarJComponent(JComponent jComponent) {
        this._statusBarJComponent = jComponent;
    }

    JComponent getStatusBarJComponent() {
        return this._statusBarJComponent;
    }

    boolean isContainerOwnedByProvider(SCContainer sCContainer) {
        return this._topLevelContainers.containsKey(sCContainer);
    }

    String getKeyName() {
        return this._internalName;
    }

    String getClassName() {
        String string = this._key.getStringValue(PROVIDERS_CLASS);
        return string;
    }

    void setClassName(String string) {
        this._key.setStringValue(PROVIDERS_CLASS, string);
    }

    String getProviderId() {
        String string = this._key.getStringValue(PROVIDERS_PROVIDER_ID);
        return string;
    }

    void setProviderId(String string) {
        this._key.setStringValue(PROVIDERS_PROVIDER_ID, string);
    }

    String getName() {
        String string = this._key.getStringValue(PROVIDERS_NAME);
        return string;
    }

    void setName(String string) {
        this._key.setStringValue(PROVIDERS_NAME, string);
    }

    String getVersion() {
        String string = this._key.getStringValue(PROVIDERS_VERSION);
        if (string == null) {
            // empty if block
        }
        return string;
    }

    void setVersion(String string) {
        this._key.setStringValue(PROVIDERS_VERSION, string);
    }

    String getClasspath() {
        String string = this._key.getStringValue(PROVIDERS_CLASSPATH);
        if (string == null) {
            // empty if block
        }
        return string;
    }

    void setClasspath(String string) {
        this._key.setStringValue(PROVIDERS_CLASSPATH, string);
    }

    String getAdditionalClasspath() {
        return this._key.getStringValue(PROVIDERS_ADDITIONAL_CLASSPATH);
    }

    void setAdditionalClasspath(String string) {
        this._key.setStringValue(PROVIDERS_ADDITIONAL_CLASSPATH, string);
    }

    int getInitialLoadOrder() {
        Integer n = this._key.getIntegerValue(PROVIDERS_INITIAL_LOAD_ORDER);
        if (n == null || n < 0) {
            this.setInitialLoadOrder(Integer.MAX_VALUE);
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    void setInitialLoadOrder(int n) {
        this._key.setIntegerValue(PROVIDERS_INITIAL_LOAD_ORDER, n);
    }

    String getClassloaderId() {
        String string = this._key.getStringValue(PROVIDERS_CLASS_LOADER_ID);
        return string;
    }

    void setClassloaderId(String string) {
        this._key.setStringValue(PROVIDERS_CLASS_LOADER_ID, string);
    }

    String getGrantStatements() {
        String string = this._key.getStringValue(PROVIDERS_GRANT_STATEMENTS);
        return string;
    }

    void setGrantStatements(String string) {
        this._key.setStringValue(PROVIDERS_GRANT_STATEMENTS, string);
    }

    boolean isClassloaderUsed() {
        Boolean bl = this._key.getBooleanValue(PROVIDERS_CLASSLOADER);
        if (bl == null) {
            this.setClassloaderUsed(true);
            return true;
        }
        return bl;
    }

    void setClassloaderUsed(boolean bl) {
        this._key.setBooleanValue(PROVIDERS_CLASSLOADER, bl);
    }

    boolean isLoaded() {
        return this._loaded;
    }

    void loadProvider(boolean bl) throws Exception {
        String string = this._key.getStringValue(PROVIDERS_CLASS);
        if (bl || !this.isClassloaderUsed()) {
            this._provider = (SCProvider)Class.forName(string).newInstance();
        } else {
            this._loader = this._providers.getClassloader(this.getFullClasspath(), this.getClassloaderId(), this.getProviderId());
            this._provider = (SCProvider)this._loader.loadClass(string).newInstance();
            this.setProviderId(this._provider.getId());
        }
        this._loaded = true;
        this._providers.updateProviderExtensionList();
    }

    void setProviderLoaded(SCProvider sCProvider, SCClassLoader sCClassLoader) {
        this._provider = sCProvider;
        this._loader = sCClassLoader;
        this._loaded = true;
        this._providers.updateProviderExtensionList();
    }

    void unloadProvider() {
        this._topLevelContainers.clear();
        this._providers.providerUnloaded(this.getFullClasspath(), this.getClassloaderId(), this._loader);
        this._loader = null;
        this._provider = null;
        this._loaded = false;
        this._providers.updateProviderExtensionList();
    }

    SCProvider getProvider() {
        return this._provider;
    }

    SCProviderLoader2 getProviderLoader() {
        return this._loader;
    }

    SCProfile getProviderProfile() {
        if (this._profile != null) {
            return this._profile;
        }
        this._profile = new ProfilesKey(this._profilesKey, this._internalName);
        this._profilesKey = null;
        return this._profile;
    }
}

