/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.central.SCProvider2;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.RepositoryKey;
import com.sybase.central.viewer.SCClassLoader;
import com.sybase.central.viewer.SCRepository;
import com.sybase.central.viewer.UserPrefRepository;
import com.sybase.central.viewer.UserPrefRepositoryInfo;
import com.sybase.util.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Providers {
    private SCRepository _scRepository;
    private UserPrefRepository _upRepository;
    private UserPrefRepositoryInfo _upRepositoryInfo;
    private Vector<ProviderEntry> _provList = new Vector(30);
    private Vector<ProviderEntry> _provExtensionList = new Vector(30);
    private boolean _listFilled = false;
    private Hashtable<String, SCClassLoader> _sharedClassLoaders = new Hashtable();
    public static final String PROVIDERS_KEY = "Providers";
    static final String PROFILES_KEY = "Profiles";
    public static final String SC_POLICY_FILE = "sc.policy";
    static final String GRANT1 = "grant codeBase \"file:/";
    static final String GRANT2 = "-\" { permission java.security.AllPermission; }; ";

    Providers(SCRepository sCRepository, UserPrefRepository userPrefRepository, UserPrefRepositoryInfo userPrefRepositoryInfo) {
        this._scRepository = sCRepository;
        this._upRepository = userPrefRepository;
        this._upRepositoryInfo = userPrefRepositoryInfo;
    }

    void releaseResources() {
        Enumeration enumeration = this.getProviderList();
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            providerEntry.releaseResources();
        }
        this._provList.removeAllElements();
        this._provList = null;
        if (this._sharedClassLoaders.size() > 0) {
            this._sharedClassLoaders.clear();
        }
        this._sharedClassLoaders = null;
        this._scRepository = null;
        this._upRepository = null;
        this._upRepositoryInfo = null;
    }

    SCClassLoader getClassloader(String string, String string2, String string3) {
        SCClassLoader sCClassLoader = null;
        if (string2 == null || string2.length() == 0) {
            sCClassLoader = new SCClassLoader(this.getClass().getClassLoader(), string, string3);
            return sCClassLoader;
        }
        sCClassLoader = this._sharedClassLoaders.get(string2);
        if (sCClassLoader == null) {
            sCClassLoader = new SCClassLoader(this.getClass().getClassLoader(), string, string3);
            this._sharedClassLoaders.put(string2, sCClassLoader);
        } else {
            sCClassLoader.addToClasspath(string, string3);
        }
        return sCClassLoader;
    }

    void providerUnloaded(String string, String string2, SCClassLoader sCClassLoader) {
        if (string2 == null || string2.length() == 0) {
            this.unloadJNILibraries(sCClassLoader);
            sCClassLoader.releaseResources();
            return;
        }
        this._sharedClassLoaders.remove(string2);
        this.unloadJNILibraries(sCClassLoader);
        if (sCClassLoader != null) {
            sCClassLoader.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadJNILibraries(SCClassLoader sCClassLoader) {
        if (sCClassLoader != null) {
            try {
                Field field = ClassLoader.class.getDeclaredField("nativeLibraries");
                field.setAccessible(true);
                Object object = field.get(sCClassLoader);
                if (object != null && object instanceof Vector) {
                    Object object2 = object;
                    synchronized (object2) {
                        ((Vector)object).clear();
                    }
                }
                System.gc();
                System.runFinalization();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    Enumeration getProviderExtensionList() {
        return this._provExtensionList.elements();
    }

    void updateProviderExtensionList() {
        Enumeration enumeration = this.getProviderList();
        this._provExtensionList.clear();
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded() || !(providerEntry.getProvider() instanceof SCProvider2)) continue;
            this._provExtensionList.addElement(providerEntry);
        }
    }

    Enumeration getProviderList() {
        if (!this._listFilled) {
            this.fillProviderList();
        }
        return this._provList.elements();
    }

    ProviderEntry getProviderEntry(int n) {
        if (n >= 0 && n < this._provList.size()) {
            return this._provList.elementAt(n);
        }
        return null;
    }

    int getProviderCount() {
        if (!this._listFilled) {
            this.fillProviderList();
        }
        return this._provList.size();
    }

    int getLoadedProviderCount() {
        if (!this._listFilled) {
            this.fillProviderList();
        }
        Enumeration enumeration = this.getProviderList();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded()) continue;
            ++n;
        }
        return n;
    }

    private void fillProviderList() {
        RepositoryKey repositoryKey = this._scRepository.openKey(PROVIDERS_KEY, true);
        if (repositoryKey != null) {
            Enumeration enumeration = repositoryKey.getKeyNames();
            RepositoryKey repositoryKey2 = this._upRepository.openKey(PROFILES_KEY, false);
            while (enumeration.hasMoreElements()) {
                ProviderEntry providerEntry = new ProviderEntry(this, (String)enumeration.nextElement(), repositoryKey, repositoryKey2);
                boolean bl = false;
                for (int i = 0; i < this._provList.size(); ++i) {
                    ProviderEntry providerEntry2 = this._provList.elementAt(i);
                    if (providerEntry.getInitialLoadOrder() >= providerEntry2.getInitialLoadOrder()) continue;
                    this._provList.insertElementAt(providerEntry, i);
                    bl = true;
                    break;
                }
                if (bl) continue;
                this._provList.add(providerEntry);
            }
        }
        this._listFilled = true;
    }

    ProviderEntry createProviderEntry(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2) {
        int n = Integer.MAX_VALUE;
        RepositoryKey repositoryKey = this._scRepository.openKey(PROVIDERS_KEY, false);
        RepositoryKey repositoryKey2 = this._upRepository.openKey(PROFILES_KEY, false);
        RepositoryKey repositoryKey3 = this._scRepository.openKey("Providers/" + string, true);
        if (repositoryKey3 != null) {
            return null;
        }
        repositoryKey3 = this._scRepository.openKey("Providers/" + string, false);
        ProviderEntry providerEntry = new ProviderEntry(this, string, repositoryKey, repositoryKey2);
        providerEntry.setClassName(string2);
        providerEntry.setProviderId(string);
        providerEntry.setName(string3);
        providerEntry.setVersion(string4);
        providerEntry.setClasspath(string5);
        if (string6 != null) {
            providerEntry.setAdditionalClasspath(string6);
        }
        if (string7 != null) {
            providerEntry.setClassloaderId(string7.trim());
        }
        if (string8 != null) {
            providerEntry.setGrantStatements(string8);
        }
        if (string9 != null) {
            try {
                n = Integer.parseInt(string9);
                if (n < 0) {
                    n = Integer.MAX_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            providerEntry.setInitialLoadOrder(n);
        }
        providerEntry.setClassloaderUsed(bl);
        this._provList.addElement(providerEntry);
        this._upRepositoryInfo.setProviderAutoload(string, bl2);
        this.updatePolicyFileAndSecurityManager();
        return providerEntry;
    }

    void removeProviderEntry(ProviderEntry providerEntry) {
        RepositoryKey repositoryKey = this._scRepository.openKey(PROVIDERS_KEY, true);
        repositoryKey.removeKey(providerEntry.getKeyName());
        this._provList.removeElement(providerEntry);
        this.updatePolicyFileAndSecurityManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePolicyFileAndSecurityManager() {
        File file = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.getProviderList();
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        Object var9_6 = null;
        file = new File(this._scRepository.getLocation() + SC_POLICY_FILE);
        file.delete();
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            String string = providerEntry.getGrantStatements();
            if (string == null || string.length() <= 0) continue;
            arrayList.add(0, "// " + providerEntry.getName());
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            if (Platform.isWindows()) {
                File[] fileArray = File.listRoots();
                for (int i = 0; i < fileArray.length; ++i) {
                    arrayList.add(i, GRANT1 + fileArray[i].getPath().replace('\\', '/') + GRANT2);
                }
            } else {
                arrayList.add(0, "grant codeBase \"file:/-\" { permission java.security.AllPermission; }; ");
            }
            arrayList.add(0, "// Sybase Central");
            try {
                fileOutputStream = new FileOutputStream(this._scRepository.getLocation() + SC_POLICY_FILE);
                printWriter = new PrintWriter(new OutputStreamWriter(fileOutputStream));
                for (String string : arrayList) {
                    printWriter.println(string);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                printWriter.close();
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            file = new File(this._scRepository.getLocation() + SC_POLICY_FILE);
            try {
                if (System.getSecurityManager() == null) {
                    System.setProperty("java.security.policy", file.getCanonicalPath());
                    System.setSecurityManager(new SecurityManager());
                } else {
                    System.setProperty("java.security.policy", file.getCanonicalPath());
                    Policy.getPolicy().refresh();
                }
            }
            catch (Throwable throwable) {
                ExceptionHandler.handleException((Throwable)throwable);
            }
        }
    }
}

