/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.Providers;
import com.sybase.central.viewer.SCJARManifestReader;
import com.sybase.central.viewer.SCRepository;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.UserPrefRepository;
import com.sybase.central.viewer.UserPrefRepositoryInfo;
import com.sybase.central.viewer.Utilities;
import com.sybase.util.FileLocator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class Register {
    static final String PLUGIN_NAME = "PluginName";
    static final String PLUGIN_ID = "PluginId";
    static final String PLUGIN_CLASS = "PluginClass";
    static final String PLUGIN_FILE = "PluginFile";
    static final String ADDITIONAL_CLASSPATH = "AdditionalClasspath";
    static final String CLASSLOADER_ID = "ClassloaderId";
    static final String GRANT_STATEMENTS = "GrantStatements";
    static final String INITIAL_LOAD_ORDER = "InitialLoadOrder";
    static final String CONNECTION_PROFILES = "ConnectionProfiles/";
    static final String NAME = "/Name=";
    static final String PROVIDER_ID = "/ProviderId=";
    static final String PROVIDER = "/Provider=";
    static final String DATA = "/Data/";
    static final String SEPARATOR = "#";

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 3) {
                Register.usage("** ERROR - invalid arguments");
            } else if (stringArray[0].toLowerCase().equals("-p") && stringArray.length == 3) {
                Register.registerPlugin(stringArray);
            } else if (stringArray[0].toLowerCase().equals("-pu") && stringArray.length == 3) {
                Register.unregisterPlugin(stringArray);
            } else if (stringArray[0].length() < 4 && stringArray[0].toLowerCase().startsWith("-r") && stringArray.length == 4) {
                Register.makeRepositoryEntry(stringArray);
            } else if (stringArray[0].length() < 4 && stringArray[0].toLowerCase().startsWith("-u") && stringArray.length == 3) {
                Register.makeUserPrefEntry(stringArray);
            } else if (stringArray[0].length() < 5 && stringArray[0].toLowerCase().startsWith("-ccp") && stringArray.length == 6) {
                Register.copyConnectionProfiles(stringArray);
            } else {
                Register.usage("** ERROR - invalid arguments");
            }
        }
        catch (Exception exception) {
            Register.usage("** ERROR - EXCEPTION:\n" + exception.toString());
        }
    }

    private static void registerPlugin(String[] stringArray) throws Exception {
        if (stringArray.length == 3) {
            if (stringArray[2].toLowerCase().endsWith(".jar")) {
                Register.registerPluginWithJAR(stringArray[1], stringArray[2]);
            } else {
                Register.registerPluginWithJPR(stringArray);
            }
        } else {
            Register.usage("");
        }
    }

    static void registerPluginWithJAR(String string, String string2) throws Exception {
        Register.registerPluginWithJAR(string, string2, "");
    }

    static void registerPluginWithJAR(String string, String string2, String string3) throws Exception {
        String string4;
        if (!FileLocator.isInstalled()) {
            return;
        }
        File file = new File(string2);
        String string5 = file.getCanonicalPath();
        String string6 = SCJARManifestReader.getPluginIdFromJARManifest(string2);
        String string7 = SCJARManifestReader.getClassloaderIdFromJARManifest(string2);
        String string8 = SCJARManifestReader.getStartupClassFromJARManifest(string2);
        String string9 = file.getName();
        String string10 = SCJARManifestReader.getRequiredViewerVersionFromJARManifest(string2);
        try {
            int n = Integer.valueOf(string10);
            if (n > 600) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Register.showError("Error! Manifest is missing the required Sybase Central version number");
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(SCJARManifestReader.getAdditionalJARsFromJARManifest(string2));
            StringBuilder stringBuilder = new StringBuilder();
            while (stringTokenizer.hasMoreTokens()) {
                String string11 = stringTokenizer.nextToken();
                file = FileLocator.find((String)string11);
                if (file == null) {
                    Register.showError("Plugin registration failed. Could not find " + string11);
                    return;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(File.pathSeparator);
                }
                stringBuilder.append(file.getPath());
            }
            string4 = stringBuilder.toString();
        }
        catch (IOException iOException) {
            string4 = null;
        }
        if (string4 == null) {
            string4 = "";
        }
        Register.registerPlugin(string, string6, string8, string9, string5, string4, string7, "", string3);
    }

    private static void registerPluginWithJPR(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[]{null, null, null, null, null, null};
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = stringArray[1];
        stringArray2 = Utilities.readJPRFile(stringArray[2]);
        string = stringArray2[0];
        string2 = stringArray2[1];
        string3 = stringArray2[2];
        string4 = stringArray2[3];
        string5 = stringArray2[4];
        string6 = stringArray2[5];
        string7 = stringArray2[6];
        string8 = stringArray2[7];
        if (string == null || string2 == null || string3 == null || string4 == null) {
            Register.usage("** ERROR - plug-in name, id, class, and classpath must be set in the *.jpr file: " + stringArray[2]);
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string6 == null) {
            string6 = "";
        }
        Register.registerPlugin(string9, string2, string3, string, string4, string5, string6, string7, string8);
    }

    private static void registerPlugin(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws IOException {
        SCRepository sCRepository = null;
        UserPrefRepository userPrefRepository = null;
        UserPrefRepositoryInfo userPrefRepositoryInfo = null;
        Providers providers = null;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        sCRepository = new SCRepository(false, string);
        sCRepository.load();
        userPrefRepository = new UserPrefRepository(false, ScjSession.getUserFileLocation(), "");
        userPrefRepository.load();
        userPrefRepositoryInfo = new UserPrefRepositoryInfo(userPrefRepository, false);
        providers = new Providers(sCRepository, userPrefRepository, userPrefRepositoryInfo);
        providers.createProviderEntry(string2, string3, string4, "", string5, string6, string7, string8, string9, true, true);
        userPrefRepository.save();
        sCRepository.save();
    }

    private static void unregisterPlugin(String[] stringArray) throws Exception {
        String string = null;
        String string2 = null;
        SCRepository sCRepository = null;
        UserPrefRepository userPrefRepository = null;
        UserPrefRepositoryInfo userPrefRepositoryInfo = null;
        Providers providers = null;
        Enumeration enumeration = null;
        ProviderEntry providerEntry = null;
        string = stringArray[1];
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string2 = stringArray[2];
        if (string.trim().length() == 0 || string2.trim().length() == 0) {
            Register.usage("** ERROR - repository file location and plug-in id must be specified");
        }
        sCRepository = new SCRepository(false, string);
        sCRepository.load();
        userPrefRepository = new UserPrefRepository(false, ScjSession.getUserFileLocation(), "");
        userPrefRepository.load();
        userPrefRepositoryInfo = new UserPrefRepositoryInfo(userPrefRepository, false);
        providers = new Providers(sCRepository, userPrefRepository, userPrefRepositoryInfo);
        enumeration = providers.getProviderList();
        while (enumeration.hasMoreElements()) {
            providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.getProviderId().equals(string2)) continue;
            providers.removeProviderEntry(providerEntry);
            break;
        }
        userPrefRepository.save();
        sCRepository.save();
    }

    private static void makeRepositoryEntry(String[] stringArray) throws Exception {
        boolean bl = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        SCRepository sCRepository = null;
        Object var6_6 = null;
        if (stringArray[0].toLowerCase().endsWith("e")) {
            bl = true;
        }
        if (!(string = stringArray[1]).endsWith(File.separator)) {
            string = string + File.separator;
        }
        string2 = stringArray[2];
        string3 = stringArray[3];
        if (string.trim().length() == 0 || string2.trim().length() == 0) {
            Register.usage("** ERROR - repository file location and key must be specified");
        }
        sCRepository = new SCRepository(false, string);
        sCRepository.load();
        sCRepository.addEntry(string2, string3, bl);
        sCRepository.save();
    }

    private static void makeUserPrefEntry(String[] stringArray) throws Exception {
        boolean bl = false;
        String string = null;
        String string2 = null;
        UserPrefRepository userPrefRepository = null;
        if (stringArray[0].toLowerCase().endsWith("e")) {
            bl = true;
        }
        string = stringArray[1];
        string2 = stringArray[2];
        if (string.trim().length() == 0) {
            Register.usage("** ERROR - key must be specified");
        }
        userPrefRepository = new UserPrefRepository(false, ScjSession.getUserFileLocation(), "");
        userPrefRepository.load();
        userPrefRepository.addEntry(string, string2, bl);
        userPrefRepository.save();
    }

    private static void copyConnectionProfiles(String[] stringArray) throws Exception {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string6 = null;
        int n = -1;
        String string7 = null;
        StringBuffer stringBuffer = new StringBuffer();
        string = stringArray[1];
        string2 = stringArray[2];
        string3 = stringArray[3];
        string4 = stringArray[4];
        string5 = stringArray[5];
        if (string.trim().length() == 0 || string2.trim().length() == 0 || string3.trim().length() == 0 || string4.trim().length() == 0 || string5.trim().length() == 0) {
            Register.usage("** ERROR - 'from plug-in id', 'from repository file name', 'to plug-in id', 'to plug-in name', and 'to repository file name' must be specified");
        }
        bufferedReader = new BufferedReader(new FileReader(string2));
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string5, true));
        }
        catch (FileNotFoundException fileNotFoundException) {
            bufferedWriter = new BufferedWriter(new FileWriter(string5));
        }
        string6 = bufferedReader.readLine();
        while (string6 != null) {
            if (string6.startsWith(CONNECTION_PROFILES)) {
                n = string6.indexOf(NAME);
                if (n >= 0) {
                    string7 = string6.substring(n + 6);
                    bufferedWriter.write(SEPARATOR);
                    bufferedWriter.newLine();
                    stringBuffer.setLength(0);
                    stringBuffer.append(CONNECTION_PROFILES).append(string7).append(NAME).append(string7);
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.newLine();
                    stringBuffer.setLength(0);
                    stringBuffer.append(CONNECTION_PROFILES).append(string7).append(PROVIDER_ID).append(string3);
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.newLine();
                    stringBuffer.setLength(0);
                    stringBuffer.append(CONNECTION_PROFILES).append(string7).append(PROVIDER).append(string4);
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.newLine();
                } else if (string7 != null && string6.indexOf(DATA) >= 0) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(CONNECTION_PROFILES).append(string7).append(DATA).append(string6.substring(string6.indexOf(DATA) + 6));
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.newLine();
                }
            } else {
                string7 = null;
            }
            string6 = bufferedReader.readLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
    }

    private static void usage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        Register.showError(stringBuilder.toString());
        System.exit(0);
    }

    private static void showError(String string) {
        try {
            Class<?> clazz = Class.forName("javax.swing.JOptionPane");
            Class<?> clazz2 = Class.forName("java.awt.Component");
            Method method = clazz.getMethod("showMessageDialog", clazz2, Object.class, String.class, Integer.TYPE);
            method.invoke(null, null, string, "Sybase Central", 0);
        }
        catch (Exception exception) {
            System.err.println(string);
        }
    }
}

