/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.DbgScj;
import com.sybase.util.Profile;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

class RepositoryKey {
    private String _keyName;
    private Properties _values = new Properties();
    private Hashtable<String, RepositoryKey> _subKeys = new Hashtable();

    RepositoryKey(String string) {
        this._keyName = string;
    }

    RepositoryKey() {
        this._keyName = null;
    }

    Enumeration getSubKeys() {
        return this._subKeys.elements();
    }

    boolean isRoot() {
        return this._keyName == null;
    }

    void addEntry(StringTokenizer stringTokenizer, String string) {
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = this.unslashString(string2);
        if (stringTokenizer.hasMoreTokens()) {
            RepositoryKey repositoryKey = this.openKey(string3, false);
            repositoryKey.addEntry(stringTokenizer, string);
        } else {
            String string4 = this.unslashString(string);
            this._values.put(string3, string4);
        }
    }

    RepositoryKey openKey(String string, boolean bl) {
        RepositoryKey repositoryKey = this._subKeys.get(string);
        if (repositoryKey == null && !bl) {
            repositoryKey = new RepositoryKey(string);
            this._subKeys.put(string, repositoryKey);
        }
        return repositoryKey;
    }

    void removeKey(String string) {
        this._subKeys.remove(string);
    }

    String getStringValue(String string) {
        return this._values.getProperty(string);
    }

    void setStringValue(String string, String string2) {
        DbgScj.wassert((string2 != null ? 1 : 0) != 0, (String)"Attempt to set a string value to null.");
        this._values.put(string, string2);
    }

    Integer getIntegerValue(String string) {
        String string2 = this.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    int getIntValue(String string) {
        Integer n = this.getIntegerValue(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    void setIntegerValue(String string, int n) {
        String string2 = Integer.toString(n);
        this.setStringValue(string, string2);
    }

    Boolean getBooleanValue(String string) {
        String string2 = this.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        return Boolean.valueOf(string2);
    }

    void setBooleanValue(String string, boolean bl) {
        Boolean bl2 = new Boolean(bl);
        String string2 = bl2.toString();
        this.setStringValue(string, string2);
    }

    void removeValue(String string) {
        this._values.remove(string);
    }

    Enumeration getValues() {
        return this._values.propertyNames();
    }

    String getKeyName() {
        return this._keyName;
    }

    Enumeration getKeyNames() {
        return this._subKeys.keys();
    }

    void writeKeyDataToProfile(String string, Profile profile) {
        Enumeration<Object> enumeration = null;
        Enumeration<RepositoryKey> enumeration2 = null;
        RepositoryKey repositoryKey = null;
        String string2 = null;
        String string3 = null;
        enumeration = this._values.keys();
        enumeration2 = this._subKeys.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string3 = this.getStringValue(string2);
            profile.addValue(string, string2, string3);
        }
        while (enumeration2.hasMoreElements()) {
            repositoryKey = enumeration2.nextElement();
            if (string.length() == 0) {
                repositoryKey.writeKeyDataToProfile(repositoryKey.getKeyName(), profile);
                continue;
            }
            repositoryKey.writeKeyDataToProfile(string + "/" + repositoryKey.getKeyName(), profile);
        }
    }

    void writeKey(String string, PrintWriter printWriter) {
        Enumeration<Object> enumeration = this._values.keys();
        Enumeration<RepositoryKey> enumeration2 = this._subKeys.elements();
        String string2 = !this.isRoot() ? string + this.slashString(this._keyName) + "/" : "";
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = this.getStringValue(string3);
            printWriter.println(string2 + this.slashString(string3) + "=" + this.slashString(string4));
        }
        while (enumeration2.hasMoreElements()) {
            RepositoryKey repositoryKey = enumeration2.nextElement();
            repositoryKey.writeKey(string2, printWriter);
        }
        printWriter.println("#");
    }

    protected String unslashString(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = string.indexOf(92, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            if (string.length() <= n + 1) break;
            switch (string.charAt(n + 1)) {
                case '_': {
                    stringBuffer.append('/');
                    break;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    break;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
                case 'e': {
                    stringBuffer.append('=');
                    break;
                }
            }
            n2 = n + 2;
        }
        stringBuffer.append(string.substring(n2, string.length()));
        return stringBuffer.toString();
    }

    protected String slashString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        if (string == null) {
            return null;
        }
        block10: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '/': {
                    stringBuffer.append("\\_");
                    continue block10;
                }
                case '=': {
                    stringBuffer.append("\\e");
                    continue block10;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }
}

