/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer;
import com.sybase.central.SCContainerEvent;
import com.sybase.central.SCContainerListener;
import com.sybase.central.SCHeader;
import com.sybase.central.SCHeader5;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCViewerDetailsPanel;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.ScjSession;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

class RootContainer
implements SCContainer,
IConstants {
    private ScjSession _session;
    private Vector<SCItem> _children = new Vector(30);
    private Vector<SCContainerListener> _containerListeners = new Vector();
    private ImageIcon _icon = null;
    private SCViewerDetailsPanel[] _panel = null;

    RootContainer(ScjSession scjSession) {
        this._session = scjSession;
    }

    @Override
    public void open(int n) {
    }

    @Override
    public void close() {
    }

    @Override
    public SCMenu getCreationMenu() {
        return null;
    }

    @Override
    public SCHeader[] getHeadingInfo() {
        SCHeader[] sCHeaderArray = new SCHeader[1];
        sCHeaderArray[0] = new SCHeader5(ScjSession.getString("STR_NAME"), 0, 300, null, 2, false, null, ScjSession.getString("STR_NAME_MNEMONIC").charAt(0), ScjSession.getString("STR_NAME_HINT"), ScjSession.getString("STR_MENU_NAME"));
        return sCHeaderArray;
    }

    @Override
    public Enumeration getItems() {
        return this._children.elements();
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
    }

    @Override
    public boolean onNotify(JFrame jFrame, int n, int n2) {
        return true;
    }

    @Override
    public String getKey() {
        return "Root";
    }

    @Override
    public SCMenu getContextMenu() {
        return null;
    }

    @Override
    public String getDisplayName(int n) {
        String string = this._session.getConfiguration().getRootName();
        if (string == null) {
            string = ScjSession.getString("STR_APP_NAME");
        }
        return string;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this._icon == null) {
            Image image = this._session.getConfiguration().getIconImage(this._session);
            this._icon = image != null ? new ImageIcon(image) : SCImageLoader.getImageIcon("scj16", 1006);
        }
        return this._icon;
    }

    @Override
    public int getAttributes() {
        return 1;
    }

    @Override
    public int queryDropItems(int n, DataFlavor[] dataFlavorArray) {
        return 0;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 0;
    }

    @Override
    public void releaseResources() {
        this._session = null;
        Enumeration<SCItem> enumeration = this._children.elements();
        while (enumeration.hasMoreElements()) {
            SCItem sCItem = enumeration.nextElement();
            sCItem.releaseResources();
        }
        this._children.removeAllElements();
        this._children = null;
        this._containerListeners.removeAllElements();
        this._containerListeners = null;
        this._icon = null;
        this._panel = null;
    }

    @Override
    public void addContainerListener(SCContainerListener sCContainerListener) {
        this._containerListeners.addElement(sCContainerListener);
    }

    @Override
    public void removeContainerListener(SCContainerListener sCContainerListener) {
        if (this._containerListeners != null) {
            this._containerListeners.removeElement(sCContainerListener);
        }
    }

    @Override
    public Object[] getDetailsPanels() {
        if (this._panel == null) {
            this._panel = new SCViewerDetailsPanel[]{SCViewerDetailsPanel.getViewerDetailsPanel("DETAILS_LIST")};
            if (this._panel[0] != null) {
                this._panel[0].setPanelName(ScjSession.getString("STR_ROOT_DETAILS_LIST_NAME"));
            }
        }
        return this._panel;
    }

    @Override
    public Hashtable getPropertyHashtable() {
        return null;
    }

    @Override
    public String getItemScript() {
        return ScjSession.getString("STR_APP_NAME");
    }

    @Override
    public boolean isOkToBatch(int n) {
        return false;
    }

    void addContainer(SCContainer sCContainer, JFrame jFrame) {
        this._children.addElement(sCContainer);
        this.notifyChangeListeners(jFrame, 1, sCContainer);
    }

    void removeContainer(SCContainer sCContainer, JFrame jFrame) {
        this._children.removeElement(sCContainer);
        this.notifyChangeListeners(jFrame, 2, sCContainer);
    }

    void notifyChangeListeners(JFrame jFrame, int n, SCContainer sCContainer) {
        for (int i = 0; i < this._containerListeners.size(); ++i) {
            this._containerListeners.elementAt(i).containerChanged(new SCContainerEvent(this, n, sCContainer));
        }
    }
}

