/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCProviderLoader2;
import com.sybase.central.viewer.ClasspathPart;
import com.sybase.util.Platform;
import com.sybase.util.SybOptionPane;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class SCClassLoader
extends SecureClassLoader
implements SCProviderLoader2 {
    static final String BLANK_STRING = "";
    static final String JAR_STRING = "jar";
    static final String JAR_SYNTAX_STRING = "!/";
    static final String JAR_EXT_STRING = ".jar";
    static final String CLASS_EXT_STRING = ".class";
    static final String JAR_TAG = "jar:";
    static final String FILE_TAG = "file:";
    static final int DIRECTORY = 1;
    static final int JAR = 2;
    private String _fullClasspath = "";
    private Vector<ClasspathPart> _classpathParts = new Vector(15);
    private Hashtable<String, String> _providerDirectories = new Hashtable();

    SCClassLoader(String string, String string2) {
        this.addToClasspath(string, string2);
    }

    SCClassLoader(ClassLoader classLoader, String string, String string2) {
        super(classLoader);
        this.addToClasspath(string, string2);
    }

    SCClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.addToClasspath(null, null);
    }

    void addToClasspath(String string, String string2) {
        String string3 = null;
        if (string != null) {
            this._fullClasspath = this._fullClasspath == null || this._fullClasspath.equals(BLANK_STRING) ? string : this._fullClasspath + File.pathSeparator + string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, false);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string3 == null) {
                    string3 = string4;
                }
                if (!this.checkPart(string4, string2)) continue;
                ClasspathPart classpathPart = new ClasspathPart(string4);
                this._classpathParts.add(classpathPart);
            }
            if (string3 == null) {
                string3 = BLANK_STRING;
            }
            if (string2 != null && string2.length() > 0) {
                this.addProviderDirectory(string2, string3);
            }
        }
    }

    private boolean checkPart(String string, String string2) {
        String string3 = null;
        ClasspathPart classpathPart = null;
        if (string.toLowerCase().endsWith(JAR_EXT_STRING)) {
            string3 = string.lastIndexOf(File.separator) > -1 ? string.substring(string.lastIndexOf(File.separator) + 1, string.length()) : string;
        }
        if (string3 != null) {
            Enumeration<ClasspathPart> enumeration = this._classpathParts.elements();
            while (enumeration.hasMoreElements()) {
                classpathPart = enumeration.nextElement();
                if (classpathPart.classpath.toLowerCase().equals(string.toLowerCase()) && Platform.isWindows() || classpathPart.classpath.equals(string) && !Platform.isWindows()) {
                    return false;
                }
                if (!classpathPart.classpath.endsWith(File.separator + string3)) continue;
                SybOptionPane.showMessageDialog(null, (Object)("ERROR! The same JAR name with a different location is in the classpath twice (for the same classloader id).\nPlug-in(s) were already loaded using this JAR: \n" + classpathPart.classpath + "\n" + "Plug-in id: '" + string2 + "' wants to load in the same classloader and use this JAR:\n" + string), (String)"Classpath ERROR", (int)0);
                return false;
            }
        }
        return true;
    }

    private void addProviderDirectory(String string, String string2) {
        String string3 = string2.trim();
        if (string3.toLowerCase().endsWith(JAR_EXT_STRING)) {
            if (string3.lastIndexOf(File.separator) > -1) {
                string3 = string3.substring(0, string3.lastIndexOf(File.separator));
            } else {
                return;
            }
        }
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        this._providerDirectories.put(string, string3);
    }

    Vector getClasspathParts() {
        return this._classpathParts;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public String getProviderDirectory() {
        ClasspathPart classpathPart = null;
        classpathPart = this._classpathParts.firstElement();
        String string = classpathPart.classpath.trim();
        if (string.toLowerCase().endsWith(JAR_EXT_STRING)) {
            if (string.lastIndexOf(File.separator) > -1) {
                string = string.substring(0, string.lastIndexOf(File.separator));
            } else {
                return BLANK_STRING;
            }
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    @Override
    public String getProviderClasspath() {
        return this._fullClasspath;
    }

    @Override
    public void setProviderClasspath(String string) {
    }

    @Override
    public void setSystemPackages(String string) {
    }

    @Override
    public String getSystemPackages() {
        return BLANK_STRING;
    }

    @Override
    public boolean isCacheEnabled() {
        return true;
    }

    @Override
    public void setCacheEnabled(boolean bl) {
    }

    @Override
    public boolean isSystemSearchedFirst() {
        return true;
    }

    @Override
    public void setSystemSearchedFirst(boolean bl) {
    }

    @Override
    public void flushCache() {
    }

    @Override
    public byte[] getResourceByteArray(String string) {
        return null;
    }

    @Override
    public String getProviderDirectory(String string) {
        String string2 = this._providerDirectories.get(string);
        if (string2 == null) {
            return this.getProviderDirectory();
        }
        return string2;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        Enumeration<ClasspathPart> enumeration = this._classpathParts.elements();
        while (enumeration.hasMoreElements()) {
            ClasspathPart classpathPart = enumeration.nextElement();
            inputStream = classpathPart.getResourceAsStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return super.getResourceAsStream(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        ClasspathPart classpathPart = null;
        byte[] byArray = null;
        File file = null;
        CodeSource codeSource = null;
        try {
            Enumeration<ClasspathPart> enumeration = this._classpathParts.elements();
            while (enumeration.hasMoreElements() && (byArray = (classpathPart = enumeration.nextElement()).getClassBytes(string)) == null) {
            }
            if (byArray != null) {
                this.definePackage(string, classpathPart);
                file = new File(classpathPart.getClasspath());
                codeSource = new CodeSource(file.toURI().toURL(), (Certificate[])null);
                return this.defineClass(string, byArray, 0, byArray.length, codeSource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ClassNotFoundException(string);
    }

    @Override
    protected URL findResource(String string) {
        ClasspathPart classpathPart = null;
        URL uRL = null;
        File file = null;
        try {
            Enumeration<ClasspathPart> enumeration = this._classpathParts.elements();
            while (enumeration.hasMoreElements() && ((uRL = (classpathPart = enumeration.nextElement()).getResource(string)) == null || uRL.getProtocol().equals("file") && !(file = new File(uRL.getFile())).exists())) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRL;
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        Vector<URL> vector = new Vector<URL>(20);
        ClasspathPart classpathPart = null;
        URL uRL = null;
        try {
            Enumeration<ClasspathPart> enumeration = this._classpathParts.elements();
            while (enumeration.hasMoreElements()) {
                classpathPart = enumeration.nextElement();
                uRL = classpathPart.getResource(string);
                if (uRL == null) continue;
                vector.add(uRL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector.elements();
    }

    private void definePackage(String string, ClasspathPart classpathPart) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        try {
            if (classpathPart.type == 2) {
                this.definePackage(string2, classpathPart.specTitle, classpathPart.specVersion, classpathPart.specVendor, classpathPart.implTitle, classpathPart.implVersion, classpathPart.implVendor, new URL(JAR_STRING, BLANK_STRING, classpathPart.classpath + JAR_SYNTAX_STRING));
            } else {
                this.definePackage(string2, BLANK_STRING, BLANK_STRING, BLANK_STRING, BLANK_STRING, BLANK_STRING, BLANK_STRING, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void releaseResources() {
        ClasspathPart classpathPart = null;
        if (this._classpathParts != null) {
            Enumeration<ClasspathPart> enumeration = this._classpathParts.elements();
            while (enumeration.hasMoreElements()) {
                classpathPart = enumeration.nextElement();
                classpathPart.releaseResources();
            }
            this._classpathParts.clear();
            this._classpathParts = null;
        }
        if (this._providerDirectories != null) {
            this._providerDirectories.clear();
        }
        this._providerDirectories = null;
        this._fullClasspath = null;
    }
}

