/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.IHelpConstants;
import com.sybase.central.viewer.ScjSession;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.util.DetailsErrorDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;

class SCHelpManager
implements IHelpConstants {
    private ScjSession _session = null;
    private HelpViewer _helpViewer = null;
    private HelpNotFoundException _notfound = null;

    SCHelpManager(ScjSession scjSession) {
        this._session = scjSession;
    }

    private void initHelpViewer(Window window) {
        if (this._notfound == null) {
            String string = null;
            if (!this._session.isApplet() && (string = this._session.getCommandLineProperties().getProperty("installdir")) == null) {
                string = "";
            }
            String string2 = "scvw.hs";
            try {
                this._helpViewer = !this._session.isApplet() ? FactoryHelp.getViewer((String)string, (String)"scvw", (String)(Integer.toString(6) + Integer.toString(0) + Integer.toString(0))) : FactoryHelp.getViewer((String)string2);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                this.showErrorDialog(window, ScjSession.getString("STR_APP_NAME"), ScjSession.getString("ERR_SHOWING_HELP"), helpNotFoundException);
                this._notfound = helpNotFoundException;
            }
        }
    }

    void showOnlineBooks(Window window) {
        if (this._helpViewer == null) {
            this.initHelpViewer(window);
        }
        if (this._helpViewer != null) {
            this._helpViewer.turnPage();
        }
    }

    void showHelpIndex(String string, Window window) {
        if (this._helpViewer == null) {
            this.initHelpViewer(window);
        }
        if (this._helpViewer != null) {
            this._helpViewer.turnPage(string, window);
        }
    }

    private void showErrorDialog(Window window, String string, String string2, Throwable throwable) {
        if (window instanceof JDialog) {
            DetailsErrorDialog.showDetailsErrorDialog((Dialog)((JDialog)window), (String)string, (String)string2, (Throwable)throwable, null);
        } else if (window instanceof JFrame) {
            DetailsErrorDialog.showDetailsErrorDialog((Frame)((JFrame)window), (String)string, (String)string2, (Throwable)throwable, null);
        }
    }

    public void releaseResources() {
        this._session = null;
        if (this._helpViewer != null) {
            FactoryHelp.disposeOfViewer((HelpViewer)this._helpViewer);
        }
        this._helpViewer = null;
        this._notfound = null;
    }
}

