/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.SCTextField;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class SCIntegerTextField
extends SCTextField {
    private Toolkit _toolkit = Toolkit.getDefaultToolkit();

    SCIntegerTextField() {
        this._init();
    }

    private void _init() {
        this.setDocument(new IntegerDocument());
        this.setHorizontalAlignment(4);
    }

    int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    void setValue(int n) {
        this.setText(String.valueOf(n));
    }

    void setPreferredWidthToDigits(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        try {
            int n2 = (int)(Math.pow(10.0, n) - 1.0);
            int n3 = fontMetrics.stringWidth(String.valueOf(n2));
            this.setPreferredWidth(n3, true);
        }
        catch (ArithmeticException arithmeticException) {
            return;
        }
    }

    private class IntegerDocument
    extends PlainDocument {
        private IntegerDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = cArray2.length;
            for (int i = 0; i < n3; ++i) {
                if (Character.isDigit(cArray[i])) {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                SCIntegerTextField.this._toolkit.beep();
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

