/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.SCIconTextData;
import com.sybase.central.viewer.SCIconTextDataListCellRenderer;
import com.sybase.central.viewer.SCScrollPane;
import com.sybase.central.viewer.SCUserData;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;

class SCList
extends JList {
    private static final String STR_EMPTY = "";
    private DefaultListModel _model;
    private SCScrollPane _scrollPane;

    public SCList() {
        this._model = new DefaultListModel();
        this.setModel(this._model);
        this._init();
    }

    SCList(DefaultListModel defaultListModel) {
        super(defaultListModel);
        this._model = defaultListModel;
    }

    public SCList(Object[] objectArray) {
        this.setModel(objectArray);
        this._init();
    }

    public SCList(Vector vector) {
        this.setModel(vector);
        this._init();
    }

    private void _init() {
        this._scrollPane = new SCScrollPane(this);
    }

    public void releaseResources() {
        this._model = null;
        this._scrollPane = null;
    }

    public void setModel(Object[] objectArray) {
        this._model = new DefaultListModel();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this._model.addElement(objectArray[i]);
        }
        this.setModel(this._model);
    }

    public void setModel(Vector vector) {
        this._model = new DefaultListModel();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this._model.addElement(vector.get(i));
        }
        this.setModel(this._model);
    }

    public boolean getHasIconTextData() {
        return this.getCellRenderer() instanceof SCIconTextDataListCellRenderer;
    }

    public void setHasIconTextData(boolean bl) {
        this.setCellRenderer(bl ? new SCIconTextDataListCellRenderer() : new DefaultListCellRenderer());
    }

    public SCScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public int getItemCount() {
        return this._model.getSize();
    }

    public void selectItem(int n) {
        this.setSelectionInterval(n, n);
    }

    public void selectRows(int n, int n2) {
        this.setSelectionInterval(n, n2);
    }

    public void selectItems(int[] nArray) {
        this.clearSelection();
        for (int n : nArray) {
            this.addSelectionInterval(n, n);
        }
    }

    public Object getValueAt(int n) {
        return this._model.get(n);
    }

    public void setValueAt(int n, Object object) {
        this._model.set(n, object);
    }

    public String getStringAt(int n) {
        Object e = this._model.get(n);
        return e == null ? STR_EMPTY : e.toString();
    }

    public void setStringAt(int n, String string) {
        Object object;
        Object e = this._model.get(n);
        if (e == null || e instanceof String) {
            object = string;
        } else if (e instanceof SCIconTextData) {
            SCIconTextData sCIconTextData = (SCIconTextData)e;
            sCIconTextData.text = string;
            object = sCIconTextData;
        } else {
            throw new UnsupportedOperationException();
        }
        this._model.set(n, object);
    }

    public Icon getIconAt(int n) {
        Icon icon;
        Object e = this._model.get(n);
        if (e == null) {
            icon = null;
        } else if (e instanceof Icon) {
            icon = (Icon)e;
        } else if (e instanceof SCIconTextData) {
            icon = ((SCIconTextData)e).icon;
        } else {
            throw new UnsupportedOperationException();
        }
        return icon;
    }

    public void setIconAt(int n, Icon icon) {
        Object object;
        Object e = this._model.get(n);
        if (e == null || e instanceof Icon) {
            object = icon;
        } else if (e instanceof SCIconTextData) {
            SCIconTextData sCIconTextData = (SCIconTextData)e;
            sCIconTextData.icon = icon;
            object = sCIconTextData;
        } else {
            throw new UnsupportedOperationException();
        }
        this._model.set(n, object);
    }

    public Object getUserDataAt(int n) {
        Object e = this._model.get(n);
        if (e == null || !(e instanceof SCUserData)) {
            throw new UnsupportedOperationException();
        }
        Object object = ((SCUserData)e).getUserData();
        return object;
    }

    public void setUserDataAt(int n, Object object) {
        Object e = this._model.get(n);
        if (e == null || !(e instanceof SCUserData)) {
            throw new UnsupportedOperationException();
        }
        SCUserData sCUserData = (SCUserData)e;
        sCUserData.setUserData(object);
        this._model.set(n, sCUserData);
    }

    public int findItem(String string) {
        return this.findItem(string, 0, this._model.getSize(), false, false);
    }

    public int findItem(String string, int n) {
        return this.findItem(string, n, this._model.getSize(), false, false);
    }

    public int findItem(String string, int n, int n2, boolean bl, boolean bl2) {
        int n3 = string.length();
        for (int i = n; i < n2; ++i) {
            String string2 = this.getStringAt(i);
            if (string2 == null || !string2.regionMatches(bl, 0, string, 0, bl2 ? n3 : string2.length())) continue;
            return i;
        }
        return -1;
    }

    public void moveItem(int n, int n2) {
        Object e = this._model.remove(n);
        this._model.add(n2, e);
    }

    public void addItem(Object object) {
        this._model.addElement(object);
    }

    public void insertItem(int n, Object object) {
        this._model.add(n, object);
    }

    public void removeItem(int n) {
        this._model.remove(n);
    }

    public void clear() {
        this._model.clear();
    }
}

