/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.SCIconTextData;
import com.sybase.central.viewer.SCIconTextTableCellRenderer;
import com.sybase.central.viewer.SCIconTextUserData;
import com.sybase.central.viewer.SCMultiListTableHeaderRenderer;
import com.sybase.central.viewer.SCMultiListTableModel;
import com.sybase.central.viewer.SCScrollPane;
import com.sybase.central.viewer.SCSortingTableModel;
import com.sybase.central.viewer.SCUserData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SCMultiList
extends JTable
implements ActionListener {
    protected static final String STR_EMPTY = "";
    protected static final String STR_LIST_DELIMITER = ",";
    protected static final String[] DEFAULT_COLUMN_NAMES = new String[]{" "};
    protected SCScrollPane scrollPane;
    protected SCSortingTableModel tableModel;
    protected TableColumnModel tableColumnModel;
    protected int columnCount;
    private boolean _autoKeySelectionEnabled = true;
    private Timer _timer = null;
    private StringBuffer _typedSoFar = null;
    private boolean _sameKeyChar = true;
    private int _ticksWithoutActivity = 0;
    private boolean _ascendingSortOrder = true;
    private int _sortedColumnNumber = -1;
    protected static Set<KeyStroke> FORWARD_TRAVERSAL_KEYSTROKES = new TreeSet<KeyStroke>();
    protected static Set<KeyStroke> BACKWARD_TRAVERSAL_KEYSTROKES;

    SCMultiList() {
        this.setModel(new SCMultiListTableModel(DEFAULT_COLUMN_NAMES, 0));
        this._init();
    }

    SCMultiList(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.setModel(new SCMultiListTableModel(vector, vector2));
        this._init();
    }

    SCMultiList(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.setModel(new SCMultiListTableModel(objectArray, objectArray2));
        this._init();
    }

    SCMultiList(String string) {
        Object[] objectArray = SCMultiList.parseStringList(string, STR_LIST_DELIMITER);
        this.setModel(new SCMultiListTableModel(objectArray, 0));
        this._init();
    }

    SCMultiList(Vector vector) {
        this.setModel(new SCMultiListTableModel(vector, 0));
        this._init();
    }

    SCMultiList(Object[] objectArray) {
        this.setModel(new SCMultiListTableModel(objectArray, 0));
        this._init();
    }

    private void _init() {
        this.scrollPane = new SCScrollPane(this);
        this.setShowGrid(false);
        if (this.getTableHeader() != null) {
            this.getTableHeader().setReorderingAllowed(false);
        }
        this.setFocusTraversalKeys(0, FORWARD_TRAVERSAL_KEYSTROKES);
        this.setFocusTraversalKeys(1, BACKWARD_TRAVERSAL_KEYSTROKES);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "none");
        inputMap.put(KeyStroke.getKeyStroke(10, 1), "none");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "none");
        this._typedSoFar = new StringBuffer();
        this._timer = new Timer(500, this);
        this._timer.start();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl && !this._timer.isRunning() && this._autoKeySelectionEnabled) {
            this._typedSoFar.setLength(0);
            this._sameKeyChar = true;
            this._timer.restart();
        } else if (!bl && this._timer.isRunning()) {
            this._timer.stop();
        }
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.columnMarginChanged(new ChangeEvent(this));
        }
    }

    public void setAutoKeySelectionEnabled(boolean bl) {
        if (bl && !this._timer.isRunning()) {
            this._timer.restart();
        }
        if (!bl && this._timer.isRunning()) {
            this._timer.stop();
        }
        this._autoKeySelectionEnabled = bl;
    }

    public boolean isAutoKeySelectionEnabled() {
        return this._timer.isRunning();
    }

    public void setSorting(boolean bl) {
        this.tableModel.setSorting(bl);
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    public boolean isSorting() {
        if (this.tableModel == null) {
            return false;
        }
        return this.tableModel.isSorting();
    }

    public void setModel(SCMultiListTableModel sCMultiListTableModel) {
        this.setModel(new SCSortingTableModel(this, sCMultiListTableModel));
    }

    protected void setModel(SCSortingTableModel sCSortingTableModel) {
        if (this.tableModel != null) {
            this.clear();
        }
        super.setModel(sCSortingTableModel);
        this.tableModel = sCSortingTableModel;
        this.tableColumnModel = this.getColumnModel();
        this.columnCount = this.tableColumnModel.getColumnCount();
        this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.setDefaultRenderer(new SCMultiListTableHeaderRenderer(this));
        }
    }

    public boolean getColumnHasIconTextData(int n) {
        return this.tableColumnModel.getColumn(n).getCellRenderer() instanceof SCIconTextTableCellRenderer;
    }

    public void setColumnHasIconTextData(int n, boolean bl) {
        this.tableColumnModel.getColumn(n).setCellRenderer(bl ? new SCIconTextTableCellRenderer() : new DefaultTableCellRenderer());
    }

    public SCScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setColumnHeadings(String string) {
        Object[] objectArray = SCMultiList.parseStringList(string, STR_LIST_DELIMITER);
        this.setModel(new SCMultiListTableModel(objectArray, 0));
    }

    public void setColumnHeadings(Vector vector) {
        this.setModel(new SCMultiListTableModel(vector, 0));
    }

    public void setColumnHeadings(Object[] objectArray) {
        this.setModel(new SCMultiListTableModel(objectArray, 0));
    }

    public void setColumnWidths(String string) {
        String[] stringArray = SCMultiList.parseStringList(string, STR_LIST_DELIMITER);
        for (int i = 0; i < this.columnCount && i < stringArray.length; ++i) {
            this.tableColumnModel.getColumn(i).setPreferredWidth(Integer.valueOf(stringArray[i]));
        }
    }

    public String getColumnWidths() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.columnCount; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.tableColumnModel.getColumn(i).getWidth());
        }
        return stringBuilder.toString();
    }

    public void setColumnWidths(int[] nArray) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.tableColumnModel.getColumn(i).setPreferredWidth(nArray[i]);
        }
    }

    public void setColumnWidthToFit(int n, String[] stringArray) {
        TableColumn tableColumn = this.tableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = null;
        tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        }
        int n2 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)((String)tableColumn.getHeaderValue()), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)stringArray[i], (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
            n2 = Math.max(n2, n4);
        }
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
    }

    public void setColumnWidthToFit(int n, int n2) {
        String string;
        TableColumn tableColumn = this.tableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = null;
        tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        }
        try {
            string = new Integer((int)Math.pow(10.0, n2 - 1)).toString();
        }
        catch (ArithmeticException arithmeticException) {
            return;
        }
        int n3 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)((String)tableColumn.getHeaderValue()), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        int n4 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)string, (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        int n5 = Math.max(n3, n4);
        tableColumn.setPreferredWidth(n5);
        tableColumn.setMinWidth(n5);
        tableColumn.setMaxWidth(n5);
    }

    public void setInitialColumnWidths() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.tableModel.getColumnCount();
        int n2 = this.getPreferredScrollableViewportSize().height;
        int n3 = n2 / this.getRowHeight();
        int n4 = this.getRowCount();
        int n5 = Math.min(n4, n3);
        if (n5 < 10 && n4 >= 10) {
            n5 = 10;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n6 = 0;
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader != null) {
                tableCellRenderer = jTableHeader.getDefaultRenderer();
                object = tableColumn.getHeaderValue();
                if (object != null) {
                    try {
                        n6 = tableCellRenderer.getTableCellRendererComponent(null, (Object)object, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
            for (int j = 0; j < n5; ++j) {
                tableCellRenderer = this.getCellRenderer(j, i);
                object = this.tableModel.getValueAt(j, i);
                if (object == null && j >= (n5 = Math.min(this.getRowCount(), 10))) break;
                int n7 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n6 = Math.max(n6, n7);
            }
            tableColumn.setPreferredWidth(n6 + 2);
        }
        this.sizeColumnsToFit(-1);
    }

    public void selectRow(int n) {
        this.setRowSelectionInterval(n, n);
    }

    public void selectRows(int n, int n2) {
        this.setRowSelectionInterval(n, n2);
    }

    public void selectRows(int[] nArray) {
        this.clearSelection();
        for (int n : nArray) {
            this.addRowSelectionInterval(n, n);
        }
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public Icon getIconAt(int n, int n2) {
        Object object = this.tableModel.getValueAt(n, n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Icon) {
            return (Icon)object;
        }
        if (object instanceof SCIconTextData) {
            return ((SCIconTextData)object).icon;
        }
        if (object instanceof SCIconTextUserData) {
            return ((SCIconTextUserData)object).icon;
        }
        return null;
    }

    public void setIconAt(Icon icon, int n, int n2) {
        Object object = this.tableModel.getValueAt(n, n2);
        if (object == null) {
            this.tableModel.setValueAt(icon, n, n2);
        } else if (object instanceof SCIconTextData) {
            ((SCIconTextData)object).icon = icon;
            this.tableModel.fireTableCellUpdated(n, n2);
        } else if (object instanceof SCIconTextUserData) {
            ((SCIconTextUserData)object).icon = icon;
            this.tableModel.fireTableCellUpdated(n, n2);
        } else {
            this.tableModel.setValueAt(icon, n, n2);
        }
    }

    public String getStringAt(int n, int n2) {
        Object object = this.tableModel.getValueAt(n, n2);
        if (object == null) {
            return new String();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public void setStringAt(String string, int n, int n2) {
        Object object = this.tableModel.getValueAt(n, n2);
        if (object == null) {
            this.tableModel.setValueAt(string, n, n2);
        } else if (object instanceof SCIconTextData) {
            ((SCIconTextData)object).text = string;
            this.tableModel.fireTableCellUpdated(n, n2);
        } else if (object instanceof SCIconTextUserData) {
            ((SCIconTextUserData)object).text = string;
            this.tableModel.fireTableCellUpdated(n, n2);
        } else {
            this.tableModel.setValueAt(string, n, n2);
        }
    }

    public Object getUserDataAt(int n, int n2) {
        Object object = this.tableModel.getValueAt(n, n2);
        if (object instanceof SCUserData) {
            return ((SCUserData)object).getUserData();
        }
        return null;
    }

    public void setUserDataAt(Object object, int n, int n2) {
        Object object2 = this.tableModel.getValueAt(n, n2);
        if (object2 instanceof SCUserData) {
            ((SCUserData)object2).setUserData(object);
            this.tableModel.fireTableCellUpdated(n, n2);
        }
    }

    public Vector getRow(int n) {
        Vector<Object> vector = new Vector<Object>(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            vector.add(this.getValueAt(n, i));
        }
        return vector;
    }

    public Vector getRowAsStringData(int n) {
        Vector<String> vector = new Vector<String>(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            vector.add(this.getStringAt(n, i));
        }
        return vector;
    }

    public Object[] getRowAsArray(int n) {
        Object[] objectArray = new Object[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            objectArray[i] = this.getValueAt(n, i);
        }
        return objectArray;
    }

    public Object getRowAsStringDataArray(int n) {
        Object[] objectArray = new Object[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            objectArray[i] = this.getStringAt(n, i);
        }
        return objectArray;
    }

    public Vector getDataVector() {
        return this.tableModel.getDataVector();
    }

    public void setRow(int n, Vector vector) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.tableModel.setValueAt(vector.get(i), n, i);
        }
    }

    public void setRow(int n, Object[] objectArray) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.tableModel.setValueAt(objectArray[i], n, i);
        }
    }

    public int findRow(String string) {
        return this.findRow(string, 0);
    }

    public int findRow(String string, int n) {
        int n2 = this.getRowCount();
        for (int i = n; i < n2; ++i) {
            if (!this.getValueAt(i, 0).toString().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void sort() {
        this.tableModel.sortByColumn(0, true);
    }

    public void sort(int n) {
        this.tableModel.sortByColumn(n, true);
    }

    public void sort(boolean bl) {
        this.tableModel.sortByColumn(0, bl);
    }

    public void sort(int n, boolean bl) {
        this.tableModel.sortByColumn(n, bl);
    }

    public void moveRow(int n, int n2, int n3) {
        this.tableModel.moveRow(n, n2, n3);
        this.clearSelection();
    }

    public void addRow(Vector vector) {
        this.tableModel.addRow(vector);
        this.clearSelection();
    }

    public void addRow(Object[] objectArray) {
        this.tableModel.addRow(objectArray);
        this.clearSelection();
    }

    public void addRowWithIcon(Icon icon, Vector vector) {
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.add(enumeration.nextElement());
        }
        vector2.set(0, new SCIconTextUserData(icon, vector.firstElement().toString(), vector.firstElement()));
        this.tableModel.addRow(vector2);
        this.clearSelection();
    }

    public void insertRow(int n, Vector vector) {
        this.tableModel.insertRow(n, vector);
        this.clearSelection();
    }

    public void insertRow(int n, Object[] objectArray) {
        this.tableModel.insertRow(n, objectArray);
        this.clearSelection();
    }

    public void insertRowWithIcon(int n, Icon icon, Vector vector) {
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.add(enumeration.nextElement());
        }
        vector2.set(0, new SCIconTextUserData(icon, vector.firstElement().toString(), vector.firstElement()));
        this.tableModel.insertRow(n, vector2);
        this.clearSelection();
    }

    public void removeRow(int n) {
        this.tableModel.removeRow(n);
    }

    public void clear() {
        if (this.tableModel != null) {
            this.tableModel.clear();
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        Object object = null;
        if (n > -1) {
            object = this.tableModel.getValueAt(n, 0);
            if (object instanceof SCIconTextData) {
                return ((SCIconTextData)object).toolTipText;
            }
            if (object instanceof SCIconTextUserData) {
                return ((SCIconTextUserData)object).toolTipText;
            }
        }
        return null;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        int n2;
        if (this._timer.isRunning() && (keyEvent.getModifiers() == 0 || (keyEvent.getModifiers() & 1) != 0) && n == 0 && keyEvent.getKeyCode() == 0 && keyEvent.getKeyChar() != '\uffff' && (n2 = this.getRowCount()) > 0) {
            this._timer.stop();
            char c = keyEvent.getKeyChar();
            this._ticksWithoutActivity = 0;
            if (this._typedSoFar.length() > 0 && this._typedSoFar.charAt(this._typedSoFar.length() - 1) != c) {
                this._sameKeyChar = false;
            }
            this._typedSoFar.append(c);
            int n3 = 0;
            int[] nArray = this.getSelectedRows();
            if (nArray.length > 0) {
                n3 = nArray[nArray.length - 1];
            }
            boolean bl2 = false;
            bl2 = this._sameKeyChar ? this.selectMatchingRow(++n3, n2, String.valueOf(c)) : this.selectMatchingRow(n3, n2, this._typedSoFar.toString());
            if (!bl2) {
                if (this._sameKeyChar) {
                    this.selectMatchingRow(0, n3, String.valueOf(c));
                } else {
                    this.selectMatchingRow(0, n3, this._typedSoFar.toString());
                }
            }
            this._timer.restart();
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private boolean selectMatchingRow(int n, int n2, String string) {
        int n3 = string.length();
        for (int i = n; i < n2; ++i) {
            String string2;
            Object object = this.tableModel.getValueAt(i, 0);
            if (object == null || (string2 = object.toString()).length() < n3 || !string2.regionMatches(true, 0, string, 0, n3)) continue;
            this.setRowSelectionInterval(i, i);
            this.scrollRectToVisible(this.getCellRect(i, 0, true));
            return true;
        }
        return false;
    }

    boolean isAscendingSortOrder() {
        return this._ascendingSortOrder;
    }

    void setAscendingSortOrder(boolean bl) {
        this._ascendingSortOrder = bl;
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    int getSortedColumnNumber() {
        if (!this.isSorting()) {
            this._sortedColumnNumber = -1;
        }
        return this._sortedColumnNumber;
    }

    void setSortedColumnNumber(int n) {
        this._sortedColumnNumber = n;
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    public void releaseResources() {
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
        this._timer.removeActionListener(this);
        this.tableModel.releaseResources();
        this._timer = null;
        this._typedSoFar = null;
        this.scrollPane = null;
        this.tableModel = null;
        this.tableColumnModel = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._timer && ++this._ticksWithoutActivity == 2) {
            this._typedSoFar.setLength(0);
            this._sameKeyChar = true;
        }
    }

    public static String[] parseStringList(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        try {
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken().trim();
            }
        }
        catch (Exception exception) {
            stringArray = null;
        }
        return stringArray;
    }

    static {
        FORWARD_TRAVERSAL_KEYSTROKES.add(KeyStroke.getKeyStroke(9, 0));
        BACKWARD_TRAVERSAL_KEYSTROKES = new TreeSet<KeyStroke>();
        BACKWARD_TRAVERSAL_KEYSTROKES.add(KeyStroke.getKeyStroke(9, 1));
    }
}

