/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.SCIconTextData;
import com.sybase.central.viewer.SCIconTextUserData;
import com.sybase.central.viewer.SCMultiList;
import com.sybase.central.viewer.SCMultiListTableModel;
import com.sybase.central.viewer.SCPercentData;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class SCSortingTableModel
extends AbstractTableModel
implements TableModelListener {
    private SCMultiList _table = null;
    private SCMultiListTableModel _model = null;
    private boolean _sorting = true;
    private Integer[] _mappingIndexes = null;
    private boolean _ascending = true;
    private int _lastSortedColumn = -1;
    private MouseAdapter _listMouseListener = null;
    private boolean _enableChangeEvents = true;

    SCSortingTableModel(SCMultiList sCMultiList) {
        this._table = sCMultiList;
        this._model = (SCMultiListTableModel)this._table.getModel();
        this.addMouseListenerToHeaderInTable();
    }

    SCSortingTableModel(SCMultiList sCMultiList, SCMultiListTableModel sCMultiListTableModel) {
        this._table = sCMultiList;
        this.setModel(sCMultiListTableModel);
        this.resetIndexes(true);
        this.addMouseListenerToHeaderInTable();
    }

    public void clear() {
        this._model.setNumRows(0);
        this.resetIndexes(true);
    }

    public void setSorting(boolean bl) {
        this._sorting = bl;
    }

    public boolean isSorting() {
        return this._sorting;
    }

    public void setModel(SCMultiListTableModel sCMultiListTableModel) {
        this._model = sCMultiListTableModel;
        this._model.addTableModelListener(this);
        this.resetIndexes(true);
        this._table.createDefaultColumnsFromModel();
    }

    public TableModel getModel() {
        return this._model;
    }

    public int getDataIndexForTableIndex(int n) {
        return this._mappingIndexes[n];
    }

    public int getTableIndexForDataIndex(int n) {
        for (int i = 0; i < this._mappingIndexes.length; ++i) {
            if (this._mappingIndexes[i] != n) continue;
            return i;
        }
        return -1;
    }

    public void releaseResources() {
        JTableHeader jTableHeader = this._table.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.removeMouseListener(this._listMouseListener);
        }
        this._table = null;
        this._model = null;
        this._mappingIndexes = null;
    }

    private void addMouseListenerToHeaderInTable() {
        this._table.setColumnSelectionAllowed(false);
        this._listMouseListener = new MouseAdapter(){
            private int[] _oldWidths;
            private int _col;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = SCSortingTableModel.this._table.getColumnModel();
                this._oldWidths = new int[tableColumnModel.getColumnCount()];
                for (int i = 0; i < this._oldWidths.length; ++i) {
                    this._oldWidths[i] = tableColumnModel.getColumn(i).getWidth();
                }
                this._col = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                TableColumnModel tableColumnModel = SCSortingTableModel.this._table.getColumnModel();
                if (tableColumnModel.getColumnCount() == this._oldWidths.length) {
                    for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
                        if (tableColumnModel.getColumn(n).getWidth() == this._oldWidths[n]) continue;
                        return;
                    }
                } else {
                    return;
                }
                if (SCSortingTableModel.this._table.isEnabled() && SCSortingTableModel.this._sorting && this._col == (n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX()))) {
                    SCSortingTableModel.this._table.getSelectionModel().clearSelection();
                    int n2 = SCSortingTableModel.this._table.convertColumnIndexToModel(n);
                    if (n2 != -1) {
                        if (n2 == SCSortingTableModel.this._lastSortedColumn) {
                            SCSortingTableModel.this._ascending = !SCSortingTableModel.this._ascending;
                        } else {
                            SCSortingTableModel.this._ascending = true;
                        }
                        SCSortingTableModel.this._lastSortedColumn = n2;
                        SCSortingTableModel.this.sortByColumn(n2);
                    }
                }
            }
        };
        JTableHeader jTableHeader = this._table.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.addMouseListener(this._listMouseListener);
        }
    }

    public void sortByColumn(int n, boolean bl) {
        this._ascending = bl;
        this._lastSortedColumn = n;
        this.sortByColumn(n);
        this._table.setSortedColumnNumber(this._lastSortedColumn);
        this._table.setAscendingSortOrder(this._ascending);
    }

    private void sortByColumn(int n) {
        TableCellEditor tableCellEditor = this._table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        this.resetIndexes(false);
        this._table.setSortedColumnNumber(this._lastSortedColumn);
        this._table.setAscendingSortOrder(this._ascending);
        Arrays.sort(this._mappingIndexes, new SortComparator(n));
        this.tableChanged(new TableModelEvent(this));
    }

    private void resetIndexes(boolean bl) {
        this._mappingIndexes = new Integer[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            this._mappingIndexes[i] = new Integer(i);
        }
        if (bl) {
            this._lastSortedColumn = -1;
            this._ascending = true;
            this._table.setSortedColumnNumber(this._lastSortedColumn);
            this._table.setAscendingSortOrder(this._ascending);
        }
    }

    private void addRowToMappingArray(int n) {
        Integer[] integerArray = null;
        if (this._mappingIndexes != null) {
            integerArray = new Integer[this._mappingIndexes.length + 1];
            System.arraycopy(this._mappingIndexes, 0, integerArray, 0, n);
            if (this._mappingIndexes.length > n) {
                System.arraycopy(this._mappingIndexes, n, integerArray, n + 1, this._mappingIndexes.length - n);
            }
        } else {
            integerArray = new Integer[1];
        }
        integerArray[n] = new Integer(integerArray.length - 1);
        this._mappingIndexes = integerArray;
        integerArray = null;
        this.tableChanged(new TableModelEvent(this, n, n, -1, 1));
    }

    private void removeRowFromMappingArray(int n) {
        Integer[] integerArray = new Integer[this._mappingIndexes.length - 1];
        int n2 = 0;
        int n3 = this._mappingIndexes[n];
        for (int i = 0; i < this._mappingIndexes.length; ++i) {
            if (this._mappingIndexes[i] < n3) {
                integerArray[n2++] = new Integer(this._mappingIndexes[i]);
                continue;
            }
            if (this._mappingIndexes[i] <= n3) continue;
            integerArray[n2++] = new Integer(this._mappingIndexes[i] - 1);
        }
        this._mappingIndexes = integerArray;
        integerArray = null;
        this.tableChanged(new TableModelEvent(this, n, n, -1, -1));
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._model.getValueAt(this._mappingIndexes[n], n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this._model.setValueAt(object, this._mappingIndexes[n], n2);
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public int getRowCount() {
        if (this._model == null) {
            return 0;
        }
        return this._model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this._model == null) {
            return 0;
        }
        return this._model.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this._model.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this._model.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this._model.isCellEditable(this.getDataIndexForTableIndex(n), n2);
    }

    public Vector getDataVector() {
        return this._model.getDataVector();
    }

    public void moveRow(int n, int n2, int n3) {
        this._enableChangeEvents = false;
        this._model.moveRow(n, n2, n3);
        this._enableChangeEvents = true;
        this.fireTableDataChanged();
    }

    public void insertRow(int n, Object[] objectArray) {
        this._enableChangeEvents = false;
        this._model.addRow(objectArray);
        this._enableChangeEvents = true;
        this.addRowToMappingArray(n);
    }

    public void insertRow(int n, Vector vector) {
        this._enableChangeEvents = false;
        this._model.addRow(vector);
        this._enableChangeEvents = true;
        this.addRowToMappingArray(n);
    }

    public void addRow(Vector vector) {
        this._enableChangeEvents = false;
        this._model.addRow(vector);
        this._enableChangeEvents = true;
        this.addRowToMappingArray(this._mappingIndexes.length);
    }

    public void addRow(Object[] objectArray) {
        this._enableChangeEvents = false;
        this._model.addRow(objectArray);
        this._enableChangeEvents = true;
        this.addRowToMappingArray(this._mappingIndexes.length);
    }

    public void removeRow(int n) {
        this._enableChangeEvents = false;
        this._model.removeRow(this.getDataIndexForTableIndex(n));
        this._enableChangeEvents = true;
        this.removeRowFromMappingArray(n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this._enableChangeEvents) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    class SortComparator
    implements Comparator<Integer> {
        private int _column = 0;
        private Collator _localeSpecificCollator = Collator.getInstance();

        SortComparator(int n) {
            this._column = n;
        }

        @Override
        public int compare(Integer n, Integer n2) {
            int n3 = this.compareRowsByColumn(n, n2, this._column);
            if (n3 != 0) {
                return SCSortingTableModel.this._ascending ? n3 : -n3;
            }
            return 0;
        }

        public boolean equals(Integer n) {
            return super.equals(n);
        }

        private int compareRowsByColumn(int n, int n2, int n3) {
            Class clazz = SCSortingTableModel.this.getColumnClass(n3);
            Object object = SCSortingTableModel.this._model.getValueAt(n, n3);
            Object object2 = SCSortingTableModel.this._model.getValueAt(n2, n3);
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (clazz.getSuperclass() == Number.class) {
                Number number;
                double d;
                Number number2 = (Number)SCSortingTableModel.this._model.getValueAt(n, n3);
                double d2 = number2.doubleValue();
                if (d2 < (d = (number = (Number)SCSortingTableModel.this._model.getValueAt(n2, n3)).doubleValue())) {
                    return -1;
                }
                if (d2 > d) {
                    return 1;
                }
                return 0;
            }
            if (clazz == Date.class) {
                Date date;
                long l;
                Date date2 = (Date)SCSortingTableModel.this._model.getValueAt(n, n3);
                long l2 = date2.getTime();
                if (l2 < (l = (date = (Date)SCSortingTableModel.this._model.getValueAt(n2, n3)).getTime())) {
                    return -1;
                }
                if (l2 > l) {
                    return 1;
                }
                return 0;
            }
            if (clazz == SCIconTextData.class) {
                SCIconTextData sCIconTextData = (SCIconTextData)SCSortingTableModel.this._model.getValueAt(n, n3);
                SCIconTextData sCIconTextData2 = (SCIconTextData)SCSortingTableModel.this._model.getValueAt(n2, n3);
                int n4 = this._localeSpecificCollator.compare(sCIconTextData.text, sCIconTextData2.text);
                if (n4 < 0) {
                    return -1;
                }
                if (n4 > 0) {
                    return 1;
                }
                return 0;
            }
            if (clazz == SCIconTextUserData.class) {
                SCIconTextUserData sCIconTextUserData = (SCIconTextUserData)SCSortingTableModel.this._model.getValueAt(n, n3);
                SCIconTextUserData sCIconTextUserData2 = (SCIconTextUserData)SCSortingTableModel.this._model.getValueAt(n2, n3);
                if (sCIconTextUserData.comparable != null && sCIconTextUserData2.comparable != null) {
                    return sCIconTextUserData.comparable.compareTo(sCIconTextUserData2.comparable);
                }
                int n5 = this._localeSpecificCollator.compare(sCIconTextUserData.text, sCIconTextUserData2.text);
                if (n5 < 0) {
                    return -1;
                }
                if (n5 > 0) {
                    return 1;
                }
                return 0;
            }
            if (clazz == SCPercentData.class) {
                SCPercentData sCPercentData = (SCPercentData)SCSortingTableModel.this._model.getValueAt(n, n3);
                SCPercentData sCPercentData2 = (SCPercentData)SCSortingTableModel.this._model.getValueAt(n2, n3);
                if (sCPercentData.value < sCPercentData2.value) {
                    return -1;
                }
                if (sCPercentData.value > sCPercentData2.value) {
                    return 1;
                }
                return 0;
            }
            if (clazz == String.class) {
                String string;
                String string2 = (String)SCSortingTableModel.this._model.getValueAt(n, n3);
                int n6 = this._localeSpecificCollator.compare(string2, string = (String)SCSortingTableModel.this._model.getValueAt(n2, n3));
                if (n6 < 0) {
                    return -1;
                }
                if (n6 > 0) {
                    return 1;
                }
                return 0;
            }
            if (clazz == Boolean.class) {
                Boolean bl;
                boolean bl2;
                Boolean bl3 = (Boolean)SCSortingTableModel.this._model.getValueAt(n, n3);
                boolean bl4 = bl3;
                if (bl4 == (bl2 = (bl = (Boolean)SCSortingTableModel.this._model.getValueAt(n2, n3)).booleanValue())) {
                    return 0;
                }
                if (bl4) {
                    return 1;
                }
                return -1;
            }
            Object object3 = SCSortingTableModel.this._model.getValueAt(n, n3);
            String string = object3.toString();
            Object object4 = SCSortingTableModel.this._model.getValueAt(n2, n3);
            String string3 = object4.toString();
            if (string == null || string3 == null) {
                return 0;
            }
            int n7 = this._localeSpecificCollator.compare(string, string3);
            if (n7 < 0) {
                return -1;
            }
            if (n7 > 0) {
                return 1;
            }
            return 0;
        }
    }
}

