/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogController2;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import com.sybase.central.SCProvider2;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.SCButton;
import com.sybase.central.viewer.ScjNullLayoutManager;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.util.DialogUtils;
import com.sybase.util.Platform;
import com.sybase.util.UIUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

abstract class ScjBaseDialog
implements WindowListener,
ActionListener {
    protected SCDialogController _dialogController;
    protected JPanel _standardButtonPanel;
    protected Rectangle _largestPageSize;
    protected JFrame _parentJFrame;
    protected JDialog _parentJDialog;
    protected Dimension _minSize;
    protected ScjSession _scjSession;
    protected ScjViewerSupport _viewerSupport;
    protected int _currentPage;
    protected Vector<SCPageController> _pages = new Vector();
    protected int _openedPages = 0;
    protected JDialog _dialog;
    protected String _title = "";
    protected boolean _modal = false;
    protected boolean _resizable = false;
    protected boolean _standardButtons = true;
    protected boolean _helpButtonUsed = true;
    protected boolean _closedByCancel = true;
    protected static final String ESCAPE_KEY_PRESS = "ESCAPE_KEY_PRESS";
    protected static final String F1_KEY_RELEASE = "F1_KEY_RELEASE";
    private boolean _vistaAdministrator = false;

    public ScjBaseDialog(JFrame jFrame, ScjViewerSupport scjViewerSupport, SCDialogController sCDialogController, boolean bl) {
        this._currentPage = sCDialogController.getInitialPageNumber() + 1;
        this._viewerSupport = scjViewerSupport;
        this._dialogController = sCDialogController;
        this._parentJFrame = jFrame;
        this._scjSession = scjViewerSupport.getScjSession();
        SCPageController[] sCPageControllerArray = this._dialogController.getPageControllers();
        for (int i = 0; i < sCPageControllerArray.length; ++i) {
            this._largestPageSize = sCPageControllerArray[i].getJPanel().getBounds();
            this.addPage(sCPageControllerArray[i]);
        }
        this._parentJDialog = null;
        this._vistaAdministrator = bl;
    }

    public ScjBaseDialog(JDialog jDialog, ScjViewerSupport scjViewerSupport, SCDialogController sCDialogController, boolean bl) {
        this._currentPage = sCDialogController.getInitialPageNumber() + 1;
        this._viewerSupport = scjViewerSupport;
        this._dialogController = sCDialogController;
        this._parentJDialog = jDialog;
        this._scjSession = scjViewerSupport.getScjSession();
        SCPageController[] sCPageControllerArray = this._dialogController.getPageControllers();
        for (int i = 0; i < sCPageControllerArray.length; ++i) {
            this._largestPageSize = sCPageControllerArray[i].getJPanel().getBounds();
            this.addPage(sCPageControllerArray[i]);
        }
        this._parentJFrame = null;
        this._vistaAdministrator = bl;
    }

    protected boolean isVistaAdministrator() {
        return this._vistaAdministrator;
    }

    protected void extendDialog(SCDialogSupport sCDialogSupport) {
        if (this._dialogController.getDialogType() == 2 && this._dialogController instanceof SCDialogController2) {
            SCDialogController2 sCDialogController2 = (SCDialogController2)this._dialogController;
            Enumeration enumeration = this._viewerSupport.getProviders().getProviderExtensionList();
            while (enumeration.hasMoreElements()) {
                SCPageController[] sCPageControllerArray;
                ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
                if (!providerEntry.isLoaded() || !(providerEntry.getProvider() instanceof SCProvider2) || (sCPageControllerArray = ((SCProvider2)providerEntry.getProvider()).getPropertyExtensionPages(sCDialogController2.getSCItem2(), sCDialogSupport)) == null) continue;
                for (int i = 0; i < sCPageControllerArray.length; ++i) {
                    this._largestPageSize = sCPageControllerArray[i].getJPanel().getBounds();
                    this.addPage(sCPageControllerArray[i]);
                }
            }
        }
    }

    protected void init() {
        this._dialog.getRootPane().registerKeyboardAction(this, F1_KEY_RELEASE, IConstants.F1_RELEASE, 2);
        this._dialog.addWindowListener(this);
        this._dialog.setDefaultCloseOperation(0);
    }

    protected void fixNullLayout(JPanel jPanel) {
        if (jPanel.getLayout() == null) {
            jPanel.setLayout(new ScjNullLayoutManager());
        }
    }

    protected boolean decrementPage() {
        --this._currentPage;
        if (this._currentPage < 1) {
            this._currentPage = 1;
            return false;
        }
        SCPageController sCPageController = this._pages.elementAt(this._currentPage - 1);
        if (!this.pagePreviouslyOpened(this._currentPage)) {
            sCPageController.onInitDialog();
            this.setPagePreviouslyOpened(this._currentPage);
        }
        return true;
    }

    protected boolean incrementPage() {
        ++this._currentPage;
        if (this._currentPage > this._pages.size()) {
            this._currentPage = this._pages.size();
            return false;
        }
        SCPageController sCPageController = this._pages.elementAt(this._currentPage - 1);
        if (!this.pagePreviouslyOpened(this._currentPage)) {
            sCPageController.onInitDialog();
            this.setPagePreviouslyOpened(this._currentPage);
        }
        return true;
    }

    protected boolean pagePreviouslyOpened(int n) {
        return ((int)Math.pow(2.0, n - 1) & this._openedPages) != 0;
    }

    protected void setPagePreviouslyOpened(int n) {
        this._openedPages |= (int)Math.pow(2.0, n - 1);
    }

    protected void addPage(SCPageController sCPageController) {
        this._pages.addElement(sCPageController);
    }

    protected JDialog getJDialog() {
        return this._dialog;
    }

    protected void setTitle(String string) {
        this._title = string;
    }

    protected void setModal(boolean bl) {
        this._modal = bl;
    }

    protected boolean isModal() {
        return this._modal;
    }

    protected void setResizable(boolean bl) {
        this._resizable = bl;
    }

    protected void setStandardButtons(boolean bl) {
        this._standardButtons = bl;
    }

    protected void setHelpButton(boolean bl) {
        this._helpButtonUsed = bl;
    }

    protected abstract void setEnabledStandardButtons(int var1);

    protected abstract void setDefaultButtonById(int var1);

    public abstract SCButton getStandardButtonById(int var1);

    protected void releaseResources() {
        this._dialog.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this._dialog.getRootPane().unregisterKeyboardAction(IConstants.F1_RELEASE);
        this._dialog.removeWindowListener(this);
        this._dialog.dispose();
        DialogUtils.removeComponents((Container)this._dialog);
        this._pages.removeAllElements();
        this._pages = null;
        this._dialog = null;
        this._dialogController = null;
        this._standardButtonPanel = null;
        this._largestPageSize = null;
        this._parentJFrame = null;
        this._parentJDialog = null;
        this._scjSession = null;
        this._viewerSupport = null;
        this._minSize = null;
    }

    protected void enableEscapeKey(boolean bl) {
        if (bl) {
            this._dialog.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_PRESS, KeyStroke.getKeyStroke(27, 0, false), 2);
        } else {
            this._dialog.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        }
    }

    protected void showDialog() {
        this._dialog.setLocationRelativeTo(this._dialog.getParent());
        UIUtils.ensureWindowIsVisible((Window)this._dialog);
        this._dialog.setVisible(true);
    }

    protected void closeDialog() {
        this._dialog.setVisible(false);
        if (!this._modal) {
            this.releaseResources();
        }
    }

    protected abstract boolean render();

    protected boolean onOk() {
        for (int i = 0; i < this._pages.size(); ++i) {
            if (this._pages.elementAt(i).onOk()) continue;
            return false;
        }
        if (this._dialogController.onOk()) {
            this._closedByCancel = false;
            this.closeDialog();
            return true;
        }
        return false;
    }

    protected void onCancel() {
        for (int i = 0; i < this._pages.size(); ++i) {
            if (this._pages.elementAt(i).onCancel()) continue;
            return;
        }
        if (this._dialogController.onCancel()) {
            this.closeDialog();
        }
    }

    protected void onHelp() {
        this._pages.elementAt(this._currentPage - 1).onHelp();
    }

    protected boolean isModified() {
        for (int i = 0; i < this._pages.size(); ++i) {
            if (!this._pages.elementAt(i).isModified()) continue;
            return true;
        }
        return false;
    }

    protected void restrictMinimumSize() {
        Dimension dimension;
        if (Platform.isHP()) {
            return;
        }
        Dimension dimension2 = this._dialog.getSize();
        Rectangle rectangle = UIUtils.getWorkArea();
        if (dimension2.width <= rectangle.width && dimension2.height <= rectangle.height) {
            dimension = this._dialog.getPreferredSize();
        } else {
            dimension = dimension2.width > rectangle.width && dimension2.height > rectangle.height ? new Dimension(rectangle.width, rectangle.height) : (dimension2.width > rectangle.width ? new Dimension(rectangle.width, dimension2.height) : new Dimension(dimension2.width, rectangle.height));
            this._dialog.setSize(dimension);
        }
        this._dialog.setMinimumSize(dimension);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.onCancel();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this._dialog.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_PRESS, KeyStroke.getKeyStroke(27, 0, false), 2);
        this._minSize = this._dialog.getSize();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ESCAPE_KEY_PRESS)) {
            this.onCancel();
        } else if (actionEvent.getActionCommand().equals(F1_KEY_RELEASE)) {
            this.onHelp();
        }
    }
}

