/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.SCButton;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.ScjBaseDialog;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

class ScjDialog
extends ScjBaseDialog
implements ActionListener,
ScjResourceConstants {
    private SCButton _okButton;
    private SCButton _cancelButton;
    private SCButton _helpButton;

    public ScjDialog(JFrame jFrame, ScjViewerSupport scjViewerSupport, SCDialogController sCDialogController, SCDialogSupport sCDialogSupport, boolean bl) {
        super(jFrame, scjViewerSupport, sCDialogController, bl);
    }

    public ScjDialog(JDialog jDialog, ScjViewerSupport scjViewerSupport, SCDialogController sCDialogController, SCDialogSupport sCDialogSupport, boolean bl) {
        super(jDialog, scjViewerSupport, sCDialogController, bl);
    }

    @Override
    public boolean render() {
        if (this._scjSession.isWindows()) {
            this._scjSession.startWait();
        }
        this._dialog = this._parentJDialog == null ? (this._modal ? new SybModalDialog((Frame)this._parentJFrame) : new JDialog((Frame)this._parentJFrame, this._modal)) : (this._modal ? new SybModalDialog((Dialog)this._parentJDialog) : new JDialog((Dialog)this._parentJDialog, this._modal));
        this._dialog.setTitle(this._title);
        this._dialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = ((SCPageController)this._pages.elementAt(0)).getJPanel();
        super.fixNullLayout(jPanel);
        this._dialog.getContentPane().add((Component)jPanel, "Center");
        if (this._standardButtons) {
            this.createStandardButtons();
            this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._okButton));
        }
        this._dialog.pack();
        this._dialog.pack();
        this._dialog.setResizable(this._resizable);
        this.restrictMinimumSize();
        this.init();
        super.showDialog();
        if (this._scjSession.isWindows()) {
            this._scjSession.endWait();
        }
        return !this._closedByCancel;
    }

    private void createStandardButtons() {
        this._standardButtonPanel = new JPanel();
        this._standardButtonPanel.setLayout(new FlowLayout(2));
        String string = ScjSession.getString("STR_DLG_OK_BUTTON");
        String string2 = ScjSession.getString("STR_DLG_CANCEL_BUTTON");
        this._okButton = this.isVistaAdministrator() ? new SCButton(string, SCImageLoader.getImageIcon("vistashield", 1001)) : new SCButton(string);
        this._okButton.addActionListener(this);
        this._standardButtonPanel.add((Component)((Object)this._okButton));
        this._cancelButton = new SCButton(string2);
        this._cancelButton.addActionListener(this);
        this._standardButtonPanel.add((Component)((Object)this._cancelButton));
        if (this._helpButtonUsed) {
            String string3 = ScjSession.getString("STR_DLG_HELP_BUTTON");
            this._helpButton = new SCButton(string3);
            this._helpButton.addActionListener(this);
            this._standardButtonPanel.add((Component)((Object)this._helpButton));
            DialogUtils.makeComponentsSameWidth((JComponent[])new SCButton[]{this._okButton, this._cancelButton, this._helpButton});
        } else {
            DialogUtils.makeComponentsSameWidth((JComponent[])new SCButton[]{this._okButton, this._cancelButton});
        }
        this._dialog.getContentPane().add((Component)this._standardButtonPanel, "South");
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void releaseResources() {
        if (this._dialog != null) {
            if (this._standardButtons) {
                this._okButton.removeActionListener(this);
                this._cancelButton.removeActionListener(this);
                if (this._helpButtonUsed) {
                    this._helpButton.removeActionListener(this);
                }
            }
            super.releaseResources();
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        SCPageController sCPageController = (SCPageController)this._pages.elementAt(this._currentPage - 1);
        sCPageController.onInitDialog();
        int n = sCPageController.getEnabledStandardButtons();
        if (n != 0) {
            this.setEnabledStandardButtons(n);
        }
        sCPageController.onSetActive();
        super.windowOpened(windowEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._standardButtons) {
            if (actionEvent.getSource() == this._okButton) {
                this._okButton.setEnabled(false);
                if (!super.onOk()) {
                    this._okButton.setEnabled(true);
                }
            } else if (actionEvent.getSource() == this._cancelButton) {
                super.onCancel();
            } else if (actionEvent.getSource() == this._helpButton) {
                super.onHelp();
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public void setEnabledStandardButtons(int n) {
        if (this._standardButtons) {
            this._okButton.setEnabled((n & 1) != 0);
            this._cancelButton.setEnabled((n & 2) != 0);
            if (this._helpButtonUsed) {
                this._helpButton.setEnabled((n & 8) != 0);
            }
        }
    }

    @Override
    public void setDefaultButtonById(int n) {
        if (this._standardButtons) {
            if (n == 1) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._okButton));
            } else if (n == 2) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._cancelButton));
            } else if (n == 8 && this._helpButtonUsed) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._helpButton));
            }
        }
    }

    @Override
    public SCButton getStandardButtonById(int n) {
        if (this._standardButtons) {
            if (n == 1) {
                return this._okButton;
            }
            if (n == 2) {
                return this._cancelButton;
            }
            if (n == 8 && this._helpButtonUsed) {
                return this._helpButton;
            }
        }
        return null;
    }
}

