/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.SCButton;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.ScjBaseDialog;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybChangeNotificationListener;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybTabbedPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ScjPropertiesDialog
extends ScjBaseDialog
implements ChangeListener,
SybChangeNotificationListener,
ActionListener,
ScjResourceConstants {
    private SybTabbedPane _tabPanel;
    private SCButton _okButton;
    private SCButton _cancelButton;
    private SCButton _applyButton;
    private SCButton _helpButton;

    public ScjPropertiesDialog(JFrame jFrame, ScjViewerSupport scjViewerSupport, SCDialogController sCDialogController, SCDialogSupport sCDialogSupport, boolean bl) {
        super(jFrame, scjViewerSupport, sCDialogController, bl);
        super.extendDialog(sCDialogSupport);
    }

    public ScjPropertiesDialog(JDialog jDialog, ScjViewerSupport scjViewerSupport, SCDialogController sCDialogController, SCDialogSupport sCDialogSupport, boolean bl) {
        super(jDialog, scjViewerSupport, sCDialogController, bl);
        super.extendDialog(sCDialogSupport);
    }

    @Override
    public boolean render() {
        if (this._scjSession.isWindows()) {
            this._scjSession.startWait();
        }
        this._dialog = this._parentJDialog == null ? (this._modal ? new SybModalDialog((Frame)this._parentJFrame) : new JDialog((Frame)this._parentJFrame, this._modal)) : (this._modal ? new SybModalDialog((Dialog)this._parentJDialog) : new JDialog((Dialog)this._parentJDialog, this._modal));
        this._dialog.setTitle(this._title);
        this._dialog.getContentPane().setLayout(new BorderLayout());
        this._tabPanel = new SybTabbedPane();
        this._tabPanel.setTabLayoutPolicy(1);
        for (int i = 0; i < this._pages.size(); ++i) {
            SCPageController sCPageController = (SCPageController)this._pages.elementAt(i);
            JPanel jPanel = sCPageController.getJPanel();
            super.fixNullLayout(jPanel);
            String string = sCPageController.getPageTitle();
            if (string == null) {
                string = "";
            }
            this._tabPanel.add(string, (Component)jPanel);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(5, 5));
        jPanel.add((Component)this._tabPanel, "tabpanel");
        this._dialog.getContentPane().add((Component)jPanel, "Center");
        if (this._standardButtons) {
            this.createStandardButtons();
            this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._okButton));
        }
        this._dialog.pack();
        this._dialog.pack();
        this._dialog.setResizable(this._resizable);
        this.restrictMinimumSize();
        this.init();
        super.showDialog();
        this._scjSession.endWait();
        return !this._closedByCancel;
    }

    private void createStandardButtons() {
        this._standardButtonPanel = new JPanel();
        this._standardButtonPanel.setLayout(new FlowLayout(2));
        String string = ScjSession.getString("STR_DLG_OK_BUTTON");
        String string2 = ScjSession.getString("STR_DLG_CANCEL_BUTTON");
        String string3 = ScjSession.getString("STR_PROP_APPLY_BUTTON");
        if (this.isVistaAdministrator()) {
            this._okButton = new SCButton(string, SCImageLoader.getImageIcon("vistashield", 1001));
            this._applyButton = new SCButton(string3, SCImageLoader.getImageIcon("vistashield", 1001));
        } else {
            this._okButton = new SCButton(string);
            this._applyButton = new SCButton(string3);
        }
        this._okButton.addActionListener(this);
        this._applyButton.addActionListener(this);
        this._cancelButton = new SCButton(string2);
        this._cancelButton.addActionListener(this);
        this._standardButtonPanel.add((Component)((Object)this._okButton));
        this._standardButtonPanel.add((Component)((Object)this._cancelButton));
        this._standardButtonPanel.add((Component)((Object)this._applyButton));
        if (this._helpButtonUsed) {
            String string4 = ScjSession.getString("STR_DLG_HELP_BUTTON");
            this._helpButton = new SCButton(string4);
            this._helpButton.addActionListener(this);
            this._standardButtonPanel.add((Component)((Object)this._helpButton));
            DialogUtils.makeComponentsSameWidth((JComponent[])new SCButton[]{this._okButton, this._cancelButton, this._applyButton, this._helpButton});
        } else {
            DialogUtils.makeComponentsSameWidth((JComponent[])new SCButton[]{this._okButton, this._cancelButton, this._applyButton});
        }
        this._dialog.getContentPane().add((Component)this._standardButtonPanel, "South");
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    protected boolean onOk() {
        if (((SCPageController)this._pages.elementAt(this._currentPage - 1)).onKillActive()) {
            return super.onOk();
        }
        return false;
    }

    protected void onApply() {
        if (((SCPageController)this._pages.elementAt(this._currentPage - 1)).onKillActive()) {
            for (int i = 0; i < this._pages.size(); ++i) {
                if (((SCPageController)this._pages.elementAt(i)).onOk()) continue;
                return;
            }
            this._dialogController.onApply();
            if (this._standardButtons && !this._applyButton.isEnabled()) {
                this._okButton.requestFocusInWindow();
            }
        }
    }

    @Override
    public void releaseResources() {
        if (this._dialog != null) {
            this._tabPanel.removeChangeNotificationListener((SybChangeNotificationListener)this);
            this._tabPanel.removeChangeListener((ChangeListener)this);
            if (this._standardButtons) {
                this._okButton.removeActionListener(this);
                this._cancelButton.removeActionListener(this);
                this._applyButton.removeActionListener(this);
                if (this._helpButtonUsed) {
                    this._helpButton.removeActionListener(this);
                }
            }
            super.releaseResources();
        }
    }

    public boolean notifyChange(ChangeEvent changeEvent) {
        if (this._tabPanel.getSelectedIndex() >= 0) {
            return ((SCPageController)this._pages.elementAt(this._currentPage - 1)).onKillActive();
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this._currentPage;
        if (this._tabPanel.getSelectedIndex() >= 0) {
            int n2;
            this._currentPage = this._tabPanel.getSelectedIndex() + 1;
            final SCPageController sCPageController = (SCPageController)this._pages.elementAt(this._currentPage - 1);
            if (!this.pagePreviouslyOpened(this._currentPage)) {
                sCPageController.onInitDialog();
                this.setPagePreviouslyOpened(this._currentPage);
            }
            if ((n2 = sCPageController.getEnabledStandardButtons()) != 0) {
                this.setEnabledStandardButtons(n2);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sCPageController.onSetActive();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._standardButtons) {
            if (actionEvent.getSource() == this._okButton) {
                this._okButton.setEnabled(false);
                if (!this.onOk()) {
                    this._okButton.setEnabled(true);
                }
            } else if (actionEvent.getSource() == this._cancelButton) {
                super.onCancel();
            } else if (actionEvent.getSource() == this._applyButton) {
                this.onApply();
            } else if (actionEvent.getSource() == this._helpButton) {
                super.onHelp();
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        SCPageController sCPageController = (SCPageController)this._pages.elementAt(this._currentPage - 1);
        sCPageController.onInitDialog();
        super.setPagePreviouslyOpened(this._currentPage);
        this.setEnabledStandardButtons(11);
        int n = sCPageController.getEnabledStandardButtons();
        if (n != 0) {
            this.setEnabledStandardButtons(n);
        }
        sCPageController.onSetActive();
        this._tabPanel.setSelectedIndex(this._currentPage - 1);
        if (this._currentPage != 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScjPropertiesDialog.this._tabPanel.requestFocusInWindow();
                }
            });
        }
        this._tabPanel.addChangeNotificationListener((SybChangeNotificationListener)this);
        this._tabPanel.addChangeListener((ChangeListener)this);
        super.windowOpened(windowEvent);
    }

    @Override
    public void setEnabledStandardButtons(int n) {
        if (this._standardButtons) {
            this._okButton.setEnabled((n & 1) != 0);
            this._cancelButton.setEnabled((n & 2) != 0);
            this._applyButton.setEnabled((n & 4) != 0);
            if (this._helpButtonUsed) {
                this._helpButton.setEnabled((n & 8) != 0);
            }
        }
    }

    @Override
    public void setDefaultButtonById(int n) {
        if (this._standardButtons) {
            if (n == 1) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._okButton));
            }
            if (n == 2) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._cancelButton));
            }
            if (n == 4) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._applyButton));
            } else if (n == 8 && this._helpButtonUsed) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._helpButton));
            }
        }
    }

    @Override
    public SCButton getStandardButtonById(int n) {
        if (this._standardButtons) {
            if (n == 1) {
                return this._okButton;
            }
            if (n == 2) {
                return this._cancelButton;
            }
            if (n == 4) {
                return this._applyButton;
            }
            if (n == 8 && this._helpButtonUsed) {
                return this._helpButton;
            }
        }
        return null;
    }
}

