/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import com.sybase.central.SCPageController2;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.SCButton;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.SCLabel;
import com.sybase.central.viewer.ScjBaseDialog;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.util.DialogUtils;
import com.sybase.util.HypertextButton;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

class ScjQuickWizardDialog
extends ScjBaseDialog
implements ActionListener,
ScjResourceConstants {
    private JPanel _wizardIndexPanel;
    private JPanel _wizardPagePanel;
    private SCButton _backButton;
    private SCButton _nextButton;
    private SCButton _finishButton;
    private SCButton _cancelButton;
    private SCButton _helpButton;
    private Stack<Integer> _previousPages = new Stack();
    protected boolean _finishAsNext = false;
    private SCLabel _titleLabel = null;
    private SybMultiLineLabel _descriptionLabel = null;
    private SCLabel _iconLabel = null;
    private HypertextButton[] _indexButtons = null;
    private static final Insets FIRST_INDEX_INSETS = new Insets(10, 10, 0, 0);
    private static final Insets INDEX_INSETS = new Insets(5, 10, 0, 0);
    private static final Insets INDEX_LABEL_INSETS = new Insets(0, 10, 30, 0);

    public ScjQuickWizardDialog(JFrame jFrame, ScjViewerSupport scjViewerSupport, SCDialogController sCDialogController, SCDialogSupport sCDialogSupport, boolean bl) {
        super(jFrame, scjViewerSupport, sCDialogController, bl);
    }

    public ScjQuickWizardDialog(JDialog jDialog, ScjViewerSupport scjViewerSupport, SCDialogController sCDialogController, SCDialogSupport sCDialogSupport, boolean bl) {
        super(jDialog, scjViewerSupport, sCDialogController, bl);
    }

    @Override
    public boolean render() {
        int n;
        String string = null;
        GridBagConstraints gridBagConstraints = null;
        JPanel jPanel = null;
        JPanel jPanel2 = null;
        JPanel jPanel3 = null;
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = null;
        Insets insets3 = null;
        CardLayout cardLayout = null;
        JPanel jPanel4 = null;
        SCPageController sCPageController = null;
        SCPageController2 sCPageController2 = null;
        Icon icon = null;
        Dimension dimension = new Dimension(0, 0);
        Font font = null;
        if (UIUtils.isXPLookAndFeelActive()) {
            insets2 = new Insets(10, 10, 10, 10);
            insets3 = new Insets(0, 20, 10, 10);
        } else {
            insets2 = new Insets(5, 5, 5, 5);
            insets3 = new Insets(0, 10, 5, 5);
        }
        if (this._scjSession.isWindows()) {
            this._scjSession.startWait();
        }
        this._dialog = this._parentJDialog == null ? (this._modal ? new SybModalDialog((Frame)this._parentJFrame) : new JDialog((Frame)this._parentJFrame, this._modal)) : (this._modal ? new SybModalDialog((Dialog)this._parentJDialog) : new JDialog((Dialog)this._parentJDialog, this._modal));
        if (this._dialogController.getDialogType() == 3) {
            string = this._scjSession.getConfiguration().getTitle();
            if (string == null) {
                string = this._title == null ? ScjSession.getString("STR_APP_NAME") : this._title;
            }
            this._dialog.setTitle(string);
        } else {
            this._dialog.setTitle(this._title);
        }
        this._dialog.getContentPane().setLayout(new BorderLayout());
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (this._pages.firstElement() instanceof SCPageController2) {
            jPanel2 = new JPanel();
            jPanel2.setBackground(SystemColor.window);
            jPanel2.setLayout(new GridBagLayout());
            jPanel3 = new JPanel();
            jPanel3.setBackground(SystemColor.window);
            jPanel3.setLayout(new GridBagLayout());
            this._titleLabel = new SCLabel(this._title);
            font = UIManager.getDefaults().getFont("InternalFrame.titleFont");
            if (font == null) {
                font = this._titleLabel.getFont();
                font = font.deriveFont(font.getStyle(), font.getSize() + 4);
            }
            this._titleLabel.setFont(font);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = insets2;
            gridBagConstraints.fill = 0;
            jPanel3.add((Component)((Object)this._titleLabel), gridBagConstraints);
            this._descriptionLabel = new SybMultiLineLabel();
            this._descriptionLabel.setBackground((Color)SystemColor.window);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = insets3;
            gridBagConstraints.fill = 2;
            jPanel3.add((Component)this._descriptionLabel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = insets;
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)jPanel3, gridBagConstraints);
            this._iconLabel = new SCLabel(SCImageLoader.getImageIcon("scj32", 1006));
            gridBagConstraints.anchor = 12;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = insets2;
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)((Object)this._iconLabel), gridBagConstraints);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = insets;
            gridBagConstraints.fill = 3;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = insets;
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)new JSeparator(), gridBagConstraints);
            this._dialog.getContentPane().add((Component)jPanel2, "North");
        }
        if (this._dialogController.getDialogType() == 3) {
            this._wizardIndexPanel = UIUtils.createExplorerBar();
            this._wizardIndexPanel.setLayout(new GridBagLayout());
            this.updateIndexPanel();
            this._dialog.getContentPane().add((Component)this._wizardIndexPanel, "West");
        }
        this._wizardPagePanel = new JPanel();
        cardLayout = new CardLayout();
        this._wizardPagePanel.setLayout(cardLayout);
        for (n = 0; n < this._pages.size(); ++n) {
            sCPageController = (SCPageController)this._pages.elementAt(n);
            jPanel4 = sCPageController.getJPanel();
            super.fixNullLayout(jPanel4);
            this._wizardPagePanel.add(String.valueOf(n + 1), jPanel4);
        }
        jPanel.add((Component)this._wizardPagePanel, "Center");
        if (this._standardButtons) {
            this.createStandardButtonPanel();
            jPanel.add((Component)this._standardButtonPanel, "South");
            if (this._finishAsNext) {
                this._finishButton.setVisible(false);
            }
            this.updateButtonMask();
        }
        this._dialog.getContentPane().add((Component)jPanel, "Center");
        this._dialog.setResizable(this._resizable);
        this.init();
        for (n = this._pages.size() - 1; n >= 0; --n) {
            cardLayout.show(this._wizardPagePanel, String.valueOf(n + 1));
            if (this._pages.elementAt(n) instanceof SCPageController2) {
                sCPageController2 = (SCPageController2)this._pages.elementAt(n);
                this._titleLabel.setText(sCPageController2.getQuickWizardPageName());
                this._descriptionLabel.setText(sCPageController2.getQuickWizardPageDescription());
                icon = sCPageController2.getQuickWizardPageIcon();
                if (icon != null) {
                    this._iconLabel.setIcon(icon);
                } else {
                    this._iconLabel.setIcon(IConstants.QUICK_WIZARD_ICON);
                }
            }
            this._dialog.pack();
            this.restrictMinimumSize();
            if (jPanel2 == null) continue;
            if (jPanel2.getSize().getWidth() > dimension.getWidth()) {
                dimension.setSize(jPanel2.getSize().getWidth(), dimension.getHeight());
            }
            if (!(jPanel2.getSize().getHeight() > dimension.getHeight())) continue;
            dimension.setSize(dimension.getWidth(), jPanel2.getSize().getHeight());
        }
        if (jPanel2 != null) {
            jPanel2.setPreferredSize(dimension);
        }
        super.showDialog();
        this._scjSession.endWait();
        return !this._closedByCancel;
    }

    private void displayPageTitleAndIndexInfo(SCPageController sCPageController) {
        SCPageController2 sCPageController2 = null;
        String string = null;
        String string2 = "";
        Object var5_5 = null;
        Icon icon = null;
        if (sCPageController instanceof SCPageController2) {
            sCPageController2 = (SCPageController2)sCPageController;
            this._titleLabel.setText(sCPageController2.getQuickWizardPageName());
            this._descriptionLabel.setText(sCPageController2.getQuickWizardPageDescription());
            icon = sCPageController2.getQuickWizardPageIcon();
            if (icon != null) {
                this._iconLabel.setIcon(icon);
            } else {
                this._iconLabel.setIcon(IConstants.QUICK_WIZARD_ICON);
            }
            if (this._dialogController.getDialogType() == 3) {
                this.updateIndexPanel();
            }
        } else {
            string = sCPageController.getPageTitle();
            if (string != null) {
                this._dialog.setTitle(string);
            }
        }
        if (this._dialogController.getDialogType() == 3) {
            this._previousPages.clear();
            for (int i = 0; i < this._pages.size(); ++i) {
                if (!(this._pages.elementAt(i) instanceof SCPageController2)) continue;
                sCPageController2 = (SCPageController2)this._pages.elementAt(i);
                if (sCPageController == sCPageController2) break;
                if (!sCPageController2.canQuickWizardPageBeShown()) continue;
                this._previousPages.push(new Integer(i + 1));
            }
        }
    }

    void updateIndexPanel() {
        int n;
        GridBagConstraints gridBagConstraints = null;
        int n2 = 0;
        int n3 = 0;
        SCPageController sCPageController = null;
        SCPageController2 sCPageController2 = null;
        HypertextButton hypertextButton = null;
        ArrayList<HypertextButton> arrayList = new ArrayList<HypertextButton>();
        int n4 = 0;
        if (this._indexButtons != null) {
            for (n = 0; n < this._indexButtons.length; ++n) {
                this._indexButtons[n].removeActionListener((ActionListener)this);
            }
        }
        this._wizardIndexPanel.removeAll();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = FIRST_INDEX_INSETS;
        for (n = 0; n < this._pages.size(); ++n) {
            sCPageController = (SCPageController)this._pages.elementAt(n);
            if (!(sCPageController instanceof SCPageController2)) continue;
            ++n2;
            sCPageController2 = (SCPageController2)sCPageController;
            hypertextButton = sCPageController2.doesQuickWizardPageContainManditoryInformation() ? new HypertextButton(sCPageController2.getPageTitle() + " *", sCPageController2.getQuickWizardPageTitleToolTip()) : new HypertextButton(sCPageController2.getPageTitle(), sCPageController2.getQuickWizardPageTitleToolTip());
            if (hypertextButton.getPreferredSize().width > n4) {
                n4 = hypertextButton.getPreferredSize().width;
            }
            if (!sCPageController2.canQuickWizardPageBeShown()) continue;
            hypertextButton.addActionListener((ActionListener)this);
            arrayList.add(hypertextButton);
            if (n2 == this._currentPage) {
                hypertextButton.setEnabled(true);
                hypertextButton.setBackground((Color)SystemColor.control);
                hypertextButton.setOpaque(true);
            }
            gridBagConstraints.gridy = n3;
            if (n3 > 0) {
                gridBagConstraints.insets = INDEX_INSETS;
            }
            this._wizardIndexPanel.add((Component)hypertextButton, gridBagConstraints);
            ++n3;
        }
        this._indexButtons = arrayList.toArray(new HypertextButton[arrayList.size()]);
        gridBagConstraints.gridy = n3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = INDEX_LABEL_INSETS;
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(n4, 1));
        this._wizardIndexPanel.add((Component)jLabel, gridBagConstraints);
        this._wizardIndexPanel.validate();
        this._wizardIndexPanel.repaint();
    }

    private void indexButtonPressed(String string) {
        int n = this._currentPage;
        SCPageController sCPageController = null;
        int n2 = 0;
        for (int i = 0; i < this._pages.size(); ++i) {
            sCPageController = (SCPageController)this._pages.elementAt(i);
            if (!(sCPageController instanceof SCPageController2) || !string.startsWith(((SCPageController2)sCPageController).getPageTitle(), 0)) continue;
            n2 = i + 1;
            break;
        }
        if (n2 == 0) {
            return;
        }
        this._currentPage = n2;
        SCPageController sCPageController2 = (SCPageController)this._pages.elementAt(this._currentPage - 1);
        if (!this.pagePreviouslyOpened(this._currentPage)) {
            sCPageController2.onInitDialog();
            this.setPagePreviouslyOpened(this._currentPage);
        }
        this.updateButtonMask();
        ((CardLayout)this._wizardPagePanel.getLayout()).show(this._wizardPagePanel, String.valueOf(this._currentPage));
        if (!sCPageController2.onSetActive()) {
            this._currentPage = n;
            ((CardLayout)this._wizardPagePanel.getLayout()).show(this._wizardPagePanel, String.valueOf(this._currentPage));
            return;
        }
        this.displayPageTitleAndIndexInfo(sCPageController2);
    }

    private void createStandardButtonPanel() {
        Object object;
        JPanel jPanel = new JPanel();
        this._standardButtonPanel = new JPanel();
        this._standardButtonPanel.setLayout(new BorderLayout());
        jPanel.setLayout(new FlowLayout(2));
        String string = ScjSession.getString("STR_WIZ_BACK_BUTTON");
        String string2 = ScjSession.getString("STR_WIZ_NEXT_BUTTON");
        String string3 = ScjSession.getString("STR_WIZ_FINISH_BUTTON");
        String string4 = ScjSession.getString("STR_DLG_CANCEL_BUTTON");
        this._backButton = new SCButton(string);
        this._backButton.addActionListener(this);
        this._nextButton = new SCButton(string2);
        this._nextButton.addActionListener(this);
        this._finishButton = this.isVistaAdministrator() ? new SCButton(string3, SCImageLoader.getImageIcon("vistashield", 1001)) : new SCButton(string3);
        this._finishButton.addActionListener(this);
        this._cancelButton = new SCButton(string4);
        this._cancelButton.addActionListener(this);
        if (this._finishAsNext) {
            object = new JPanel();
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(0);
            flowLayout.setVgap(0);
            ((Container)object).setLayout(flowLayout);
            ((Container)object).add((Component)((Object)this._backButton));
            ((Container)object).add((Component)((Object)this._nextButton));
            jPanel.add((Component)object);
        } else {
            jPanel.add((Component)((Object)this._backButton));
            jPanel.add((Component)((Object)this._nextButton));
        }
        jPanel.add((Component)((Object)this._finishButton));
        jPanel.add((Component)((Object)this._cancelButton));
        if (this._helpButtonUsed) {
            object = ScjSession.getString("STR_DLG_HELP_BUTTON");
            this._helpButton = new SCButton((String)object);
            this._helpButton.addActionListener(this);
            jPanel.add((Component)((Object)this._helpButton));
            DialogUtils.makeComponentsSameWidth((JComponent[])new SCButton[]{this._backButton, this._nextButton, this._finishButton, this._cancelButton, this._helpButton});
        } else {
            DialogUtils.makeComponentsSameWidth((JComponent[])new SCButton[]{this._backButton, this._nextButton, this._finishButton, this._cancelButton});
        }
        this._standardButtonPanel.add((Component)jPanel, "South");
        object = new JSeparator();
        this._standardButtonPanel.add((Component)object, "North");
    }

    @Override
    public void init() {
        super.init();
    }

    public void onWizardBack() {
        if (!this._previousPages.empty() && ((SCPageController)this._pages.elementAt(this._currentPage - 1)).onWizardBack()) {
            this._currentPage = this._previousPages.pop();
            this.updateButtonMask();
            SCPageController sCPageController = (SCPageController)this._pages.elementAt(this._currentPage - 1);
            ((CardLayout)this._wizardPagePanel.getLayout()).show(this._wizardPagePanel, String.valueOf(this._currentPage));
            sCPageController.onSetActive();
            this.displayPageTitleAndIndexInfo(sCPageController);
        }
    }

    public void onWizardNext() {
        int n = this._currentPage;
        int n2 = ((SCPageController)this._pages.elementAt(this._currentPage - 1)).onWizardNext();
        if (n2 == 0) {
            if (super.incrementPage()) {
                this.updateButtonMask();
                ((CardLayout)this._wizardPagePanel.getLayout()).show(this._wizardPagePanel, String.valueOf(this._currentPage));
                while (!((SCPageController)this._pages.elementAt(this._currentPage - 1)).onSetActive()) {
                    if (!super.incrementPage()) {
                        this._currentPage = n;
                        ((CardLayout)this._wizardPagePanel.getLayout()).show(this._wizardPagePanel, String.valueOf(this._currentPage));
                        return;
                    }
                    this.updateButtonMask();
                    ((CardLayout)this._wizardPagePanel.getLayout()).show(this._wizardPagePanel, String.valueOf(this._currentPage));
                }
                SCPageController sCPageController = (SCPageController)this._pages.elementAt(this._currentPage - 1);
                this._previousPages.push(new Integer(n));
                this.displayPageTitleAndIndexInfo(sCPageController);
            } else {
                this._currentPage = n;
            }
        } else if (n2 > 0 && n2 < this._pages.size() + 1) {
            this._currentPage = n2;
            SCPageController sCPageController = (SCPageController)this._pages.elementAt(this._currentPage - 1);
            if (!this.pagePreviouslyOpened(this._currentPage)) {
                sCPageController.onInitDialog();
                this.setPagePreviouslyOpened(this._currentPage);
            }
            this.updateButtonMask();
            ((CardLayout)this._wizardPagePanel.getLayout()).show(this._wizardPagePanel, String.valueOf(this._currentPage));
            if (!sCPageController.onSetActive()) {
                this._currentPage = n;
                ((CardLayout)this._wizardPagePanel.getLayout()).show(this._wizardPagePanel, String.valueOf(this._currentPage));
                return;
            }
            this._previousPages.push(new Integer(n));
            this.displayPageTitleAndIndexInfo(sCPageController);
        }
    }

    private void updateButtonMask() {
        int n = ((SCPageController)this._pages.elementAt(this._currentPage - 1)).getEnabledStandardButtons();
        if (n != 0) {
            this.setEnabledStandardButtons(n);
        } else if (this._currentPage == 1) {
            if (this._currentPage == this._pages.size()) {
                this.setEnabledStandardButtons(16777290);
            } else {
                this.setEnabledStandardButtons(42);
            }
        } else if (this._currentPage == this._pages.size()) {
            this.setEnabledStandardButtons(16777306);
        } else {
            this.setEnabledStandardButtons(58);
        }
        if (this._standardButtons) {
            if (this._currentPage == this._pages.size()) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._finishButton));
            } else {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._nextButton));
            }
        }
    }

    public void onWizardFinish() {
        this._finishButton.setEnabled(false);
        for (int i = 0; i < this._pages.size(); ++i) {
            if (((SCPageController)this._pages.elementAt(i)).onWizardFinish()) continue;
            this._finishButton.setEnabled(true);
            return;
        }
        if (this._dialogController.onWizardFinish()) {
            this._closedByCancel = false;
            this.closeDialog();
        } else {
            this._finishButton.setEnabled(true);
        }
    }

    @Override
    public void releaseResources() {
        this._previousPages = null;
        if (this._indexButtons != null) {
            for (int i = 0; i < this._indexButtons.length; ++i) {
                this._indexButtons[i].removeActionListener((ActionListener)this);
            }
            this._indexButtons = null;
        }
        if (this._dialog != null) {
            if (this._standardButtons) {
                this._backButton.removeActionListener(this);
                this._nextButton.removeActionListener(this);
                this._finishButton.removeActionListener(this);
                this._cancelButton.removeActionListener(this);
                if (this._helpButtonUsed) {
                    this._helpButton.removeActionListener(this);
                }
            }
            super.releaseResources();
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        SCPageController sCPageController = (SCPageController)this._pages.elementAt(this._currentPage - 1);
        this.displayPageTitleAndIndexInfo(sCPageController);
        sCPageController.onInitDialog();
        this.setPagePreviouslyOpened(this._currentPage);
        this.updateButtonMask();
        sCPageController.onSetActive();
        ((CardLayout)this._wizardPagePanel.getLayout()).show(this._wizardPagePanel, String.valueOf(this._currentPage));
        super.windowOpened(windowEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._indexButtons != null) {
            for (int i = 0; i < this._indexButtons.length; ++i) {
                if (actionEvent.getSource() != this._indexButtons[i]) continue;
                this.indexButtonPressed(this._indexButtons[i].getText());
                return;
            }
        }
        if (this._standardButtons) {
            if (actionEvent.getSource() == this._backButton) {
                this.onWizardBack();
            } else if (actionEvent.getSource() == this._nextButton) {
                if (this._finishAsNext && this._currentPage == this._pages.size()) {
                    this.onWizardFinish();
                } else {
                    this.onWizardNext();
                }
            } else if (actionEvent.getSource() == this._finishButton) {
                this.onWizardFinish();
            } else if (actionEvent.getSource() == this._cancelButton) {
                super.onCancel();
            } else if (actionEvent.getSource() == this._helpButton) {
                super.onHelp();
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public void setEnabledStandardButtons(int n) {
        if (this._standardButtons) {
            this._backButton.setEnabled((n & 0x10) != 0);
            if (this._finishAsNext && this._currentPage == this._pages.size()) {
                String string = ScjSession.getString("STR_WIZ_FINISH_BUTTON");
                this._nextButton.setText(string);
                this._nextButton.setEnabled((n & 0x1000040) != 0);
                if (this.isVistaAdministrator()) {
                    this._nextButton.setIcon(SCImageLoader.getImageIcon("vistashield", 1001));
                }
            } else {
                String string = ScjSession.getString("STR_WIZ_NEXT_BUTTON");
                this._nextButton.setText(string);
                this._nextButton.setEnabled((n & 0x20) != 0);
                this._nextButton.setIcon(null);
            }
            this._finishButton.setEnabled((n & 0x1000040) != 0);
            this._cancelButton.setEnabled((n & 2) != 0);
            if (this._helpButtonUsed) {
                this._helpButton.setEnabled((n & 8) != 0);
            }
        }
    }

    @Override
    public void setDefaultButtonById(int n) {
        if (this._standardButtons) {
            if (n == 16) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._backButton));
            }
            if (n == 32) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._nextButton));
            }
            if (n == 0x1000040) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._finishButton));
            } else if (n == 2) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._cancelButton));
            } else if (n == 8 && this._helpButtonUsed) {
                this._dialog.getRootPane().setDefaultButton((JButton)((Object)this._helpButton));
            }
        }
    }

    @Override
    public SCButton getStandardButtonById(int n) {
        if (this._standardButtons) {
            if (n == 16) {
                return this._backButton;
            }
            if (n == 32) {
                return this._nextButton;
            }
            if (n == 0x1000040) {
                return this._finishButton;
            }
            if (n == 2) {
                return this._cancelButton;
            }
            if (n == 8 && this._helpButtonUsed) {
                return this._helpButton;
            }
        }
        return null;
    }

    public void setFinishAsNext(boolean bl) {
        this._finishAsNext = bl;
    }
}

