/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCDialogSupport;
import com.sybase.central.viewer.Configuration;
import com.sybase.central.viewer.ConnectionProfile;
import com.sybase.central.viewer.ConnectionProfilesKey;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.RootContainer;
import com.sybase.central.viewer.SCHelpManager;
import com.sybase.central.viewer.SCRepository;
import com.sybase.central.viewer.SCRepositoryInfo;
import com.sybase.central.viewer.ScjBundleManager;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.central.viewer.SessionEvent;
import com.sybase.central.viewer.SessionListener;
import com.sybase.central.viewer.UserPrefRepository;
import com.sybase.central.viewer.UserPrefRepositoryInfo;
import com.sybase.central.viewer.Utilities;
import com.sybase.central.viewer.Viewer;
import com.sybase.util.Platform;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;

class ScjSession
implements ClipboardOwner,
IConstants,
WindowListener {
    private JApplet _applet = null;
    private RootContainer _rootCont = null;
    private SCRepository _scRepository = null;
    private SCRepositoryInfo _scRepInfo = null;
    private UserPrefRepositoryInfo _upRepInfo = null;
    private ConnectionProfilesKey _connProfKey = null;
    private Configuration _configuration = null;
    private Vector<SessionListener> _sessionListeners = new Vector(10);
    private String[] _args = null;
    private Properties _cmdLineProperties = new Properties();
    private Clipboard _clipboard = null;
    private Locale _scjLocale = null;
    private String _lang = null;
    private boolean _newUser = true;
    private SCHelpManager _helpManager = new SCHelpManager(this);
    private static ScjBundleManager _bundleManager = null;
    private static UserPrefRepository _upRepository = null;
    private static Vector<Viewer> _viewers = null;
    private static Viewer _currentlyActiveViewer = null;
    static boolean startup = true;
    static final String LOCATION = "screpository";
    static final String AUTOLOAD_PROVIDER_ID = "loadprovider";
    static final String INSTALL_DIRECTORY = "installdir";
    static final String SAFE_MODE = "safemode";
    static final String APPLICATION_NAME = "Sybase Central";

    ScjSession(JApplet jApplet, String[] stringArray) {
        this._applet = jApplet;
        this._args = stringArray;
        this._rootCont = new RootContainer(this);
        _viewers = new Vector(5);
        if (this.isApplet()) {
            this.readAppletArgs();
        } else {
            this.readApplicationArgs();
        }
        if (!this.isApplet()) {
            this.setLocale();
        } else {
            this._scjLocale = Locale.getDefault();
        }
        try {
            _bundleManager = new ScjBundleManager();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._scRepository = new SCRepository(this.isApplet(), this.getSharedFileLocation());
        try {
            this._scRepository.load();
        }
        catch (IOException iOException) {
            SybOptionPane.showMessageDialog((Component)ScjSession.getViewerFrame(), (Object)SybMessageFormat.format((String)ScjSession.getString("ERR_SC_REPOSITORY_READ"), (Object[])new Object[]{this._scRepository.getFileName()}), (String)ScjSession.getString("STR_APP_NAME"), (int)0);
        }
        _upRepository = new UserPrefRepository(this.isApplet(), ScjSession.getUserFileLocation(), this.getSharedFileLocation());
        try {
            this._newUser = !_upRepository.load();
        }
        catch (IOException iOException) {
            SybOptionPane.showMessageDialog((Component)ScjSession.getViewerFrame(), (Object)SybMessageFormat.format((String)ScjSession.getString("ERR_USER_REPOSITORY_READ"), (Object[])new Object[]{_upRepository.getFileName()}), (String)ScjSession.getString("STR_APP_NAME"), (int)0);
        }
    }

    String getSharedFileLocation() {
        String string = null;
        string = this._cmdLineProperties.getProperty(LOCATION);
        return string;
    }

    static String getUserFileLocation() {
        return Platform.getUserConfigurationDirectory((String)ScjSession.getSCDirectoryName());
    }

    private static String getSCDirectoryName() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Integer.toString(6);
        String string2 = Integer.toString(0);
        String string3 = Integer.toString(0);
        stringBuilder.append(APPLICATION_NAME).append(" ");
        stringBuilder.append(string).append(".").append(string2).append(".").append(string3);
        return stringBuilder.toString();
    }

    public void releaseResources() {
        this._applet = null;
        this._rootCont.releaseResources();
        this._rootCont = null;
        _bundleManager = null;
        this._scRepository = null;
        _upRepository = null;
        this._scRepInfo = null;
        this._upRepInfo = null;
        this._connProfKey = null;
        this._configuration = null;
        this._sessionListeners.removeAllElements();
        this._sessionListeners = null;
        this._args = null;
        this._cmdLineProperties = null;
        this._clipboard = null;
        this._scjLocale = null;
        this._lang = null;
        _viewers.removeAllElements();
        _viewers = null;
        _currentlyActiveViewer = null;
        this._helpManager.releaseResources();
        this._helpManager = null;
        startup = true;
    }

    boolean isStartup() {
        return startup;
    }

    Locale getLocale() {
        return this._scjLocale;
    }

    RootContainer getRootContainer() {
        return this._rootCont;
    }

    private void setLocale() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._lang == null) {
            stringBuffer.append("SOFTWARE\\Sybase\\Sybase Central\\");
            stringBuffer.append(Integer.toString(6)).append(".");
            stringBuffer.append(Integer.toString(0)).append(".");
            stringBuffer.append(Integer.toString(0));
            this._lang = UIUtils.getLanguageCode(null, (String)stringBuffer.toString());
        }
        if (this._lang.equalsIgnoreCase("zh")) {
            this._lang = "zh_CN";
        } else if (this._lang.equalsIgnoreCase("tw")) {
            this._lang = "zh_TW";
        } else if (this._lang.equalsIgnoreCase("hk")) {
            this._lang = "zh_HK";
        }
        String string = this._lang;
        if (string != null && string.length() > 0) {
            int n = string.indexOf(95);
            if (n < 0) {
                this._scjLocale = new Locale(string, "");
            } else {
                String string2 = "";
                String string3 = "";
                String string4 = "";
                string2 = string.substring(0, n);
                int n2 = string.indexOf(95, n + 1);
                if (n2 < 0) {
                    n2 = string.length();
                } else {
                    string4 = string.substring(n2 + 1, string.length());
                }
                string3 = string.substring(n + 1, n2);
                this._scjLocale = new Locale(string2, string3, string4);
            }
        }
        if (this._scjLocale == null || !(this._scjLocale instanceof Locale)) {
            this._scjLocale = Locale.getDefault();
        }
        if (this._scjLocale.getLanguage().equalsIgnoreCase("zh") && (this._scjLocale.getCountry().equalsIgnoreCase("tw") || this._scjLocale.getCountry().equalsIgnoreCase("hk"))) {
            this._scjLocale = Locale.ENGLISH;
        }
        Locale.setDefault(this._scjLocale);
        UIUtils.resetAWTToolkitResources();
    }

    Clipboard getClipboard() {
        if (this._clipboard == null) {
            this._clipboard = new Clipboard(APPLICATION_NAME);
        }
        return this._clipboard;
    }

    boolean isApplet() {
        return this._applet != null;
    }

    boolean isNewUser() {
        return this._newUser;
    }

    JApplet getApplet() {
        return this._applet;
    }

    static ScjBundleManager getBundleManager() {
        return _bundleManager;
    }

    public static String getString(String string) {
        if (_bundleManager != null) {
            return _bundleManager.getString(string);
        }
        return "";
    }

    public static char getMnemonic(String string) {
        if (_bundleManager != null) {
            return _bundleManager.getString(string).charAt(0);
        }
        return '\u0000';
    }

    public static String getString(String string, String string2) {
        if (_bundleManager != null) {
            return _bundleManager.getFormattedString(string, string2);
        }
        return "";
    }

    SCRepositoryInfo getSCRepositoryInfo() {
        if (this._scRepInfo == null) {
            this._scRepInfo = new SCRepositoryInfo(this._scRepository);
        }
        return this._scRepInfo;
    }

    UserPrefRepositoryInfo getUserPrefRepositoryInfo() {
        if (this._upRepInfo == null) {
            this._upRepInfo = new UserPrefRepositoryInfo(_upRepository, this.isNewUser());
        }
        return this._upRepInfo;
    }

    private void doNotification(SessionEvent sessionEvent) {
        Enumeration<SessionListener> enumeration = this._sessionListeners.elements();
        while (enumeration.hasMoreElements()) {
            SessionListener sessionListener = enumeration.nextElement();
            sessionListener.sessionChanged(sessionEvent);
        }
    }

    void updateConnectionOptions() {
        this.doNotification(SessionEvent.CONNECTION_OPTIONS_CHANGE);
    }

    void updateOptions() {
        this.doNotification(SessionEvent.OPTIONS_CHANGE);
    }

    void providerEntryChanged(ProviderEntry providerEntry) {
        SessionEvent sessionEvent = new SessionEvent(providerEntry, SessionEvent.PROVIDER_CHANGE_ID);
        this.doNotification(sessionEvent);
    }

    Configuration getConfiguration() {
        if (this._configuration == null) {
            this._configuration = new Configuration(this._scRepository, this.getSCRepositoryInfo().getCurrentConfigurationName());
        }
        return this._configuration;
    }

    SCRepository getSCRepository() {
        return this._scRepository;
    }

    boolean isSCRepositoryWriteable() {
        return this._scRepository.hasWriteAccess();
    }

    static UserPrefRepository getUserPrefRepository() {
        return _upRepository;
    }

    void saveSCPreferences() {
        try {
            this._scRepository.save();
        }
        catch (IOException iOException) {
            SybOptionPane.showMessageDialog((Component)ScjSession.getViewerFrame(), (Object)SybMessageFormat.format((String)ScjSession.getString("ERR_SC_REPOSITORY_SAVE"), (Object[])new Object[]{this._scRepository.getFileName()}), (String)ScjSession.getString("STR_APP_NAME"), (int)0);
        }
    }

    static void saveUserPreferences() {
        try {
            if (_upRepository != null) {
                _upRepository.save();
            }
        }
        catch (IOException iOException) {
            SybOptionPane.showMessageDialog((Component)ScjSession.getViewerFrame(), (Object)SybMessageFormat.format((String)ScjSession.getString("ERR_USER_REPOSITORY_SAVE"), (Object[])new Object[]{_upRepository.getFileName()}), (String)ScjSession.getString("STR_APP_NAME"), (int)0);
        }
    }

    ConnectionProfilesKey getConnectionProfilesKey() {
        if (this._connProfKey == null) {
            this._connProfKey = new ConnectionProfilesKey(this._scRepository, _upRepository, this.getUserPrefRepositoryInfo());
        }
        return this._connProfKey;
    }

    void addSessionListener(SessionListener sessionListener) {
        this._sessionListeners.addElement(sessionListener);
    }

    void removeSessionListener(SessionListener sessionListener) {
        if (this._sessionListeners != null) {
            this._sessionListeners.removeElement(sessionListener);
        }
    }

    void addViewer(Viewer viewer) {
        _viewers.addElement(viewer);
        viewer.getFrame().addWindowListener(this);
    }

    void removeViewer(Viewer viewer) {
        if (_viewers != null) {
            _viewers.removeElement(viewer);
        }
        viewer.getFrame().removeWindowListener(this);
    }

    static JFrame getViewerFrame() {
        if (_currentlyActiveViewer != null) {
            return _currentlyActiveViewer.getFrame();
        }
        if (_viewers.size() > 0) {
            return _viewers.firstElement().getFrame();
        }
        return null;
    }

    boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    void showOnlineBooks(JFrame jFrame) {
        this._helpManager.showOnlineBooks(jFrame);
    }

    void showHelpIndex(String string, SCDialogSupport sCDialogSupport) {
        sCDialogSupport.startWait();
        this._helpManager.showHelpIndex(string, sCDialogSupport.getJDialog());
        sCDialogSupport.endWait();
    }

    void showHelpIndex(String string, JFrame jFrame) {
        this.startWait();
        this._helpManager.showHelpIndex(string, jFrame);
        this.endWait();
    }

    String[] getArgs() {
        return this._args;
    }

    Properties getCommandLineProperties() {
        return this._cmdLineProperties;
    }

    protected void readAppletArgs() {
        String string = this._applet.getParameter(LOCATION);
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            this._cmdLineProperties.put(LOCATION, string);
        }
        if ((string = this._applet.getParameter(AUTOLOAD_PROVIDER_ID)) != null) {
            this._cmdLineProperties.put(AUTOLOAD_PROVIDER_ID, string);
        }
    }

    private void readApplicationArgs() {
        String string = null;
        String string2 = null;
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i].startsWith("-lang")) {
                this._lang = this._args[i].substring(this._args[i].indexOf("=") + 1).trim();
                continue;
            }
            if (!this._args[i].startsWith("-")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(this._args[i].substring(1), "=");
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
            }
            if (string == null || string2 == null) continue;
            if (string.equals(LOCATION) && !string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            } else if (string.equals(INSTALL_DIRECTORY) && !string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            this._cmdLineProperties.put(string, string2);
            stringTokenizer = null;
            string = null;
            string2 = null;
        }
    }

    boolean isInSafeMode() {
        String string = null;
        string = this.getCommandLineProperties().getProperty(SAFE_MODE);
        return string != null && (string.equalsIgnoreCase("Y") || string.equalsIgnoreCase("YES"));
    }

    void startWait() {
        this.doNotification(SessionEvent.START_WAIT);
    }

    void endWait() {
        if (!startup) {
            this.doNotification(SessionEvent.END_WAIT);
        }
    }

    ArrayList<String> getConnectionProfileMRUList(ScjViewerSupport scjViewerSupport) {
        ArrayList<String> arrayList = null;
        Enumeration enumeration = null;
        ConnectionProfile connectionProfile = null;
        boolean bl = false;
        arrayList = Utilities.parseProfileStringListIntoArrayList(this.getUserPrefRepositoryInfo().getMRUConnectionProfiles());
        for (int i = arrayList.size() - 2; i >= 0; i -= 2) {
            boolean bl2 = false;
            String string = arrayList.get(i);
            String string2 = arrayList.get(i + 1);
            if (scjViewerSupport.getLoadedSCProviderByName(string2) != null) {
                enumeration = this.getConnectionProfilesKey().getConnectionProfiles();
                while (enumeration.hasMoreElements()) {
                    connectionProfile = (ConnectionProfile)enumeration.nextElement();
                    if (!connectionProfile.getName().equals(string)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) continue;
            arrayList.remove(i + 1);
            arrayList.remove(i);
            bl = true;
        }
        if (bl) {
            this.getUserPrefRepositoryInfo().setMRUConnectionProfiles(Utilities.buildProfileStringList(arrayList));
        }
        return arrayList;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        for (int i = 0; i < _viewers.size(); ++i) {
            Viewer viewer = _viewers.elementAt(i);
            if (windowEvent.getSource() != viewer.getFrame()) continue;
            _currentlyActiveViewer = viewer;
            break;
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

