/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCProvider;
import com.sybase.central.SCProvider4;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.IMenuListener;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.SCToolBarDropDownButton;
import com.sybase.central.viewer.SCToolBarToggleButton;
import com.sybase.central.viewer.SCViewerToolBarButton;
import com.sybase.central.viewer.ScjConnection;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.DialogUtils;
import com.sybase.util.DropDownButtonEvent;
import com.sybase.util.DropDownButtonListener;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

class ScjToolBar
extends JPanel
implements IConstants,
ScjResourceConstants,
ActionListener,
DropDownButtonListener {
    private ScjSession _session;
    private ViewerManager _viewerManager;
    private JToolBar _toolBar;
    private int _toolBarButtonBitMask = 0;
    private IMenuListener _listener;
    private int _selectedRow = 0;
    private SCToolBarDropDownButton _connectToolBarDropDownButton = null;
    protected static final String F11_KEY = "F11_KEY";
    private static final Object[][] tbNavigationBtns = new Object[][]{{BACK_ICON, "STR_BACK", new Integer(1012), new Integer(1)}, {FORWARD_ICON, "STR_FORWARD", new Integer(1013), new Integer(2)}, {UP_ICON, "STR_UP", new Integer(1014), new Integer(4)}, null};
    private static final Object[][] tbViewBtns = new Object[][]{{TASKS_ICON, "STR_TASKS", new Integer(1016), new Integer(32)}, {FOLDERS_ICON, "STR_FOLDERS_TIP", new Integer(1017), new Integer(16)}, {SEARCH_ICON, "STR_SEARCH", new Integer(1015), new Integer(8)}, null};
    private static final Object[][] tbConnectionsBtns = new Object[][]{{CONNECT_ICON, "STR_CONNECT", new Integer(1019), new Integer(128)}, {DISCONNECT_ICON, "STR_DISCONNECT", new Integer(1020), new Integer(64)}, {CONN_PROFILE_ICON, "STR_BTN_CONNPROF", new Integer(1021), new Integer(512)}, null};
    private static final Object[][] tbOtherBtns = new Object[][]{{REFRESH_FOLDER_ICON, "STR_BTN_REFRESH", new Integer(1006), new Integer(256)}, null, {CUT_ICON, "STR_CUT", new Integer(101), new Integer(4)}, {COPY_ICON, "STR_COPY", new Integer(102), new Integer(8)}, {PASTE_ICON, "STR_PASTE", new Integer(103), new Integer(16)}, {DELETE_ICON, "STR_DELETE", new Integer(106), new Integer(32)}, null, {UNDO_ICON, "STR_UNDO", new Integer(109), new Integer(128)}, {REDO_ICON, "STR_REDO", new Integer(108), new Integer(256)}, null, {PROPERTIES_ICON, "STR_PROPERTIES", new Integer(107), new Integer(64)}};
    private static final int BTN_GIF = 0;
    private static final int BTN_TIP = 1;
    private static final int BTN_CMD = 2;
    private static final int BTN_MASK = 3;

    ScjToolBar(ScjSession scjSession, ViewerManager viewerManager) {
        int n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JSeparator jSeparator = null;
        SCViewerToolBarButton sCViewerToolBarButton = null;
        SCToolBarToggleButton sCToolBarToggleButton = null;
        SCToolBarDropDownButton sCToolBarDropDownButton = null;
        ImageIcon imageIcon = null;
        this._session = scjSession;
        this._listener = viewerManager;
        this._viewerManager = viewerManager;
        this.setBorder(null);
        this.setLayout(gridBagLayout);
        this._toolBar = new JToolBar();
        this._toolBar.setFloatable(false);
        this._toolBar.setBorder(null);
        this.add(this._toolBar);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = UIUtils.isXPLookAndFeelActive() ? new Insets(1, 2, 1, 2) : new Insets(1, 0, 1, 0);
        gridBagLayout.setConstraints(this._toolBar, gridBagConstraints);
        jSeparator = new JSeparator();
        this.add(jSeparator);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = UIUtils.isXPLookAndFeelActive() ? new Insets(0, 2, 0, 2) : new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        for (n = 0; n < tbNavigationBtns.length; ++n) {
            if (tbNavigationBtns[n] != null) {
                imageIcon = (ImageIcon)tbNavigationBtns[n][0];
                sCViewerToolBarButton = new SCViewerToolBarButton(imageIcon, ScjSession.getString((String)tbNavigationBtns[n][1]), (Integer)tbNavigationBtns[n][2], (Integer)tbNavigationBtns[n][3]);
                sCViewerToolBarButton.addActionListener(this);
                this._toolBar.add((Component)((Object)sCViewerToolBarButton));
                continue;
            }
            this._toolBar.addSeparator();
        }
        for (n = 0; n < tbViewBtns.length; ++n) {
            if (tbViewBtns[n] != null) {
                imageIcon = (ImageIcon)tbViewBtns[n][0];
                sCToolBarToggleButton = new SCToolBarToggleButton(imageIcon, ScjSession.getString((String)tbViewBtns[n][1]), (Integer)tbViewBtns[n][2], (Integer)tbViewBtns[n][3]);
                if (sCToolBarToggleButton.getCommandId() == 1015) {
                    sCToolBarToggleButton.setSelected(this._session.getUserPrefRepositoryInfo().getVisiblePane().equals("search"));
                } else if (sCToolBarToggleButton.getCommandId() == 1016) {
                    sCToolBarToggleButton.setSelected(this._session.getUserPrefRepositoryInfo().getVisiblePane().equals("tasks"));
                } else if (sCToolBarToggleButton.getCommandId() == 1017) {
                    sCToolBarToggleButton.setSelected(this._session.getUserPrefRepositoryInfo().getVisiblePane().equals("folders"));
                }
                sCToolBarToggleButton.addActionListener(this);
                this._toolBar.add((Component)((Object)sCToolBarToggleButton));
                continue;
            }
            this._toolBar.addSeparator();
        }
        for (n = 0; n < tbConnectionsBtns.length; ++n) {
            if (tbConnectionsBtns[n] != null) {
                imageIcon = (ImageIcon)tbConnectionsBtns[n][0];
                sCToolBarDropDownButton = new SCToolBarDropDownButton(imageIcon, new String[0], ScjSession.getString((String)tbConnectionsBtns[n][1]), (Integer)tbConnectionsBtns[n][2], (Integer)tbConnectionsBtns[n][3]);
                if ((Integer)tbConnectionsBtns[n][2] == 1019) {
                    this._connectToolBarDropDownButton = sCToolBarDropDownButton;
                }
                sCToolBarDropDownButton.addActionListener(this);
                sCToolBarDropDownButton.addDropDownButtonListener(this);
                this._toolBar.add((Component)((Object)sCToolBarDropDownButton));
                continue;
            }
            this._toolBar.addSeparator();
        }
        for (n = 0; n < tbOtherBtns.length; ++n) {
            if (tbOtherBtns[n] != null) {
                imageIcon = (ImageIcon)tbOtherBtns[n][0];
                sCViewerToolBarButton = new SCViewerToolBarButton(imageIcon, ScjSession.getString((String)tbOtherBtns[n][1]), (Integer)tbOtherBtns[n][2], (Integer)tbOtherBtns[n][3]);
                sCViewerToolBarButton.addActionListener(this);
                this._toolBar.add((Component)((Object)sCViewerToolBarButton));
                continue;
            }
            this._toolBar.addSeparator();
        }
        this.registerF11Key(true);
    }

    JToolBar getJToolBar() {
        return this._toolBar;
    }

    void registerF11Key(boolean bl) {
        this._viewerManager.getViewerFrame().getRootPane().unregisterKeyboardAction(F11);
        if (bl) {
            this._viewerManager.getViewerFrame().getRootPane().registerKeyboardAction(this, F11_KEY, F11, 2);
        }
    }

    private ArrayList<Object> getConnectionsListItemInfo() {
        Enumeration enumeration = null;
        ProviderEntry providerEntry = null;
        SCProvider sCProvider = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Icon> arrayList3 = new ArrayList<Icon>();
        enumeration = this._viewerManager.getViewerSupport().getProviders().getProviderList();
        while (enumeration.hasMoreElements()) {
            providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded() || (sCProvider = providerEntry.getProvider()) instanceof SCProvider4 && (!(sCProvider instanceof SCProvider4) || !((SCProvider4)sCProvider).supportsConnecting())) continue;
            string = sCProvider instanceof SCProvider4 ? ((SCProvider4)sCProvider).getProviderConnectionsMenuItemText() : sCProvider.getDisplayName();
            arrayList2.add(SybMessageFormat.format((String)ScjSession.getString("STR_CONNECTIONS_CONNECT_TO"), (Object[])new Object[]{string}));
            if (sCProvider instanceof SCProvider4) {
                arrayList3.add(((SCProvider4)sCProvider).getProviderIcon());
                continue;
            }
            arrayList3.add(EMPTY_ICON);
        }
        arrayList.add(arrayList2.toArray(new String[arrayList2.size()]));
        arrayList.add(arrayList3.toArray(new Icon[arrayList3.size()]));
        return arrayList;
    }

    private ArrayList<Object> getDisconnectListItemInfo() {
        Enumeration enumeration = this._viewerManager.getViewerSupport().getConnectionList().elements();
        ScjConnection scjConnection = null;
        SCProvider sCProvider = null;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Icon> arrayList3 = new ArrayList<Icon>();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            scjConnection = (ScjConnection)enumeration.nextElement();
            sCProvider = scjConnection.provider;
            stringBuffer.setLength(0);
            stringBuffer.append('&').append(String.valueOf(n)).append(" ").append(scjConnection.description);
            if (scjConnection.displayName != null && scjConnection.displayName.trim().length() > 0) {
                stringBuffer.append(" - ").append(scjConnection.displayName);
            }
            stringBuffer.append(" (").append(sCProvider.getDisplayName()).append(")");
            arrayList2.add(stringBuffer.toString());
            ++n;
            if (sCProvider instanceof SCProvider4) {
                arrayList3.add(((SCProvider4)sCProvider).getProviderIcon());
                continue;
            }
            arrayList3.add(EMPTY_ICON);
        }
        arrayList.add(arrayList2.toArray(new String[arrayList2.size()]));
        arrayList.add(arrayList3.toArray(new Icon[arrayList3.size()]));
        return arrayList;
    }

    private String[] getConnProfListItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        arrayList2 = this._session.getConnectionProfileMRUList(this._viewerManager.getViewerSupport());
        if (arrayList2.size() > 0) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < 5 && i * 2 + 1 < arrayList2.size(); ++i) {
                stringBuffer.setLength(0);
                stringBuffer.append('&').append(String.valueOf(n2 + 1)).append(" ").append(arrayList2.get(n));
                arrayList.add(stringBuffer.toString());
                ++n2;
                n += 2;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void doDisconnect(int n) {
        Vector vector = null;
        ScjConnection scjConnection = null;
        vector = this._viewerManager.getViewerSupport().getConnectionList();
        if (n < vector.size()) {
            scjConnection = (ScjConnection)vector.elementAt(n);
            scjConnection.provider.disconnect(this._viewerManager.getViewerFrame(), scjConnection.data);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SCToolBarDropDownButton sCToolBarDropDownButton = null;
        SCToolBarToggleButton sCToolBarToggleButton = null;
        SCViewerToolBarButton sCViewerToolBarButton = null;
        Vector vector = null;
        ScjConnection scjConnection = null;
        if (actionEvent.getActionCommand().equals(F11_KEY)) {
            this._connectToolBarDropDownButton.doClick();
        } else if (actionEvent.getSource() instanceof SCToolBarDropDownButton) {
            sCToolBarDropDownButton = (SCToolBarDropDownButton)((Object)actionEvent.getSource());
            int n = sCToolBarDropDownButton.getCommandId();
            if (n == 1019) {
                ArrayList<Object> arrayList = this.getConnectionsListItemInfo();
                if (((String[])arrayList.get(0)).length == 1) {
                    this._listener.menuItemSelected(1305);
                } else {
                    sCToolBarDropDownButton.showDropDown();
                }
            } else if (n == 1020) {
                vector = this._viewerManager.getViewerSupport().getConnectionList();
                if (vector != null && vector.size() == 1) {
                    scjConnection = (ScjConnection)vector.firstElement();
                    scjConnection.provider.disconnect(this._viewerManager.getViewerFrame(), scjConnection.data);
                } else {
                    sCToolBarDropDownButton.showDropDown();
                }
            } else if (n == 1021) {
                this._listener.menuItemSelected(n);
            }
        } else if (actionEvent.getSource() instanceof SCToolBarToggleButton) {
            sCToolBarToggleButton = (SCToolBarToggleButton)((Object)actionEvent.getSource());
            this._listener.menuItemSelected(sCToolBarToggleButton.getCommandId());
        } else if (actionEvent.getSource() instanceof SCViewerToolBarButton) {
            sCViewerToolBarButton = (SCViewerToolBarButton)((Object)actionEvent.getSource());
            this._listener.menuItemSelected(sCViewerToolBarButton.getCommandId());
        }
    }

    public void dropDownOpening(DropDownButtonEvent dropDownButtonEvent) {
        SCToolBarDropDownButton sCToolBarDropDownButton = null;
        Object[] objectArray = null;
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>();
        if (dropDownButtonEvent.getSource() instanceof SCToolBarDropDownButton) {
            sCToolBarDropDownButton = (SCToolBarDropDownButton)((Object)dropDownButtonEvent.getSource());
            int n = sCToolBarDropDownButton.getCommandId();
            if (n == 1019) {
                ArrayList<Object> arrayList2 = this.getConnectionsListItemInfo();
                sCToolBarDropDownButton.setListData((String[])arrayList2.get(0), (Icon[])arrayList2.get(1));
            } else if (n == 1020) {
                ArrayList<Object> arrayList3 = this.getDisconnectListItemInfo();
                sCToolBarDropDownButton.setListData((String[])arrayList3.get(0), (Icon[])arrayList3.get(1));
            } else if (n == 1021) {
                objectArray = this.getConnProfListItems();
                if (objectArray.length == 0) {
                    sCToolBarDropDownButton.setListData(null, null);
                    this._listener.menuItemSelected(n);
                } else {
                    for (int i = 0; i < objectArray.length; ++i) {
                        arrayList.add(JCOMP_CONN_PROFILE_ICON);
                    }
                    sCToolBarDropDownButton.setListData(objectArray, arrayList.toArray(new Icon[arrayList.size()]));
                }
            }
        }
    }

    public void dropDownItemClicked(DropDownButtonEvent dropDownButtonEvent) {
        SCToolBarDropDownButton sCToolBarDropDownButton = null;
        if (dropDownButtonEvent.getSource() instanceof SCToolBarDropDownButton) {
            sCToolBarDropDownButton = (SCToolBarDropDownButton)((Object)dropDownButtonEvent.getSource());
            int n = sCToolBarDropDownButton.getCommandId();
            if (n == 1019) {
                this._listener.menuItemSelected(1305 + dropDownButtonEvent.getIndex());
            } else if (n == 1020) {
                this.doDisconnect(dropDownButtonEvent.getIndex());
            } else if (n == 1021) {
                this._listener.menuItemSelected(1300 + dropDownButtonEvent.getIndex());
            }
        }
    }

    void setEnabledToolBarButtons(int n) {
        this._toolBarButtonBitMask = n;
        int n2 = 0;
        for (n2 = 0; n2 < this._toolBar.getComponentCount(); ++n2) {
            Component component = this._toolBar.getComponentAtIndex(n2);
            if (!(component instanceof SCViewerToolBarButton) || ((SCViewerToolBarButton)((Object)component)).getCommandId() == 1012 || ((SCViewerToolBarButton)((Object)component)).getCommandId() == 1013 || ((SCViewerToolBarButton)((Object)component)).getCommandId() == 1014 || ((SCViewerToolBarButton)((Object)component)).getCommandId() == 1006) continue;
            ((SCViewerToolBarButton)((Object)component)).enable(n);
        }
        this.repaint();
    }

    void setSelectedViewButton(String string) {
        int n = 0;
        int n2 = 0;
        Component component = null;
        SCToolBarToggleButton sCToolBarToggleButton = null;
        if (string.equals("search")) {
            n = 1015;
        } else if (string.equals("tasks")) {
            n = 1016;
        } else if (string.equals("folders")) {
            n = 1017;
        } else if (string.equals("none")) {
            n = 0;
        }
        for (n2 = 0; n2 < this._toolBar.getComponentCount(); ++n2) {
            component = this._toolBar.getComponentAtIndex(n2);
            if (!(component instanceof SCToolBarToggleButton)) continue;
            sCToolBarToggleButton = (SCToolBarToggleButton)((Object)component);
            sCToolBarToggleButton.removeActionListener(this);
            sCToolBarToggleButton.setSelected(sCToolBarToggleButton.getCommandId() == n);
            sCToolBarToggleButton.addActionListener(this);
        }
        this.repaint();
    }

    void setEnabledNavigationButtons(int n) {
        int n2 = 0;
        for (n2 = 0; n2 < this._toolBar.getComponentCount(); ++n2) {
            Component component = this._toolBar.getComponentAtIndex(n2);
            if (!(component instanceof SCViewerToolBarButton) || ((SCViewerToolBarButton)((Object)component)).getCommandId() != 1012 && ((SCViewerToolBarButton)((Object)component)).getCommandId() != 1013 && ((SCViewerToolBarButton)((Object)component)).getCommandId() != 1014) continue;
            ((SCViewerToolBarButton)((Object)component)).enable(n);
        }
        this.repaint();
    }

    void setEnabledConnectionButtons(int n) {
        this._toolBarButtonBitMask = n;
        int n2 = 0;
        for (n2 = 0; n2 < this._toolBar.getComponentCount(); ++n2) {
            Component component = this._toolBar.getComponentAtIndex(n2);
            if (!(component instanceof SCToolBarDropDownButton) || ((SCToolBarDropDownButton)((Object)component)).getCommandId() != 1019 && ((SCToolBarDropDownButton)((Object)component)).getCommandId() != 1020) continue;
            ((SCToolBarDropDownButton)((Object)component)).enable(n);
        }
        this.repaint();
    }

    void releaseResources() {
        for (int i = 0; i < this._toolBar.getComponentCount(); ++i) {
            Component component = this._toolBar.getComponentAtIndex(i);
            if (component instanceof SCViewerToolBarButton) {
                ((SCViewerToolBarButton)((Object)component)).removeActionListener(this);
                continue;
            }
            if (component instanceof SCToolBarToggleButton) {
                ((SCToolBarToggleButton)((Object)component)).removeActionListener(this);
                continue;
            }
            if (!(component instanceof SCToolBarDropDownButton)) continue;
            ((SCToolBarDropDownButton)((Object)component)).removeActionListener(this);
            ((SCToolBarDropDownButton)((Object)component)).removeDropDownButtonListener(this);
        }
        this.registerF11Key(false);
        DialogUtils.removeComponents((Container)this);
        this._session = null;
        this._viewerManager = null;
        this._listener = null;
        this._toolBar.removeAll();
        this._toolBar = null;
        this._connectToolBarDropDownButton = null;
    }
}

