/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.DefaultSCDialogController;
import com.sybase.central.SCContainer;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCLogEntry;
import com.sybase.central.SCLogViewer;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCPageController;
import com.sybase.central.SCProfile;
import com.sybase.central.SCProvider;
import com.sybase.central.SCSearch;
import com.sybase.central.SCSearchHit;
import com.sybase.central.SCViewerManager;
import com.sybase.central.SCViewerSupport6;
import com.sybase.central.editor.EditorFrame;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.SCEditorFrame;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.ConnProfileDlg;
import com.sybase.central.viewer.ConnectionProfile;
import com.sybase.central.viewer.ConnectionProfilesKey;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.LogViewer;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.Providers;
import com.sybase.central.viewer.Register;
import com.sybase.central.viewer.ScjConnection;
import com.sybase.central.viewer.ScjDialogSupport;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.Utilities;
import com.sybase.central.viewer.Viewer;
import com.sybase.util.AppCounter;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.DetailsWarningDialog;
import com.sybase.util.FileLocator;
import com.sybase.util.Launcher;
import com.sybase.util.SplashScreen;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

class ScjViewerSupport
implements SCViewerSupport6,
AppCounter,
ScjResourceConstants,
IConstants {
    private ScjSession _session = null;
    private AppCounter _appCounter = null;
    private Vector<ScjConnection> _connectionList = new Vector(30);
    private Providers _providers = null;
    private SCLogViewer _logViewer = null;
    private Viewer _viewer = null;
    private int _applicationCount = 0;

    ScjViewerSupport(ScjSession scjSession, AppCounter appCounter) {
        this._session = scjSession;
        this._appCounter = appCounter;
    }

    ScjSession getScjSession() {
        return this._session;
    }

    @Override
    public long getVersion() {
        return 600L;
    }

    @Override
    public Locale getLocale() {
        return this._session.getLocale();
    }

    @Override
    public String[] getCommandLineArgs() {
        return this._session.getArgs();
    }

    @Override
    public String getHelpType() {
        return "Java Help";
    }

    @Override
    public void registerTopLevelContainer(SCContainer sCContainer) {
        this._session.getRootContainer().addContainer(sCContainer, null);
    }

    @Override
    public void unregisterTopLevelContainer(SCContainer sCContainer) {
        this._session.getRootContainer().removeContainer(sCContainer, null);
    }

    @Override
    public void registerConnection(SCProvider sCProvider, String string, String string2, Object object) {
        ScjConnection scjConnection = new ScjConnection();
        scjConnection.provider = sCProvider;
        scjConnection.displayName = string;
        scjConnection.data = object;
        scjConnection.description = string2;
        this._connectionList.addElement(scjConnection);
        this._session.updateConnectionOptions();
    }

    @Override
    public void unregisterConnection(Object object) {
        Enumeration<ScjConnection> enumeration = this._connectionList.elements();
        while (enumeration.hasMoreElements()) {
            ScjConnection scjConnection = enumeration.nextElement();
            if (object != scjConnection.data) continue;
            this._connectionList.removeElement(scjConnection);
            this._session.updateConnectionOptions();
            return;
        }
    }

    @Override
    public void messageBoxString(Container container, String string, int n) {
        this.messageBoxString(container, string, -1, n);
    }

    @Override
    public int messageBoxString(Container container, String string, int n, int n2) {
        return this.messageBoxString(container, string, n, n2, 0);
    }

    @Override
    public JApplet getApplet() {
        return this._session.getApplet();
    }

    @Override
    public SCDialogSupport getDialogSupport(JFrame jFrame) {
        return new ScjDialogSupport(jFrame, this, false);
    }

    @Override
    public SCDialogSupport getDialogSupport(JDialog jDialog) {
        return new ScjDialogSupport(jDialog, this, false);
    }

    @Override
    public void startWait() {
        this._session.startWait();
    }

    @Override
    public void endWait() {
        this._session.endWait();
    }

    @Override
    public Clipboard getClipboard() {
        return this._session.getClipboard();
    }

    @Override
    public void addLogEntry(SCLogEntry sCLogEntry) {
        if (this._logViewer == null) {
            this._logViewer = new LogViewer(this._session);
            try {
                this._logViewer.create(false);
            }
            catch (Exception exception) {
                return;
            }
        }
        this._logViewer.addLogEntry(sCLogEntry);
    }

    @Override
    public EditorFrame getEditor(JFrame jFrame, String string, Image image, String string2, Parser parser, SCMenuItem sCMenuItem) {
        return this.getEditor(jFrame, string, image, string2, parser, sCMenuItem, true, true, false, true, true, true, true);
    }

    @Override
    public EditorFrame getEditor(JFrame jFrame, String string, Image image, String string2, Parser parser, SCMenuItem sCMenuItem, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        return this.getEditor(string, image, string2, parser, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    @Override
    public AppCounter getAppCounter() {
        if (this._appCounter != null) {
            return this._appCounter;
        }
        return this;
    }

    @Override
    public int messageBoxString(Container container, String string, int n, int n2, int n3) {
        String string2 = ScjSession.getString("STR_APP_NAME");
        if (container == null) {
            ScjViewerSupport scjViewerSupport = this;
            container = scjViewerSupport._session.getViewerFrame();
        }
        return SybOptionPane.showOptionDialog((Component)container, (Object)string, (String)string2, (int)n, (int)n2, null, null, (Object)n3);
    }

    @Override
    public SCProfile[] getSCProfiles(String string) {
        Vector<SCProfile> vector = new Vector<SCProfile>();
        Object[] objectArray = this._session.getConnectionProfilesKey().getConnectionProfiles();
        while (objectArray.hasMoreElements()) {
            ConnectionProfile connectionProfile = (ConnectionProfile)objectArray.nextElement();
            if (!connectionProfile.getProviderId().equals(string)) continue;
            vector.addElement(connectionProfile.getDataProfilesKey());
        }
        if (!vector.isEmpty()) {
            objectArray = new SCProfile[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    @Override
    public void showDetailsErrorDialog(Container container, String string, String string2) {
        String string3 = ScjSession.getString("STR_APP_NAME");
        Window window = container instanceof Dialog || container instanceof Frame ? (Window)container : SwingUtilities.windowForComponent(container);
        if (window instanceof Dialog) {
            DetailsErrorDialog.showDetailsErrorDialog((Dialog)((Dialog)window), (String)string3, (String)string, (String)string2, null);
        } else if (window instanceof Frame) {
            DetailsErrorDialog.showDetailsErrorDialog((Frame)((Frame)window), (String)string3, (String)string, (String)string2, null);
        } else {
            ScjViewerSupport scjViewerSupport = this;
            DetailsErrorDialog.showDetailsErrorDialog((Frame)scjViewerSupport._session.getViewerFrame(), (String)string3, (String)string, (String)string2, null);
        }
    }

    @Override
    public void showDetailsErrorDialog(Container container, String string, Throwable throwable) {
        String string2 = ScjSession.getString("STR_APP_NAME");
        if (container instanceof Dialog || container instanceof Frame) {
            Window window = (Window)container;
        } else {
            Window window = SwingUtilities.windowForComponent(container);
        }
        if (container instanceof Dialog) {
            DetailsErrorDialog.showDetailsErrorDialog((Dialog)((Dialog)container), (String)string2, (String)string, (Throwable)throwable, null);
        } else if (container instanceof Frame) {
            DetailsErrorDialog.showDetailsErrorDialog((Frame)((Frame)container), (String)string2, (String)string, (Throwable)throwable, null);
        } else {
            ScjViewerSupport scjViewerSupport = this;
            DetailsErrorDialog.showDetailsErrorDialog((Frame)scjViewerSupport._session.getViewerFrame(), (String)string2, (String)string, (Throwable)throwable, null);
        }
    }

    @Override
    public JFrame getViewerFrame() {
        ScjViewerSupport scjViewerSupport = this;
        return scjViewerSupport._session.getViewerFrame();
    }

    @Override
    public void setSelectedDetailsTabByName(String string) {
        this._viewer.getViewerManager().getContentPane().setSelectedDetailsTabByName(string);
    }

    @Override
    public boolean notifyAndSetSelectedDetailsTabByName(String string) {
        boolean bl = this._viewer.getViewerManager().getContentPane().setSelectedDetailsTabByName(string);
        if (bl) {
            this._viewer.getViewerManager().updateProviderVisualElements();
        }
        return bl;
    }

    @Override
    public void showConnectionProfileDlg(Container container) {
        SCPageController[] sCPageControllerArray;
        SCDialogSupport sCDialogSupport;
        if (container instanceof JDialog) {
            sCDialogSupport = this.getDialogSupport((JDialog)container);
        } else if (container instanceof JFrame) {
            sCDialogSupport = this.getDialogSupport((JFrame)container);
        } else {
            sCPageControllerArray = SwingUtilities.windowForComponent(container);
            if (sCPageControllerArray instanceof JDialog) {
                sCDialogSupport = this.getDialogSupport((JDialog)sCPageControllerArray);
            } else if (sCPageControllerArray instanceof JFrame) {
                sCDialogSupport = this.getDialogSupport((JFrame)sCPageControllerArray);
            } else {
                return;
            }
        }
        sCPageControllerArray = new SCPageController[]{new ConnProfileDlg(sCDialogSupport, this._session, this)};
        DefaultSCDialogController defaultSCDialogController = new DefaultSCDialogController(sCDialogSupport, sCPageControllerArray, 0);
        sCDialogSupport.setDialogController(defaultSCDialogController);
        sCDialogSupport.setTitle(ScjSession.getString("STR_CONNPROF_TITLE"));
        sCDialogSupport.setStandardButtons(false);
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(true);
        sCDialogSupport.render();
    }

    @Override
    public EditorFrame getEditor(String string, Image image, String string2, Parser parser, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        SCEditorFrame sCEditorFrame = new SCEditorFrame();
        sCEditorFrame.setShowNewFileItem(bl);
        sCEditorFrame.setShowOpenFileItem(bl2);
        sCEditorFrame.setShowCloseFileItem(bl3);
        sCEditorFrame.setShowSaveFileItem(bl4);
        sCEditorFrame.setShowSaveAsFileItem(bl5);
        sCEditorFrame.setShowPrintFileItem(bl6);
        sCEditorFrame.setShowExitFileItem(bl7);
        try {
            sCEditorFrame.create();
        }
        catch (Exception exception) {
            return null;
        }
        sCEditorFrame.newFile();
        sCEditorFrame.getEditor().setEditorType(parser);
        if (string2 != null) {
            sCEditorFrame.getEditor().reload((Reader)new StringReader(string2), 0);
        }
        sCEditorFrame.setTitle(string);
        sCEditorFrame.setIconImage(image);
        return sCEditorFrame;
    }

    @Override
    public void registerTopLevelContainer(SCContainer sCContainer, SCProvider sCProvider) {
        this._session.getRootContainer().addContainer(sCContainer, null);
        ProviderEntry providerEntry = this.getProviderEntryForProvider(sCProvider);
        if (providerEntry != null) {
            providerEntry.addTopLevelContainer(sCContainer);
        }
    }

    @Override
    public void unregisterTopLevelContainer(SCContainer sCContainer, SCProvider sCProvider) {
        this._session.getRootContainer().removeContainer(sCContainer, null);
        ProviderEntry providerEntry = this.getProviderEntryForProvider(sCProvider);
        if (providerEntry != null) {
            providerEntry.removeTopLevelContainer(sCContainer);
        }
    }

    @Override
    public void setToolBarJComponents(JComponent[] jComponentArray, SCProvider sCProvider) {
        ProviderEntry providerEntry = this.getProviderEntryForProvider(sCProvider);
        if (providerEntry != null) {
            providerEntry.setToolBarJComponents(jComponentArray);
            this._viewer.getViewerManager().getMainPanel().updateProviderToolBar(providerEntry, true);
        }
    }

    @Override
    public void setTopLevelJMenus(JMenu[] jMenuArray, SCProvider sCProvider) {
        ProviderEntry providerEntry = this.getProviderEntryForProvider(sCProvider);
        if (providerEntry != null) {
            providerEntry.setTopLevelJMenus(jMenuArray);
            this._viewer.getViewerManager().getMenuManager().updateProviderMenus(providerEntry, true);
        }
    }

    @Override
    public void setBottomJComponent(JComponent jComponent, String string, String string2, SCProvider sCProvider, boolean bl) {
        ProviderEntry providerEntry = this.getProviderEntryForProvider(sCProvider);
        if (providerEntry != null) {
            providerEntry.setBottomJComponent(jComponent, string, string2);
            providerEntry.setBottomJComponentVisible(bl);
            this._viewer.getViewerManager().getMainPanel().updateProviderBottomJComponent(providerEntry, true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ScjViewerSupport.this._viewer.getViewerManager().getMainPanel().requestPaneFocus();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean isBottomJComponentVisible(SCProvider sCProvider) {
        ProviderEntry providerEntry = this.getProviderEntryForProvider(sCProvider);
        if (providerEntry != null) {
            return providerEntry.isBottomJComponentVisible();
        }
        return false;
    }

    @Override
    public void setStatusBarMessage(String string) {
        if (this._viewer != null && this._viewer.getViewerManager() != null && this._viewer.getViewerManager().getMainPanel() != null) {
            this._viewer.getViewerManager().getMainPanel().updateStatusBarText(string);
        }
    }

    @Override
    public void setStatusBarJComponent(JComponent jComponent, SCProvider sCProvider) {
        ProviderEntry providerEntry = this.getProviderEntryForProvider(sCProvider);
        if (providerEntry != null) {
            providerEntry.setStatusBarJComponent(jComponent);
            this._viewer.getViewerManager().getMainPanel().updateProviderStatusBarJComponent(providerEntry, true);
        }
    }

    @Override
    public SCProvider[] getLoadedSCProviders() {
        ArrayList<SCProvider> arrayList = new ArrayList<SCProvider>();
        SCProvider[] sCProviderArray = new SCProvider[]{};
        Enumeration enumeration = this._providers.getProviderList();
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded()) continue;
            arrayList.add(providerEntry.getProvider());
        }
        if (!arrayList.isEmpty()) {
            sCProviderArray = arrayList.toArray(new SCProvider[arrayList.size()]);
        }
        return sCProviderArray;
    }

    @Override
    public String getSelectedDetailsTabName() {
        return this._viewer.getViewerManager().getContentPane().getSelectedDetailsTabName();
    }

    @Override
    public SCProfile createConnectionProfile(SCProvider sCProvider, String string, boolean bl) {
        return this.createConnectionProfile(sCProvider, string, "", bl, false);
    }

    @Override
    public SCViewerManager getViewerManager() {
        return this._viewer.getViewerManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SCProfile createConnectionProfile(SCProvider sCProvider, String string, String string2, boolean bl, boolean bl2) {
        ConnectionProfile connectionProfile;
        ConnectionProfilesKey connectionProfilesKey = this._session.getConnectionProfilesKey();
        if (connectionProfilesKey.hasConnectionProfile(string)) {
            return null;
        }
        String string3 = sCProvider.getDisplayName();
        String string4 = sCProvider.getId();
        if (bl) {
            if (!this._session.isSCRepositoryWriteable()) return null;
            connectionProfile = connectionProfilesKey.createSystemConnectionProfile(string, string2, false, string3, string4, null, bl2);
            return connectionProfile.getDataProfilesKey();
        } else {
            connectionProfile = connectionProfilesKey.createUserConnectionProfile(string, string2, false, string3, string4, null);
        }
        return connectionProfile.getDataProfilesKey();
    }

    @Override
    public void addSearchHits(SCSearchHit[] sCSearchHitArray) {
        if (Thread.currentThread().getName().indexOf("AWT") < 0) {
            // empty if block
        }
        for (int i = 0; i < sCSearchHitArray.length; ++i) {
            this._viewer.getViewerManager().getMainPanel().getSearchPane().addSCSearchHitToResults(sCSearchHitArray[i]);
        }
    }

    @Override
    public void searchComplete(SCSearch sCSearch) {
        if (Thread.currentThread().getName().indexOf("AWT") < 0) {
            // empty if block
        }
        this._viewer.getViewerManager().getMainPanel().getSearchPane().searchCompleted(sCSearch);
    }

    @Override
    public boolean selectTreeRootNode() {
        return this._viewer.getViewerManager().selectTreeItem(this._session.getRootContainer());
    }

    @Override
    public boolean registerPlugin(String string) {
        String[] stringArray = new String[]{null, null, null, null, null, null};
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        Object var11_11 = null;
        try {
            stringArray = Utilities.readJPRFile(string);
            string2 = stringArray[0];
            string3 = stringArray[1];
            string4 = stringArray[2];
            string5 = stringArray[3];
            string6 = stringArray[4];
            string7 = stringArray[5];
            string8 = stringArray[6];
            string9 = stringArray[7];
            if (string2 == null || string3 == null || string4 == null || string5 == null) {
                return false;
            }
            if (string6 == null) {
                string6 = "";
            }
            if (string7 == null) {
                string7 = "";
            }
            if (this._providers.createProviderEntry(string3, string4, string2, "", string5, string6, string7, string8, string9, true, true) != null) {
                this._session.saveSCPreferences();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean unregisterPlugin(String string) {
        Enumeration enumeration = null;
        ProviderEntry providerEntry = null;
        enumeration = this._providers.getProviderList();
        while (enumeration.hasMoreElements()) {
            providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.getProviderId().equals(string)) continue;
            this._providers.removeProviderEntry(providerEntry);
            this._session.saveSCPreferences();
            return true;
        }
        return false;
    }

    @Override
    public SCDetailsContainer getDetailsContainerForSelectedDetailsPanel() {
        return this._viewer.getViewerManager().getContentPane().getDetailsContainerForActiveDetailsPanel();
    }

    @Override
    public SCDialogSupport getVistaAdministratorDialogSupport(JFrame jFrame) {
        return new ScjDialogSupport(jFrame, this, true);
    }

    @Override
    public SCDialogSupport getVistaAdministratorDialogSupport(JDialog jDialog) {
        return new ScjDialogSupport(jDialog, this, true);
    }

    @Override
    public void showDetailsWarningDialog(Container container, String string, String string2) {
        String string3 = ScjSession.getString("STR_APP_NAME");
        DetailsWarningDialog.showDialog((Component)container, (String)string3, (String)string, (String)string2, null);
    }

    @Override
    public String getSCViewerDetailsPanelTypeForSelectedDetailsPanel() {
        if (this._viewer.getViewerManager().getContentPane().getDetailsListForActiveDetailsPanel() != null) {
            return "DETAILS_LIST";
        }
        return null;
    }

    public void AppStarted() {
        if (this._appCounter != null) {
            this._appCounter.AppStarted();
        } else {
            ++this._applicationCount;
        }
    }

    public void AppStopped() {
        if (this._appCounter != null) {
            this._appCounter.AppStopped();
        } else {
            --this._applicationCount;
            if (this._applicationCount < 1) {
                if (this._session != null) {
                    int n = this._session.getUserPrefRepositoryInfo().getFastLauncherPort();
                    if (!Launcher.isFastLauncherRunningInProcess((int)n)) {
                        System.exit(0);
                    }
                } else {
                    System.exit(0);
                }
            }
        }
    }

    private ProviderEntry getProviderEntryForProvider(SCProvider sCProvider) {
        Enumeration enumeration = this._providers.getProviderList();
        while (enumeration.hasMoreElements()) {
            ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
            if (providerEntry.getProvider() == null || providerEntry.getProvider() != sCProvider) continue;
            return providerEntry;
        }
        return null;
    }

    void releaseResources() {
        this._session = null;
        this._connectionList.removeAllElements();
        this._connectionList = null;
        this._providers.releaseResources();
        this._providers = null;
        this._logViewer = null;
        this._viewer = null;
    }

    Vector getConnectionList() {
        return this._connectionList;
    }

    void initialize(Viewer viewer, SplashScreen splashScreen) {
        ProviderEntry providerEntry;
        Object object;
        String[] stringArray;
        String string;
        this._viewer = viewer;
        ScjViewerSupport scjViewerSupport = this;
        this._providers = new Providers(this._session.getSCRepository(), scjViewerSupport._session.getUserPrefRepository(), this._session.getUserPrefRepositoryInfo());
        Enumeration enumeration = this._providers.getProviderList();
        if (!enumeration.hasMoreElements() && (string = System.getenv("SQLANY11")) != null && !string.isEmpty() && FileLocator.isInstalled()) {
            String string2 = this._session.getSCRepository().getLocation();
            stringArray = new String[]{"saplugin.jar", "mlplugin.jar", "qaplugin.jar", "ulplugin.jar"};
            for (int i = 0; i < stringArray.length; ++i) {
                object = FileLocator.find((String)stringArray[i]);
                if (object == null) continue;
                try {
                    Register.registerPluginWithJAR(string2, ((File)object).getPath(), String.valueOf(i + 1));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._providers.releaseResources();
            try {
                this._session.getSCRepository().load();
                ScjViewerSupport scjViewerSupport2 = this;
                this._providers = new Providers(this._session.getSCRepository(), scjViewerSupport2._session.getUserPrefRepository(), this._session.getUserPrefRepositoryInfo());
                enumeration = this._providers.getProviderList();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        string = this._session.getCommandLineProperties().getProperty("loadprovider");
        while (enumeration.hasMoreElements()) {
            providerEntry = (ProviderEntry)enumeration.nextElement();
            boolean bl = false;
            if (this._session.isInSafeMode() || !this._session.getUserPrefRepositoryInfo().isProviderAutoload(providerEntry.getProviderId()) && (string == null || !string.equals(providerEntry.getProviderId()))) continue;
            try {
                if (splashScreen != null) {
                    splashScreen.setStatusMessage(SybMessageFormat.format((String)ScjSession.getString("STR_SPLASH_PLUGIN"), (Object[])new Object[]{providerEntry.getName()}));
                }
                providerEntry.loadProvider(this._session.isApplet());
                object = providerEntry.getProvider();
                try {
                    if (!object.initialize(viewer.getFrame(), this)) {
                        this.messageBoxString(viewer.getFrame(), SybMessageFormat.format((String)ScjSession.getString("ERR_PROVIDER_INIT"), (Object[])new Object[]{providerEntry.getName()}), 0);
                        providerEntry.unloadProvider();
                        continue;
                    }
                    try {
                        if (!object.startup(viewer.getFrame(), providerEntry.getProviderProfile(), providerEntry.getProviderLoader())) {
                            providerEntry.unloadProvider();
                            continue;
                        }
                        bl = true;
                        this._session.providerEntryChanged(providerEntry);
                        providerEntry.setName(providerEntry.getProvider().getDisplayName());
                        providerEntry.setVersion(providerEntry.getProvider().getDisplayVersion());
                    }
                    catch (Throwable throwable) {
                        this.showDetailsErrorDialog((Container)viewer.getFrame(), SybMessageFormat.format((String)ScjSession.getString("ERR_PROVIDER_STARTUP"), (Object[])new Object[]{providerEntry.getName()}), throwable);
                        providerEntry.unloadProvider();
                    }
                }
                catch (Throwable throwable) {
                    this.showDetailsErrorDialog((Container)viewer.getFrame(), SybMessageFormat.format((String)ScjSession.getString("ERR_PROVIDER_INIT"), (Object[])new Object[]{providerEntry.getName()}), throwable);
                    providerEntry.unloadProvider();
                }
            }
            catch (Throwable throwable) {
                if (providerEntry.isLoaded() && bl) {
                    providerEntry.getProvider().shutdown();
                }
                providerEntry.unloadProvider();
                this.showDetailsErrorDialog((Container)viewer.getFrame(), SybMessageFormat.format((String)ScjSession.getString("ERR_LOADING_PROVIDER_CLASS"), (Object[])new Object[]{providerEntry.getName()}), throwable);
            }
        }
        Enumeration enumeration2 = this._session.getConnectionProfilesKey().getConnectionProfiles();
        block12: while (enumeration2.hasMoreElements()) {
            object = (ConnectionProfile)enumeration2.nextElement();
            if (!this._session.getUserPrefRepositoryInfo().isConnProfAutostart(((ConnectionProfile)object).getName(), ((ConnectionProfile)object).isFirstTimeStart())) continue;
            stringArray = ((ConnectionProfile)object).getProviderName();
            Enumeration enumeration3 = this._providers.getProviderList();
            while (enumeration3.hasMoreElements()) {
                SCProvider sCProvider;
                providerEntry = (ProviderEntry)enumeration3.nextElement();
                if (!providerEntry.isLoaded() || !(sCProvider = providerEntry.getProvider()).getDisplayName().equals(stringArray)) continue;
                if (splashScreen != null) {
                    splashScreen.setStatusMessage(SybMessageFormat.format((String)ScjSession.getString("STR_SPLASH_CONN"), (Object[])new Object[]{((ConnectionProfile)object).getName()}));
                }
                this.restoreConnection(sCProvider, viewer.getFrame(), (ConnectionProfile)object);
                continue block12;
            }
        }
        this._viewer.getViewerManager().getMainPanel().getTaskPane().updateTasks();
    }

    Providers getProviders() {
        return this._providers;
    }

    @Override
    public SCLogViewer getLogViewer() {
        if (this._logViewer == null) {
            this._logViewer = new LogViewer(this._session);
            try {
                this._logViewer.create(false);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this._logViewer;
    }

    boolean restoreConnection(SCProvider sCProvider, JFrame jFrame, ConnectionProfile connectionProfile) {
        ArrayList<String> arrayList = null;
        boolean bl = sCProvider.restoreConnection(jFrame, connectionProfile.getDataProfilesKey());
        if (bl) {
            arrayList = this._session.getConnectionProfileMRUList(this);
            arrayList.add(0, connectionProfile.getName());
            arrayList.add(1, connectionProfile.getProviderName());
            for (int i = arrayList.size() - 2; i > 1; i -= 2) {
                String string = arrayList.get(i);
                String string2 = arrayList.get(i + 1);
                if (!string.equals(connectionProfile.getName()) || !string2.equals(connectionProfile.getProviderName())) continue;
                arrayList.remove(i + 1);
                arrayList.remove(i);
            }
            while (arrayList.size() > 10) {
                arrayList.remove(10);
            }
            this._session.getUserPrefRepositoryInfo().setMRUConnectionProfiles(Utilities.buildProfileStringList(arrayList));
        }
        return bl;
    }

    SCProvider getLoadedSCProviderByName(String string) {
        Enumeration enumeration = null;
        ProviderEntry providerEntry = null;
        enumeration = this.getProviders().getProviderList();
        while (enumeration.hasMoreElements()) {
            providerEntry = (ProviderEntry)enumeration.nextElement();
            if (!providerEntry.isLoaded() || !providerEntry.getProvider().getDisplayName().equals(string)) continue;
            return providerEntry.getProvider();
        }
        return null;
    }
}

