/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer;
import com.sybase.central.SCItem5;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.ContainerListener;
import com.sybase.central.viewer.NewInterfaceVersionHelper;
import com.sybase.central.viewer.RootContainer;
import com.sybase.central.viewer.SCScrollPane;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.TransferableItems;
import com.sybase.central.viewer.TransferableSCItem;
import com.sybase.central.viewer.TreeItem;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class ScopePane
implements TreeWillExpandListener,
TreeExpansionListener,
TreeSelectionListener,
ScjResourceConstants,
FocusListener {
    private SCScrollPane _scrollPane;
    private SCJTree _tree;
    private JFrame _viewerFrame;
    private ScjSession _session;
    private DefaultTreeModel _treeModel;
    private TreeItem _rootItem;
    private ViewerManager _viewerManager;
    private TreeItem _selectedItem = null;
    private TreeItem _pendingTreeItemSelection = null;
    private MouseListener _mouseListener = null;
    private Timer _treeTimer = null;
    private boolean _isPerformingNewSelection = false;
    private static final int STATE_EXPANDED = 1;
    private static final int STATE_SELECTED = 2;
    static Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    ScopePane(JFrame jFrame, ScjSession scjSession) {
        this._viewerFrame = jFrame;
        this._session = scjSession;
        this._scrollPane = new SCScrollPane();
        this._scrollPane.setMinimumSize(new Dimension(0, this._scrollPane.getHeight()));
        this._scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this._tree = new SCJTree(this._treeModel);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._treeModel.setAsksAllowsChildren(true);
        this._tree.setRequestFocusEnabled(true);
        this._scrollPane.getViewport().setView(this._tree);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        TreeItem treeItem = this.getNodeFromPath(treePath);
        SCContainer sCContainer = treeItem.getContainer();
        if (treeItem == this._rootItem) {
            return;
        }
        if (!NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 201, 0)) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
        if (!treeItem.hasBeenOpened() && !NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 100, 0)) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        TreeItem treeItem = this.getNodeFromPath(treePath);
        SCContainer sCContainer = treeItem.getContainer();
        if (treeItem == this._rootItem) {
            return;
        }
        if (!NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 202, 0)) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
        if (this.isDescendant(this._selectedItem, treeItem)) {
            this._isPerformingNewSelection = true;
            if (!this._viewerManager.getContentPane().notifyCurrentPageOfOnKillActive()) {
                this.setViewerManagerSelectedTreeItem(this._selectedItem);
                this._isPerformingNewSelection = false;
                throw new ExpandVetoException(treeExpansionEvent);
            }
            NewInterfaceVersionHelper.doOnNotify(this._selectedItem.getContainer(), this._viewerFrame, 204, 0);
            this.setViewerManagerSelectedTreeItem(treeItem);
            NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 203, 0);
            this._isPerformingNewSelection = false;
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        TreeItem treeItem = this.getNodeFromPath(treePath);
        SCContainer sCContainer = treeItem.getContainer();
        if (treeItem == this._rootItem) {
            return;
        }
        if (!treeItem.hasBeenOpened()) {
            this.openTreeItem(treeItem, false, false);
        }
        this._viewerManager.getMainPanel().requestPaneFocus();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        TreeItem treeItem = this.getNodeFromPath(treePath);
        SCContainer sCContainer = treeItem.getContainer();
        if (this.isDescendant(this._selectedItem, treeItem)) {
            this._isPerformingNewSelection = true;
            this.listenToTreeEvents(false);
            this._tree.setSelectionPath(new TreePath(treeItem.getPath()));
            this._selectedItem = treeItem;
            this.setViewerManagerSelectedTreeItem(this._selectedItem);
            this.listenToTreeEvents(true);
            this._isPerformingNewSelection = false;
        }
        if (treeItem == this._rootItem) {
            return;
        }
        if ((sCContainer.getAttributes() & 2) != 0 && (this.isAncestor(this._selectedItem, treeItem) || this.isAtSameLevel(treeItem, this._selectedItem))) {
            this.closeTreeItem(treeItem);
        }
        this._viewerManager.getMainPanel().requestPaneFocus();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        TreeItem treeItem = this.getNodeFromPath(treePath);
        this._isPerformingNewSelection = true;
        this.setTreeSelection(treeItem);
        this._isPerformingNewSelection = false;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this._viewerManager.isWaiting()) {
            return;
        }
        this.listenToTreeEvents(false);
        if (focusEvent.getSource() == this._tree && this._selectedItem != null && focusEvent.getOppositeComponent() != this._tree) {
            this._viewerManager.setSelectedTreeItem(this._selectedItem);
        }
        this.listenToTreeEvents(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    TreeItem getTreeItemForTreePath(String[] stringArray) {
        Vector<TreeItem> vector = new Vector<TreeItem>();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        vector.add(this._rootItem);
        return this.findItemInTreeForPath(vector.elements(), stringArray, 0);
    }

    private TreeItem findItemInTreeForPath(Enumeration enumeration, String[] stringArray, int n) {
        TreeItem treeItem = null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                treeItem = (TreeItem)enumeration.nextElement();
                if (treeItem.toString() == null || !treeItem.toString().equals(stringArray[n])) continue;
                if (n + 1 == stringArray.length) {
                    return treeItem;
                }
                if ((treeItem = this.findItemInTreeForPath(treeItem.children(), stringArray, n + 1)) == null) continue;
                return treeItem;
            }
        }
        return null;
    }

    TreeItem getPendingTreeItemSelection() {
        return this._pendingTreeItemSelection;
    }

    void setPendingTreeItemSelection(TreeItem treeItem) {
        this._pendingTreeItemSelection = treeItem;
    }

    private void setTreeSelection(TreeItem treeItem) {
        if (this._tree.keyNavigation()) {
            if (this._treeTimer != null) {
                this._treeTimer.stop();
                this._treeTimer = null;
            }
            this.setPendingTreeItemSelection(treeItem);
            this._treeTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ScopePane.this.getPendingTreeItemSelection() == null) {
                        return;
                    }
                    if (ScopePane.this.getPendingTreeItemSelection() == ScopePane.this._selectedItem) {
                        ScopePane.this.setViewerManagerSelectedTreeItem(ScopePane.this._selectedItem);
                    } else if (!ScopePane.this.selectTreeItem(ScopePane.this.getPendingTreeItemSelection())) {
                        ScopePane.this.listenToTreeEvents(false);
                        if (ScopePane.this._selectedItem != null) {
                            ScopePane.this._tree.setSelectionPath(new TreePath(ScopePane.this._selectedItem.getPath()));
                            ScopePane.this._tree.scrollPathToVisible(new TreePath(ScopePane.this._selectedItem.getPath()));
                        }
                        ScopePane.this.listenToTreeEvents(true);
                    }
                    ScopePane.this.setPendingTreeItemSelection(null);
                }
            });
            this._treeTimer.setRepeats(false);
            this._treeTimer.start();
        } else if (treeItem == this._selectedItem) {
            this.setViewerManagerSelectedTreeItem(this._selectedItem);
        } else if (treeItem != this._selectedItem && !this.selectTreeItem(treeItem)) {
            this.listenToTreeEvents(false);
            this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
            this._tree.scrollPathToVisible(new TreePath(this._selectedItem.getPath()));
            this.listenToTreeEvents(true);
        }
    }

    private boolean isAncestor(TreeItem treeItem, TreeItem treeItem2) {
        if (treeItem == treeItem2 || treeItem.getParent() == treeItem2.getParent()) {
            return false;
        }
        TreePath treePath = new TreePath(treeItem.getPath());
        TreePath treePath2 = new TreePath(treeItem2.getPath());
        boolean bl = treePath2.isDescendant(treePath);
        return !bl;
    }

    private boolean isDescendant(TreeItem treeItem, TreeItem treeItem2) {
        if (treeItem == treeItem2 || treeItem == null || treeItem2 == null || treeItem.getParent() == treeItem2.getParent()) {
            return false;
        }
        TreePath treePath = new TreePath(treeItem.getPath());
        TreePath treePath2 = new TreePath(treeItem2.getPath());
        boolean bl = treePath2.isDescendant(treePath);
        return bl;
    }

    private boolean isAtSameLevel(TreeItem treeItem, TreeItem treeItem2) {
        return treeItem != treeItem2 && treeItem != null && treeItem2 != null && treeItem.getParent() == treeItem2.getParent();
    }

    private String[] getNodeNamePathBetweenNodes(TreeItem treeItem, TreeItem treeItem2) {
        TreeItem treeItem3;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(treeItem2.toString());
        for (treeItem3 = (TreeItem)treeItem2.getParent(); treeItem3 != null && treeItem3 != treeItem; treeItem3 = (TreeItem)treeItem3.getParent()) {
            arrayList.add(0, treeItem3.toString());
        }
        if (treeItem3 == null) {
            return null;
        }
        arrayList.add(0, treeItem.toString());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private TreeItem getChildTreeItemWithName(TreeItem treeItem, String string) {
        Enumeration enumeration = treeItem.children();
        while (enumeration.hasMoreElements()) {
            TreeItem treeItem2 = (TreeItem)enumeration.nextElement();
            if (!treeItem2.toString().equals(string)) continue;
            return treeItem2;
        }
        return null;
    }

    private TreeItem getNodeFromPath(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        return (TreeItem)treePath.getLastPathComponent();
    }

    JComponent getPane() {
        return this._scrollPane;
    }

    void requestFocusInWindow() {
        this.listenToTreeEvents(false);
        this._tree.requestFocusInWindow();
        this.listenToTreeEvents(true);
    }

    void initialize(RootContainer rootContainer, ViewerManager viewerManager) {
        this._viewerManager = viewerManager;
        this._rootItem = new TreeItem(rootContainer, null);
        this._treeModel.setRoot(this._rootItem);
        this._tree.setCellRenderer(new TreeViewRenderer());
        this._tree.getSelectionModel().setSelectionMode(1);
        ContainerListener containerListener = new ContainerListener(this._viewerManager, rootContainer, this._rootItem);
        this._rootItem.setContainerListener(containerListener);
        this._viewerManager.getContainerListeners().addElement(containerListener);
        this.listenToTreeEvents(true);
        this.listenToTreeEvents(false);
        this._rootItem.setSelected(true);
        this._selectedItem = this._rootItem;
        this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
        Enumeration enumeration = this._rootItem.getContainer().getItems();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SCContainer)) continue;
            this.addTreeItem(this._rootItem, (SCContainer)e);
            this.listenToTreeEvents(false);
        }
        this.setViewerManagerSelectedTreeItem(this._selectedItem);
        this.listenToTreeEvents(true);
        this.initMouseListener();
    }

    private void initMouseListener() {
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    ScopePane.this.showPopupMenu(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    ScopePane.this.showPopupMenu(mouseEvent);
                }
            }
        };
        this._tree.addMouseListener(this._mouseListener);
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            JMenuItem[] jMenuItemArray;
            TreeItem treeItem = (TreeItem)treePath.getLastPathComponent();
            if (this._viewerManager.getSelectedTreeItem() == null || this._viewerManager.getSelectedTreeItem() != treeItem) {
                if (!this.selectTreeItem(treeItem)) {
                    return;
                }
            } else {
                this._selectedItem = treeItem;
                this.listenToTreeEvents(false);
                this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
                this.listenToTreeEvents(true);
                this.setViewerManagerSelectedTreeItem(this._selectedItem);
            }
            if ((jMenuItemArray = this._viewerManager.buildTreeContextMenuItems()) != null) {
                JPopupMenu jPopupMenu = new JPopupMenu(null);
                for (int i = 0; i < jMenuItemArray.length; ++i) {
                    if (jMenuItemArray[i] == null) {
                        jPopupMenu.addSeparator();
                        continue;
                    }
                    jPopupMenu.add(jMenuItemArray[i]);
                }
                this._viewerManager.setPopupMenu(jPopupMenu);
                UIUtils.showJPopupMenu((JPopupMenu)jPopupMenu, (JComponent)this._tree, (Point)new Point(mouseEvent.getX(), mouseEvent.getY()));
            }
        }
    }

    private void reloadModelWithoutEvents() {
        this.listenToTreeEvents(false);
        this._treeModel.reload();
        this.listenToTreeEvents(true);
    }

    void listenToTreeEvents(boolean bl) {
        if (bl) {
            this._tree.removeFocusListener(this);
            this._tree.removeTreeWillExpandListener(this);
            this._tree.removeTreeExpansionListener(this);
            this._tree.removeTreeSelectionListener(this);
            this._tree.addFocusListener(this);
            this._tree.addTreeWillExpandListener(this);
            this._tree.addTreeExpansionListener(this);
            this._tree.addTreeSelectionListener(this);
        } else {
            this._tree.removeFocusListener(this);
            this._tree.removeTreeWillExpandListener(this);
            this._tree.removeTreeExpansionListener(this);
            this._tree.removeTreeSelectionListener(this);
        }
    }

    void addTreeItem(TreeItem treeItem, SCContainer sCContainer) {
        if (treeItem != this._rootItem && !treeItem.hasBeenOpened()) {
            return;
        }
        this.listenToTreeEvents(false);
        if (treeItem == this._rootItem) {
            treeItem.setOpened(true);
        }
        TreeItem treeItem2 = new TreeItem(sCContainer, treeItem);
        this._treeModel.insertNodeInto(treeItem2, treeItem, treeItem.getChildCount());
        ContainerListener containerListener = new ContainerListener(this._viewerManager, sCContainer, treeItem2);
        treeItem2.setContainerListener(containerListener);
        this._viewerManager.getContainerListeners().addElement(containerListener);
        this.listenToTreeEvents(true);
        if ((sCContainer.getAttributes() & 4) != 0 && (sCContainer.getAttributes() & 1) != 0) {
            this.openTreeItem(treeItem2, true, false);
        }
    }

    boolean deleteTreeItem(TreeItem treeItem) {
        boolean bl = false;
        int n = 0;
        if (treeItem == this.getPendingTreeItemSelection()) {
            this.setPendingTreeItemSelection(null);
        }
        if (!this._isPerformingNewSelection) {
            if (treeItem == this._selectedItem) {
                bl = true;
                n = ((TreeItem)treeItem.getParent()).getIndex(treeItem) + 1;
                this._selectedItem = ((TreeItem)treeItem.getParent()).getChildCount() > n ? (TreeItem)((TreeItem)treeItem.getParent()).getChildAt(n) : (TreeItem)treeItem.getParent();
            } else if (this.isDescendant(this._selectedItem, treeItem)) {
                bl = true;
                this._selectedItem = (TreeItem)treeItem.getParent();
            }
            if (bl) {
                this.listenToTreeEvents(false);
                this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
                this.listenToTreeEvents(true);
                this.setViewerManagerSelectedTreeItem(this._selectedItem);
            }
        }
        this.removeTreeItem(treeItem);
        return this._isPerformingNewSelection;
    }

    private void removeTreeItem(TreeItem treeItem) {
        this.releaseTreeItemResources(treeItem);
        TreeItem treeItem2 = (TreeItem)treeItem.getParent();
        if (treeItem2 != null) {
            this.listenToTreeEvents(false);
            this._treeModel.removeNodeFromParent(treeItem);
            this.listenToTreeEvents(true);
            if (!(this._isPerformingNewSelection || this._selectedItem != treeItem && treeItem2 != this._rootItem)) {
                this._selectedItem = this._rootItem;
                this.listenToTreeEvents(false);
                this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
                this.listenToTreeEvents(true);
                this.setViewerManagerSelectedTreeItem(this._selectedItem);
            }
        }
    }

    boolean refreshTreeItem(TreeItem treeItem) {
        TreeItem treeItem2 = null;
        String[] stringArray = null;
        if (this._selectedItem == null) {
            this._selectedItem = treeItem;
        }
        if (this._selectedItem == treeItem || treeItem == this._rootItem) {
            this._viewerManager.getContentPane().closeDetailsContainers();
        }
        if (treeItem.isExpanded()) {
            boolean bl = this.isDescendant(this._selectedItem, treeItem);
            if (bl) {
                stringArray = this.getNodeNamePathBetweenNodes(treeItem, this._selectedItem);
            }
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            this.saveContainerStates("", treeItem, hashtable);
            this.closeTreeItem(treeItem);
            this.restoreContainerStates("", treeItem, hashtable);
            if (this._tree.getSelectionModel().isSelectionEmpty() || bl) {
                if (stringArray != null) {
                    for (int i = 1; i < stringArray.length && (treeItem2 = this.getChildTreeItemWithName(treeItem, stringArray[i])) != null; ++i) {
                        treeItem = treeItem2;
                    }
                }
                this._selectedItem = treeItem;
                this.listenToTreeEvents(false);
                this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
                this.listenToTreeEvents(true);
                this.setViewerManagerSelectedTreeItem(this._selectedItem);
            } else if (this._tree.getSelectionModel().isSelectionEmpty() && !bl) {
                this.listenToTreeEvents(false);
                this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
                this.listenToTreeEvents(true);
                this.setViewerManagerSelectedTreeItem(this._selectedItem);
            }
        } else {
            SCContainer sCContainer;
            if (treeItem.hasBeenOpened()) {
                this.closeTreeItem(treeItem);
            } else {
                sCContainer = treeItem.getContainer();
                NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 200, 0);
                sCContainer.close();
            }
            sCContainer = treeItem.getContainer();
            if (treeItem == this._selectedItem) {
                this._viewerManager.getContentPane().clearDetailsPanels();
                if (NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 100, 0)) {
                    sCContainer.open(0);
                }
            }
        }
        return this._isPerformingNewSelection;
    }

    void expandTreeItem(TreeItem treeItem) {
        if (treeItem.isExpanded()) {
            return;
        }
        SCContainer sCContainer = treeItem.getContainer();
        if (NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 201, 0)) {
            if (!treeItem.hasBeenOpened()) {
                this.openTreeItem(treeItem, true, false);
            } else {
                this.listenToTreeEvents(false);
                this._tree.expandPath(new TreePath(treeItem.getPath()));
                this.listenToTreeEvents(true);
            }
        }
    }

    void collapseTreeItem(TreeItem treeItem) {
        if (!treeItem.isExpanded()) {
            return;
        }
        SCContainer sCContainer = treeItem.getContainer();
        if (NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 202, 0)) {
            if (this.isDescendant(this._selectedItem, treeItem)) {
                this.listenToTreeEvents(false);
                this._tree.setSelectionPath(new TreePath(treeItem.getPath()));
                this._selectedItem = treeItem;
                this.setViewerManagerSelectedTreeItem(this._selectedItem);
                this.listenToTreeEvents(true);
            }
            if ((sCContainer.getAttributes() & 2) != 0 && (this.isAncestor(this._selectedItem, treeItem) || this.isAtSameLevel(treeItem, this._selectedItem))) {
                this.closeTreeItem(treeItem);
            } else {
                this.listenToTreeEvents(false);
                this._tree.collapsePath(new TreePath(treeItem.getPath()));
                this.listenToTreeEvents(true);
            }
        }
    }

    void redisplayTreeItem(TreeItem treeItem) {
        this._treeModel.nodeChanged(treeItem);
    }

    private void setViewerManagerSelectedTreeItem(TreeItem treeItem) {
        this._viewerManager.startWait();
        this._viewerManager.setSelectedTreeItem(treeItem);
        this._viewerManager.endWait();
        this._viewerManager.getMainPanel().requestPaneFocus();
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean selectTreeItem(TreeItem treeItem) {
        boolean bl = true;
        this._isPerformingNewSelection = true;
        if (treeItem == this._selectedItem && this._selectedItem != null) {
            this._tree.scrollPathToVisible(new TreePath(this._selectedItem.getPath()));
            this.listenToTreeEvents(false);
            this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
            this.listenToTreeEvents(true);
            this._isPerformingNewSelection = false;
            return true;
        }
        if (this._selectedItem != null) {
            bl = NewInterfaceVersionHelper.doOnNotify(this._selectedItem.getContainer(), this._viewerFrame, 204, 0);
        }
        if (treeItem == null) {
            this._selectedItem = null;
            this.setViewerManagerSelectedTreeItem(this._selectedItem);
        } else {
            if (!bl) {
                this.listenToTreeEvents(false);
                this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
                this._tree.scrollPathToVisible(new TreePath(this._selectedItem.getPath()));
                this.listenToTreeEvents(true);
                this._isPerformingNewSelection = false;
                return false;
            }
            if (!this._viewerManager.getContentPane().notifyCurrentPageOfOnKillActive()) {
                this._isPerformingNewSelection = false;
                return false;
            }
            SCContainer sCContainer = treeItem.getContainer();
            if (NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 203, 0) && NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 100, 0)) {
                sCContainer.open(0);
                this.setViewerManagerSelectedTreeItem(treeItem);
                TreeItem treeItem2 = this._selectedItem;
                this._selectedItem = treeItem;
                if (treeItem2 != null) {
                    this.redisplayTreeItem(treeItem2);
                }
                this.listenToTreeEvents(false);
                this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
                this.listenToTreeEvents(true);
                this._tree.scrollPathToVisible(new TreePath(this._selectedItem.getPath()));
            } else {
                this.setViewerManagerSelectedTreeItem(this._selectedItem);
                this.listenToTreeEvents(false);
                this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
                this._tree.scrollPathToVisible(new TreePath(this._selectedItem.getPath()));
                this.listenToTreeEvents(true);
                this._isPerformingNewSelection = false;
                return false;
            }
        }
        this._isPerformingNewSelection = false;
        return true;
    }

    private boolean openTreeItem(TreeItem treeItem, boolean bl, boolean bl2) {
        SCContainer sCContainer = treeItem.getContainer();
        if (!NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 100, 0)) {
            return false;
        }
        this._viewerManager.startWait();
        this.listenToTreeEvents(false);
        sCContainer.open(0);
        treeItem.setOpened(true);
        Enumeration enumeration = sCContainer.getItems();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SCContainer)) continue;
            TreeItem treeItem2 = new TreeItem((SCContainer)e, treeItem);
            this._treeModel.insertNodeInto(treeItem2, treeItem, treeItem.getChildCount());
            if (treeItem == this._rootItem) {
                this._tree.expandPath(new TreePath(this._rootItem.getPath()));
            }
            ContainerListener containerListener = new ContainerListener(this._viewerManager, (SCContainer)e, treeItem2);
            treeItem2.setContainerListener(containerListener);
            this._viewerManager.getContainerListeners().addElement(containerListener);
            if (bl2 || (((SCContainer)e).getAttributes() & 4) == 0 || (((SCContainer)e).getAttributes() & 1) == 0) continue;
            this.openTreeItem(treeItem2, true, false);
            this.listenToTreeEvents(false);
        }
        if (bl) {
            this._tree.expandPath(new TreePath(treeItem.getPath()));
        }
        this.listenToTreeEvents(true);
        this._viewerManager.endWait();
        return true;
    }

    private void closeTreeItem(TreeItem treeItem) {
        for (int i = treeItem.getChildCount() - 1; i > -1; --i) {
            this.removeTreeItem((TreeItem)treeItem.getChildAt(i));
        }
        treeItem.setOpened(false);
        SCContainer sCContainer = treeItem.getContainer();
        NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 200, 0);
        sCContainer.close();
        this._treeModel.nodeStructureChanged(treeItem);
    }

    private void saveContainerStates(String string, TreeItem treeItem, Hashtable<String, Integer> hashtable) {
        SCContainer sCContainer = treeItem.getContainer();
        int n = 0;
        TreePath treePath = new TreePath(treeItem.getPath());
        n = treeItem.isExpanded() ? 1 : 0;
        int n2 = treeItem == this._selectedItem ? 2 : 0;
        String string2 = string + treeItem.toString();
        hashtable.put(string2, new Integer(n |= n2));
        if (this._tree.isExpanded(treePath)) {
            Enumeration enumeration = treeItem.children();
            while (enumeration.hasMoreElements()) {
                TreeItem treeItem2 = (TreeItem)enumeration.nextElement();
                this.saveContainerStates(string2, treeItem2, hashtable);
            }
        }
    }

    private void restoreContainerStates(String string, TreeItem treeItem, Hashtable hashtable) {
        SCContainer sCContainer = treeItem.getContainer();
        String string2 = string + treeItem.toString();
        Integer n = (Integer)hashtable.get(string2);
        if (n == null) {
            return;
        }
        if ((n & 2) != 0) {
            this.setPendingTreeItemSelection(treeItem);
        }
        if ((n & 1) != 0) {
            if (this.openTreeItem(treeItem, false, true)) {
                Enumeration enumeration = treeItem.children();
                while (enumeration.hasMoreElements()) {
                    TreeItem treeItem2 = (TreeItem)enumeration.nextElement();
                    this.restoreContainerStates(string2, treeItem2, hashtable);
                }
            }
            this.listenToTreeEvents(false);
            this._tree.expandPath(new TreePath(treeItem.getPath()));
            this.listenToTreeEvents(true);
        }
        if (this.getPendingTreeItemSelection() == treeItem && NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 203, 0) && NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 100, 0)) {
            sCContainer.open(0);
            this._selectedItem = treeItem;
            this.listenToTreeEvents(false);
            this._tree.setSelectionPath(new TreePath(this._selectedItem.getPath()));
            this.listenToTreeEvents(true);
            this.setViewerManagerSelectedTreeItem(this._selectedItem);
        }
        this.setPendingTreeItemSelection(null);
    }

    private void releaseTreeItemResources(TreeItem treeItem) {
        Object object;
        Enumeration enumeration = treeItem.children();
        while (enumeration.hasMoreElements()) {
            object = (TreeItem)enumeration.nextElement();
            this.releaseTreeItemResources((TreeItem)object);
        }
        object = treeItem.getContainer();
        ContainerListener containerListener = treeItem.getContainerListener();
        containerListener.releaseResources();
        this._viewerManager.getContainerListeners().removeElement(containerListener);
        NewInterfaceVersionHelper.doOnNotify((SCContainer)object, this._viewerFrame, 200, 0);
        object.close();
    }

    void releaseResources() {
        if (this._treeTimer != null) {
            this._treeTimer.stop();
            this._treeTimer = null;
        }
        this._session = null;
        this._tree.removeMouseListener(this._mouseListener);
        this._mouseListener = null;
        this.listenToTreeEvents(false);
        ToolTipManager.sharedInstance().unregisterComponent(this._tree);
        this._tree.releaseResources();
        this._tree = null;
        DialogUtils.removeComponents((Container)this._scrollPane);
        this._scrollPane = null;
        this._viewerFrame = null;
        this._treeModel = null;
        this._rootItem = null;
        this._viewerManager = null;
        this._selectedItem = null;
    }

    class SCJTree
    extends JTree
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener,
    ActionListener {
        private DragSource _dSource;
        private DropTarget _dTarget;
        private int _defaultActions;
        private Timer _timer;
        private StringBuffer _typedSoFar;
        private boolean _sameKeyChar;
        private int _ticksWithoutActivity;
        private boolean _keyNavigation;
        private TreeSelectionEvent _savedSelectionEvent;
        private TreePath _oldSelectedPath;
        private boolean _forceFireTreeSelectionEvent;

        SCJTree(TreeModel treeModel) {
            super(treeModel);
            this._defaultActions = 0x40000003;
            this._timer = null;
            this._typedSoFar = null;
            this._sameKeyChar = true;
            this._ticksWithoutActivity = 0;
            this._keyNavigation = false;
            this._savedSelectionEvent = null;
            this._oldSelectedPath = null;
            this._forceFireTreeSelectionEvent = false;
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScopePane.this._viewerManager.menuItemSelected(101);
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScopePane.this._viewerManager.menuItemSelected(102);
                }
            };
            AbstractAction abstractAction3 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScopePane.this._viewerManager.menuItemSelected(103);
                }
            };
            this.getActionMap().put("cut", abstractAction);
            this.getActionMap().put("copy", abstractAction2);
            this.getActionMap().put("paste", abstractAction3);
            this.getActionMap().remove("selectAll");
            this.getActionMap().getParent().remove("selectAll");
            this._dSource = DragSource.getDefaultDragSource();
            this._dSource.createDefaultDragGestureRecognizer(this, this._defaultActions, this);
            this._dTarget = new DropTarget(this, this._defaultActions, this, true);
            this._typedSoFar = new StringBuffer();
            this._timer = new Timer(500, this);
            this._timer.start();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SCJTree.this._savedSelectionEvent != null) {
                        SCJTree.super.fireValueChanged(SCJTree.this._savedSelectionEvent);
                        SCJTree.this._savedSelectionEvent = null;
                    }
                }
            });
        }

        @Override
        public Insets getInsets() {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!this._forceFireTreeSelectionEvent) {
                this._oldSelectedPath = treeSelectionEvent.getOldLeadSelectionPath();
                this._savedSelectionEvent = treeSelectionEvent;
            } else {
                this._forceFireTreeSelectionEvent = false;
                super.fireValueChanged(treeSelectionEvent);
            }
        }

        boolean keyNavigation() {
            return this._keyNavigation;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            TreeItem treeItem;
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && (treeItem = (TreeItem)treePath.getLastPathComponent()) != null) {
                return treeItem.getContainer().getDisplayName(0);
            }
            return null;
        }

        private Transferable buildTransferableItem() {
            TreeItem treeItem;
            TransferableItems transferableItems = null;
            TreePath treePath = this.getSelectionPath();
            if (treePath != null && (treeItem = (TreeItem)treePath.getLastPathComponent()) != null) {
                transferableItems = new TransferableItems();
                transferableItems.addTransferable(new TransferableSCItem(treeItem.getContainer()));
            }
            return transferableItems;
        }

        private void determineDragAction(DropTargetDragEvent dropTargetDragEvent) {
            TreeItem treeItem;
            TreePath treePath;
            Vector<Transferable> vector = new Vector<Transferable>(1);
            int n = this.getRowForLocation(dropTargetDragEvent.getLocation().x, dropTargetDragEvent.getLocation().y);
            if (n > -1 && (treePath = this.getPathForRow(n)) != null && (treeItem = (TreeItem)treePath.getLastPathComponent()) != null) {
                SCContainer sCContainer = treeItem.getContainer();
                int n2 = dropTargetDragEvent.getDropAction();
                if (sCContainer != null) {
                    int n3;
                    Object[] objectArray = dropTargetDragEvent.getCurrentDataFlavors();
                    Vector<Object> vector2 = new Vector<Object>(objectArray.length);
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i].equals(TransferableItems.TransferableItemsFlavor)) continue;
                        vector2.addElement(objectArray[i]);
                    }
                    objectArray = new DataFlavor[vector2.size()];
                    vector2.copyInto(objectArray);
                    if (sCContainer instanceof SCItem5) {
                        if (dropTargetDragEvent.getTransferable() instanceof TransferableItems) {
                            n3 = ((SCItem5)((Object)sCContainer)).queryDropItems(dropTargetDragEvent.getDropAction(), (DataFlavor[])objectArray, ((TransferableItems)dropTargetDragEvent.getTransferable()).elements());
                        } else {
                            vector.add(dropTargetDragEvent.getTransferable());
                            n3 = ((SCItem5)((Object)sCContainer)).queryDropItems(dropTargetDragEvent.getDropAction(), (DataFlavor[])objectArray, vector.elements());
                        }
                    } else {
                        n3 = sCContainer.queryDropItems(dropTargetDragEvent.getDropAction(), (DataFlavor[])objectArray);
                    }
                    if (n3 == 1) {
                        dropTargetDragEvent.acceptDrag(1);
                        return;
                    }
                    if (n3 == 0x40000000) {
                        dropTargetDragEvent.acceptDrag(0x40000000);
                        return;
                    }
                    if (n3 == 2) {
                        dropTargetDragEvent.acceptDrag(2);
                        return;
                    }
                }
            }
            dropTargetDragEvent.rejectDrag();
        }

        void releaseResources() {
            this._dSource = null;
            this._dTarget = null;
            if (this._timer.isRunning()) {
                this._timer.stop();
            }
            this._timer.removeActionListener(this);
            this._timer = null;
            this._typedSoFar = null;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
            if (inputEvent instanceof MouseEvent && ((MouseEvent)inputEvent).isPopupTrigger()) {
                return;
            }
            int n = this.getRowForLocation(dragGestureEvent.getDragOrigin().x, dragGestureEvent.getDragOrigin().y);
            if (n >= 0) {
                Transferable transferable;
                if (!this.isRowSelected(n)) {
                    this.setSelectionRow(n);
                }
                if ((transferable = this.buildTransferableItem()) != null) {
                    try {
                        dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, transferable, this);
                    }
                    catch (InvalidDnDOperationException invalidDnDOperationException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            int n = dragSourceDragEvent.getTargetActions();
            dragSourceContext.setCursor(null);
            if (n == 0x40000000) {
                dragSourceContext.setCursor(DragSource.DefaultLinkDrop);
            } else if (n == 1) {
                dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
            } else if (n == 2) {
                dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
            } else {
                dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            int n = dragSourceDragEvent.getTargetActions();
            dragSourceContext.setCursor(null);
            if (n == 0x40000000) {
                dragSourceContext.setCursor(DragSource.DefaultLinkDrop);
            } else if (n == 1) {
                dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
            } else if (n == 2) {
                dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
            } else {
                dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
            dragSourceContext.setCursor(null);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (this._oldSelectedPath != null) {
                this.setSelectionPath(this._oldSelectedPath);
            }
            this._oldSelectedPath = null;
            this._savedSelectionEvent = null;
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.determineDragAction(dropTargetDragEvent);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.determineDragAction(dropTargetDragEvent);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this.determineDragAction(dropTargetDragEvent);
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            SCContainer sCContainer;
            TreeItem treeItem;
            TreePath treePath;
            int n = this.getRowForLocation(dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y);
            if (n > -1 && (treePath = this.getPathForRow(n)) != null && (treeItem = (TreeItem)treePath.getLastPathComponent()) != null && (sCContainer = treeItem.getContainer()) != null) {
                try {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    Vector vector = null;
                    try {
                        vector = (Vector)transferable.getTransferData(TransferableItems.TransferableItemsFlavor);
                        switch (dropTargetDropEvent.getDropAction()) {
                            case 1: {
                                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                dropTargetDropEvent.dropComplete(true);
                                sCContainer.onCommand(ScopePane.this._viewerFrame, 103, vector.elements(), 0);
                                break;
                            }
                            case 2: {
                                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                dropTargetDropEvent.dropComplete(true);
                                sCContainer.onCommand(ScopePane.this._viewerFrame, 104, vector.elements(), 0);
                                break;
                            }
                            case 0x40000000: {
                                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                dropTargetDropEvent.dropComplete(true);
                                sCContainer.onCommand(ScopePane.this._viewerFrame, 105, vector.elements(), 0);
                                break;
                            }
                            default: {
                                dropTargetDropEvent.rejectDrop();
                                dropTargetDropEvent.dropComplete(false);
                                return;
                            }
                        }
                        return;
                    }
                    catch (Exception exception) {
                        Vector<Transferable> vector2 = new Vector<Transferable>(1);
                        vector2.addElement(transferable);
                        switch (dropTargetDropEvent.getDropAction()) {
                            case 1: {
                                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                dropTargetDropEvent.dropComplete(true);
                                sCContainer.onCommand(ScopePane.this._viewerFrame, 103, vector2.elements(), 0);
                                break;
                            }
                            case 2: {
                                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                dropTargetDropEvent.dropComplete(true);
                                sCContainer.onCommand(ScopePane.this._viewerFrame, 104, vector2.elements(), 0);
                                break;
                            }
                            case 0x40000000: {
                                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                                dropTargetDropEvent.dropComplete(true);
                                sCContainer.onCommand(ScopePane.this._viewerFrame, 105, vector2.elements(), 0);
                                break;
                            }
                            default: {
                                dropTargetDropEvent.rejectDrop();
                                dropTargetDropEvent.dropComplete(false);
                                return;
                            }
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34) {
                this._keyNavigation = true;
            }
            this._forceFireTreeSelectionEvent = true;
            super.processKeyEvent(keyEvent);
            this._forceFireTreeSelectionEvent = false;
            this._keyNavigation = false;
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if ((keyEvent.getModifiers() == 0 || (keyEvent.getModifiers() & 1) != 0) && n == 0 && keyEvent.getKeyCode() == 0 && keyEvent.getKeyChar() != '\uffff') {
                this._timer.stop();
                char c = keyEvent.getKeyChar();
                this._ticksWithoutActivity = 0;
                if (this._typedSoFar.length() > 0 && this._typedSoFar.charAt(this._typedSoFar.length() - 1) != c) {
                    this._sameKeyChar = false;
                }
                this._typedSoFar.append(c);
                int n2 = 0;
                TreePath treePath = this.getSelectionPath();
                if (treePath != null) {
                    n2 = this.getRowForPath(treePath);
                }
                boolean bl2 = false;
                bl2 = this._sameKeyChar ? this.selectMatchingRow(n2, this.getRowCount(), String.valueOf(c)) : this.selectMatchingRow(n2, this.getRowCount(), this._typedSoFar.toString());
                if (!bl2) {
                    if (this._sameKeyChar) {
                        this.selectMatchingRow(0, n2, String.valueOf(c));
                    } else {
                        this.selectMatchingRow(0, n2, this._typedSoFar.toString());
                    }
                }
                this._timer.restart();
            }
            this._forceFireTreeSelectionEvent = true;
            boolean bl3 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            this._forceFireTreeSelectionEvent = false;
            return bl3;
        }

        private boolean selectMatchingRow(int n, int n2, String string) {
            for (int i = n; i < n2; ++i) {
                TreeItem treeItem;
                TreePath treePath = this.getPathForRow(i);
                if (treePath == null || (treeItem = (TreeItem)treePath.getLastPathComponent()).toString().toLowerCase().indexOf(string.toLowerCase()) != 0) continue;
                this.setSelectionInterval(i, i);
                this.scrollRowToVisible(i);
                return true;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._timer && ++this._ticksWithoutActivity == 2) {
                this._typedSoFar.setLength(0);
                this._sameKeyChar = true;
            }
        }
    }

    class TreeViewRenderer
    extends DefaultTreeCellRenderer {
        private Font _defaultFont = null;

        TreeViewRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object == null) {
                return this;
            }
            TreeItem treeItem = (TreeItem)object;
            String string = treeItem.toString();
            if (string != null && !string.isEmpty()) {
                if (this._defaultFont == null) {
                    this._defaultFont = this.getFont();
                }
                if (this._defaultFont != null) {
                    FontHelper.setFontForString((Component)this, (Font)this._defaultFont, (String)string);
                }
            }
            this.setText(string);
            treeItem.setExpanded(bl2);
            treeItem.setSelected(bl);
            if (ScopePane.this._selectedItem == treeItem) {
                this.setIcon(treeItem.getOpenedImage());
            } else {
                this.setIcon(treeItem.getClosedImage());
            }
            if (bl && bl4) {
                this.setBackgroundSelectionColor(UIManager.getColor("TextField.selectionBackground"));
                this.setForeground(UIManager.getColor("TextField.selectionForeground"));
            } else if (bl && !bl4) {
                this.setBackgroundSelectionColor(SystemColor.control);
                this.setForeground(SystemColor.controlText);
            } else {
                this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.background"));
                this.setForeground(UIManager.getColor("Label.foreground"));
            }
            return this;
        }
    }
}

