/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDetailsPanel;
import com.sybase.central.SCDetailsPanel4;
import com.sybase.central.SCItem;
import com.sybase.central.SCItem5;
import com.sybase.central.SCSearch;
import com.sybase.central.SCSearchHit;
import com.sybase.central.SCSearchOption;
import com.sybase.central.SCViewerDetailsPanel;
import com.sybase.central.SCViewerDetailsPanel2;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.NewInterfaceVersionHelper;
import com.sybase.central.viewer.RootContainer;
import com.sybase.central.viewer.SCDropDownTreeItemRenderer;
import com.sybase.central.viewer.SCIconTextUserData;
import com.sybase.central.viewer.SCMultiList;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.Step;
import com.sybase.central.viewer.TreeItem;
import com.sybase.central.viewer.Utilities;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.BarberPole;
import com.sybase.util.DialogUtils;
import com.sybase.util.MRUComboBox;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class SearchPane
implements ScjResourceConstants,
IConstants,
ActionListener,
DocumentListener,
MouseListener,
ItemListener {
    private JFrame _viewerFrame = null;
    private ScjSession _session = null;
    private ViewerManager _viewerManager = null;
    private JPanel _searchPanel = null;
    private JPanel _searchOptionsPanel = null;
    private SybLabel _nameLabel = null;
    private MRUComboBox _nameMRUComboBox = null;
    private SybLabel _containerComboLabel = null;
    private SybComboBox _treeItemComboBox = null;
    private SybCheckBox _caseCheckBox = null;
    private SybCheckBox _wordCheckBox = null;
    private SybButton _button = null;
    private SCMultiList _resultsTable = null;
    private Component _resultsPane = null;
    private BarberPole _bPole = null;
    private boolean _searching = false;
    private Timer _threadTimer = null;
    private Vector<Runnable> _runnables = null;
    private static Vector<SCSearch> _activeSCSearchObjects = new Vector();
    private ArrayList<SybCheckBox> _optionCheckBoxes = new ArrayList();
    private ArrayList<Integer> _optionIds = new ArrayList();
    static final Insets NAME_LABEL_INSETS = new Insets(5, 5, 5, 5);
    static final Insets SEARCH_BUTTON_INSETS = new Insets(5, 5, 0, 5);
    static final Insets SEARCH_NAME_INSETS = new Insets(0, 5, 5, 5);
    static final Insets CHECKBOX_INSETS = new Insets(0, 5, 0, 5);
    static final Insets XP_SEARCH_PANEL_INSETS = new Insets(10, 10, 10, 10);
    static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    private static final String ENTER_KEY_RELEASE = "ENTER_KEY_RELEASE";
    private static final int PLUGIN_OPTIONS_INDEX = 7;

    SearchPane(JFrame jFrame, ScjSession scjSession) {
        this._viewerFrame = jFrame;
        this._session = scjSession;
        this.init();
    }

    private void init() {
        boolean bl = false;
        ArrayList<JComponent> arrayList = null;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._searchPanel = UIUtils.createExplorerBar();
        this._searchOptionsPanel = UIUtils.createExplorerBarGroup();
        this._nameLabel = new SybLabel(ScjSession.getString("STR_SEARCH_LABEL"));
        this._nameMRUComboBox = new MRUComboBox(this._session.getUserPrefRepositoryInfo().getPreviousSearches());
        this._nameMRUComboBox.setPopupExpandable(true);
        this._nameMRUComboBox.setPrototypeDisplayValue((Object)"XXXXX");
        this._containerComboLabel = new SybLabel(ScjSession.getString("STR_SEARCH_CTR_LABEL"));
        this._treeItemComboBox = new SybComboBox(){

            public Dimension getMinimumSize() {
                return new Dimension(0, super.getMinimumSize().height);
            }
        };
        this._treeItemComboBox.setPopupExpandable(true);
        this._button = new SybButton(ScjSession.getString("STR_SEARCH_BUTTON"));
        this._caseCheckBox = new SybCheckBox(ScjSession.getString("STR_CASE_CHECKBOX"));
        this._caseCheckBox.setMinimumSize(new Dimension(1, this._caseCheckBox.getPreferredSize().height));
        this._caseCheckBox.setSelected(this._session.getUserPrefRepositoryInfo().isSearchMatchCase());
        this._wordCheckBox = new SybCheckBox(ScjSession.getString("STR_WORD_CHECKBOX"));
        this._wordCheckBox.setMinimumSize(new Dimension(1, this._wordCheckBox.getPreferredSize().height));
        this._wordCheckBox.setSelected(this._session.getUserPrefRepositoryInfo().isSearchWholeWord());
        Object[] objectArray = new String[3];
        objectArray[0] = ScjSession.getString("STR_RESULTS_NAME");
        objectArray[1] = ScjSession.getString("STR_RESULTS_TYPE");
        objectArray[2] = ScjSession.getString("STR_RESULTS_CONTEXT");
        this._resultsTable = new SCMultiList(objectArray);
        this._resultsTable.setSelectionMode(0);
        this._resultsTable.setAutoResizeMode(0);
        this._resultsTable.setColumnWidths(this._session.getUserPrefRepositoryInfo().getSearchColumnWidths());
        this._resultsTable.setColumnHasIconTextData(0, true);
        this._button.setEnabled(false);
        this._searchPanel.setLayout(gridBagLayout);
        this._searchOptionsPanel.setLayout(gridBagLayout2);
        this._nameLabel.setLabelFor((Component)this._nameMRUComboBox);
        this._containerComboLabel.setLabelFor((Component)this._treeItemComboBox);
        this._treeItemComboBox.setAlignmentY(0.5f);
        this._treeItemComboBox.setAlignmentX(0.0f);
        this._treeItemComboBox.setRenderer((ListCellRenderer)new SCDropDownTreeItemRenderer());
        ((JTextField)this._nameMRUComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        ((JTextField)this._nameMRUComboBox.getEditor().getEditorComponent()).addActionListener(this);
        this._treeItemComboBox.addActionListener((ActionListener)this);
        this._button.addActionListener((ActionListener)this);
        this._resultsTable.addMouseListener(this);
        this._resultsTable.registerKeyboardAction(this, ENTER_KEY_RELEASE, KeyStroke.getKeyStroke(10, 0), 1);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = NAME_LABEL_INSETS;
        this._searchOptionsPanel.add((Component)this._nameLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = SEARCH_NAME_INSETS;
        this._searchOptionsPanel.add((Component)this._nameMRUComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = NAME_LABEL_INSETS;
        this._searchOptionsPanel.add((Component)this._containerComboLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = SEARCH_NAME_INSETS;
        gridBagConstraints.ipady = 2;
        this._searchOptionsPanel.add((Component)this._treeItemComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = CHECKBOX_INSETS;
        gridBagConstraints.ipady = 0;
        this._searchOptionsPanel.add((Component)this._caseCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this._searchOptionsPanel.add((Component)this._wordCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = SEARCH_BUTTON_INSETS;
        gridBagConstraints.weightx = 0.0;
        this._searchOptionsPanel.add((Component)this._button, gridBagConstraints);
        this._bPole = new BarberPole();
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = NAME_LABEL_INSETS;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this._searchOptionsPanel.add((Component)this._bPole, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = UIUtils.isXPLookAndFeelActive() ? XP_SEARCH_PANEL_INSETS : NO_INSETS;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this._searchPanel.add((Component)this._searchOptionsPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = NO_INSETS;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        arrayList = Utilities.addHeaderToComponent(this._resultsTable.getScrollPane(), ScjSession.getString("STR_RESULTS"));
        this._resultsPane = arrayList.get(0);
        this._searchPanel.add(this._resultsPane, gridBagConstraints);
        this._threadTimer = new Timer(11, this);
        this._threadTimer.setRepeats(false);
        this._runnables = new Vector();
        this._caseCheckBox.setOpaque(false);
        this._wordCheckBox.setOpaque(false);
        this._bPole.setOpaque(false);
    }

    void updateSearchInDropDown(TreeItem treeItem) {
        this._treeItemComboBox.removeActionListener((ActionListener)this);
        this._treeItemComboBox.removeAllItems();
        int n = 0;
        TreeItem[] treeItemArray = treeItem.getPath();
        for (n = 0; n < treeItemArray.length; ++n) {
            this._treeItemComboBox.addItem((Object)treeItemArray[n]);
        }
        if (n > 0) {
            this._treeItemComboBox.setSelectedIndex(n - 1);
        }
        this._treeItemComboBox.addActionListener((ActionListener)this);
        this.searchTreeItemWasUpdated();
    }

    private void searchTreeItemWasUpdated() {
        if (this._viewerManager != null) {
            SCContainer sCContainer = this.getSelectedSearchSCContainer();
            if (sCContainer instanceof SCSearch) {
                this.updateOptions(((SCSearch)((Object)sCContainer)).getSCSearchOptions());
            } else {
                this.updateOptions(null);
            }
        }
    }

    private void updateOptions(SCSearchOption[] sCSearchOptionArray) {
        int n;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        SybCheckBox sybCheckBox = null;
        int n2 = 7;
        for (n = 0; n < this._optionCheckBoxes.size(); ++n) {
            this._optionCheckBoxes.get(n).removeItemListener((ItemListener)this);
            this._searchOptionsPanel.remove((Component)this._optionCheckBoxes.get(n));
        }
        this._optionCheckBoxes.clear();
        this._optionIds.clear();
        this._searchOptionsPanel.remove((Component)this._button);
        this._searchOptionsPanel.remove((Component)this._bPole);
        if (sCSearchOptionArray != null) {
            for (n = 0; n < sCSearchOptionArray.length; ++n) {
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 7 + n;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = CHECKBOX_INSETS;
                sybCheckBox = new SybCheckBox(sCSearchOptionArray[n].getName());
                sybCheckBox.setOpaque(false);
                sybCheckBox.setMinimumSize(new Dimension(1, sybCheckBox.getPreferredSize().height));
                sybCheckBox.setSelected(sCSearchOptionArray[n].isSelected());
                this._searchOptionsPanel.add((Component)sybCheckBox, gridBagConstraints);
                sybCheckBox.addItemListener((ItemListener)this);
                this._optionCheckBoxes.add(sybCheckBox);
                this._optionIds.add(new Integer(sCSearchOptionArray[n].getOptionId()));
                n2 = gridBagConstraints.gridy + 1;
            }
        }
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = SEARCH_BUTTON_INSETS;
        this._searchOptionsPanel.add((Component)this._button, gridBagConstraints);
        gridBagConstraints.gridy = n2 + 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = NAME_LABEL_INSETS;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this._searchOptionsPanel.add((Component)this._bPole, gridBagConstraints);
        this._searchPanel.validate();
    }

    private SCContainer getSelectedSearchSCContainer() {
        TreeItem treeItem = null;
        SCContainer sCContainer = null;
        treeItem = (TreeItem)this._treeItemComboBox.getSelectedItem();
        sCContainer = treeItem == null ? this._session.getRootContainer() : treeItem.getContainer();
        return sCContainer;
    }

    JComponent getPane() {
        return this._searchPanel;
    }

    void requestFocusInWindow() {
        this._nameMRUComboBox.requestFocusInWindow();
        this._viewerManager.setStatusMenuHint(SybMessageFormat.format((String)ScjSession.getString("STR_RESULTS_FOUND"), (Object[])new Object[]{String.valueOf(this._resultsTable.getRowCount())}));
    }

    void initialize(ViewerManager viewerManager) {
        this._viewerManager = viewerManager;
    }

    void setSearchPreferences() {
        this._session.getUserPrefRepositoryInfo().setSearchColumnWidths(this._resultsTable.getColumnWidths());
        this._session.getUserPrefRepositoryInfo().setSearchMatchCase(this._caseCheckBox.isSelected());
        this._session.getUserPrefRepositoryInfo().setSearchWholeWord(this._wordCheckBox.isSelected());
    }

    private void searchTextUpdate() {
        String string = (String)this._nameMRUComboBox.getEditor().getItem();
        this._button.setEnabled(string.trim().length() != 0);
    }

    private void startSearch() {
        boolean bl = this._caseCheckBox.isSelected();
        boolean bl2 = this._wordCheckBox.isSelected();
        this.clearResults();
        this._viewerManager.setStatusMenuHint(null);
        this._bPole.start();
        this._button.setText(ScjSession.getString("STR_STOP_BUTTON"));
        this.enableSearchOptions(false);
        this._searching = true;
        String string = this._nameMRUComboBox.getStringValue();
        this._nameMRUComboBox.addStringValue(string);
        this._session.getUserPrefRepositoryInfo().setPreviousSearches(this._nameMRUComboBox.getMRUList());
        this.doContainerSearch(this.getSelectedSearchSCContainer(), this.getSelectedSearchSCContainer(), string, bl, bl2, this.getPathToCurrentTreeItemSelection());
    }

    private ArrayList<Step> getPathToCurrentTreeItemSelection() {
        ArrayList<Step> arrayList = null;
        SCContainer sCContainer = null;
        TreeItem treeItem = null;
        arrayList = new ArrayList<Step>();
        sCContainer = this.getSelectedSearchSCContainer();
        if (sCContainer != this._session.getRootContainer()) {
            treeItem = this._viewerManager.getTreeItemForContainer(sCContainer);
            while (treeItem != null && treeItem.getContainer() != this._session.getRootContainer()) {
                if ((treeItem = (TreeItem)treeItem.getParent()) == null || treeItem.getContainer() == this._session.getRootContainer()) continue;
                arrayList.add(0, new Step(treeItem.getContainer(), true));
            }
        }
        return arrayList;
    }

    void searchCompleted(SCSearch sCSearch) {
        _activeSCSearchObjects.remove(sCSearch);
        if (_activeSCSearchObjects.size() == 0 && this._runnables.size() == 0) {
            this.stopSearch(false, false);
        }
    }

    private void doContainerSearch(final SCContainer sCContainer, final SCContainer sCContainer2, final String string, final boolean bl, final boolean bl2, final ArrayList<Step> arrayList) {
        if (sCContainer instanceof SCSearch) {
            _activeSCSearchObjects.add((SCSearch)((Object)sCContainer));
            this._runnables.add(new Runnable(){

                @Override
                public void run() {
                    if (!((SCSearch)((Object)sCContainer)).search(string, SearchPane.this.getSearchOptions(bl, bl2), SearchPane.this.buildContextStringArray(arrayList))) {
                        _activeSCSearchObjects.remove(sCContainer);
                        SearchPane.this.doSybaseCentralSearch(sCContainer, sCContainer2, string, bl, bl2, new ArrayList(arrayList));
                        if (SearchPane.this._runnables.size() == 0) {
                            SearchPane.this.stopSearch(false, false);
                        }
                    }
                }
            });
        } else {
            this._runnables.add(new Runnable(){

                @Override
                public void run() {
                    SearchPane.this.doSybaseCentralSearch(sCContainer, sCContainer2, string, bl, bl2, new ArrayList(arrayList));
                    if (SearchPane.this._runnables.size() == 0) {
                        SearchPane.this.stopSearch(false, false);
                    }
                }
            });
        }
        if (!this._threadTimer.isRunning()) {
            this._threadTimer.start();
        }
    }

    private void doSybaseCentralSearch(SCContainer sCContainer, SCContainer sCContainer2, String string, boolean bl, boolean bl2, ArrayList<Step> arrayList) {
        String string2;
        String string3 = null;
        if (sCContainer != sCContainer2 && (string2 = sCContainer.getDisplayName(0)) != null && this.isAMatch(bl, bl2, string, string2)) {
            this.addItemToResults(sCContainer, arrayList);
        }
        arrayList.add(new Step(sCContainer, false));
        Object[] objectArray = sCContainer instanceof SCContainer2 ? ((SCContainer2)sCContainer).getDetailsPanels(this._viewerFrame) : sCContainer.getDetailsPanels();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                SCDetailsContainer sCDetailsContainer;
                if (objectArray[i] instanceof SCViewerDetailsPanel2) {
                    sCDetailsContainer = ((SCViewerDetailsPanel2)objectArray[i]).getSCDetailsContainer();
                    if (sCDetailsContainer == null) continue;
                    this.doContainerSearch(sCDetailsContainer, sCContainer2, ((SCViewerDetailsPanel2)objectArray[i]).getPanelName(), string, bl, bl2, new ArrayList<Step>(arrayList));
                    continue;
                }
                if (objectArray[i] instanceof SCDetailsPanel4) {
                    sCDetailsContainer = ((SCDetailsPanel4)objectArray[i]).getSCDetailsContainer();
                    if (sCDetailsContainer == null) continue;
                    this.doContainerSearch(sCDetailsContainer, sCContainer2, ((SCDetailsPanel4)objectArray[i]).getPanelName(), string, bl, bl2, new ArrayList<Step>(arrayList));
                    continue;
                }
                if (!(objectArray[i] instanceof SCViewerDetailsPanel) || !((SCViewerDetailsPanel)objectArray[i]).getPanelType().equals("DETAILS_LIST") || objectArray.length <= 1) continue;
                string3 = ((SCViewerDetailsPanel)objectArray[i]).getPanelName();
            }
        }
        if (string3 != null) {
            arrayList.add(new Step(2, string3));
        }
        if (!NewInterfaceVersionHelper.doOnNotify(sCContainer, this._viewerFrame, 100, 0)) {
            return;
        }
        sCContainer.open(0);
        Enumeration enumeration = sCContainer.getItems();
        while (enumeration.hasMoreElements()) {
            SCItem sCItem = (SCItem)enumeration.nextElement();
            if (sCItem instanceof SCContainer) {
                this.doContainerSearch((SCContainer)sCItem, sCContainer2, string, bl, bl2, new ArrayList<Step>(arrayList));
                continue;
            }
            string2 = sCItem.getDisplayName(0);
            if (string2 != null && this.isAMatch(bl, bl2, string, string2)) {
                if (objectArray != null && objectArray.length > 1 && objectArray[0] instanceof SCDetailsPanel && string3 == null && !arrayList.get(arrayList.size() - 1).getName().equals(((SCDetailsPanel)objectArray[0]).getPanelName())) {
                    arrayList.add(new Step(2, ((SCDetailsPanel)objectArray[0]).getPanelName()));
                }
                this.addItemToResults(sCItem, arrayList);
            }
            if (!(sCItem instanceof SCSearch)) continue;
            ((SCSearch)((Object)sCItem)).search(string, this.getSearchOptions(bl, bl2), this.buildContextStringArray(arrayList));
        }
    }

    private void doContainerSearch(final SCDetailsContainer sCDetailsContainer, final SCContainer sCContainer, final String string, final String string2, final boolean bl, final boolean bl2, final ArrayList<Step> arrayList) {
        if (sCDetailsContainer instanceof SCSearch) {
            _activeSCSearchObjects.add((SCSearch)((Object)sCDetailsContainer));
            this._runnables.add(new Runnable(){

                @Override
                public void run() {
                    if (!((SCSearch)((Object)sCDetailsContainer)).search(string2, SearchPane.this.getSearchOptions(bl, bl2), SearchPane.this.buildContextStringArray(arrayList))) {
                        _activeSCSearchObjects.remove(sCDetailsContainer);
                        SearchPane.this.doSybaseCentralSearch(sCDetailsContainer, sCContainer, string, string2, bl, bl2, new ArrayList(arrayList));
                        if (SearchPane.this._runnables.size() == 0) {
                            SearchPane.this.stopSearch(false, false);
                        }
                    }
                }
            });
        } else {
            this._runnables.add(new Runnable(){

                @Override
                public void run() {
                    SearchPane.this.doSybaseCentralSearch(sCDetailsContainer, sCContainer, string, string2, bl, bl2, new ArrayList(arrayList));
                    if (SearchPane.this._runnables.size() == 0) {
                        SearchPane.this.stopSearch(false, false);
                    }
                }
            });
        }
        if (!this._threadTimer.isRunning()) {
            this._threadTimer.start();
        }
    }

    private void doSybaseCentralSearch(SCDetailsContainer sCDetailsContainer, SCContainer sCContainer, String string, String string2, boolean bl, boolean bl2, ArrayList<Step> arrayList) {
        if (!NewInterfaceVersionHelper.doOnNotify(sCDetailsContainer, this._viewerFrame, 100, 0)) {
            return;
        }
        sCDetailsContainer.open(0);
        arrayList.add(new Step(3, string));
        Enumeration enumeration = sCDetailsContainer.getItems();
        while (enumeration.hasMoreElements()) {
            SCItem sCItem = (SCItem)enumeration.nextElement();
            String string3 = sCItem.getDisplayName(0);
            if (string3 != null && this.isAMatch(bl, bl2, string2, string3)) {
                this.addItemToResults(sCItem, arrayList);
            }
            if (!(sCItem instanceof SCSearch)) continue;
            ((SCSearch)((Object)sCItem)).search(string2, this.getSearchOptions(bl, bl2), this.buildContextStringArray(arrayList));
        }
    }

    private boolean isAMatch(boolean bl, boolean bl2, String string, String string2) {
        if (string2 != null) {
            int n;
            if (!bl) {
                string = string.toLowerCase();
                string2 = string2.toLowerCase();
            }
            if ((n = string2.indexOf(string)) != -1) {
                if (bl2) {
                    char c;
                    boolean bl3 = n > 0 ? Character.isWhitespace(c = string2.charAt(n - 1)) || !Character.isLetter(c) : true;
                    if (bl3) {
                        boolean bl4 = (n += string.length()) < string2.length() ? Character.isWhitespace(c = string2.charAt(n)) || !Character.isLetter(c) : true;
                        return bl3 && bl4;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    private int[] getSearchOptions(boolean bl, boolean bl2) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = null;
        if (bl) {
            arrayList.add(new Integer(Integer.MAX_VALUE));
        }
        if (bl2) {
            arrayList.add(new Integer(0x7FFFFFFE));
        }
        for (n = 0; n < this._optionCheckBoxes.size(); ++n) {
            if (!this._optionCheckBoxes.get(n).isSelected()) continue;
            arrayList.add(this._optionIds.get(n));
        }
        nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    private void addItemToResults(SCItem sCItem, ArrayList<Step> arrayList) {
        this.addSCSearchHitToResults(new ResultData(sCItem, arrayList, this));
    }

    void addSCSearchHitToResults(SCSearchHit sCSearchHit) {
        Vector<Object> vector = new Vector<Object>();
        String[] stringArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        SCIconTextUserData sCIconTextUserData = null;
        stringArray = sCSearchHit.getContext();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i + 1 >= stringArray.length) continue;
                stringBuffer.append('/');
            }
        }
        stringBuffer2.append("<html><body style=\"margin:4pt\">");
        stringBuffer2.append("<table border=0 cellspacing=0 cellpadding=0>");
        stringBuffer2.append("<tr><td>");
        stringBuffer2.append(ScjSession.getString("STR_RESULTS_TIP_NAME"));
        stringBuffer2.append("</td><td>");
        stringBuffer2.append("&nbsp;</td><td>");
        stringBuffer2.append(this.escapeHTML(sCSearchHit.getName()));
        stringBuffer2.append("</td></tr>");
        stringBuffer2.append("<tr><td>");
        stringBuffer2.append(ScjSession.getString("STR_RESULTS_TIP_TYPE"));
        stringBuffer2.append("</td><td>");
        stringBuffer2.append("&nbsp;</td><td>");
        stringBuffer2.append(this.escapeHTML(sCSearchHit.getType()));
        stringBuffer2.append("</td></tr>");
        stringBuffer2.append("<tr><td>");
        stringBuffer2.append(ScjSession.getString("STR_RESULTS_TIP_CONTEXT"));
        stringBuffer2.append("</td><td>");
        stringBuffer2.append("&nbsp;</td><td>");
        stringBuffer2.append(this.escapeHTML(stringBuffer.toString()));
        stringBuffer2.append("</td></tr>");
        stringBuffer2.append("</table>");
        stringBuffer2.append("</body></html>");
        sCIconTextUserData = new SCIconTextUserData(sCSearchHit.getIcon(), sCSearchHit.getName(), stringBuffer2.toString(), sCSearchHit);
        sCIconTextUserData.comparable = sCSearchHit.getComparable();
        vector.addElement(sCIconTextUserData);
        vector.addElement(sCSearchHit.getType());
        vector.addElement(stringBuffer.toString());
        this._resultsTable.removeMouseListener(this);
        this._resultsTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        int n = this._resultsTable.getSelectedRow();
        this._resultsTable.addRow(vector);
        if (n >= 0) {
            this._resultsTable.getSelectionModel().setSelectionInterval(n, n);
        }
        this._resultsTable.addMouseListener(this);
        this._resultsTable.registerKeyboardAction(this, ENTER_KEY_RELEASE, KeyStroke.getKeyStroke(10, 0), 1);
        this._viewerManager.setStatusMenuHint(SybMessageFormat.format((String)ScjSession.getString("STR_RESULTS_FOUND"), (Object[])new Object[]{String.valueOf(this._resultsTable.getRowCount())}));
    }

    private String escapeHTML(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 50);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void clearResults() {
        Object[] objectArray = null;
        SCSearchHit sCSearchHit = null;
        for (int i = 0; i < this._resultsTable.getRowCount(); ++i) {
            objectArray = this._resultsTable.getRowAsArray(i);
            sCSearchHit = (SCSearchHit)((SCIconTextUserData)objectArray[0]).getUserData();
            sCSearchHit.releaseResources();
        }
        this._resultsTable.clear();
    }

    private void stopSearch(boolean bl, boolean bl2) {
        Iterator<SCSearch> iterator = null;
        this._threadTimer.stop();
        this._runnables.clear();
        if (bl) {
            iterator = _activeSCSearchObjects.iterator();
            while (iterator.hasNext()) {
                iterator.next().stopSearch();
            }
            _activeSCSearchObjects.clear();
        }
        this._bPole.stop();
        this._searching = false;
        if (!bl2) {
            this._button.setText(ScjSession.getString("STR_SEARCH_BUTTON"));
            if (this._button.isFocusOwner()) {
                this._nameMRUComboBox.getEditor().getEditorComponent().requestFocusInWindow();
            }
            this.enableSearchOptions(true);
            this._viewerManager.setStatusMenuHint(SybMessageFormat.format((String)ScjSession.getString("STR_RESULTS_FOUND"), (Object[])new Object[]{String.valueOf(this._resultsTable.getRowCount())}));
        }
    }

    void stopSearch() {
        Iterator<SCSearch> iterator = null;
        this._threadTimer.stop();
        this._runnables.clear();
        iterator = _activeSCSearchObjects.iterator();
        while (iterator.hasNext()) {
            iterator.next().stopSearch();
        }
        _activeSCSearchObjects.clear();
        this._bPole.stop();
        this._button.setText(ScjSession.getString("STR_SEARCH_BUTTON"));
        if (this._button.isFocusOwner()) {
            this._nameMRUComboBox.getEditor().getEditorComponent().requestFocusInWindow();
        }
        this.enableSearchOptions(true);
        this._searching = false;
    }

    private void enableSearchOptions(boolean bl) {
        this._nameMRUComboBox.setEnabled(bl);
        this._treeItemComboBox.setEnabled(bl);
        this._caseCheckBox.setEnabled(bl);
        this._wordCheckBox.setEnabled(bl);
        for (int i = 0; i < this._optionCheckBoxes.size(); ++i) {
            this._optionCheckBoxes.get(i).setEnabled(bl);
        }
    }

    private void resultsTableSelect(int n) {
        Object[] objectArray = null;
        SCSearchHit sCSearchHit = null;
        if (n >= 0 && !(sCSearchHit = (SCSearchHit)((SCIconTextUserData)(objectArray = this._resultsTable.getRowAsArray(n))[0]).getUserData()).show()) {
            this._viewerManager.getViewerSupport().messageBoxString(this._viewerFrame, ScjSession.getString("ERR_RESULT_NOT_SHOWN"), 0);
        }
    }

    private boolean showResult(ResultData resultData) {
        SCContainer sCContainer = null;
        TreeItem treeItem = null;
        ArrayList<Step> arrayList = null;
        String string = null;
        RootContainer rootContainer = null;
        Step step = null;
        Iterator<Step> iterator = null;
        SCItem sCItem = null;
        String string2 = null;
        sCContainer = this._session.getRootContainer();
        treeItem = this._viewerManager.getTreeItemForContainer(sCContainer);
        arrayList = resultData.path;
        string = resultData.getName();
        if (treeItem == null) {
            return false;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            step = iterator.next();
            if (iterator.hasNext() || step.isSCContainer()) {
                this._viewerManager.expandItem(treeItem);
            }
            if (step.isSCContainer()) {
                rootContainer = sCContainer;
                if (sCContainer instanceof RootContainer && sCContainer.getDisplayName(0).equals(step.getName())) continue;
                if (!NewInterfaceVersionHelper.doOnNotify(rootContainer, this._viewerFrame, 100, 0)) {
                    return false;
                }
                rootContainer.open(0);
                Enumeration enumeration = rootContainer.getItems();
                while (enumeration.hasMoreElements()) {
                    sCItem = (SCItem)enumeration.nextElement();
                    sCContainer = null;
                    if (!(sCItem instanceof SCContainer) || !sCItem.getDisplayName(0).equals(step.getName())) continue;
                    sCContainer = (SCContainer)sCItem;
                    break;
                }
                if (sCContainer == null) {
                    return false;
                }
                treeItem = this._viewerManager.getTreeItemForContainer(sCContainer);
                if (treeItem != null) continue;
                return false;
            }
            if (!step.isSCContainerPanel() && !step.isSCDetailsContainer()) continue;
            string2 = step.getName();
        }
        if (!this._viewerManager.selectTreeItem(sCContainer)) {
            return false;
        }
        if (string2 != null && !this._viewerManager.selectDetailsContainerTab(string2)) {
            return false;
        }
        return this._viewerManager.selectDetailsItemByName(resultData.getName());
    }

    String[] buildContextStringArray(ArrayList<Step> arrayList) {
        Iterator<Step> iterator = null;
        Step step2 = null;
        boolean bl = false;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Step step2 : arrayList) {
            if (bl) {
                arrayList2.add(step2.getName());
            }
            if (step2.isAboveSearchStart()) continue;
            bl = true;
        }
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    void releaseResources() {
        this.stopSearch(true, true);
        this._threadTimer = null;
        this._runnables = null;
        this.clearResults();
        this._treeItemComboBox.removeActionListener((ActionListener)this);
        ((JTextField)this._nameMRUComboBox.getEditor().getEditorComponent()).getDocument().removeDocumentListener(this);
        ((JTextField)this._nameMRUComboBox.getEditor().getEditorComponent()).removeActionListener(this);
        this._button.removeActionListener((ActionListener)this);
        for (int i = 0; i < this._optionCheckBoxes.size(); ++i) {
            this._optionCheckBoxes.get(i).removeItemListener((ItemListener)this);
        }
        this._session = null;
        DialogUtils.removeComponents((Container)this._searchPanel);
        this._searchPanel = null;
        this._searchOptionsPanel = null;
        this._optionCheckBoxes.clear();
        this._optionCheckBoxes = null;
        this._optionIds.clear();
        this._optionIds = null;
        this._viewerFrame = null;
        this._viewerManager = null;
        this._nameLabel = null;
        this._nameMRUComboBox = null;
        this._containerComboLabel = null;
        this._treeItemComboBox.setRenderer(null);
        this._treeItemComboBox = null;
        this._caseCheckBox = null;
        this._wordCheckBox = null;
        this._button = null;
        this._resultsTable.removeMouseListener(this);
        this._resultsTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this._resultsTable.releaseResources();
        this._resultsTable = null;
        this._resultsPane = null;
        this._bPole.releaseResources();
        this._bPole = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._nameMRUComboBox.getEditor().getEditorComponent() && !this._searching) {
            this._button.doClick();
        } else if (actionEvent.getSource() == this._button && !this._searching) {
            this.startSearch();
            this._button.requestFocusInWindow();
        } else if (actionEvent.getSource() == this._button && this._searching) {
            this.stopSearch(true, false);
        } else if (actionEvent.getSource() == this._threadTimer) {
            if (this._runnables.size() > 0) {
                SwingUtilities.invokeLater(this._runnables.firstElement());
                this._runnables.removeElementAt(0);
                if (this._runnables.size() > 0) {
                    this._threadTimer.start();
                }
            }
        } else if (actionEvent.getActionCommand().equals(ENTER_KEY_RELEASE) && actionEvent.getSource() == this._resultsTable) {
            this.resultsTableSelect(this._resultsTable.getSelectedRow());
        } else if (actionEvent.getSource() == this._treeItemComboBox) {
            this.searchTreeItemWasUpdated();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.searchTextUpdate();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.searchTextUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.searchTextUpdate();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && mouseEvent.getSource() == this._resultsTable) {
            this.resultsTableSelect(this._resultsTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY())));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        SCContainer sCContainer = this.getSelectedSearchSCContainer();
        if (sCContainer instanceof SCSearch) {
            ((SCSearch)((Object)sCContainer)).searchOptionChange(this.getSearchOptions(false, false));
        }
    }

    class ResultData
    implements SCSearchHit {
        Icon icon = null;
        String name = null;
        String type = null;
        ArrayList<Step> path = null;
        SearchPane searchPane = null;
        String[] context = null;

        ResultData(SCItem sCItem, ArrayList<Step> arrayList, SearchPane searchPane2) {
            this.icon = sCItem.getImage(false);
            this.name = sCItem.getDisplayName(0);
            this.type = sCItem instanceof SCItem5 ? ((SCItem5)sCItem).getSCItemType() : "";
            this.path = new ArrayList<Step>(arrayList);
            this.searchPane = searchPane2;
            this.context = SearchPane.this.buildContextStringArray(arrayList);
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Comparable getComparable() {
            return null;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String[] getContext() {
            return this.context;
        }

        @Override
        public boolean show() {
            return this.searchPane.showResult(this);
        }

        @Override
        public void releaseResources() {
            this.icon = null;
            this.name = null;
            this.type = null;
            this.path = null;
            this.searchPane = null;
            this.context = null;
        }
    }
}

